/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import java.util.Vector;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.htmlreport.TableCell;
import oracle.ops.verification.framework.report.htmlreport.Text;
import oracle.ops.verification.framework.util.VerificationUtil;

public class Table {
    private HtmlConstants.Colors m_backGroundColor = null;
    private int m_columns;
    private int m_borderWidth = 0;
    private HtmlConstants.Colors m_borderColor = null;
    Vector<TableCell> m_headers = null;
    Vector<TableCell[]> m_rowData = null;
    private Text m_caption = null;
    private int m_width = 0;
    private MessageBundle s_rptMsgBundle = VerificationUtil.getMessageBundle("Prve");

    public Table(Text caption, TableCell[] headers, HtmlConstants.Colors backGroundcolor, HtmlConstants.Colors borderColor, int borderWidth) throws HtmlReportToolException {
        if (headers != null) {
            this.m_caption = caption;
            this.m_columns = headers.length;
            this.m_headers = new Vector(this.m_columns);
            this.m_rowData = new Vector();
            if (backGroundcolor != null) {
                this.m_backGroundColor = backGroundcolor;
            }
            if (borderColor != null) {
                this.m_borderColor = borderColor;
            }
            this.m_borderWidth = borderWidth;
            for (TableCell header : headers) {
                this.m_headers.add(header);
            }
        } else {
            throw new HtmlReportToolException(this.s_rptMsgBundle.getMessage("10051", false, (Object[])new String[]{"headers"}));
        }
    }

    public Table(TableCell[] headers, int borderWidth) throws HtmlReportToolException {
        if (headers != null) {
            this.m_columns = headers.length;
            this.m_headers = new Vector(this.m_columns);
            this.m_rowData = new Vector();
            this.m_borderWidth = borderWidth;
            for (TableCell header : headers) {
                this.m_headers.add(header);
            }
        } else {
            throw new HtmlReportToolException(this.s_rptMsgBundle.getMessage("10051", false, (Object[])new String[]{"headers"}));
        }
    }

    public Table(TableCell[] headers) throws HtmlReportToolException {
        if (headers != null) {
            this.m_columns = headers.length;
            this.m_headers = new Vector(this.m_columns);
            this.m_rowData = new Vector();
            for (TableCell header : headers) {
                this.m_headers.add(header);
            }
        } else {
            throw new HtmlReportToolException(this.s_rptMsgBundle.getMessage("10051", false, (Object[])new String[]{"headers"}));
        }
    }

    public Table(int columns) {
        this.m_columns = columns;
        this.m_rowData = new Vector();
    }

    public void addRow(TableCell[] rowData) throws HtmlReportToolException {
        this.m_rowData.add(rowData);
    }

    public void setCaption(Text caption) {
        this.m_caption = caption;
    }

    public Text getCaption() {
        return this.m_caption;
    }

    public boolean hasCaption() {
        return this.m_caption != null;
    }

    public void setWidth(int width) {
        if (width <= 100) {
            this.m_width = width;
        }
    }

    public int getWidth() {
        return this.m_width;
    }

    public Vector<TableCell> getHeader() {
        return this.m_headers;
    }

    public void setHeaders(TableCell[] headers) throws HtmlReportToolException {
        if (headers != null) {
            this.m_columns = headers.length;
            this.m_headers = new Vector(this.m_columns);
            for (TableCell header : headers) {
                this.m_headers.add(header);
            }
        } else {
            throw new HtmlReportToolException(this.s_rptMsgBundle.getMessage("10051", false, (Object[])new String[]{"headers"}));
        }
    }

    public void setBorderColor(HtmlConstants.Colors color) {
        if (color != null) {
            this.m_borderColor = color;
        }
    }

    public void setBackGroundColor(HtmlConstants.Colors color) {
        if (color != null) {
            this.m_backGroundColor = color;
        }
    }

    public void setTableBorderWidth(int border) {
        if (border >= 0) {
            this.m_borderWidth = border;
        }
    }

    public Vector<TableCell[]> getRows() {
        return this.m_rowData;
    }

    public TableCell[] getRows(int index) {
        if (this.m_rowData.size() <= index) {
            return this.m_rowData.get(index);
        }
        return null;
    }

    public int getRowCount() {
        return this.m_rowData.size();
    }

    public int getColumCount() {
        return this.m_columns;
    }

    public HtmlConstants.Colors getBorderColor() {
        return this.m_borderColor;
    }

    public HtmlConstants.Colors getBackGroudColor() {
        return this.m_backGroundColor;
    }

    public int getTableBorderWidth() {
        return this.m_borderWidth;
    }

    public boolean hasHeader() {
        return this.m_headers != null;
    }
}

