/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report.htmlreport;

import java.io.Writer;
import java.util.Map;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.report.htmlreport.HtmlBuffer;
import oracle.ops.verification.framework.report.htmlreport.HtmlConstants;
import oracle.ops.verification.framework.report.htmlreport.HtmlPageData;
import oracle.ops.verification.framework.report.htmlreport.HtmlReportToolException;
import oracle.ops.verification.framework.report.htmlreport.Table;
import oracle.ops.verification.framework.report.htmlreport.TableCell;
import oracle.ops.verification.framework.report.htmlreport.Text;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HtmlPage
extends HtmlPageData {
    protected MessageBundle s_rptMsgBundle = VerificationUtil.getMessageBundle("Prve");
    protected boolean m_isIndented = false;

    public HtmlPage(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent, Writer writer, boolean addBody) throws ReportToolException {
        super(title, author, backGroundColor, indent, writer, addBody);
        if (title == null) {
            throw new HtmlReportToolException(this.s_rptMsgBundle.getMessage("10051", false, (Object[])new String[]{"title"}));
        }
        if (author == null) {
            author = "Oracle Corporation";
        }
        this.m_isIndented = indent;
    }

    public HtmlPage(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent, Writer writer) throws ReportToolException {
        this(title, author, backGroundColor, indent, writer, true);
    }

    public HtmlPage(String title, String author, HtmlConstants.Colors backGroundColor, boolean indent) throws ReportToolException {
        this(title, author, backGroundColor, indent, null);
    }

    public void addHeadingToHtmlBody(Text heading, int headingNumber, HtmlConstants.HorizontalAlignment align) throws HtmlReportToolException {
        HtmlBuffer headingBuffer = new HtmlBuffer(this.m_isIndented);
        headingBuffer.addHeading(heading, headingNumber, align);
        this.add(headingBuffer);
    }

    public void addCommentToHtmlBody(String comment) throws HtmlReportToolException {
        if (VerificationUtil.isStringGood(comment)) {
            HtmlBuffer commentBuffer = new HtmlBuffer(this.m_isIndented);
            commentBuffer.addComment(comment);
            this.add(commentBuffer);
        }
    }

    public void addParagraphToHtmlBody(Text data, HtmlConstants.HorizontalAlignment align) throws HtmlReportToolException {
        if (data != null) {
            HtmlBuffer paragrahBuffer = new HtmlBuffer(this.m_isIndented);
            paragrahBuffer.addParagraph(data, align);
            this.add(paragrahBuffer);
        }
    }

    public void addHorizontalLineToHtmlBody() throws HtmlReportToolException {
        this.addHorizontalLineWithWidthToHtmlBody(100);
    }

    public void addHorizontalLineWithWidthToHtmlBody(int width) throws HtmlReportToolException {
        HtmlBuffer lineBuffer = new HtmlBuffer(this.m_isIndented);
        lineBuffer.addHorizontalLineWithWidth(width);
        this.add(lineBuffer);
    }

    public void addDefinitionListToHtmlBody(Map<Text, Text[]> defData) throws HtmlReportToolException {
        if (defData != null) {
            HtmlBuffer defListBuffer = new HtmlBuffer(this.m_isIndented);
            defListBuffer.addDefinitionList(defData);
            this.add(defListBuffer);
        }
    }

    public void addListToHtmlBody(Text[] data, boolean isOrdered) throws HtmlReportToolException {
        if (data != null) {
            HtmlBuffer listBuffer = new HtmlBuffer(this.m_isIndented);
            listBuffer.addList(data, isOrdered);
            this.add(listBuffer);
        }
    }

    public void addTableToHtmlBody(Table tab, HtmlConstants.HorizontalAlignment align) throws HtmlReportToolException {
        if (tab != null) {
            HtmlBuffer tableBuffer = new HtmlBuffer(this.m_isIndented);
            tableBuffer.addTable(tab, align);
            this.add(tableBuffer);
        }
    }

    public void addTableHeaderToHtmlBody(Table tab, HtmlConstants.HorizontalAlignment align) throws HtmlReportToolException {
        if (tab != null) {
            HtmlBuffer tableBuffer = new HtmlBuffer(this.m_isIndented);
            tableBuffer.addTableHeader(tab, align);
            this.add(tableBuffer);
        }
    }

    public void addTableRowToHtmlBody(TableCell[] row) throws HtmlReportToolException {
        if (row != null) {
            HtmlBuffer tableBuffer = new HtmlBuffer(this.m_isIndented);
            tableBuffer.addTableRow(row);
            this.add(tableBuffer);
        }
    }

    public void addLineBreakToHtmlBody() throws HtmlReportToolException {
        HtmlBuffer lineBrkBuffer = new HtmlBuffer(this.m_isIndented);
        lineBrkBuffer.addLineBreak();
        this.add(lineBrkBuffer);
    }

    public void addHTMLBodyClose() throws HtmlReportToolException {
        this.add(HtmlBuffer.createClose(this.m_isIndented, "body"));
    }

    public void addHTMLClose() throws HtmlReportToolException {
        this.add(HtmlBuffer.createClose(this.m_isIndented, "html"));
    }

    public void addTableClose() throws HtmlReportToolException {
        this.add(HtmlBuffer.createClose(this.m_isIndented, "table"));
    }

    @Override
    protected void finalize() throws Throwable {
        this.destroy();
    }
}

