/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.report;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Set;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.report.ReportData;
import oracle.ops.verification.framework.report.ReportObjRef;
import oracle.ops.verification.framework.report.ReportSerializableObj;
import oracle.ops.verification.framework.report.ReportToolException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ReportHandler {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static boolean m_cleanupExistingReposDir = true;
    private static String m_localNodeName = null;
    private static long m_reportIDInstanceCnt = 0L;
    public static final long m_max_runtime_buffer_limit_in_bytes = VDMUtil.getDefaultRuntimeMemLimForSerialization();
    private ReportData.ReportTypes m_reportType;
    private String m_reposDirPath;
    private String m_reportSubDirectory = null;
    private long m_fileID;
    private ReportSerializableObj m_serializableObjectContainer = null;
    private Set<String> m_seriailizedObjectFiles = null;

    public ReportHandler(ReportData.ReportTypes type) throws ReportToolException {
        if (!VerificationUtil.isStringGood(m_localNodeName)) {
            m_localNodeName = VerificationUtil.getLocalNode();
        }
        this.m_fileID = 0L;
        this.m_reportType = type;
        this.m_reposDirPath = VerificationUtil.getCVUSubDirPath() + this.m_reportType.toString().toLowerCase();
        this.cleanUpReposDirIfExist();
        this.createReposDirectory();
        this.m_reportSubDirectory = this.createNewReposSubDirectory();
        this.m_serializableObjectContainer = new ReportSerializableObj();
        this.m_seriailizedObjectFiles = new HashSet<String>();
    }

    public void destroy() {
        try {
            this.finalize();
        }
        catch (Throwable e) {
            Trace.out((String)("IGNORING: Error during cleaning up of report handler, Error is " + e.getMessage()));
        }
    }

    public final void cleanUp() {
        m_cleanupExistingReposDir = true;
        try {
            this.cleanUpReposDirIfExist();
        }
        catch (ReportToolException e) {
            Trace.out((String)("Caught an exception during clean-up of report repository directory (" + this.m_reportSubDirectory + ") \nError is: " + e.getMessage()));
        }
        this.destroy();
    }

    protected void finalize() throws Throwable {
        for (String fileName : this.m_seriailizedObjectFiles) {
            File file = new File(fileName);
            if (file.exists()) {
                file.delete();
                continue;
            }
            Trace.out((String)("File (" + fileName + ") does not exist, Ignoring"));
        }
        try {
            this.deleteReposDirIfExist(this.m_reportSubDirectory);
        }
        catch (ReportToolException e) {
            Trace.out((String)("Failed to delete the report repository with error " + e.getMessage()));
        }
    }

    public ReportData.ReportTypes getReportType() {
        return this.m_reportType;
    }

    public String getReportSubDirectoryPath() {
        return this.m_reportSubDirectory;
    }

    public long getSerializableContainerSize() {
        return this.m_serializableObjectContainer.getSizeInBytes();
    }

    protected long getNewReportIDInstanceNumber() {
        return ++m_reportIDInstanceCnt;
    }

    protected synchronized String getCurrentObjectFileID() {
        return this.completePath(this.getReportType().toString().toLowerCase() + "_" + this.m_fileID);
    }

    protected synchronized void delete(ReportObjRef objRef) throws ReportToolException {
        if (this.m_seriailizedObjectFiles.contains(objRef.getFilePath())) {
            ReportSerializableObj serObj = this.load(objRef.getFilePath());
            if (serObj.getObjectCount() == 1) {
                objRef.delete();
            } else {
                serObj.deleteObject(objRef.getIndex());
                this.serialize(serObj, objRef);
            }
        } else {
            this.m_serializableObjectContainer.deleteObject(objRef.getIndex());
        }
    }

    protected synchronized ReportObjRef save(Object obj) throws ReportToolException {
        long objectSize = obj.toString().getBytes().length;
        ReportObjRef objRef = null;
        int objectIndex = 0;
        if (objectSize >= m_max_runtime_buffer_limit_in_bytes) {
            ReportSerializableObj serObj = new ReportSerializableObj();
            objectIndex = serObj.addObject(obj);
            objRef = new ReportObjRef(this.getObjectFileID(true), objectIndex);
            this.serialize(serObj, objRef);
        } else {
            objectIndex = this.m_serializableObjectContainer.addObject(obj);
            objectSize = this.m_serializableObjectContainer.getSizeInBytes();
            objRef = new ReportObjRef(this.getObjectFileID(false), objectIndex);
            if (this.m_serializableObjectContainer.getSizeInBytes() >= m_max_runtime_buffer_limit_in_bytes) {
                this.serialize(objRef);
                this.getNextObjFileID();
            }
        }
        return objRef;
    }

    protected synchronized Object load(ReportObjRef objRef) throws ReportToolException {
        ReportSerializableObj serializedObj = null;
        serializedObj = this.m_seriailizedObjectFiles.contains(objRef.getFilePath()) ? this.load(objRef.getFilePath()) : this.m_serializableObjectContainer;
        Object obj = serializedObj.getObject(objRef.getIndex());
        this.delete(objRef);
        return obj;
    }

    private synchronized ReportSerializableObj load(String filePath) throws ReportToolException {
        ReportSerializableObj serializedObj = null;
        FileInputStream file_for_obj = null;
        ObjectInputStream obj_in = null;
        try {
            file_for_obj = new FileInputStream(filePath);
            obj_in = new ObjectInputStream(file_for_obj);
            serializedObj = (ReportSerializableObj)obj_in.readObject();
        }
        catch (FileNotFoundException fnfe) {
            throw new ReportToolException(fnfe.getMessage(), fnfe);
        }
        catch (IOException ioe) {
            throw new ReportToolException(ioe.getMessage(), ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReportToolException(cnfe.getMessage(), cnfe);
        }
        finally {
            if (file_for_obj != null) {
                try {
                    file_for_obj.close();
                }
                catch (IOException iOException) {}
            }
            if (obj_in != null) {
                try {
                    obj_in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return serializedObj;
    }

    private synchronized void serialize(ReportObjRef objRef) throws ReportToolException {
        this.serialize(this.m_serializableObjectContainer, objRef);
        this.m_serializableObjectContainer.clear();
        this.m_serializableObjectContainer = new ReportSerializableObj();
    }

    private synchronized void serialize(ReportSerializableObj obj, ReportObjRef objRef) throws ReportToolException {
        FileOutputStream file_for_obj = null;
        ObjectOutputStream obj_out = null;
        try {
            file_for_obj = new FileOutputStream(objRef.getFilePath());
            obj_out = new ObjectOutputStream(file_for_obj);
            obj_out.writeObject(obj);
            this.m_seriailizedObjectFiles.add(objRef.getFilePath());
        }
        catch (FileNotFoundException fnfe) {
            throw new ReportToolException(fnfe.getMessage(), fnfe);
        }
        catch (IOException ioe) {
            throw new ReportToolException(ioe.getMessage(), ioe);
        }
        finally {
            if (file_for_obj != null) {
                try {
                    file_for_obj.close();
                }
                catch (IOException iOException) {}
            }
            if (obj_out != null) {
                try {
                    obj_out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private synchronized String getObjectFileID(boolean nextFileID) {
        if (nextFileID) {
            return this.getNextObjFileID();
        }
        return this.getCurrentObjectFileID();
    }

    private synchronized String getNextObjFileID() {
        ++this.m_fileID;
        String fileName = this.getReportType().toString().toLowerCase() + "_" + this.m_fileID;
        return this.completePath(fileName);
    }

    private synchronized void createReposDirectory() throws ReportToolException {
        this.createReportDirectory(this.m_reposDirPath);
    }

    private synchronized String createNewReposSubDirectory() throws ReportToolException {
        String subDirPath = this.m_reposDirPath + VerificationConstants.FILE_SEPARATOR + this.m_reportType.toString().toLowerCase() + this.getNewReportIDInstanceNumber();
        this.createReportDirectory(subDirPath);
        return subDirPath;
    }

    private synchronized void cleanUpReposDirIfExist() throws ReportToolException {
        if (m_cleanupExistingReposDir) {
            this.deleteReposDirIfExist(this.m_reposDirPath);
        }
        m_cleanupExistingReposDir = false;
    }

    private synchronized void deleteReposDirIfExist(String dirPath) throws ReportToolException {
        Trace.out((String)("Cleaning the directory " + dirPath + " if it exists on local node " + m_localNodeName));
        new SystemFactory().CreateSystem().removeDirRecurse(m_localNodeName, dirPath);
    }

    private synchronized void createReportDirectory(String dirPath) throws ReportToolException {
        File directory = new File(dirPath);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new ReportToolException(s_msgBundle.getMessage("7705", true, (Object[])new String[]{dirPath}));
        }
    }

    private String completePath(String fileName) {
        return this.getReportSubDirectoryPath() + VerificationConstants.FILE_SEPARATOR + fileName;
    }
}

