/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param.parser;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.param.parser.CLOption;
import oracle.ops.verification.framework.param.parser.CLOptionEnumItem;
import oracle.ops.verification.framework.param.parser.CLOptionSelection;
import oracle.ops.verification.framework.param.parser.CLOptionUseEnum;
import oracle.ops.verification.framework.param.parser.CLSyntaxValidator;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.VersionComparator;
import oracle.ops.verification.resources.PrvpMsgID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CLSyntaxXMLParser {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvp");
    String classLoc = "oracle.ops.verification.framework.param.parser";
    private static boolean m_unixSystem = false;

    public List<CLCommand> getCommands(String version) throws XmlParserException {
        return this.parse(version);
    }

    public List<CLCommand> parse(String version) throws XmlParserException {
        List<CLCommand> commands = null;
        DocumentBuilderFactory m_xmlFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_xmlParser = null;
        Document m_xmlDocument = null;
        try {
            InputStream m_xsdURI = CLSyntaxXMLParser.class.getResourceAsStream("CLSyntax.xsd");
            InputStream m_xml = CLSyntaxXMLParser.class.getResourceAsStream("CLSyntax.xml");
            if (m_xsdURI != null) {
                m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                m_xmlFactory.setNamespaceAware(true);
                m_xmlFactory.setValidating(true);
                m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", m_xsdURI);
            }
            m_xmlParser = m_xmlFactory.newDocumentBuilder();
            ErrorHandler handler = new ErrorHandler(){

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                    Trace.out((String)("Igonred waring while parsing: " + arg0));
                }
            };
            m_xmlParser.setErrorHandler(handler);
            m_xmlDocument = m_xmlParser.parse(m_xml);
            Element rootElement = m_xmlDocument.getDocumentElement();
            commands = this.parseCommand(rootElement, version);
        }
        catch (ParserConfigurationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        return commands;
    }

    private List<CLCommand> parseCommand(Element element, String release) throws XmlParserException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        ArrayList<CLCommand> commands = new ArrayList<CLCommand>();
        NodeList commandNL = element.getElementsByTagName("command");
        for (int i = 0; i < commandNL.getLength(); ++i) {
            Element commandElem = (Element)commandNL.item(i);
            if (!this.isApplicableToRelease(commandElem, release) || !this.isApplicableToCurrentOS(commandElem)) continue;
            CLCommand command = new CLCommand();
            commands.add(command);
            String name = this.getRequiredAttributeValue(commandElem, "name");
            command.setName(name);
            String hidden = this.getOptionalAttributeValue(commandElem, "hidden");
            command.setHidden("true".equalsIgnoreCase(hidden));
            String fixedPosition = this.getOptionalAttributeValue(commandElem, "fixedPosition");
            command.setFixedPosition("true".equalsIgnoreCase(fixedPosition));
            String label = this.getOptionalAttributeValue(commandElem, "label");
            command.setLabel(label);
            String validatorList = this.getOptionalAttributeValue(commandElem, "validators");
            command.setValidatorList(this.instantiateValidators(validatorList));
            String uniqueKeyPart = this.getOptionalAttributeValue(commandElem, "uniqueKeyPart");
            command.setUniqueKeyPart("true".equalsIgnoreCase(uniqueKeyPart));
            this.parseOptions(commandElem, command, release);
        }
        return commands;
    }

    private List<CLSyntaxValidator> instantiateValidators(String validatorListStr) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] validatorClassNames;
        ArrayList<CLSyntaxValidator> validatorList = new ArrayList<CLSyntaxValidator>();
        if (validatorListStr == null || validatorListStr.length() == 0) {
            return validatorList;
        }
        for (String validatorClassName : validatorClassNames = validatorListStr.split(",")) {
            if (validatorClassName.indexOf(".") < 0) {
                validatorClassName = this.classLoc + "." + validatorClassName;
            }
            validatorList.add((CLSyntaxValidator)Class.forName(validatorClassName).newInstance());
        }
        return validatorList;
    }

    private void parseOptions(Element parentElem, CLCommand parent, String release) throws XmlParserException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        NodeList allChildren = parentElem.getChildNodes();
        ArrayList<CLOption> optionList = new ArrayList<CLOption>();
        for (int i = 0; i < allChildren.getLength(); ++i) {
            CLOption option;
            Node toddler = allChildren.item(i);
            if (toddler == null || toddler.getNodeType() != 1 || (option = this.parseOption((Element)toddler, parent, release)) == null) continue;
            optionList.add(option);
        }
        parent.setOptionList(optionList);
    }

    private CLOption parseOption(Element elem, CLCommand parent, String release) throws XmlParserException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String topLevel;
        if (!this.isApplicableToRelease(elem, release) || !this.isApplicableToCurrentOS(elem)) {
            return null;
        }
        CLOption option = null;
        if (elem.getNodeName().equalsIgnoreCase("all")) {
            option = new CLOption(parent);
            option.setSelection(CLOptionSelection.ALL);
            topLevel = this.getOptionalAttributeValue(elem, "topLevel");
            option.setTopLevel("true".equalsIgnoreCase(topLevel));
            this.parseOptions(elem, option, release);
        } else if (elem.getNodeName().equalsIgnoreCase("choice")) {
            option = new CLOption(parent);
            option.setSelection(CLOptionSelection.CHOICE);
            topLevel = this.getOptionalAttributeValue(elem, "topLevel");
            option.setTopLevel("true".equalsIgnoreCase(topLevel));
            this.parseOptions(elem, option, release);
        } else if (elem.getNodeName().equalsIgnoreCase("option")) {
            ArrayList<CLOption> optionList;
            String detailedDescription;
            option = new CLOption(parent);
            String name = this.getRequiredAttributeValue(elem, "name");
            option.setName(name);
            String description = this.getOptionalAttributeValue(elem, "description");
            if (description != null) {
                option.setDescription(this.getMessage(description));
            }
            if ((detailedDescription = this.getOptionalAttributeValue(elem, "detailedDescription")) != null) {
                option.setDetailedDescription(this.getMessage(detailedDescription));
            }
            String symbolicName = this.getOptionalAttributeValue(elem, "symbolicName");
            option.setSymbolicName(symbolicName);
            String label = this.getOptionalAttributeValue(elem, "label");
            option.setLabel(label);
            String hidden = this.getOptionalAttributeValue(elem, "hidden");
            option.setHidden("true".equalsIgnoreCase(hidden));
            String fixedPosition = this.getOptionalAttributeValue(elem, "fixedPosition");
            option.setFixedPosition("true".equalsIgnoreCase(fixedPosition));
            String topLevel2 = this.getOptionalAttributeValue(elem, "topLevel");
            option.setTopLevel("true".equalsIgnoreCase(topLevel2));
            String uniqueKeyPart = this.getOptionalAttributeValue(elem, "uniqueKeyPart");
            option.setUniqueKeyPart("true".equalsIgnoreCase(uniqueKeyPart));
            Element allElem = null;
            Element choiceElem = null;
            Element valueElem = null;
            allElem = this.getFirstChildByTagName(elem, "all");
            choiceElem = this.getFirstChildByTagName(elem, "choice");
            valueElem = this.getFirstChildByTagName(elem, "value");
            Object selection = null;
            Object selectionElem = null;
            if (valueElem != null) {
                String type = this.getRequiredAttributeValue(valueElem, "type");
                option.setValueRequired(true);
                option.setValueType(type);
                String multiplateValuesAllowed = this.getOptionalAttributeValue(valueElem, "allowMultipeValues");
                option.setMultipleValuesAllowed(Boolean.parseBoolean(multiplateValuesAllowed));
                option.setIgnoreCase("true".equalsIgnoreCase(this.getOptionalAttributeValue(valueElem, "ignoreCase")));
                if ("ENUM".equalsIgnoreCase(type)) {
                    NodeList itemNL = valueElem.getElementsByTagName("item");
                    ArrayList<CLOptionEnumItem> items = new ArrayList<CLOptionEnumItem>();
                    for (int i = 0; i < itemNL.getLength(); ++i) {
                        boolean hiddenItem = "true".equalsIgnoreCase(this.getOptionalAttributeValue((Element)itemNL.item(i), "hidden"));
                        String itemText = itemNL.item(i).getFirstChild().getNodeValue();
                        items.add(new CLOptionEnumItem(itemText, hiddenItem));
                    }
                    option.setValueList(items);
                }
            }
            if (allElem != null) {
                optionList = new ArrayList<CLOption>();
                CLOption allOption = this.parseOption(allElem, option, release);
                optionList.add(allOption);
                option.setOptionList(optionList);
            } else if (choiceElem != null) {
                optionList = new ArrayList();
                CLOption choiceOption = this.parseOption(choiceElem, option, release);
                optionList.add(choiceOption);
                option.setOptionList(optionList);
            }
        }
        String validatorList = this.getOptionalAttributeValue(elem, "validators");
        option.setValidatorList(this.instantiateValidators(validatorList));
        String use = this.getOptionalAttributeValue(elem, "use");
        option.setUse(CLOptionUseEnum.valueOf(use));
        return option;
    }

    private boolean isApplicableToCurrentOS(Element elem) {
        String[] osList;
        String osAttr = this.getOptionalAttributeValue(elem, "os");
        if (osAttr == null || osAttr.length() == 0) {
            return true;
        }
        for (String os : osList = osAttr.split(",")) {
            if (!this.matchOSType(os)) continue;
            return true;
        }
        return false;
    }

    private boolean matchOSType(String osType) {
        boolean osTypeMatches = false;
        if (osType.equalsIgnoreCase("all")) {
            osTypeMatches = true;
        } else if (osType.equalsIgnoreCase("unix")) {
            osTypeMatches = m_unixSystem;
        } else if (osType.equalsIgnoreCase("windows")) {
            osTypeMatches = !m_unixSystem;
        } else if (osType.equalsIgnoreCase(VerificationUtil.getCurrentOS())) {
            osTypeMatches = true;
        }
        return osTypeMatches;
    }

    private boolean isApplicableToRelease(Element element, String release) throws XmlParserException {
        boolean result = true;
        Element releaseElem = this.getFirstChildByTagName(element, "release");
        VersionComparator comparator = new VersionComparator("-");
        if (releaseElem != null) {
            String eq = this.getOptionalAttributeValue(releaseElem, "eq");
            String ge = this.getOptionalAttributeValue(releaseElem, "ge");
            String le = this.getOptionalAttributeValue(releaseElem, "le");
            String gt = this.getOptionalAttributeValue(releaseElem, "gt");
            String lt = this.getOptionalAttributeValue(releaseElem, "lt");
            if (eq != null) {
                result = comparator.compare(eq, release) == 0;
            } else if (ge != null) {
                result = comparator.compare(ge, release) <= 0;
            } else if (gt != null) {
                result = comparator.compare(gt, release) < 0;
            } else if (le != null) {
                result = comparator.compare(le, release) >= 0;
            } else if (lt != null) {
                result = comparator.compare(lt, release) > 0;
            }
        }
        return result;
    }

    private String getRequiredAttributeValue(Element elem, String key) throws XmlParserException {
        if (!elem.hasAttribute(key)) {
            String[] msgParams = new String[]{elem.getTagName(), key};
            String msg = "A required attribute is missing";
            throw new XmlParserException(msg);
        }
        String value = elem.getAttribute(key);
        return value;
    }

    private String getOptionalAttributeValue(Element elem, String key) {
        String attributeValue = null;
        if (elem.hasAttribute(key)) {
            attributeValue = elem.getAttribute(key);
        }
        return attributeValue;
    }

    private Element getFirstDescendentByTagName(Element osElem, String elemName) throws XmlParserException {
        if (osElem == null || elemName == null) {
            return null;
        }
        NodeList nl = osElem.getElementsByTagName(elemName);
        if (nl.getLength() >= 1) {
            return (Element)nl.item(0);
        }
        return null;
    }

    private Element getFirstChildByTagName(Element osElem, String elemName) throws XmlParserException {
        NodeList nl = this.getChildrenByTagName(osElem, elemName);
        if (nl != null && nl.getLength() >= 1) {
            return (Element)nl.item(0);
        }
        return null;
    }

    private NodeList getChildrenByTagName(Element elem, String tagName) {
        if (elem == null || tagName == null) {
            return null;
        }
        NodeList allChildren = elem.getChildNodes();
        final ArrayList<Node> _items = new ArrayList<Node>();
        NodeList immediateChildren = new NodeList(){

            @Override
            public int getLength() {
                return _items.size();
            }

            @Override
            public Node item(int paramInt) {
                return (Node)_items.get(paramInt);
            }
        };
        boolean j = false;
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            _items.add(toddler);
        }
        return immediateChildren;
    }

    public String getMessage(String symbolicMessageID) {
        String message = null;
        try {
            Class<PrvpMsgID> c = PrvpMsgID.class;
            Field f = c.getField(symbolicMessageID);
            String msgID = null;
            if (f != null) {
                msgID = f.get(null).toString();
            }
            message = msgID != null ? s_msgBundle.getMessage(msgID, false) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return message;
    }

    static {
        m_unixSystem = new SystemFactory().CreateSystem().isUnixSystem();
    }
}

