/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.param;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Pattern;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.factory.data.OperationMode;
import oracle.ops.verification.framework.param.CLSyntax;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.param.parser.CLCommand;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public final class ParamManager {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvp");
    static final String LSEP = System.getProperty("line.separator");
    private boolean b_CfsOh = false;
    private Hashtable<String, Integer> m_flagsHash = new Hashtable();
    private String[] m_cmdLineArgList = null;
    private List<String> m_keyTokens = new ArrayList<String>();
    private static ParamManager _paramManager;
    private OperationMode m_mode;
    private static boolean fromRuncluvfy;
    private static boolean m_fromRacHome;
    private static boolean m_paramInstantiated;
    private CLCommand matchedCommand = null;

    public static boolean isInstantiated() {
        return m_paramInstantiated;
    }

    private ParamManager(OperationMode mode, String[] args) throws InvalidCommandlineException {
        this.m_mode = mode;
        if (this.m_mode == OperationMode.api) {
            CVUVariables.setReleaseForVariablesXml("12.2");
            CVUVariables.setValue(CVUVariableConstants.MODE_API, "TRUE");
            CVUVariables.setValue(CVUVariableConstants.MODE_CLI, "FALSE");
        } else {
            CVUVariables.setValue(CVUVariableConstants.MODE_CLI, "TRUE");
            CVUVariables.setValue(CVUVariableConstants.MODE_API, "FALSE");
        }
        Trace.out((String)"m_paramInstantiated set to TRUE");
        m_paramInstantiated = true;
    }

    public void validate(String[] args) throws InvalidCommandlineException {
        int i;
        String[] actualArgs;
        VerificationUtil.setLocalNodeOperation(true);
        if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("_FROM_RUNCLUVFY")) {
            actualArgs = new String[args.length - 1];
            i = 0;
            while (i < args.length - 1) {
                actualArgs[i] = args[i++];
            }
            CLSyntax.setRunCluvfyTxt();
            fromRuncluvfy = true;
            args = actualArgs;
        }
        if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("_FROM_RACHOME")) {
            actualArgs = new String[args.length - 1];
            i = 0;
            while (i < args.length - 1) {
                actualArgs[i] = args[i++];
            }
            m_fromRacHome = true;
            args = actualArgs;
        }
        this.m_cmdLineArgList = args;
        this.checkReleaseOption(args);
        String clVersion = VerificationUtil.getVersionForCL();
        Trace.out((String)("clVersion=" + clVersion));
        this.matchedCommand = CLSyntax.validate(clVersion, this.m_cmdLineArgList);
        if (this.matchedCommand == null) {
            throw new InvalidCommandlineException(s_msgBundle.getMessage("1001", true));
        }
        this.m_keyTokens = Arrays.asList(this.matchedCommand.getUniqueKey().split(Pattern.quote(".")));
        VerificationUtil.isLocalNodeOperation(true);
    }

    private void checkReleaseOption(String[] args) {
        Trace.out((String)"Method Entry");
        String relVal = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if (!CLSyntax.STR_R.equals(args[i])) continue;
            relVal = args[i + 1];
            Trace.out((String)("Saved value for given release :" + relVal));
        }
        if (relVal != null) {
            try {
                Float.parseFloat(relVal);
                Trace.out((String)"Found valid release from command line");
                if (VerificationUtil.isVersionPre(relVal, "12.2")) {
                    Trace.out((String)"Requested release is pre 12.2. Set rsh fallback  to true");
                    System.setProperty("SRVM_ALLOW_RSH", "TRUE");
                } else {
                    Trace.out((String)"Requested release is post 12.2. Set rsh fallback  to false");
                    System.setProperty("SRVM_ALLOW_RSH", "FALSE");
                }
                CVUVariables.setReleaseForVariablesXml(relVal);
            }
            catch (NumberFormatException e) {
                Trace.out((String)"Invalid release option given");
                CVUVariables.initialize();
            }
        } else {
            Trace.out((String)"an specific release was not requested or invalid syntax");
            CVUVariables.initialize();
        }
    }

    public static synchronized ParamManager getInstance(OperationMode mode, String[] args) throws InvalidCommandlineException {
        if (_paramManager == null) {
            _paramManager = new ParamManager(mode, args);
        }
        return _paramManager;
    }

    public static ParamManager getInstance() throws UninitializedParamManagerException {
        if (_paramManager == null) {
            throw new UninitializedParamManagerException(s_msgBundle.getMessage("1000", false));
        }
        return _paramManager;
    }

    public static boolean isRuncluvfy() {
        return fromRuncluvfy;
    }

    public static boolean isRacHome() {
        return m_fromRacHome;
    }

    public OperationMode getMode() {
        return this.m_mode;
    }

    public boolean checkInstallConfigFile() {
        return CVUVariables.getValue(CVUVariableConstants.CONF_FILE) != null;
    }

    public String getInstallConfigFile() {
        return CVUVariables.getValue(CVUVariableConstants.CONF_FILE);
    }

    public boolean checkInstallResponseFile() {
        return CVUVariables.getValue(CVUVariableConstants.RESP_FILE) != null;
    }

    public String getInstallResponseFile() {
        return CVUVariables.getValue(CVUVariableConstants.RESP_FILE);
    }

    public boolean checkArgStage() {
        return this.m_keyTokens.contains(CLSyntax.STR_STAGE);
    }

    public String getStageID() {
        return this.getStageCompID();
    }

    public boolean checkArgPre() {
        return this.m_keyTokens.contains(CLSyntax.STR_PRE);
    }

    public boolean checkArgPost() {
        return this.m_keyTokens.contains(CLSyntax.STR_POST);
    }

    public boolean checkArgComp() {
        return this.m_keyTokens.contains(CLSyntax.STR_COMPONENT);
    }

    public boolean checkArgServer() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.DNS_SERVER));
    }

    public boolean checkArgClient() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.DNS_CLIENT));
    }

    public boolean checkArgLastClient() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.LAST_CLIENT));
    }

    public boolean checkArgGnsPreCrsinst() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.COMP_GNS_PRE));
    }

    public boolean checkArgGnsPostCrsinst() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.COMP_GNS_POST));
    }

    public boolean checkArgAllSoftware() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.ALL_FILES));
    }

    public String getCompID() {
        return this.getStageCompID();
    }

    private String getStageCompID() {
        String id = null;
        if (this.m_keyTokens != null && this.m_keyTokens.size() > 0) {
            id = this.m_keyTokens.get(this.m_keyTokens.size() - 1);
        }
        return id;
    }

    public boolean checkArgVerbose() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.VERBOSE_FLAG));
    }

    public static boolean checkArgOldFormat() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.OLDFORMAT_FLAG));
    }

    public boolean checkArgFormat() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.FORMAT_FLAG));
    }

    public boolean checkArgDeviations() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_DEVIATIONS));
    }

    public boolean checkArgHTML() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_HTML));
    }

    public boolean checkArgBestPractice() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.BESTPRACTICE));
    }

    public boolean checkArgMandatory() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.MANDATORY));
    }

    public boolean checkArgDisplayStatus() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.DISPLAY_STATUS_FLAG));
    }

    public boolean checkArgSshonly() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.SSH_ONLY));
    }

    public boolean checkArgPatchonly() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.PATCH_ONLY_FLAG));
    }

    public boolean checkArgNoCtss() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.NO_CTSS));
    }

    public boolean checkArgSummary() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.SUMMARY_FLAG));
    }

    public boolean checkArgDiag() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.DIAG_FLAG));
    }

    public boolean checkArgCfsOh() {
        return this.b_CfsOh;
    }

    public boolean checkASM() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.ASM_FLAG));
    }

    public boolean checkFlex() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.BIG_CLUSTER_FLAG));
    }

    public boolean checkUSM() {
        return this.m_flagsHash.containsKey(CLSyntax.STR_USMFLAG);
    }

    public boolean checkArgFixup() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.FIXUP_GEN));
    }

    public boolean checkArgFixupNoExecute() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.FIXUP_NO_EXEC));
    }

    public boolean checkArgSave() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.HEALTH_CHECK_SAVE));
    }

    public boolean checkArgRolling() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.ISROLLING));
    }

    public boolean checkArgUpgrade() {
        return Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.UPGRADE));
    }

    public boolean isGNSDomainSpecified() {
        return CVUVariables.getValue(CVUVariableConstants.GNS_SUB_DOMAIN) != null;
    }

    public boolean isGNSClientDataSpecified() {
        return CVUVariables.getValue(CVUVariableConstants.GNS_CLIENT_DATA_FILE) != null;
    }

    public boolean isServicePwdSpecified() {
        return CVUVariables.getValue(CVUVariableConstants.SERVICEPWD_FLAG) != null;
    }

    public boolean isServiceUserSpecified() {
        return CVUVariables.getValue(CVUVariableConstants.SERVICE_USER) != null;
    }

    public String getServiceUserPassword() {
        return CVUVariables.getValue(CVUVariableConstants.SERVICEPWD);
    }

    public String getLogFileName() {
        return "cvu.log";
    }

    public String[] getMultiPartArgVal(String arg) {
        Trace.out((String)("Retrieving argument of type = " + arg));
        if (arg != null) {
            return arg.split(CLSyntax.DELIMETER);
        }
        return null;
    }

    public boolean isNodeAdd() {
        if (this.m_keyTokens == null) {
            return false;
        }
        return this.m_keyTokens.contains(CLSyntax.STR_PRE) && this.m_keyTokens.contains(CLSyntax.STR_STAGE) && this.m_keyTokens.contains(CLSyntax.STR_NODEADD);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Command line arguments: " + LSEP);
        for (int i = 0; i < this.m_cmdLineArgList.length; ++i) {
            sb.append(this.m_cmdLineArgList[i] + " ");
        }
        sb.append(LSEP + "ParamManager object contains:" + LSEP);
        sb.append(LSEP + "\tcheckArgStage returns: " + this.checkArgStage());
        sb.append(LSEP + "\tcheckArgComp returns: " + this.checkArgComp());
        sb.append(LSEP + "\tcheckArgPre returns: " + this.checkArgPre());
        sb.append(LSEP + "\tcheckArgPost returns: " + this.checkArgPost());
        sb.append(LSEP + "\t CVU variables discovered: " + (this.matchedCommand != null ? this.matchedCommand.getDiscoveredSymbols() : "<EMPTY>"));
        return sb.toString();
    }

    public String getAdminPrivOperation() {
        boolean operationUE = Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.OPERATION_UE));
        boolean operationCI = Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.OPERATION_CI));
        boolean operationDI = Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.OPERATION_DI));
        boolean operationDC = Boolean.parseBoolean(CVUVariables.getValue(CVUVariableConstants.OPERATION_DC));
        if (operationUE) {
            return "user_equiv";
        }
        if (operationCI) {
            return "crs_inst";
        }
        if (operationDI) {
            return "db_inst";
        }
        if (operationDC) {
            return "db_config";
        }
        return null;
    }

    static {
        fromRuncluvfy = false;
        m_fromRacHome = false;
        m_paramInstantiated = false;
    }
}

