/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Map;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.util.NoSuchIdentifierException;
import oracle.cluster.wallet.CLSWAccessDeniedException;
import oracle.cluster.wallet.CLSWAliasNotExistException;
import oracle.cluster.wallet.CLSWException;
import oracle.cluster.wallet.CLSWNotExistException;
import oracle.cluster.wallet.OSUserWallet;
import oracle.cluster.winsecurity.Credentials;
import oracle.cluster.winsecurity.Group;
import oracle.cluster.winsecurity.PermissionType;
import oracle.cluster.winsecurity.User;
import oracle.cluster.winsecurity.UserPrivilege;
import oracle.cluster.winsecurity.WinSecurityFactory;
import oracle.cluster.winsecurity.WindowsSecurityException;
import oracle.cluster.winsecurity.WindowsStorageType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskVerifyServiceUser
extends Task
implements VerificationConstants {
    private String[] m_nodeList = null;
    private boolean m_isPostDBInst = false;
    private Credentials m_credentials = null;
    private String m_localName = null;
    private MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private final String ORA_DBA_GROUP = "ORA_DBA";

    public sTaskVerifyServiceUser(String[] nodeList, Credentials credentials, ResultSet resultSet, boolean isPostDBInst) {
        this.m_nodeList = nodeList;
        this.m_credentials = credentials;
        this.m_resultSet = resultSet;
        this.m_isPostDBInst = isPostDBInst;
    }

    @Override
    public boolean performTask() {
        String username = this.m_credentials.getUsername();
        boolean status = false;
        Trace.out((String)("checking for username " + username));
        ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("4503", false, (Object[])new String[]{username}));
        if (this.m_credentials.isUserBuiltinUser() && this.m_credentials.isUserLocalSystem()) {
            Trace.out((String)"user is a builtin user localsystem");
            this.m_resultSet.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("4504", false, (Object[])new String[]{username}));
            return true;
        }
        boolean isLocalService = this.m_credentials.isUserLocalService();
        boolean isVirtualAccount = this.m_credentials.isUserVirtualAccount();
        if (this.m_credentials.isUserBuiltinUser() && (isLocalService || isVirtualAccount)) {
            String errMsg = null;
            if (isLocalService) {
                Trace.out((String)"user is builtin user localService");
                errMsg = this.s_gMsgBundle.getMessage("4505", true, (Object[])new String[]{username});
            } else {
                Trace.out((String)"user is builtin user virtual account");
                errMsg = this.s_gMsgBundle.getMessage("4530", true);
            }
            ReportUtil.sureprintln(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        try {
            this.m_localName = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: while getting local node" + uhe));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = this.s_msgBundle.getMessage("0002", true);
            ReportUtil.printError(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        String destloc = VerificationUtil.getDestLoc();
        String srcloc = VerificationUtil.getCVHome();
        try {
            Trace.out((String)"getting winsecurity factory and user");
            WinSecurityFactory wsecFac = WinSecurityFactory.getInstance((String)srcloc, (String)destloc);
            User user = wsecFac.getUser(this.m_credentials, new Version());
            if (user.isGroupMSA()) {
                return this.performGMSAValidation(user, username);
            }
            ResultSet locrs = new ResultSet();
            this.performDomainUserValidation(user, locrs, username);
            TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4544", false, (Object[])new String[]{username}), this.m_nodeList, this);
            anonymousTask.performAnonymousTask(locrs);
            this.m_resultSet.uploadResultSet(locrs);
            if (!locrs.anySuccess()) {
                return false;
            }
            locrs.clear();
            TaskAnonymousProxy anonymousAdminTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4545", false, (Object[])new String[]{username}), this.m_nodeList, this);
            this.performNotAdminValidation(user, locrs, username, anonymousAdminTask);
            anonymousAdminTask.performAnonymousTask(locrs);
            this.m_resultSet.uploadResultSet(locrs);
            if (locrs.allSuccess()) {
                status = true;
            }
            boolean isCLIMode = VerificationUtil.isCLIMode();
            boolean isValidUser = false;
            try {
                if (this.m_credentials.getPassword() != null) {
                    Trace.out((String)"performing valid user check as we have password");
                    locrs.clear();
                    isValidUser = this.performValidUserCheck(user, locrs, username, false);
                    TaskAnonymousProxy anonymousUserTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4546", false, (Object[])new String[]{username}), this.m_nodeList, this);
                    anonymousUserTask.performAnonymousTask(locrs);
                    this.m_resultSet.uploadResultSet(locrs);
                }
                locrs.clear();
                Trace.out((String)"checking if user password exists in wallet");
                if (this.performWalletValidation(wsecFac, this.m_credentials, locrs, username, isValidUser, isCLIMode)) {
                    TaskAnonymousProxy anonymousWalletTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4547", false, (Object[])new String[]{username}), this.m_nodeList, this);
                    anonymousWalletTask.performAnonymousTask(locrs);
                    this.m_resultSet.uploadResultSet(locrs);
                }
            }
            catch (WindowsSecurityException e) {
                Trace.out((String)("WSE in valid user check" + e.getMessage()));
                String errMsg = this.s_gMsgBundle.getMessage("4522", true, (Object[])new String[]{username}) + LSEP + e.getMessage();
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
            if (this.m_isPostDBInst) {
                locrs.clear();
                this.performPostDBInstChecks(wsecFac, user, this.m_credentials, username);
            }
        }
        catch (WindowsSecurityException e) {
            String errMsg = this.s_gMsgBundle.getMessage("4522", true, (Object[])new String[]{username}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        return this.m_resultSet.allSuccess();
    }

    private void performDomainUserValidation(User user, ResultSet locrs, String username) {
        ReportUtil.println(this.s_gMsgBundle.getMessage("4507", false, (Object[])new String[]{username}));
        try {
            if (!user.isUserDomainUser()) {
                String errMsg = this.s_gMsgBundle.getMessage("4506", true, (Object[])new String[]{username});
                locrs.addResult(this.m_nodeList, 3);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg);
                return;
            }
            locrs.addResult(this.m_nodeList, 1);
            ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("4508", false, (Object[])new String[]{username}));
        }
        catch (WindowsSecurityException e) {
            String errMsg = this.s_gMsgBundle.getMessage("4515", true, (Object[])new String[]{username}) + LSEP + e.getMessage();
            locrs.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errMsg);
            return;
        }
    }

    private void performNotAdminValidation(User user, ResultSet locrs, String username, TaskAnonymousProxy anonTask) {
        ReportUtil.println(this.s_gMsgBundle.getMessage("4509", false, (Object[])new String[]{username}));
        try {
            Map adminMap = user.isAdministrator(this.m_localName, this.m_nodeList);
            Task previousTaskReference = ReportUtil.setTaskReference(anonTask);
            ReportUtil.writeColHeaders(this.s_msgBundle.getMessage("8000", false), this.s_gMsgBundle.getMessage("0401", false), this.s_msgBundle.getMessage("8018", false));
            ArrayList<String> adminNodesList = new ArrayList<String>();
            for (String node : adminMap.keySet()) {
                String status;
                String isAdminStr;
                if (((Boolean)adminMap.get(node)).booleanValue()) {
                    isAdminStr = ReportUtil.YES;
                    status = ReportUtil.FAILED;
                    locrs.addResult(node, 4);
                    adminNodesList.add(node);
                    Trace.out((String)(" user is admin on node :" + node));
                } else {
                    Trace.out((String)(" user is not admin on node :" + node));
                    isAdminStr = ReportUtil.NO;
                    status = ReportUtil.PASSED;
                    locrs.addResult(node, 1);
                }
                ReportUtil.writeRecord(node, isAdminStr, status);
            }
            ReportUtil.setTaskReference(previousTaskReference);
            if (adminNodesList.size() > 0) {
                String errMsg = this.s_gMsgBundle.getMessage("4510", true, (Object[])new String[]{username, VerificationUtil.strList2List(adminNodesList)});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(adminNodesList.toArray(new String[adminNodesList.size()]), errDesc);
                ReportUtil.printWarning(errMsg);
            } else {
                ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("4511", false, (Object[])new String[]{username}));
            }
        }
        catch (WindowsSecurityException e) {
            String errMsg = this.s_gMsgBundle.getMessage("4516", true, (Object[])new String[]{username, VerificationUtil.strArr2String(this.m_nodeList)}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(errMsg);
        }
        catch (CompositeOperationException e) {
            String[] errNodeArr = this.getCompositeOperationFailureNodes(e);
            String errMsg = this.s_gMsgBundle.getMessage("4516", true, (Object[])new String[]{username, VerificationUtil.strArr2String(errNodeArr)}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(errNodeArr, 2);
            ReportUtil.sureprintln(errMsg);
        }
    }

    private boolean performValidUserCheck(User user, ResultSet locrs, String username, boolean mute) throws WindowsSecurityException {
        if (!mute) {
            ReportUtil.println(this.s_gMsgBundle.getMessage("4512", false, (Object[])new String[]{username}));
        }
        try {
            if (!user.isValidUser()) {
                Trace.out((String)"username/password is not valid");
                String errMsg = this.s_gMsgBundle.getMessage("11423", true, (Object[])new String[]{username});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(errDesc);
                locrs.addResult(this.m_nodeList, 3);
                if (!mute) {
                    ReportUtil.sureprintln(errMsg);
                }
                return false;
            }
            Trace.out((String)"username/password is valid");
            locrs.addResult(this.m_nodeList, 1);
            if (!mute) {
                ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("4514", false, (Object[])new String[]{username}));
            }
            return true;
        }
        catch (WindowsSecurityException e) {
            Trace.out((String)("couldn't determine if user is valid :" + e.getMessage()));
            String errMsg = this.s_gMsgBundle.getMessage("4517", true, (Object[])new String[]{username}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(this.m_nodeList, 2);
            if (mute) {
                throw e;
            }
            ReportUtil.sureprintln(errMsg);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performWalletValidation(WinSecurityFactory wsecFac, Credentials credentials, ResultSet locrs, String username, boolean isValidUser, boolean isCLIMode) {
        String userEnteredPassword = null;
        OSUserWallet osWallet = null;
        String crshome = VerificationUtil.getCRSHome();
        String cvhome = VerificationUtil.getCVHome();
        cvhome = cvhome.substring(0, cvhome.length() - 1);
        if (isCLIMode && crshome.equalsIgnoreCase(cvhome)) {
            try {
                osWallet = OSUserWallet.getInstance();
                osWallet.initializeWalletContext();
                if (osWallet.isUserWalletExist(credentials)) {
                    Trace.out((String)"user found in wallet");
                    ReportUtil.println(this.s_gMsgBundle.getMessage("4518", false, (Object[])new String[]{username}));
                    userEnteredPassword = credentials.getPassword();
                    Credentials cred1 = new Credentials(username);
                    osWallet.getWalletContents(cred1);
                    String walletPassword = cred1.getPassword();
                    boolean passwordsMatch = false;
                    if (userEnteredPassword == null || !isValidUser) {
                        User user = wsecFac.getUser(cred1, new Version());
                        this.performValidUserCheck(user, locrs, username, true);
                        if (locrs.allSuccess()) {
                            passwordsMatch = true;
                        }
                    } else if (userEnteredPassword.equalsIgnoreCase(walletPassword)) {
                        passwordsMatch = true;
                    }
                    if (passwordsMatch) {
                        locrs.addResult(this.m_nodeList, 1);
                        ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("4519", false, (Object[])new String[]{username}));
                    }
                    Trace.out((String)"password in wallet is invalid");
                    String errMsg = this.s_gMsgBundle.getMessage("4520", true, (Object[])new String[]{username});
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    locrs.addErrorDescription(errDesc);
                    locrs.addResult(this.m_nodeList, 3);
                    ReportUtil.sureprintln(errMsg);
                }
            }
            catch (CLSWAccessDeniedException e) {
                Trace.out((String)("clsw access denied excpt " + e.getMessage()));
                this.updateResultForWalletException(username, e.getMessage(), locrs);
            }
            catch (CLSWNotExistException e) {
                Trace.out((String)("clswnotexistse " + e.getMessage()));
                this.updateResultForWalletException(username, e.getMessage(), locrs);
            }
            catch (CLSWAliasNotExistException e) {
                Trace.out((String)("clswaliasnotexistse " + e.getMessage()));
                this.updateResultForWalletException(username, e.getMessage(), locrs);
            }
            catch (CLSWException e) {
                Trace.out((String)("clswe " + e.getMessage()));
                this.updateResultForWalletException(username, e.getMessage(), locrs);
            }
            catch (WindowsSecurityException e) {
                Trace.out((String)("clswnotexistse " + e.getMessage()));
                this.updateResultForWalletException(username, e.getMessage(), locrs);
            }
            finally {
                try {
                    if (osWallet != null) {
                        osWallet.terminateWalletContext();
                    }
                }
                catch (CLSWException e) {
                    Trace.out((String)("CLSWE while closing wallet context :" + e.getMessage()));
                }
                return true;
            }
        }
        return false;
    }

    private void updateResultForWalletException(String username, String exceptionMsg, ResultSet locrs) {
        String errMsg = this.s_gMsgBundle.getMessage("4522", true, (Object[])new String[]{username}) + LSEP + exceptionMsg;
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        locrs.addErrorDescription(errDesc);
        locrs.addResult(this.m_nodeList, 2);
        ReportUtil.sureprintln(errMsg);
    }

    private void performPostDBInstChecks(WinSecurityFactory wsecFac, User user, Credentials credentials, String username) {
        ResultSet locrs = new ResultSet();
        String oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
        String groupToCheck = null;
        if (oracleHome == null || oracleHome.length() == 0) {
            String errMsg = this.s_msgBundle.getMessage("5461", true, (Object[])new String[]{"ORACLE_HOME"});
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(errMsg);
            return;
        }
        boolean skipRegCheck = false;
        String oracleKey = null;
        try {
            FileInputStream fileStream = new FileInputStream(oracleHome + FSEP + "bin" + FSEP + "oracle.key");
            BufferedReader myInput = new BufferedReader(new InputStreamReader(fileStream));
            oracleKey = myInput.readLine().trim();
        }
        catch (IOException e) {
            Trace.out((String)(" IOE while reading oracle.key" + e.getMessage()));
            skipRegCheck = true;
        }
        TaskAnonymousProxy anonymousTask = null;
        if (oracleKey != null) {
            String[] oracleKeys = oracleKey.split("\\\\");
            groupToCheck = oracleKeys[oracleKeys.length - 1];
            Trace.out((String)("The key retrieved from oracle.key is (" + oracleKey + "), groupname value after filtering is (" + groupToCheck + ")"));
            if (VerificationUtil.isStringGood(groupToCheck) && groupToCheck.trim().startsWith("KEY_")) {
                groupToCheck = groupToCheck.substring("KEY_".length());
            }
            groupToCheck = "ORA_" + groupToCheck + "_DBA";
            Trace.out((String)("checking if user belongs to group " + groupToCheck));
            anonymousTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4548", false, (Object[])new String[]{username, groupToCheck}), this.m_nodeList, this);
            this.performGroupMembershipCheck(wsecFac, username, locrs, groupToCheck, anonymousTask);
        } else {
            Trace.out((String)"Oracle.key returned an empty home name");
            groupToCheck = "ORA_DBA";
            anonymousTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4548", false, (Object[])new String[]{username, groupToCheck}), this.m_nodeList, this);
            this.performGroupMembershipCheck(wsecFac, username, locrs, groupToCheck, anonymousTask);
        }
        anonymousTask.performAnonymousTask(locrs);
        this.m_resultSet.uploadResultSet(locrs);
        if (oracleKey == null || oracleKey.length() == 0) {
            skipRegCheck = true;
        }
        locrs.clear();
        WindowsStorageType wsType = WindowsStorageType.Directory;
        PermissionType permType = PermissionType.DatabaseHome;
        Trace.out((String)"checking permission for a database home");
        TaskAnonymousProxy anonymousHomeTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4549", false, (Object[])new String[]{username, oracleHome}), this.m_nodeList, this);
        this.performPermissionCheck(wsecFac, wsType, permType, credentials, oracleHome, username, locrs, anonymousHomeTask);
        anonymousHomeTask.performAnonymousTask(locrs);
        this.m_resultSet.uploadResultSet(locrs);
        locrs.clear();
        wsType = WindowsStorageType.File;
        permType = PermissionType.DatabaseFiles;
        String oracleExe = oracleHome + FSEP + "bin" + FSEP + "oracle.exe";
        Trace.out((String)"checking permission for oracle.exe");
        TaskAnonymousProxy anonymousFileTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4497", false, (Object[])new String[]{username, oracleExe}), this.m_nodeList, this);
        this.performPermissionCheck(wsecFac, wsType, permType, credentials, oracleExe, username, locrs, anonymousFileTask);
        anonymousFileTask.performAnonymousTask(locrs);
        this.m_resultSet.uploadResultSet(locrs);
        if (!skipRegCheck) {
            locrs.clear();
            wsType = WindowsStorageType.Registry;
            permType = PermissionType.Registry;
            Trace.out((String)("checking permission for registry key " + oracleKey));
            TaskAnonymousProxy anonymousRegTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4498", false, (Object[])new String[]{username, oracleKey}), this.m_nodeList, this);
            this.performPermissionCheck(wsecFac, wsType, permType, credentials, "MACHINE\\" + oracleKey, username, locrs, anonymousRegTask);
            anonymousRegTask.performAnonymousTask(locrs);
            this.m_resultSet.uploadResultSet(locrs);
        }
    }

    private void performPermissionCheck(WinSecurityFactory wsecFac, WindowsStorageType wsType, PermissionType permType, Credentials cred, String path, String username, ResultSet locrs, TaskAnonymousProxy anonProxy) {
        boolean isRecurse = true;
        try {
            Trace.out((String)"Checking for storage type :", (Object[])new Object[]{wsType});
            switch (wsType) {
                case Directory: {
                    ReportUtil.println(this.s_gMsgBundle.getMessage("4527", false, (Object[])new String[]{username, path}));
                    isRecurse = false;
                    break;
                }
                case File: {
                    ReportUtil.println(this.s_gMsgBundle.getMessage("4528", false, (Object[])new String[]{username, path}));
                    break;
                }
                case Registry: {
                    ReportUtil.println(this.s_gMsgBundle.getMessage("4529", false, (Object[])new String[]{username, path}));
                }
            }
            UserPrivilege userPriv = wsecFac.getUserPrivilege(cred, new Version());
            Map userAclMap = userPriv.checkAclsForUser(wsType, path, permType, isRecurse, this.m_localName, this.m_nodeList);
            Task previousTaskReference = ReportUtil.setTaskReference(anonProxy);
            ReportUtil.writeColHeaders(this.s_msgBundle.getMessage("8000", false), this.s_gMsgBundle.getMessage("0403", false), this.s_msgBundle.getMessage("8018", false));
            ArrayList<String> noPermissionNodeList = new ArrayList<String>();
            for (String node : userAclMap.keySet()) {
                String status;
                String hasPermissionStr;
                if (((Boolean)userAclMap.get(node)).booleanValue()) {
                    Trace.out((String)("user has permission on node :" + node));
                    hasPermissionStr = ReportUtil.YES;
                    status = ReportUtil.PASSED;
                    locrs.addResult(node, 1);
                } else {
                    hasPermissionStr = ReportUtil.NO;
                    status = ReportUtil.FAILED;
                    locrs.addResult(node, 3);
                    noPermissionNodeList.add(node);
                    Trace.out((String)(" user does not have permission on node :" + node));
                }
                ReportUtil.writeRecord(node, hasPermissionStr, status);
            }
            ReportUtil.setTaskReference(previousTaskReference);
            if (noPermissionNodeList.size() > 0) {
                String errMsg = null;
                switch (wsType) {
                    case Directory: {
                        errMsg = this.s_gMsgBundle.getMessage("4531", true, (Object[])new String[]{username, path, VerificationUtil.strList2List(noPermissionNodeList)});
                        break;
                    }
                    case File: {
                        errMsg = this.s_gMsgBundle.getMessage("4532", true, (Object[])new String[]{username, path, VerificationUtil.strList2List(noPermissionNodeList)});
                        break;
                    }
                    case Registry: {
                        errMsg = this.s_gMsgBundle.getMessage("4533", true, (Object[])new String[]{username, path, VerificationUtil.strList2List(noPermissionNodeList)});
                    }
                }
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(noPermissionNodeList.toArray(new String[noPermissionNodeList.size()]), errDesc);
                ReportUtil.printWarning(errMsg);
            } else {
                String message = null;
                switch (wsType) {
                    case Directory: {
                        message = this.s_gMsgBundle.getMessage("4534", false, (Object[])new String[]{username, path});
                        break;
                    }
                    case File: {
                        message = this.s_gMsgBundle.getMessage("4535", false, (Object[])new String[]{username, path});
                        break;
                    }
                    case Registry: {
                        message = this.s_gMsgBundle.getMessage("4536", false, (Object[])new String[]{username, path});
                    }
                }
                ReportUtil.sureprintln(message);
            }
        }
        catch (CompositeOperationException e) {
            Trace.out((String)("COE while trying to get permissions" + e.getMessage()));
            String[] errNodeArr = this.getCompositeOperationFailureNodes(e);
            this.displayPermissionsErrorMessage(e.getMessage(), path, username, wsType, locrs, errNodeArr);
        }
        catch (WindowsSecurityException e) {
            Trace.out((String)("WSE while trying to get permissions" + e.getMessage()));
            this.displayPermissionsErrorMessage(e.getMessage(), path, username, wsType, locrs, this.m_nodeList);
        }
    }

    private void displayPermissionsErrorMessage(String exptMsg, String path, String username, WindowsStorageType wsType, ResultSet locrs, String[] nodeArr) {
        String errMsg = null;
        switch (wsType) {
            case Directory: {
                errMsg = this.s_gMsgBundle.getMessage("4537", true, (Object[])new String[]{username, VerificationUtil.strArr2String(nodeArr), path}) + LSEP + exptMsg;
                break;
            }
            case File: {
                errMsg = this.s_gMsgBundle.getMessage("4538", true, (Object[])new String[]{username, VerificationUtil.strArr2String(nodeArr), path}) + LSEP + exptMsg;
                break;
            }
            case Registry: {
                errMsg = this.s_gMsgBundle.getMessage("4539", true, (Object[])new String[]{username, VerificationUtil.strArr2String(nodeArr), path}) + LSEP + exptMsg;
            }
        }
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        locrs.addErrorDescription(errDesc);
        locrs.addResult(nodeArr, 2);
        ReportUtil.sureprintln(errMsg);
    }

    private void performGroupMembershipCheck(WinSecurityFactory wsecFac, String username, ResultSet locrs, String groupChk, TaskAnonymousProxy anonTask) {
        try {
            ReportUtil.println(this.s_gMsgBundle.getMessage("4523", false, (Object[])new String[]{username, groupChk}));
            Group group = wsecFac.getGroup(groupChk, new Version());
            Trace.out((String)("checking if user " + username + " is part of " + groupChk + " group"));
            Map grpMembershipMap = group.isMemberOf(username, true, this.m_localName, this.m_nodeList);
            Task previousTaskReference = ReportUtil.setTaskReference(anonTask);
            ReportUtil.writeColHeaders(this.s_msgBundle.getMessage("8000", false), this.s_gMsgBundle.getMessage("0402", false), this.s_msgBundle.getMessage("8018", false));
            ArrayList<String> notMemberList = new ArrayList<String>();
            for (String node : grpMembershipMap.keySet()) {
                String status;
                String isMemberStr;
                if (((Boolean)grpMembershipMap.get(node)).booleanValue()) {
                    Trace.out((String)("user is a " + groupChk + " member on node :" + node));
                    isMemberStr = ReportUtil.YES;
                    status = ReportUtil.PASSED;
                    locrs.addResult(node, 1);
                } else {
                    isMemberStr = ReportUtil.NO;
                    status = ReportUtil.FAILED;
                    locrs.addResult(node, 3);
                    notMemberList.add(node);
                    Trace.out((String)(" user is not part of " + groupChk + " group on node :" + node));
                }
                ReportUtil.writeRecord(node, isMemberStr, status);
            }
            ReportUtil.setTaskReference(previousTaskReference);
            if (notMemberList.size() > 0) {
                String errMsg = this.s_gMsgBundle.getMessage("4524", true, (Object[])new String[]{username, VerificationUtil.strList2List(notMemberList), groupChk});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(notMemberList.toArray(new String[notMemberList.size()]), errDesc);
                ReportUtil.printWarning(errMsg);
            } else {
                ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("4525", false, (Object[])new String[]{username, groupChk}));
            }
        }
        catch (WindowsSecurityException e) {
            String errMsg = this.s_gMsgBundle.getMessage("4526", true, (Object[])new String[]{username, groupChk}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(errMsg);
        }
        catch (CompositeOperationException e) {
            String[] errNodeArr = this.getCompositeOperationFailureNodes(e);
            String errMsg = this.s_gMsgBundle.getMessage("4526", true, (Object[])new String[]{username, groupChk}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(errNodeArr, 2);
            ReportUtil.sureprintln(errMsg);
        }
    }

    private String[] getCompositeOperationFailureNodes(CompositeOperationException e) {
        ArrayList<String> failedNodeList = new ArrayList<String>();
        for (String node : this.m_nodeList) {
            try {
                if (e.getStatus((Object)node) == CompositeOperationException.Status.SUCCESS) continue;
                failedNodeList.add(node);
            }
            catch (NoSuchIdentifierException ne) {
                failedNodeList.add(node);
            }
        }
        return failedNodeList.toArray(new String[failedNodeList.size()]);
    }

    private boolean performGMSAValidation(User user, String username) {
        boolean retval = true;
        ResultSet locrs = new ResultSet();
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy(this.s_gMsgBundle.getMessage("4499", false, (Object[])new String[]{username}), this.m_nodeList, this);
        ReportUtil.println(this.s_gMsgBundle.getMessage("4540", false, (Object[])new String[]{username}));
        try {
            Map gmsaMap = user.isGroupMSA(this.m_localName, this.m_nodeList);
            Task previousTaskReference = ReportUtil.setTaskReference(anonymousTask);
            ReportUtil.writeColHeaders(this.s_msgBundle.getMessage("8000", false), this.s_gMsgBundle.getMessage("0414", false), this.s_msgBundle.getMessage("8018", false));
            ArrayList<String> gmsaNodesList = new ArrayList<String>();
            for (String node : gmsaMap.keySet()) {
                String status;
                String isGMSAStr;
                if (((Boolean)gmsaMap.get(node)).booleanValue()) {
                    isGMSAStr = ReportUtil.YES;
                    status = ReportUtil.PASSED;
                    locrs.addResult(node, 1);
                    Trace.out((String)(" user is gmsa on node :" + node));
                } else {
                    Trace.out((String)(" user is not gmsa on node :" + node));
                    isGMSAStr = ReportUtil.NO;
                    status = ReportUtil.FAILED;
                    locrs.addResult(node, 4);
                    gmsaNodesList.add(node);
                }
                ReportUtil.writeRecord(node, isGMSAStr, status);
            }
            ReportUtil.setTaskReference(previousTaskReference);
            if (gmsaNodesList.size() > 0) {
                String errMsg = this.s_gMsgBundle.getMessage("4541", true, (Object[])new String[]{username, VerificationUtil.strList2List(gmsaNodesList)});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                locrs.addErrorDescription(gmsaNodesList.toArray(new String[gmsaNodesList.size()]), errDesc);
                ReportUtil.printError(errMsg);
                retval = false;
            } else {
                ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("4542", false, (Object[])new String[]{username}));
            }
            anonymousTask.performAnonymousTask(locrs);
            this.m_resultSet.uploadResultSet(locrs);
        }
        catch (WindowsSecurityException e) {
            String errMsg = this.s_gMsgBundle.getMessage("4543", true, (Object[])new String[]{username, VerificationUtil.strArr2String(this.m_nodeList)}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(this.m_nodeList, 2);
            ReportUtil.sureprintln(errMsg);
            anonymousTask.performAnonymousTask(locrs);
            this.m_resultSet.uploadResultSet(locrs);
            return false;
        }
        catch (CompositeOperationException e) {
            String[] errNodeArr = this.getCompositeOperationFailureNodes(e);
            String errMsg = this.s_gMsgBundle.getMessage("4543", true, (Object[])new String[]{username, VerificationUtil.strArr2String(errNodeArr)}) + LSEP + e.getMessage();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            locrs.addErrorDescription(errDesc);
            locrs.addResult(errNodeArr, 2);
            ReportUtil.sureprintln(errMsg);
            anonymousTask.performAnonymousTask(locrs);
            this.m_resultSet.uploadResultSet(locrs);
            return false;
        }
        return retval;
    }

    @Override
    public String getDefaultElementName() {
        return this.s_gMsgBundle.getMessage("4501", false);
    }

    @Override
    public String getDefaultDescription() {
        return this.s_gMsgBundle.getMessage("4502", false);
    }
}

