/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.sCommandsUtil;

public class sTaskNameServiceSwitch
extends Task {
    private sCommandsUtil m_cmdsUtil = null;
    String m_nsswConfFile;
    HashMap<String, List<String>> m_hostsEntryMap = new HashMap();
    List<String> m_confOKVector = new ArrayList<String>();
    boolean m_nsswConfMissingAllNodes = false;
    String m_hostsEntry;
    final String m_hostsLineFormat = "^[\\s]*hosts[\\s]*[:=].*";

    public sTaskNameServiceSwitch(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_RACNODE_ADD: 
            case PREREQ_NODE_ADD: 
            case PREREQ_FARM_HEALTH: {
                return true;
            }
        }
        return !VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.SCAN_NAME)) || this.m_globalContext.isDHCPConfigured();
    }

    public sTaskNameServiceSwitch(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    @Override
    public boolean performTask() {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            return true;
        }
        this.performNSSwitchConfValidation();
        String msg = this.m_resultSet.allSuccess() ? s_gMsgBundle.getMessage("2062", false, (Object[])new String[]{this.m_nsswConfFile}) + LSEP : s_gMsgBundle.getMessage("2063", false, (Object[])new String[]{this.m_nsswConfFile}) + LSEP;
        ReportUtil.sureprintln(msg);
        return this.m_resultSet.allSuccess();
    }

    boolean performNSSwitchConfValidation() {
        this.m_cmdsUtil = new sCommandsUtil();
        Object cmdSpec = null;
        this.m_nsswConfFile = this.m_cmdsUtil.getNsswitch();
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("2051", false, (Object[])new String[]{this.m_nsswConfFile}));
        if (!this.prepareNameSrvConfMap()) {
            return false;
        }
        if (this.m_nsswConfMissingAllNodes) {
            return true;
        }
        if (this.m_confOKVector.size() == 0) {
            return false;
        }
        if (!this.performHostsEntryValidation()) {
            return false;
        }
        for (String node : this.m_nodeList) {
            this.m_resultSet.addResult(node, 1);
            if (!VerificationUtil.isStringGood(this.m_hostsEntry)) continue;
            this.m_resultSet.getResult(node).addResultInfo(this.m_hostsEntry);
        }
        return true;
    }

    private boolean prepareNameSrvConfMap() {
        boolean status = true;
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg = s_msgBundle.getMessage("5642", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            return false;
        }
        ArrayList<String> nsswConfnotExistNodes = new ArrayList<String>();
        ArrayList<String> nsswConfExistNodes = new ArrayList<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        for (String node : this.m_nodeList) {
            boolean successfulCopy = false;
            Trace.out((String)("copying file from node:" + node));
            try {
                boolean currentNodeStatus = clusterCmd.fileExists(node, this.m_nsswConfFile);
                if (!currentNodeStatus) {
                    Trace.out((String)("'" + this.m_nsswConfFile + "' does not exist on node" + node));
                    nsswConfnotExistNodes.add(node);
                    continue;
                }
                nsswConfExistNodes.add(node);
                successfulCopy = clusterCmd.copyFileFromNode(node, this.m_nsswConfFile, scratchPath + "/nssw_conf_" + node);
                Trace.out((String)("successfulCopy = " + successfulCopy));
                if (!successfulCopy) continue;
                this.m_confOKVector.add(node);
            }
            catch (ClusterException e) {
                Trace.out((String)("ClusterException while looking for '" + this.m_nsswConfFile + "'"));
                this.m_resultSet.addResult(node, 2);
                String msg = s_gMsgBundle.getMessage("2002", true, (Object[])new String[]{this.m_nsswConfFile, node, m_localNode}) + LSEP + e.getMessage();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(msg));
                ReportUtil.sureprintln(msg);
                status = false;
            }
        }
        if (nsswConfnotExistNodes.size() > 0 && nsswConfExistNodes.size() > 0) {
            Trace.out((String)"configuration file exists on some nodes");
            String msg = s_msgBundle.getMessage("5605", true, (Object[])new String[]{this.m_nsswConfFile, VerificationUtil.strList2List(nsswConfnotExistNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addResult(nsswConfnotExistNodes.toArray(new String[0]), 3);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            ReportUtil.sureprintln(s_msgBundle.getMessage("0008", false));
            ReportUtil.sureprintNodelist(nsswConfExistNodes.toArray(new String[0]));
            ReportUtil.sureprintln("");
        } else if (nsswConfExistNodes.size() == 0) {
            Trace.out((String)"no configuration file on any node. not an error just skip the test");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5606", false, (Object[])new String[]{this.m_nsswConfFile}));
            this.m_resultSet.addResult(this.m_nodeList, 1);
            this.m_nsswConfMissingAllNodes = true;
            return true;
        }
        if (this.m_confOKVector.size() == 0) {
            return false;
        }
        for (String node : this.m_confOKVector) {
            boolean badConfFile = false;
            ArrayList badResolvConfLines = new ArrayList();
            ArrayList<String> hostsEntryList = new ArrayList<String>();
            Trace.out((String)("Parsing configuration file of node:" + node));
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(scratchPath + "/nssw_conf_" + node));
                while ((line = in.readLine()) != null) {
                    String[] tokens;
                    if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    int index = line.indexOf("#");
                    if (index != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((index = line.indexOf(";")) != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if (!(line = VerificationUtil.strArr2String(tokens = line.split("\\s+"), " ")).matches("^[\\s]*hosts[\\s]*[:=].*")) continue;
                    Trace.out((String)(node + ":Found hosts entry==>" + line));
                    hostsEntryList.add(line);
                    this.m_hostsEntry = line;
                }
                this.m_hostsEntryMap.put(node, hostsEntryList);
                in.close();
            }
            catch (IOException e) {
                Trace.out((String)("IOException while reading copied configuration file for node :" + node));
                this.m_resultSet.addResult(node, 2);
                String msg = s_msgBundle.getMessage("5629", true, (Object[])new String[]{this.m_nsswConfFile, node}) + LSEP + e.getMessage();
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(msg);
                this.m_confOKVector.remove(node);
                status = false;
            }
        }
        return status;
    }

    public boolean performHostsEntryValidation() {
        ErrorDescription errDesc;
        ResultSet locRes = new ResultSet();
        boolean toRejectAllConfigFiles = false;
        boolean status = true;
        ReportUtil.println(s_gMsgBundle.getMessage("2050", false, (Object[])new String[]{this.m_nsswConfFile}));
        ArrayList<String> hostsExistNode = new ArrayList<String>();
        ArrayList<String> hostsNonExistantNodes = new ArrayList<String>();
        for (String node : this.m_confOKVector) {
            if (this.m_hostsEntryMap.get(node) != null && this.m_hostsEntryMap.get(node).size() != 0) {
                Trace.out((String)("hosts exists on node :" + node));
                hostsExistNode.add(node);
                continue;
            }
            Trace.out((String)("hosts does not exist on node :" + node));
            hostsNonExistantNodes.add(node);
        }
        if (hostsExistNode.size() > 0 && hostsNonExistantNodes.size() > 0) {
            String[] hostsNonExistantArray = hostsNonExistantNodes.toArray(new String[0]);
            String msg = s_gMsgBundle.getMessage("2052", true, (Object[])new String[]{this.m_nsswConfFile, VerificationUtil.strList2List(hostsNonExistantNodes)});
            locRes.addResult(hostsNonExistantArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            if (hostsExistNode.size() == 0) {
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2056", false, (Object[])new String[]{this.m_nsswConfFile}));
            }
            locRes.addResult(this.m_confOKVector.toArray(new String[0]), 1);
        }
        if (hostsExistNode.size() == 0) {
            Trace.out((String)"hosts name doesn't exist on any node");
            this.m_resultSet.uploadResultSet(locRes);
            return status;
        }
        ArrayList<String> singleHostsNodes = new ArrayList<String>();
        ArrayList<String> multiHostsNodes = new ArrayList<String>();
        ReportUtil.println(s_gMsgBundle.getMessage("2053", false, (Object[])new String[]{this.m_nsswConfFile}));
        for (String node : hostsExistNode) {
            int hostsCount = this.m_hostsEntryMap.get(node).size();
            Trace.out((String)("There are " + hostsCount + " hosts on " + node));
            if (hostsCount > 1) {
                multiHostsNodes.add(node);
                continue;
            }
            locRes.addResult(node, 1);
            singleHostsNodes.add(node);
        }
        if (multiHostsNodes.size() > 0) {
            toRejectAllConfigFiles = true;
            String[] multiHostsArray = multiHostsNodes.toArray(new String[0]);
            String msg = s_gMsgBundle.getMessage("2054", true, (Object[])new String[]{this.m_nsswConfFile, VerificationUtil.strList2List(multiHostsNodes)});
            locRes.addResult(multiHostsArray, 3);
            errDesc = new ErrorDescription(msg);
            locRes.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg);
            status = false;
        } else {
            ReportUtil.println(s_gMsgBundle.getMessage("2055", false, (Object[])new String[]{this.m_nsswConfFile}));
        }
        if (singleHostsNodes.size() <= 1) {
            Trace.out((String)"no or only one nodes with single hosts name");
            this.m_resultSet.uploadResultSet(locRes);
            return status;
        }
        Hashtable<Object, Vector<Object>> hostsTable = new Hashtable<Object, Vector<Object>>();
        for (String node : singleHostsNodes) {
            Trace.out((String)("Node with single hosts entry:" + node));
            VerificationUtil.updateResultMap(hostsTable, this.m_hostsEntryMap.get(node).get(0), node);
        }
        if (hostsTable.size() == 1) {
            if (!toRejectAllConfigFiles) {
                locRes.addResult(singleHostsNodes, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("2057", false, (Object[])new String[]{this.m_nsswConfFile}));
            }
        } else {
            StringBuilder msg = new StringBuilder();
            msg.append(s_gMsgBundle.getMessage("2058", true, (Object[])new String[]{this.m_nsswConfFile}));
            Enumeration<Object> e = hostsTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String nodeListStr = VerificationUtil.strList2List((List<String>)hostsTable.get(key));
                msg.append(LSEP + s_gMsgBundle.getMessage("2059", false, (Object[])new String[]{key, nodeListStr}));
            }
            locRes.addResult(singleHostsNodes, 3);
            locRes.addErrorDescription(new ErrorDescription(msg.toString()));
            ReportUtil.sureprintln(msg.toString());
            status = false;
        }
        this.m_resultSet.uploadResultSet(locRes);
        return status;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9503", false);
    }

    @Override
    public String getTaskID() {
        return "DNS_CONFIG";
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9604", false);
    }
}

