/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskNameService;
import oracle.ops.verification.framework.engine.task.sTaskNameServiceSwitch;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.framework.util.sCommandsUtil;

public class sTaskNameService
extends TaskNameService {
    private String[] m_nodeList = null;
    private String m_scanName = null;
    private sCommandsUtil m_cmdsUtil = null;
    private TaskNameService m_taskNS = null;
    private MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    static final String LSEP = System.getProperty("line.separator");

    public sTaskNameService(String[] nodeList, String scanName, TaskNameService taskNS) {
        this.m_nodeList = nodeList;
        this.m_scanName = scanName;
        this.m_taskNS = taskNS;
    }

    @Override
    public boolean performTask() {
        String status;
        String comment;
        InetAddress[] addrList;
        ErrorDescription errDesc;
        String nameServiceHost = null;
        boolean DNSbeforeNIS = false;
        HashSet<InetAddress> nsIPAddrs = new HashSet<InetAddress>();
        this.m_cmdsUtil = new sCommandsUtil();
        String hostsLine = null;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("ENTRY: scan name '" + this.m_scanName + "'"));
        }
        String osName = VerificationUtil.getCurrentOS().toLowerCase();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            return true;
        }
        ReportUtil.sureprintln(LSEP + this.s_msgBundle.getMessage("4655", false, (Object[])new String[]{this.m_scanName}));
        sTaskNameServiceSwitch taskNSS = new sTaskNameServiceSwitch(this.m_nodeList);
        taskNSS.setChildTaskLevel(this.m_taskNS.getChildTaskLevel() + 1);
        String taskNameStr = this.s_gMsgBundle.getMessage("2061", false);
        taskNSS.setElementName(taskNameStr);
        this.m_taskNS.addChildTask(taskNSS);
        Task previousTaskReference = null;
        previousTaskReference = ReportUtil.setTaskReference(this.m_taskNS);
        boolean isOkNSS = taskNSS.perform();
        ResultSet nssResultSet = taskNSS.getResultSet();
        ReportUtil.setTaskReference(previousTaskReference);
        this.m_resultSet.uploadResultSet(nssResultSet);
        if (!isOkNSS) {
            return false;
        }
        Vector resInfoSet = nssResultSet.getResult(this.m_nodeList[0]).getResultInfoSet();
        if (resInfoSet != null && resInfoSet.size() > 0) {
            hostsLine = (String)resInfoSet.get(0);
        }
        Trace.out((String)("hostsLine=" + hostsLine));
        int foundDNS = 0;
        int foundNIS = 0;
        String searchStr = "dns";
        if (osName.contentEquals("aix")) {
            searchStr = "bind";
        }
        if (hostsLine == null) {
            hostsLine = new String();
        }
        foundNIS = hostsLine.indexOf("nis");
        foundDNS = hostsLine.indexOf(searchStr);
        if (foundNIS != -1 && foundDNS != -1 && foundDNS < foundNIS || foundDNS != -1 && foundNIS == -1) {
            DNSbeforeNIS = true;
        }
        Trace.out((int)5, (String)("DNSbeforeNIS is: " + DNSbeforeNIS));
        try {
            nameServiceHost = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: Local node not found: " + uhe.getMessage()));
            String errMsg = this.s_msgBundle.getMessage("0002", true);
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_taskNS.getResultSet().addResult(this.m_nodeList, 2);
            this.m_taskNS.getResultSet().addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        nsIPAddrs.addAll(this.getNSLookupIPAddrs(nameServiceHost, false));
        nsIPAddrs.addAll(this.getNSLookupIPAddrs(nameServiceHost, true));
        if (nsIPAddrs.size() == 0) {
            errDesc = new ErrorDescription("1101", new String[]{this.m_scanName}, this.s_gMsgBundle);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc);
        }
        try {
            addrList = InetAddress.getAllByName(this.m_scanName);
        }
        catch (UnknownHostException uhe2) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: InetAddress.getAllByName() failed: " + uhe2.getMessage()));
            errDesc = new ErrorDescription("1101", new String[]{this.m_scanName}, this.s_gMsgBundle);
            this.m_resultSet.addResult(nameServiceHost, 2);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        ArrayList<InetAddress> inetIPAddrs = new ArrayList<InetAddress>();
        for (InetAddress inAddr : addrList) {
            Trace.out((int)5, (String)("Adding inAddr: '" + inAddr + "'"));
            inetIPAddrs.add(inAddr);
        }
        ReportUtil.writeColHeaders(ReportUtil.SCANNAME, ReportUtil.IPADDR, ReportUtil.STATUS, ReportUtil.COMMENT);
        boolean diffDNSNIS = false;
        ArrayList<InetAddress> track_nsIPAddrs = new ArrayList<InetAddress>();
        track_nsIPAddrs.addAll(nsIPAddrs);
        for (InetAddress ipAddr : nsIPAddrs) {
            Trace.out((int)5, (String)("Checking ipAddr: '" + ipAddr + "'"));
            if (inetIPAddrs.size() != 0 && inetIPAddrs.contains(ipAddr)) {
                comment = new String("");
                status = ReportUtil.PASSED;
                ReportUtil.writeRecord(this.m_scanName, ipAddr.getHostAddress(), status, comment);
                track_nsIPAddrs.remove(ipAddr);
                inetIPAddrs.remove(ipAddr);
                Trace.out((int)5, (String)("Match DNS and NIS entry: '" + ipAddr + "'"));
                continue;
            }
            Trace.out((int)5, (String)("DNS and NIS do not match for: '" + ipAddr + "'"));
            comment = this.s_msgBundle.getMessage("4659", false);
            status = ReportUtil.FAILED;
            ReportUtil.writeRecord(this.m_scanName, ipAddr.getHostAddress(), status, comment);
            diffDNSNIS = true;
            track_nsIPAddrs.remove(ipAddr);
            errDesc = new ErrorDescription("4657", new String[]{this.m_scanName, ipAddr.getHostAddress()}, this.s_msgBundle);
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc);
            if (ReportUtil.isVerbose()) continue;
            ReportUtil.printError(errDesc.getErrorMessage());
        }
        for (InetAddress nisAddr : inetIPAddrs) {
            Trace.out((int)5, (String)("No DNS entry for NIS: '" + nisAddr + "'"));
            comment = this.s_msgBundle.getMessage("4660", false);
            status = ReportUtil.FAILED;
            ReportUtil.writeRecord(this.m_scanName, nisAddr.getHostAddress(), status, comment);
            diffDNSNIS = true;
            errDesc = new ErrorDescription("4657", new String[]{this.m_scanName, nisAddr.getHostAddress()}, this.s_msgBundle);
            this.m_resultSet.addResult(nameServiceHost, 3);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.printError(errDesc.getErrorMessage());
        }
        if (diffDNSNIS) {
            errDesc = !DNSbeforeNIS ? new ErrorDescription("4663", this.s_msgBundle) : new ErrorDescription("4664", new String[]{this.m_scanName}, this.s_msgBundle);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            ReportUtil.printError(errDesc.getErrorMessage());
            return false;
        }
        this.m_taskNS.getResultSet().addResult(this.m_nodeList, 1);
        return true;
    }

    private List<InetAddress> getNSLookupIPAddrs(String nameServiceHost, boolean bAAAARecord) {
        GlobalExecution globalExec = new GlobalExecution();
        ArrayList<InetAddress> nsIPAddrs = new ArrayList<InetAddress>();
        ResultSet nameSrvcRsltSet = new ResultSet();
        String cmdSpec = null;
        cmdSpec = bAAAARecord ? this.m_cmdsUtil.getNslookup() + " -type=AAAA " + this.m_scanName : this.m_cmdsUtil.getNslookup() + " " + this.m_scanName;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Running CMD: " + cmdSpec + "\n on Node: " + nameServiceHost));
        }
        Hashtable nsLookupOutput = globalExec.runExeWithOutput(new String[]{nameServiceHost}, cmdSpec, nameSrvcRsltSet);
        String output = (String)nsLookupOutput.get(nameServiceHost);
        String cmdOutput = VerificationUtil.fetchVerificationValue(output);
        String exitStat = VerificationUtil.fetchVerificationResult(output);
        if (exitStat != null && exitStat.contentEquals("0")) {
            Trace.out((int)5, (String)"nslookup command succeeded");
            String[] nsLookupOutputLines = VerificationUtil.string2strArr(cmdOutput, VerificationUtil.LINE_SEPARATOR);
            int i = 0;
            while (i < nsLookupOutputLines.length) {
                String outLine = nsLookupOutputLines[i];
                Trace.out((int)5, (String)("nslookup outputLine: \n" + outLine));
                StringTokenizer st2 = new StringTokenizer(outLine);
                String lineTag = st2.nextToken();
                Trace.out((int)5, (String)("Looking for 'Name:' in '" + lineTag + "'"));
                if (lineTag.startsWith("Name:") && st2.hasMoreTokens()) {
                    String name = st2.nextToken();
                    if (name.startsWith(this.m_scanName)) {
                        String outLine2 = nsLookupOutputLines[++i];
                        Trace.out((int)5, (String)("nslookup outputLine2: \n" + outLine2));
                        StringTokenizer st3 = new StringTokenizer(outLine2);
                        lineTag = st3.nextToken();
                        Trace.out((int)5, (String)("Looking for 'Address:' in '" + lineTag + "'"));
                        if (lineTag.startsWith("Address:")) {
                            String lineVal = st3.nextToken();
                            Trace.out((int)5, (String)("Adding name: '" + name + "'" + " and IP addr: '" + lineVal + "' from nslookup"));
                            nsIPAddrs.add(this.getInetAddress(lineVal));
                        } else if (lineTag.startsWith("Addresses:")) {
                            boolean checkForNoSpaces = false;
                            while (st3.hasMoreTokens()) {
                                String lineVal = st3.nextToken();
                                if (st3.hasMoreTokens()) {
                                    checkForNoSpaces = true;
                                }
                                String ipVal = null;
                                int commaPos = lineVal.indexOf(",");
                                ipVal = commaPos == -1 ? lineVal : lineVal.substring(0, commaPos);
                                if (!checkForNoSpaces && !st3.hasMoreTokens()) {
                                    checkForNoSpaces = true;
                                    String addrList = lineVal;
                                    StringTokenizer st4 = new StringTokenizer(addrList, ",");
                                    while (st4.hasMoreTokens()) {
                                        ipVal = st4.nextToken();
                                        Trace.out((int)5, (String)("Adding name: '" + name + "'" + " and IP addr: '" + ipVal + "' from nslookup"));
                                        nsIPAddrs.add(this.getInetAddress(ipVal));
                                    }
                                    continue;
                                }
                                Trace.out((int)5, (String)("Adding name: '" + name + "'" + " and IP addr: '" + ipVal + "' from nslookup"));
                                nsIPAddrs.add(this.getInetAddress(ipVal));
                            }
                        }
                    }
                    ++i;
                    continue;
                }
                if (lineTag.startsWith(this.m_scanName) && st2.hasMoreTokens()) {
                    String term4;
                    String term1 = st2.hasMoreTokens() ? st2.nextToken() : null;
                    String term2 = st2.hasMoreTokens() ? st2.nextToken() : null;
                    String term3 = st2.hasMoreTokens() ? st2.nextToken() : null;
                    String string = term4 = st2.hasMoreTokens() ? st2.nextToken() : null;
                    if (term1 != null && term2 != null && term3 != null && term4 != null && term1.equals("has") && term2.equals("AAAA") && term3.equals("address")) {
                        Trace.out((String)("Adding IP addr: '" + term4 + "' from nslookup"));
                        nsIPAddrs.add(this.getInetAddress(term4));
                    } else if (term1 != null && term2 != null && term3 != null && term4 != null && term1.equals("IPv6") && term2.equals("address") && term3.equals("=")) {
                        Trace.out((String)("Adding IP addr: '" + term4 + "' from nslookup"));
                        nsIPAddrs.add(this.getInetAddress(term4));
                    } else {
                        Trace.out((String)("could not understand : " + lineTag));
                    }
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        return nsIPAddrs;
    }

    private InetAddress getInetAddress(String ipVal) {
        InetAddress retVal = null;
        try {
            retVal = InetAddress.getByName(ipVal);
        }
        catch (UnknownHostException uhEx) {
            Trace.out((String)("UnknownHostException occured while doing InetAddress.getByName with name " + ipVal));
        }
        return retVal;
    }
}

