/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class sTaskNICBindingOrder
extends Task {
    private Set<NetworkInfo> m_clusterNetworks = null;
    private boolean m_isIPv4PublicNetwork = false;
    private boolean m_isIPv6Network = true;
    private boolean m_isPostW2k12 = VerificationUtil.isPostW2K12();
    HashMap<String, List<String>> nodeNICBindOrderInfo = new HashMap();
    HashMap<String, HashMap<String, String>> nodeNICMetricInfo = new HashMap();
    HashMap<String, List<String>> nodePvtNICList = new HashMap();
    HashMap<String, List<String>> nodePubNICList = new HashMap();

    public sTaskNICBindingOrder(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ResultSet networksResultSet = new ResultSet();
        try {
            Set<NetworkInfo> networks = NetworkUtility.getNetworkInfo(networksResultSet);
            if (!NetworkUtility.isNetworksSetGood(networks) || networksResultSet.anyFailure()) {
                Trace.out((String)"Could not get the cluster network details successfully during NIC Binding order checks");
                NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, false);
            }
            if (NetworkUtility.isNetworksSetGood(networks)) {
                this.m_clusterNetworks = networks;
            }
        }
        catch (CVUException cvuEx) {
            String errMsg = cvuEx.getMessage();
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            VerificationUtil.traceAndLog("Exception occured while getting network info. msg=" + cvuEx.getMessage());
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!NetworkUtility.isNetworksSetGood(this.m_clusterNetworks)) {
            Trace.out((String)"Could not find cluster networks. Hence task not applicable");
            return false;
        }
        for (NetworkInfo network : this.m_clusterNetworks) {
            Trace.out((String)("Network Subnet : " + network.getSubnetAsString()));
            if (IPAddressUtil.isIPv4AddressString((String)network.getSubnetAsString()) && (network.getNetworkType() & 1) == 0 && (network.getNetworkType() & 0x80) == 0) {
                this.m_isIPv4PublicNetwork = true;
                Trace.out((String)"Found public IPV4 network");
                break;
            }
            if (!this.m_isIPv6Network || IPAddressUtil.isIPv6AddressString((String)network.getSubnetAsString())) continue;
            this.m_isIPv6Network = false;
        }
        return this.m_isIPv4PublicNetwork || this.m_isIPv6Network || this.m_isPostW2k12;
    }

    public sTaskNICBindingOrder(String[] nodeList, Set<NetworkInfo> clusterNetworks) {
        this.m_nodeList = nodeList;
        if (NetworkUtility.isNetworksSetGood(clusterNetworks)) {
            this.m_clusterNetworks = clusterNetworks;
            for (NetworkInfo network : this.m_clusterNetworks) {
                if (IPAddressUtil.isIPv4AddressString((String)network.getSubnetAsString()) && (network.getNetworkType() & 1) == 0 && (network.getNetworkType() & 0x80) == 0) {
                    this.m_isIPv4PublicNetwork = true;
                    Trace.out((String)"Found public IPV4 network");
                    break;
                }
                if (!this.m_isIPv6Network || IPAddressUtil.isIPv6AddressString((String)network.getSubnetAsString())) continue;
                this.m_isIPv6Network = false;
            }
        }
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"performTask Entry");
        ResultSet rsltSet = new ResultSet();
        boolean retVal = true;
        if (!NetworkUtility.isNetworksSetGood(this.m_clusterNetworks)) {
            this.m_resultSet.setStatus(1);
            Trace.out((String)"NIC bind order check can not proceed: User provided  interface info is empty ");
        } else if (this.m_isIPv4PublicNetwork || this.m_isIPv6Network || this.m_isPostW2k12) {
            HashMap<String, Vector> nodeWiseNICInfo = new VerifyNetwork().getNICBindOrder(this.m_nodeList, rsltSet);
            this.m_resultSet.uploadResultSet(rsltSet);
            if (!rsltSet.anySuccess()) {
                Trace.out((String)"Failure in retrieval of NIC bind order information on  all nodes");
                this.m_resultSet.uploadResultSet(rsltSet);
                ReportUtil.printError(s_gMsgBundle.getMessage("11776", true));
                return false;
            }
            ArrayList<String> opFailedNodeList = new ArrayList<String>();
            Hashtable ht = rsltSet.getResultTable();
            Enumeration e = ht.keys();
            while (e.hasMoreElements()) {
                String node = (String)e.nextElement();
                Result nodeRes = (Result)ht.get(node);
                if (nodeRes.getStatus() == 1) {
                    HashMap<String, String> nicMetricInfo = new HashMap<String, String>();
                    ArrayList<String> nicBindOrderInfo = new ArrayList<String>();
                    ArrayList<String> publicNICList = new ArrayList<String>();
                    ArrayList<String> privateNICList = new ArrayList<String>();
                    ArrayList nicInfo = new ArrayList(nodeWiseNICInfo.get(node));
                    block3: for (String nic : nicInfo) {
                        String[] nicInfoArray = VerificationUtil.string2strArr(nic);
                        if (nicInfoArray.length <= 4) continue;
                        try {
                            String friendlyName = nicInfoArray[0].trim();
                            String adapterName = nicInfoArray[1].trim();
                            String ipv4AddrStr = GenericUtil.getValueByKey(nicInfoArray[2].trim(), "IPV4");
                            ArrayList<String> ipv4AddrList = new ArrayList<String>();
                            if (VerificationUtil.isStringGood(ipv4AddrStr)) {
                                ipv4AddrList.addAll(Arrays.asList(VerificationUtil.string2strArr(ipv4AddrStr, " ")));
                            }
                            String ipv6AddrStr = GenericUtil.getValueByKey(nicInfoArray[3].trim(), "IPV6");
                            ArrayList<String> ipv6AddrList = new ArrayList<String>();
                            if (VerificationUtil.isStringGood(ipv6AddrStr)) {
                                ipv6AddrList.addAll(Arrays.asList(VerificationUtil.string2strArr(ipv6AddrStr, " ")));
                            }
                            String nicMetric = GenericUtil.getValueByKey(nicInfoArray[4].trim(), "METRIC");
                            for (NetworkInfo network : this.m_clusterNetworks) {
                                if (!VerificationUtil.isStringGood(friendlyName) || !VerificationUtil.isStringGood(adapterName) || !friendlyName.equals(network.getInterfaceName()) || (!IPAddressUtil.isIPv4AddressString((String)network.getSubnetAsString()) || !ipv4AddrList.contains(network.getIPAsString())) && (!IPAddressUtil.isIPv6AddressString((String)network.getSubnetAsString()) || !ipv6AddrList.contains(network.getIPAsString()))) continue;
                                nicBindOrderInfo.add(friendlyName);
                                nicMetricInfo.put(adapterName, nicMetric);
                                if ((network.getNetworkType() & 2) != 0) {
                                    publicNICList.add(adapterName);
                                    continue block3;
                                }
                                privateNICList.add(adapterName);
                            }
                        }
                        catch (ParsingException p) {
                            Trace.out((String)p.getMessage());
                            this.m_resultSet.addResult(node, 2);
                            this.m_resultSet.addErrorDescription(node, new ErrorDescription(p.getMessage()));
                            ReportUtil.sureprintln(p.getMessage());
                            opFailedNodeList.add(node);
                            retVal = false;
                        }
                    }
                    this.nodeNICBindOrderInfo.put(node, nicBindOrderInfo);
                    this.nodeNICMetricInfo.put(node, nicMetricInfo);
                    this.nodePvtNICList.put(node, privateNICList);
                    this.nodePubNICList.put(node, publicNICList);
                    continue;
                }
                this.m_resultSet.addResult(node, nodeRes);
                opFailedNodeList.add(node);
                retVal = false;
            }
            if (opFailedNodeList.size() > 0) {
                ReportUtil.printError(s_gMsgBundle.getMessage("11775", true, (Object[])new String[]{VerificationUtil.strList2List(opFailedNodeList)}));
                return retVal;
            }
            if (this.m_isPostW2k12) {
                retVal &= this.performNICMetricCheck();
            }
            if (this.m_isIPv4PublicNetwork || this.m_isIPv6Network) {
                retVal &= this.performNICBindOrderCheck();
            }
        }
        Trace.out((String)"TaskNICBindingOrder :: exiting ");
        return retVal;
    }

    private boolean performNICMetricCheck() {
        boolean retVal = true;
        String status = "";
        Trace.out((String)"Checking NIC metric value for pub and pvt interfaces");
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11777", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        for (String node : this.nodeNICMetricInfo.keySet()) {
            for (String pubNic : this.nodePubNICList.get(node)) {
                String pubNICMetric = this.nodeNICMetricInfo.get(node).get(pubNic);
                try {
                    int pubNICMetricVal = Integer.parseInt(pubNICMetric);
                    for (String prvNic : this.nodePvtNICList.get(node)) {
                        String prvNICMetric = this.nodeNICMetricInfo.get(node).get(prvNic);
                        try {
                            int prvNICMetricVal = Integer.parseInt(prvNICMetric);
                            if (pubNICMetricVal < prvNICMetricVal) continue;
                            String errMsg = s_gMsgBundle.getMessage("11779", true, (Object[])new String[]{pubNICMetric, pubNic, prvNICMetric, prvNic, node});
                            ReportUtil.sureprintln(errMsg);
                            Trace.out((String)("Public NIC: " + pubNic + " Metric: " + pubNICMetric + " Private NIC: " + prvNic + " Metric : " + prvNICMetric + "\n" + errMsg));
                            this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                            this.m_resultSet.addResult(node, 3);
                            status = ReportUtil.FAILED;
                            retVal = false;
                        }
                        catch (NumberFormatException nfe) {
                            Trace.out((String)nfe.getMessage());
                            String mesg = s_gMsgBundle.getMessage("11780", true, (Object[])new String[]{prvNICMetric}) + LSEP + nfe.getMessage();
                            ErrorDescription errorDesc = new ErrorDescription(mesg);
                            this.m_resultSet.addErrorDescription(node, errorDesc);
                            this.m_resultSet.addResult(node, 2);
                            ReportUtil.printError(mesg + LSEP);
                            retVal = false;
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    Trace.out((String)nfe.getMessage());
                    String mesg = s_gMsgBundle.getMessage("11780", true, (Object[])new String[]{pubNICMetric}) + LSEP + nfe.getMessage();
                    ErrorDescription errorDesc = new ErrorDescription(mesg);
                    this.m_resultSet.addErrorDescription(node, errorDesc);
                    this.m_resultSet.addResult(node, 2);
                    ReportUtil.printError(mesg + LSEP);
                    retVal = false;
                }
            }
            if (retVal) {
                this.m_resultSet.addResult(node, 1);
                status = ReportUtil.PASSED;
                Trace.out((String)("NIC metric check PASSED on node " + node));
            }
            ReportUtil.writeRecord(node, status);
        }
        Trace.out((String)"NIC metric check completed");
        return retVal;
    }

    private boolean performNICBindOrderCheck() {
        boolean retVal = true;
        String status = "";
        Trace.out((String)"Checking NIC bind order");
        ReportUtil.blankln();
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11772", false));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        for (String node : this.nodeNICBindOrderInfo.keySet()) {
            boolean pvtIfExist = false;
            block1: for (String nic : this.nodeNICBindOrderInfo.get(node)) {
                for (NetworkInfo network : this.m_clusterNetworks) {
                    if (!nic.equals(network.getInterfaceName())) continue;
                    if ((network.getNetworkType() & 2) != 0) {
                        if (!pvtIfExist) continue block1;
                        String errMsg = s_gMsgBundle.getMessage("11774", true, (Object[])new String[]{node});
                        Trace.out((String)("NIC bind order Check failed on node: " + node + " Error Info : " + errMsg));
                        this.m_resultSet.addErrorDescription(node, new ErrorDescription(errMsg));
                        this.m_resultSet.addResult(node, 3);
                        status = ReportUtil.FAILED;
                        retVal = false;
                        continue block1;
                    }
                    if ((network.getNetworkType() & 1) == 0) continue;
                    pvtIfExist = true;
                    continue block1;
                }
            }
            if (retVal) {
                this.m_resultSet.addResult(node, 1);
                status = ReportUtil.PASSED;
                Trace.out((String)("Task PASSED on node " + node));
            }
            ReportUtil.writeRecord(node, status);
        }
        Trace.out((String)"NIC bind order check completed");
        return retVal;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11770", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11771", false);
    }
}

