/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskClusterIntegrity;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ServiceConfiguration;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskClusterIntegrity {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    static final String LSEP = System.getProperty("line.separator");
    static final String FSEP = System.getProperty("file.separator");
    private TaskClusterIntegrity m_genTask;
    private final String ORAARPDRV_SERVICE = "oraarpdrv";

    public sTaskClusterIntegrity(TaskClusterIntegrity genTask) {
        this.m_genTask = genTask;
    }

    public boolean performCheck() {
        String[] mbrNds;
        boolean retVal;
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4750", false));
        ReportUtil.sureblankln();
        ResultSet resultSet = new ResultSet();
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_genTask.m_nodeList, this.m_genTask.m_resultSet);
        if (validNodeArr == null) {
            return false;
        }
        String osVersion = System.getProperty("os.name");
        if (osVersion.contains("2008") && !VerificationUtil.isCVUTestEnv() && !(retVal = this.performOraarpdrvCheck(validNodeArr))) {
            return false;
        }
        GlobalExecution globalExec = new GlobalExecution();
        String crsHome = VerificationUtil.getCRSHome();
        String cmd = crsHome + FSEP + "bin" + FSEP + "olsnodes.exe";
        Trace.out((String)("==== Olsnodes command: " + cmd));
        Hashtable olsnodesOutputHT = globalExec.runExeWithOutput(validNodeArr, cmd, resultSet);
        Vector<String> notRunVec = new Vector<String>();
        Hashtable partHt = new Hashtable();
        Hashtable ht = resultSet.getResultTable();
        Enumeration nodesEnum = ht.keys();
        while (nodesEnum.hasMoreElements()) {
            String curNode = (String)nodesEnum.nextElement();
            Trace.out((String)("==== Analyzing olsnodes output for node " + curNode));
            Result result = (Result)ht.get(curNode);
            if (result == null) {
                Trace.out((String)("==== OLSNODE output not found for node " + curNode));
                this.m_genTask.getResultSet().addResult(curNode, 2);
                this.m_genTask.getResultSet().addErrorDescription(curNode, new ErrorDescription(s_msgBundle.getMessage("4758", false, (Object[])new String[]{curNode})));
                notRunVec.add(curNode);
                continue;
            }
            if (result.getStatus() == 1) {
                String exitStatus = VerificationUtil.fetchVerificationResult((String)olsnodesOutputHT.get(curNode));
                if (!exitStatus.equals("0")) {
                    Trace.out((String)("==== Non-zero exit stauts(" + exitStatus + ") from Olsnodes for " + curNode));
                    notRunVec.add(curNode);
                    this.m_genTask.getResultSet().addResult(curNode, 2);
                    this.m_genTask.getResultSet().addErrorDescription(curNode, new ErrorDescription(s_msgBundle.getMessage("4759", false, (Object[])new String[]{curNode})));
                    continue;
                }
                String[] outList = (String[])result.getResultInfoSet().firstElement();
                for (int cnt = 0; cnt < outList.length; ++cnt) {
                    outList[cnt] = outList[cnt].trim();
                }
                String partKey = VerificationUtil.strArr2List(outList);
                Trace.out((String)("==== Node sequence obtained for cluster integrity: " + partKey));
                Vector partMbrVec = (Vector)partHt.get(partKey);
                if (partMbrVec == null) {
                    Vector<String> newPartVec = new Vector<String>();
                    newPartVec.add(new String(curNode));
                    partHt.put(partKey, newPartVec);
                    continue;
                }
                partMbrVec.add(new String(curNode));
                continue;
            }
            if (result.getStatus() == 2) {
                Trace.out((String)("==== OLSNODE failed for node " + curNode));
                this.m_genTask.getResultSet().addResult(curNode, 2);
                this.m_genTask.getResultSet().addErrorDescription(curNode, new ErrorDescription(s_msgBundle.getMessage("4759", false, (Object[])new String[]{curNode})));
                notRunVec.add(curNode);
                continue;
            }
            Trace.out((String)("==== OLSNODE was not successful for node " + curNode));
            this.m_genTask.getResultSet().addResult(curNode, 2);
            this.m_genTask.getResultSet().addErrorDescription(curNode, new ErrorDescription(s_msgBundle.getMessage("4759", false, (Object[])new String[]{curNode})));
            notRunVec.add(curNode);
        }
        int numPart = partHt.size();
        if (numPart == 0) {
            Trace.out((String)("==== Number of partitions found " + numPart));
        } else if (numPart == 1) {
            String stmt1 = "";
            if (notRunVec.isEmpty()) {
                Trace.out((String)"==== Cluster integrity check: normal case");
                stmt1 = s_msgBundle.getMessage("4754", false);
            } else {
                Trace.out((String)("==== Cluster integrity check: 1 partition, but did not run on " + notRunVec.size() + " nodes."));
                stmt1 = s_msgBundle.getMessage("4755", false);
            }
            ReportUtil.writeColHeaders(ReportUtil.NODENAME);
            for (String ndSeq : partHt.keySet()) {
                mbrNds = VerificationUtil.getTokensAsArray(ndSeq, ",");
                for (int i = 0; i < mbrNds.length; ++i) {
                    ReportUtil.writeRecord(mbrNds[i]);
                }
            }
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("4756", false, new Object[]{new Integer(numPart)}));
            Iterator iterator = partHt.keySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                String ndSeq;
                ReportUtil.sureprintln(s_msgBundle.getMessage("4757", false, new Object[]{new Integer(++count)}));
                ReportUtil.surewriteColHeaders(ReportUtil.NODENAME);
                ndSeq = (String)iterator.next();
                mbrNds = VerificationUtil.getTokensAsArray(ndSeq, ",");
                for (int i = 0; i < mbrNds.length; ++i) {
                    ReportUtil.surewriteRecord(mbrNds[i]);
                }
                ReportUtil.sureblankln();
            }
        }
        boolean chkRes = false;
        String summaryStmt = "";
        if (numPart == 1 && notRunVec.isEmpty()) {
            chkRes = true;
            summaryStmt = s_msgBundle.getMessage("4751", false);
            this.m_genTask.getResultSet().setStatus(1);
            ReportUtil.sureblankln();
            ReportUtil.sureprintln(summaryStmt);
        } else {
            summaryStmt = numPart > 1 ? s_msgBundle.getMessage("4753", false, new Object[]{new Integer(numPart)}) : s_msgBundle.getMessage("4752", false) + " ";
            ReportUtil.sureblankln();
            ReportUtil.sureprint(summaryStmt);
            if (!notRunVec.isEmpty()) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("8101", false));
                ReportUtil.sureprintNodelist(notRunVec);
            }
        }
        ReportUtil.sureblankln();
        if (numPart > 1) {
            String[] ndsChecked = VerificationUtil.diffStringArr(validNodeArr, notRunVec.toArray(new String[notRunVec.size()]));
            this.m_genTask.m_resultSet.addResult(ndsChecked, 2);
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("4761", true));
            this.m_genTask.m_resultSet.addErrorDescription(ndsChecked, errorDesc);
            Trace.out((String)("==== Cluster is fragmented. The following nodes will be marked as failed: " + VerificationUtil.strArr2List(ndsChecked)));
        }
        return chkRes;
    }

    private boolean performOraarpdrvCheck(String[] nodeList) {
        GlobalExecution exec = new GlobalExecution();
        ResultSet resultSetCmd = new ResultSet();
        ResultSet taskResultSet = this.m_genTask.getResultSet();
        boolean retVal = true;
        boolean cnt = false;
        Trace.out((String)("about to send the command checkservice to all nodes " + VerificationUtil.strArr2String(nodeList)));
        boolean cmdResult = exec.checkService(nodeList, "oraarpdrv", resultSetCmd);
        Enumeration e1 = resultSetCmd.getResultTable().keys();
        while (e1.hasMoreElements()) {
            String node = (String)e1.nextElement();
            Result result = (Result)resultSetCmd.getResultTable().get(node);
            Vector servList = result.getResultInfoSet();
            Trace.out((String)("result for node " + node + "  " + ((Object)servList).toString()));
            boolean okRunning = true;
            boolean okServiceType = true;
            boolean okStartType = true;
            if (result.getStatus() == 1) {
                Object errorDesc;
                String errMsg;
                Trace.out((String)("execution of checkservice command on node " + node + " results " + ((Object)servList).toString()));
                if (!servList.contains((Object)ServiceConfiguration.ServiceKernelDriver)) {
                    okServiceType = false;
                    Trace.out((String)"service oraarpdrv has not the required configuration for service type");
                    retVal = false;
                    taskResultSet.addResult(node, 3);
                    errMsg = s_gMsgBundle.getMessage("11377", true, (Object[])new String[]{node});
                    errorDesc = new ErrorDescription(errMsg);
                    taskResultSet.addErrorDescription(node, (ErrorDescription)errorDesc);
                    ReportUtil.printError(errMsg);
                }
                if (!servList.contains((Object)ServiceConfiguration.ServiceAutoStart)) {
                    okStartType = false;
                    Trace.out((String)"service oraarpdrv does not have the required  configuration for start type");
                    retVal = false;
                    taskResultSet.addResult(node, 3);
                    errMsg = s_gMsgBundle.getMessage("11376", true, (Object[])new String[]{node});
                    errorDesc = new ErrorDescription(errMsg);
                    taskResultSet.addErrorDescription(node, (ErrorDescription)errorDesc);
                    ReportUtil.printError(errMsg);
                }
                Trace.out((String)"service oraarpdrv has the required configuration");
                if (!servList.contains((Object)ServiceConfiguration.ServiceRunning)) {
                    okRunning = false;
                    Trace.out((String)"service oraarpdrv is not running");
                    retVal = false;
                    taskResultSet.addResult(node, 2);
                    errMsg = s_gMsgBundle.getMessage("11378", true, (Object[])new String[]{node});
                    errorDesc = new ErrorDescription(errMsg);
                    taskResultSet.addErrorDescription(node, (ErrorDescription)errorDesc);
                    ReportUtil.printError(errMsg);
                }
                if (!okStartType || !okServiceType || !okRunning) continue;
                Trace.out((String)"service oraarpdrv is running");
                taskResultSet.addResult(node, 1);
                String sucMsg = s_gMsgBundle.getMessage("11379", false, (Object[])new String[]{node});
                ReportUtil.println(sucMsg);
                continue;
            }
            retVal = false;
            StringBuilder errString = new StringBuilder();
            taskResultSet.addResult(node, 2);
            List<VerificationError> errList = result.getErrors();
            for (VerificationError err : errList) {
                errString.append(err.getErrorMessage());
                errString.append(LSEP);
                taskResultSet.addErrorDescription(node, new ErrorDescription(err.getErrorMessage()));
            }
            if (errString.indexOf("1060") != -1) {
                Trace.out((String)"the service oraarpdrv does not exists");
                String errNotFound = s_gMsgBundle.getMessage("11375", true, (Object[])new String[]{node});
                ErrorDescription errorDesc = new ErrorDescription(errNotFound);
                taskResultSet.addErrorDescription(node, errorDesc);
                ReportUtil.printError(errNotFound);
                continue;
            }
            ReportUtil.printError(errString.toString());
            Trace.out((String)("checkservice commnad has failed with error " + errString.toString()));
        }
        return retVal;
    }
}

