/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.cluster.resources.PrCiMsgID;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.network.VerifyNetwork;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskVIPSubnetCheck
extends Task
implements VerificationConstants,
VerificationAPIConstants {
    static final String TYPE_OIFCFG_PUBLIC = "PUBLIC";
    private boolean m_isPreCRS = false;
    private boolean m_isAddNode = false;
    private String[] m_newNodes = null;
    private String[] m_newVipNames = null;
    private Set<NetworkInfo> m_newVips = null;
    private Set<NetworkInfo> m_vips = null;

    public TaskVIPSubnetCheck(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: {
                this.m_isPreCRS = !this.m_globalContext.isRollingUpgrade();
                break;
            }
            case POSTREQ_CRS_INST: 
            case BESTPRACTICE_POSTREQ_CRS_INST: {
                this.m_isPreCRS = false;
                break;
            }
            case PREREQ_FARM_HEALTH: {
                this.setIsPreCRS(true);
                break;
            }
            case PREREQ_NODE_ADD: {
                ParamPreReqNodeAddDel param = (ParamPreReqNodeAddDel)this.m_globalContext.getParamPrereq();
                if (param == null) break;
                this.setNodeList(param.getValidNewClusterNodes());
                String[] vipList = param.getVipList();
                String[] nodesWithVip = param.getNodesWithVip();
                Trace.out((String)("Processing nodes with VIP list: '" + VerificationUtil.strArr2List(nodesWithVip) + "'"));
                Trace.out((String)("Processing vip list: '" + VerificationUtil.strArr2List(vipList) + "'"));
                if (vipList != null && vipList.length > 0 && vipList.length == nodesWithVip.length) {
                    this.addNodes(nodesWithVip, vipList);
                    break;
                }
                if (vipList != null && vipList.length > 0) {
                    Trace.out((String)("Cannot match node list: " + VerificationUtil.strArr2List(nodesWithVip) + " To VIP list: " + VerificationUtil.strArr2List(vipList)));
                    break;
                }
                Trace.out((String)"vipList is empty");
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationUtil.isOPC() || VerificationUtil.isODALiteEnv()) {
            VerificationUtil.traceAndLog("skipping vip subnet check in  OPC/ODALite env");
            return false;
        }
        switch (this.m_globalContext.getVerificationType()) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: {
                boolean isVIPdhcpAssigned;
                new Version();
                boolean isVerPost12c = !Version.isPre12102((Version)Version.getCurrentVersion());
                boolean bl = isVIPdhcpAssigned = isVerPost12c ? this.m_globalContext.isDHCPConfigured() : this.m_globalContext.isGNSConfigured();
                if (isVIPdhcpAssigned) break;
                return this.m_globalContext.isRollingUpgrade() || VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.INTERCONNECT_LIST)) || VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.HOST_VIP_NAMES));
            }
            case PREREQ_NODE_ADD: {
                if (this.m_newVipNames != null && this.m_newVipNames.length > 0 && this.m_newVipNames.length == this.m_newNodes.length) {
                    VerificationUtil.traceAndLog("TaskVIPSubnetCheck has been added.");
                    return true;
                }
                if (this.m_newVipNames != null && this.m_newVipNames.length > 0) {
                    VerificationUtil.traceAndLog("Not Adding VIP Subnet check. Cannot match node list: " + VerificationUtil.strArr2List(this.m_newNodes) + " To VIP list: " + VerificationUtil.strArr2List(this.m_newVipNames));
                } else {
                    VerificationUtil.traceAndLog("Not Adding VIP Subnet check. vipList is empty");
                }
                return false;
            }
            case POSTREQ_CRS_INST: 
            case BESTPRACTICE_POSTREQ_CRS_INST: 
            case PREREQ_DB_INST: {
                Set<NetworkInfo> vipNetworks = this.getVIPList(this.m_nodeList);
                boolean foundValidVIP = false;
                for (NetworkInfo network : vipNetworks) {
                    if (!VerificationUtil.isStringGood(network.getIPAsString())) continue;
                    foundValidVIP = true;
                }
                if (vipNetworks.isEmpty() || !foundValidVIP) {
                    VerificationUtil.traceAndLog("Not adding VIP subnet check. VIP address could not be found");
                    return false;
                }
                return true;
            }
            case PREREQ_FARM_HEALTH: {
                if (!VerificationUtil.isStringGood(CVUVariables.getValue(CVUVariableConstants.HOST_VIP_NAMES))) {
                    ReportUtil.printWarning(s_gMsgBundle.getMessage("11755", true, (Object[])new String[]{CVUVariableConstants.HOST_VIP_NAMES.toString(), this.m_globalContext.getParamManager().getInstallConfigFile()}));
                    VerificationUtil.traceAndLog("The property (" + VAR_HOST_VIP_NAMES + ") is not defined. Check is not applicable");
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public TaskVIPSubnetCheck(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskVIPSubnetCheck(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskVIPSubnetCheck(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    public void setIsPreCRS(boolean isPreCRS) {
        this.m_isPreCRS = isPreCRS;
    }

    public void addNodes(String[] nodeNames, String[] vipNames) {
        this.m_isAddNode = true;
        this.m_newNodes = new String[nodeNames.length];
        System.arraycopy(nodeNames, 0, this.m_newNodes, 0, nodeNames.length);
        this.m_newVipNames = new String[vipNames.length];
        System.arraycopy(vipNames, 0, this.m_newVipNames, 0, vipNames.length);
    }

    @Override
    public boolean performTask() {
        boolean retVal = false;
        boolean bSubnetCheck = false;
        Set<Object> vips = null;
        Trace.out((String)"Performing VIP Configuration check...");
        ReportUtil.sureprintln(s_msgBundle.getMessage("10202", false));
        if (this.m_isAddNode) {
            Trace.out((String)"Performing VIP Subnet check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10203", false));
            bSubnetCheck = this.performVIPSubnetCheckAddNodes();
            if (bSubnetCheck) {
                Trace.out((String)"VIP Subnet check was passed");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10206", false));
            } else {
                Trace.out((String)"VIP Subnet check was failed");
                String msg = s_msgBundle.getMessage("10205", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(this.m_newNodes, errDesc);
            }
            if (this.m_newVips != null && this.m_newVips.size() > 0) {
                Trace.out((String)"Performing VIP active check...");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10204", false));
                vips = this.checkReachability(this.m_newVips, true);
                if (vips.size() == 0) {
                    Trace.out((String)"VIP active check passed");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("10207", false));
                } else {
                    StringBuffer nodesBuffer = new StringBuffer();
                    int count = 0;
                    for (NetworkInfo networkInfo : vips) {
                        nodesBuffer.append(networkInfo.getIPAsString());
                        if (++count >= vips.size()) continue;
                        nodesBuffer.append(", ");
                    }
                    String reachableNodes = nodesBuffer.toString();
                    Trace.out((String)("VIP(s) " + reachableNodes + " are active. VIPs should " + "be configured to use unused IP address before cluster install"));
                    Object[] objectArray = new String[]{reachableNodes};
                    String string = s_msgBundle.getMessage("10209", true, objectArray);
                    ReportUtil.sureprintln(string);
                    ErrorDescription errDesc = new ErrorDescription(string);
                    this.m_resultSet.addErrorDescription((String[])objectArray, errDesc);
                }
            } else {
                vips = new HashSet();
            }
            if (!bSubnetCheck || vips.size() != 0) {
                retVal = false;
                this.m_resultSet.addResult(this.m_newNodes, 3);
            } else {
                retVal = true;
                this.m_resultSet.addResult(this.m_newNodes, 1);
            }
        } else if (this.m_isPreCRS) {
            Trace.out((String)"Performing VIP Subnet check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10203", false));
            bSubnetCheck = this.performVIPSubnetCheckInst();
            if (bSubnetCheck) {
                Trace.out((String)"VIP Subnet check was passed");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10206", false));
            } else {
                Trace.out((String)"VIP Subnet check was failed");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10205", false));
            }
            if (this.m_vips != null && this.m_vips.size() > 0) {
                Trace.out((String)"Performing VIP active check...");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10204", false));
                vips = this.checkReachability(this.m_vips, true);
                if (vips.size() == 0) {
                    Trace.out((String)"VIP active check passed");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("10207", false));
                } else {
                    StringBuffer nodesBuffer = new StringBuffer();
                    HashSet reverseOrder = new HashSet();
                    int count = 0;
                    for (NetworkInfo networkInfo : vips) {
                        nodesBuffer.append(networkInfo.getIPAsString());
                        if (++count >= vips.size()) continue;
                        nodesBuffer.append(", ");
                    }
                    Trace.out((String)("VIP(s) " + nodesBuffer + " are active. VIPs should be " + "configured to use unused IP address before cluster install"));
                    String string = s_msgBundle.getMessage("10209", false, (Object[])new String[]{nodesBuffer.toString()});
                    ReportUtil.printWarning(string);
                    ErrorDescription errorDescription = new ErrorDescription(string);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, errorDescription);
                }
            }
            if (!bSubnetCheck) {
                this.m_resultSet.addResult(this.m_nodeList, 3);
            } else {
                retVal = true;
                this.m_resultSet.addResult(this.m_nodeList, 1);
            }
        } else {
            Trace.out((String)"Performing VIP Subnet check...");
            ReportUtil.sureprintln(s_msgBundle.getMessage("10203", false));
            bSubnetCheck = this.performVIPSubnetCheckPostCrsInst();
            if (bSubnetCheck) {
                Trace.out((String)"VIP Subnet check was passed");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10206", false));
            } else {
                Trace.out((String)"VIP Subnet check was failed");
                String msg = s_msgBundle.getMessage("10205", true);
                ReportUtil.sureprintln(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            }
            if (this.m_vips != null && this.m_vips.size() > 0) {
                Trace.out((String)"Performing VIP active check...");
                ReportUtil.sureprintln(s_msgBundle.getMessage("10204", false));
                vips = this.checkReachability(this.m_vips, false);
                if (vips.size() == 0) {
                    Trace.out((String)"VIP active check passed");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("10207", false));
                    this.checkAdditionalIPOnPublicSubnetWithVIP();
                } else {
                    StringBuffer nodesBuffer = new StringBuffer();
                    int count = 0;
                    for (NetworkInfo networkInfo : vips) {
                        nodesBuffer.append(networkInfo.getIPAsString());
                        if (++count >= vips.size()) continue;
                        nodesBuffer.append(", ");
                    }
                    Trace.out((String)("VIP(s) " + nodesBuffer + " are not active. clusterware " + "install should have failed to confiure VIP(s)"));
                    String msg = s_msgBundle.getMessage("10210", true, (Object[])new String[]{nodesBuffer.toString()});
                    ReportUtil.sureprintln(msg);
                    ErrorDescription errorDescription = new ErrorDescription(msg);
                    this.m_resultSet.addErrorDescription(this.m_nodeList, errorDescription);
                }
            }
            if (!bSubnetCheck || vips != null && vips.size() > 0) {
                this.m_resultSet.addResult(this.m_nodeList, 3);
            } else {
                retVal = true;
                this.m_resultSet.addResult(this.m_nodeList, 1);
            }
        }
        return retVal;
    }

    private boolean performVIPSubnetCheckInst() {
        HashSet<NetworkInfo> vipNetworks = new HashSet();
        HashSet<NetworkInfo> cluifs = new HashSet<NetworkInfo>();
        String vipTuple = null;
        String vipName = null;
        String errMsg = null;
        boolean retVal = false;
        try {
            if (this.m_globalContext.isUpgrade()) {
                vipNetworks = this.getVIPList(this.m_nodeList);
                Version crsVersion = VerificationUtil.getCRSActiveVersionObj();
                if (crsVersion != null && Version.isPre112((Version)crsVersion)) {
                    Set<NetworkInfo> cluifsAll = NetworkUtility.getClusterNetworks(this.m_nodeList, this.m_resultSet);
                    if (this.m_resultSet.anyFailure()) {
                        return false;
                    }
                    cluifs = NetworkDataDiscovery.getClusterNetworksByType(cluifsAll, NetworkConstants.NetworkType.PUBLIC);
                } else if (crsVersion != null && !Version.isPre112((Version)crsVersion)) {
                    cluifs.addAll(NetworkUtility.getAllPublicNetworks());
                } else {
                    return false;
                }
                if (cluifs.size() == 0) {
                    return false;
                }
            } else {
                String strVipNames = CVUVariables.getValue(CVUVariableConstants.HOST_VIP_NAMES);
                if (strVipNames == null) {
                    Trace.out((String)("Install env " + VAR_HOST_VIP_NAMES + " is null"));
                    errMsg = s_msgBundle.getMessage("5461", true, (Object[])new String[]{VAR_HOST_VIP_NAMES});
                    ReportUtil.sureprintln(errMsg);
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    ErrorDescription errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.getResult(this.m_nodeList[0]).addErrorDescription(errDesc);
                    return false;
                }
                Trace.out((String)("got " + VAR_HOST_VIP_NAMES + " = " + strVipNames));
                StringTokenizer tokenizer = new StringTokenizer(strVipNames, ",");
                while (tokenizer.hasMoreTokens()) {
                    vipTuple = tokenizer.nextToken();
                    String[] vip = vipTuple.split(":");
                    vipName = null;
                    if (vip.length == 1 || vip.length == 2 && vip[1].equalsIgnoreCase("AUTO")) {
                        Trace.out((String)"HOST_VIP_NAMES variable containing AUTO for hostname was encounterd. The task should not have been added in task list at TaskFactory level.");
                    } else if (vip.length >= 2) {
                        vipName = vip[1];
                    }
                    if (vipName == null) {
                        Trace.out((String)("Install env " + VAR_HOST_VIP_NAMES + " is not in valid format as expected"));
                        errMsg = s_msgBundle.getMessage("5461", true, (Object[])new String[]{VAR_HOST_VIP_NAMES});
                        ReportUtil.sureprintln(errMsg);
                        this.m_resultSet.addResult(this.m_nodeList, 2);
                        ErrorDescription errDesc = new ErrorDescription(errMsg);
                        this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                        return false;
                    }
                    VerificationUtil.traceAndLog("Found VIP: %s\n", vip[1]);
                    vipNetworks.add(new NetworkInfo(InetAddress.getByName(vipName), null, null, null));
                }
                this.m_vips = vipNetworks;
                Set<NetworkInfo> resolvedIfTypes = this.resolveInterfaceType(this.m_nodeList[0]);
                if (resolvedIfTypes == null) {
                    return false;
                }
                cluifs.addAll(resolvedIfTypes);
            }
            retVal = this.performVIPSubnetCheckInternal(vipNetworks, cluifs);
        }
        catch (UnknownHostException unknownException) {
            Trace.out((String)("exception : " + unknownException.getMessage()));
            Trace.out((String)("could not create VIPAddress. vipname, " + vipName + ", is not valid"));
            errMsg = s_gMsgBundle.getMessage("1564", true, (Object[])new String[]{vipName});
            ReportUtil.sureprintln(errMsg);
            ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, this.m_nodeList, false, false);
            return false;
        }
        catch (NetworkException ne) {
            Trace.out((String)"Error while getting cluster interfaces");
            Trace.out((String)("exception : " + ne.getMessage()));
            errMsg = s_msgBundle.getMessage("10208", true);
            errMsg = errMsg + LSEP + ne.getMessage();
            ReportUtil.sureprintln(errMsg);
            ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, this.m_nodeList, false, false);
            return false;
        }
        return retVal;
    }

    private Set<NetworkInfo> resolveInterfaceType(String node) {
        Set<Object> allMatchingNetworksOnNode = new HashSet();
        HashSet<NetworkInfo> networksToBeReturned = new HashSet<NetworkInfo>();
        String cvuVarErrMsg = null;
        try {
            ResultSet networksResultSet = new ResultSet();
            Set<NetworkInfo> clusterNetworks = NetworkDataDiscovery.getClusterNetworksFromCVUVariable(networksResultSet);
            if (!NetworkUtility.isNetworksSetGood(clusterNetworks) || networksResultSet.anyFailure()) {
                Trace.out((String)"Could not fetch the network details from CVU variable during VIP Subnet checks");
                NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
                return null;
            }
            networksResultSet = new ResultSet();
            allMatchingNetworksOnNode = NetworkDataDiscovery.getMatchingNetworksOnNode(null, clusterNetworks, node, networksResultSet);
            if (!NetworkUtility.isNetworksSetGood(allMatchingNetworksOnNode)) {
                Trace.out((String)"Could not find matching network details of CVU variable on the nodes during VIP Subnet checks");
                NetworkUtility.reportResultSet(networksResultSet, this.m_resultSet, true);
                return null;
            }
            if (!NetworkUtility.isNetworksSetGood(allMatchingNetworksOnNode = NetworkDataDiscovery.getNetworksWithStatusUp(allMatchingNetworksOnNode))) {
                Trace.out((String)"Could not find any matching network with status UP duringVIP subnet checks");
                String errorMessage = s_gMsgBundle.getMessage("11086", true, (Object[])new String[]{this.m_nodeList[0]});
                ResultSet.updateResultSetWithErrorDescription(errorMessage, this.m_resultSet, this.m_nodeList, true, false);
                ReportUtil.sureprintln(errorMessage);
                return null;
            }
            for (NetworkInfo network : allMatchingNetworksOnNode) {
                InetAddress subnet = network.getSubnet();
                InetAddress subnetMask = network.getSubnetMask();
                String ifType = network.getNetworkType() == NetworkConstants.NetworkType.PUBLIC.getValue() ? TYPE_OIFCFG_PUBLIC : null;
                networksToBeReturned.add(new NetworkInfo(null, subnet, subnetMask, ifType));
            }
        }
        catch (CVUException cvuEx) {
            cvuVarErrMsg = cvuEx.getMessage();
            Trace.out((String)(VAR_INTERCONNECT_LIST + "is not in valid format as expected"));
            cvuVarErrMsg = s_msgBundle.getMessage("5461", true, (Object[])new String[]{VAR_INTERCONNECT_LIST}) + LSEP + cvuVarErrMsg;
            Trace.out((Exception)cvuEx);
            ReportUtil.sureprintln(cvuVarErrMsg);
            ResultSet.updateResultSetWithErrorDescription(cvuVarErrMsg, this.m_resultSet, this.m_nodeList, true, false);
            return null;
        }
        return networksToBeReturned;
    }

    private boolean performVIPSubnetCheckPostCrsInst() {
        HashSet<NetworkInfo> cluifs = new HashSet<NetworkInfo>();
        Set<NetworkInfo> vips = this.getVIPList(this.m_nodeList);
        if (this.m_resultSet.anyFailure()) {
            return false;
        }
        if (vips.size() == 0) {
            Trace.out((String)"No vips found. returning true as VIP check is not required");
            return true;
        }
        try {
            Version crsVersion = VerificationUtil.getCRSActiveVersionObj();
            if (crsVersion != null && Version.isPre112((Version)crsVersion)) {
                cluifs = NetworkUtility.getClusterNetworks(this.m_nodeList, this.m_resultSet);
            } else if (crsVersion != null && !Version.isPre112((Version)crsVersion)) {
                cluifs.addAll(NetworkUtility.getAllPublicNetworks());
            }
            if (this.m_resultSet.anyFailure() || cluifs.size() == 0) {
                return false;
            }
            boolean ret = this.performVIPSubnetCheckInternal(vips, cluifs);
            if (VerificationUtil.isRollingUpgrade() && crsVersion != null && Version.isPre112((Version)crsVersion)) {
                Trace.out((String)"CRS version of source home found to be pre 11.2, performing check for public subnets with inconsistent VIP subnet and mask");
                ret &= this.checkVIPConsistencyWithActualPublicNetworks(VerificationUtil.getCRSHome(), crsVersion);
            }
            return ret;
        }
        catch (NetworkException ne) {
            Trace.out((String)"Error while getting cluster interfaces");
            Trace.out((String)("exception : " + ne.getMessage()));
            String errMsg = s_msgBundle.getMessage("10208", true);
            errMsg = errMsg + LSEP + ne.getMessage();
            ReportUtil.sureprintln(errMsg);
            ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, this.m_nodeList, false, false);
            return false;
        }
    }

    private boolean performVIPSubnetCheckAddNodes() {
        Set<NetworkInfo> vips = this.getVIPList(this.m_nodeList);
        this.m_newVips = new HashSet<NetworkInfo>();
        int n = 0;
        String[] stringArray = this.m_newVipNames;
        int n2 = stringArray.length;
        if (n < n2) {
            String newVipName = stringArray[n];
            Trace.out((String)("Adding new vip=" + this.m_newVipNames + " to the new vips list"));
            try {
                this.m_newVips.add(new NetworkInfo(InetAddress.getByName(newVipName), null, null, null));
            }
            catch (UnknownHostException uex) {
                Trace.out((Object)("UnknownHostException while getting IP address for VIP name " + newVipName + ". exception="), (String)uex.getMessage());
                String errMsg = s_msgBundle.getMessage("10211", true, (Object[])new String[]{newVipName});
                Trace.out((String)errMsg);
                ReportUtil.sureprintln(errMsg);
                ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, new String[]{newVipName}, true, false);
            }
        }
        vips.addAll(this.m_newVips);
        try {
            HashSet<NetworkInfo> cluifs = new HashSet<NetworkInfo>();
            Version crsVersion = VerificationUtil.getCRSActiveVersionObj();
            if (crsVersion != null && Version.isPre112((Version)crsVersion)) {
                cluifs = NetworkUtility.getClusterNetworks(this.m_nodeList, this.m_resultSet);
            } else if (crsVersion != null && !Version.isPre112((Version)crsVersion)) {
                cluifs.addAll(NetworkUtility.getAllPublicNetworks());
            }
            if (this.m_resultSet.anyFailure() || cluifs.size() == 0) {
                return false;
            }
            return this.performVIPSubnetCheckInternal(vips, cluifs);
        }
        catch (NetworkException ne) {
            Trace.out((String)"Error while getting cluster interfaces");
            Trace.out((String)("exception : " + ne.getMessage()));
            String errMsg = s_msgBundle.getMessage("10208", true);
            errMsg = errMsg + LSEP + ne.getMessage();
            ReportUtil.sureprintln(errMsg);
            ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, this.m_nodeList, false, false);
            return false;
        }
    }

    private Set<NetworkInfo> getVIPList(String[] nodeList) {
        if (this.m_vips == null) {
            this.m_vips = new HashSet<NetworkInfo>();
            Trace.out((String)"Trying to get VIPs");
            String crsHome = VerificationUtil.getCRSHome();
            if (!VerificationUtil.isStringGood(crsHome)) {
                Trace.out((String)"Failed to get CRS HOME.");
                String msg = s_msgBundle.getMessage("5301", true);
                ReportUtil.printError(msg);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                return this.m_vips;
            }
            Version actCRSVer = VerificationUtil.getCRSActiveVersionObj();
            if (actCRSVer == null) {
                String msg = s_gMsgBundle.getMessage("6020", true, (Object[])new String[]{m_localNode});
                ResultSet.updateResultSetWithErrorDescription(msg, this.m_resultSet, this.m_nodeList, false, true);
                return this.m_vips;
            }
            try {
                Hashtable<String, NetworkInfo> vipTable = NetworkUtility.getResourceVIPList(nodeList, crsHome, actCRSVer, this.m_resultSet);
                if (vipTable != null && !vipTable.isEmpty()) {
                    for (String vip : vipTable.keySet()) {
                        VerificationUtil.traceAndLog("Successfully retreived network information for VIP (" + vip + ")");
                        this.m_vips.add(vipTable.get(vip));
                    }
                }
            }
            catch (NetworkException ne) {
                Trace.out((String)("Caught NetworkException - failed to get the network information , Error :" + ne.getMessage()));
                ResultSet.updateResultSetWithErrorDescription(ne.getMessage(), this.m_resultSet, this.m_nodeList, false, false);
                return this.m_vips;
            }
        }
        Trace.out((String)"Returning VIP list");
        return this.m_vips;
    }

    private Set<NetworkInfo> checkReachability(Set<NetworkInfo> vips, boolean bActive) {
        VerifyNetwork verifyNetwork = new VerifyNetwork();
        String[] vipHosts = new String[vips.size()];
        boolean[] bActiveHosts = new boolean[vips.size()];
        String[] reachabilityErrorMessages = new String[vips.size()];
        HashSet<NetworkInfo> retVals = new HashSet<NetworkInfo>();
        int i = 0;
        for (NetworkInfo network : vips) {
            if (VerificationUtil.isStringGood(network.getIPAsString())) {
                vipHosts[i++] = network.getIPAsString();
                continue;
            }
            bActiveHosts[i++] = !bActive;
        }
        if (vipHosts.length == 0) {
            return retVals;
        }
        Trace.out((String)("checking reachability from " + this.m_nodeList[0]));
        verifyNetwork.checkReachFromSrcNode(vipHosts, bActiveHosts, this.m_nodeList[0], reachabilityErrorMessages);
        i = 0;
        for (NetworkInfo network : vips) {
            if (bActiveHosts[i++] != bActive) continue;
            retVals.add(network);
        }
        return retVals;
    }

    private boolean performVIPSubnetCheckInternal(Set<NetworkInfo> vips, Set<NetworkInfo> clusterNetworks) {
        boolean retv6 = true;
        boolean retv4 = true;
        if (!NetworkUtility.isNetworksSetGood(vips)) {
            VerificationUtil.traceAndLog("No vips found. returning true as VIP check is not required");
            return true;
        }
        ArrayList<NetworkInfo> vips_v6 = new ArrayList<NetworkInfo>();
        ArrayList<NetworkInfo> vips_v4 = new ArrayList<NetworkInfo>();
        for (NetworkInfo network : vips) {
            String ipAddress = network.getIPAsString();
            if (!VerificationUtil.isStringGood(ipAddress)) continue;
            if (IPAddressUtil.isIPv6AddressString((String)ipAddress)) {
                vips_v6.add(network);
                continue;
            }
            if (!IPAddressUtil.isIPv4AddressString((String)ipAddress)) continue;
            vips_v4.add(network);
        }
        if (vips_v4.isEmpty() && vips_v6.isEmpty()) {
            VerificationUtil.traceAndLog("No vips found. returning true as VIP check is not required");
            return true;
        }
        if (!vips_v4.isEmpty()) {
            VerificationUtil.traceAndLog("Found valid IPv4 VIPs: " + VerificationUtil.strCollection2String(NetworkUtility.getIPsOnNetworks(new HashSet<NetworkInfo>(vips_v4))));
        }
        if (!vips_v6.isEmpty()) {
            VerificationUtil.traceAndLog("Found valid IPv6 VIPs: " + NetworkUtility.getIPsOnNetworks(new HashSet<NetworkInfo>(vips_v6)));
        }
        if (!NetworkUtility.isNetworksSetGood(clusterNetworks) || !NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(clusterNetworks, NetworkConstants.NetworkType.PUBLIC.getValue())) {
            String errMsg = s_gMsgBundle.getMessage("1563", true, (Object[])new String[]{m_localNode});
            VerificationUtil.traceAndLog("Could not find any public cluster network on the node " + m_localNode + " Error message: " + errMsg);
            ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, new String[]{m_localNode}, true, true);
            return false;
        }
        ArrayList<NetworkInfo> cluIfs_v6 = new ArrayList<NetworkInfo>();
        ArrayList<NetworkInfo> cluIfs_v4 = new ArrayList<NetworkInfo>();
        StringBuffer foundClusterIfs = new StringBuffer();
        for (NetworkInfo network : clusterNetworks) {
            String subnet = network.getSubnetAsString();
            if (IPAddressUtil.isIPv6AddressString((String)subnet)) {
                cluIfs_v6.add(network);
            }
            if (!IPAddressUtil.isIPv4AddressString((String)subnet)) continue;
            cluIfs_v4.add(network);
        }
        if (!cluIfs_v4.isEmpty()) {
            VerificationUtil.traceAndLog("Found valid IPv4 cluster IPs: " + VerificationUtil.strCollection2String(NetworkUtility.getIPsOnNetworks(new HashSet<NetworkInfo>(cluIfs_v4))));
        }
        if (!cluIfs_v6.isEmpty()) {
            VerificationUtil.traceAndLog("Found valid IPv6 cluster IPs: " + VerificationUtil.strCollection2String(NetworkUtility.getIPsOnNetworks(new HashSet<NetworkInfo>(cluIfs_v6))));
        }
        if (vips_v6.size() > 0) {
            retv6 = this.performVIPSubnetCheck(vips_v6, cluIfs_v6);
        }
        if (vips_v4.size() > 0) {
            retv4 = this.performVIPSubnetCheck(vips_v4, cluIfs_v4);
        }
        return retv4 && retv6;
    }

    private boolean performVIPSubnetCheck(List<NetworkInfo> vips, List<NetworkInfo> clusterNetworks) {
        ArrayList<NetworkInfo> tmpclusterNetworks = new ArrayList<NetworkInfo>();
        for (NetworkInfo vip : vips) {
            tmpclusterNetworks.clear();
            for (NetworkInfo clusterNetwork : clusterNetworks) {
                if (clusterNetwork.getNetworkType() == NetworkConstants.NetworkType.PUBLIC.getValue() && this.checkSubNetwork(vip.getIP(), clusterNetwork)) {
                    tmpclusterNetworks.add(clusterNetwork);
                    Trace.out((String)("Cluster network " + clusterNetwork.getInterfaceName() + " is a public network and belongs to the same subnet " + vip.getSubnetAsString() + " as " + " VIP network " + vip.getIP()));
                }
                if (!Utils.isDevelopmentEnv()) continue;
                Trace.out((String)"******THIS BLOCK EXECUTES ONLY by srg and lrgs but not in shiphome lrgs and customer env***********");
                tmpclusterNetworks.add(clusterNetwork);
                Trace.out((String)("ADDING(Utils.isDevelopmentEnv()=TRUE) to tmpclusterNetworks:" + vip.getIP()));
            }
            clusterNetworks.clear();
            clusterNetworks.addAll(tmpclusterNetworks);
            if (clusterNetworks.size() != 0) continue;
            for (NetworkInfo vip1 : vips) {
                Trace.out((String)("vip:" + vip1.getIP() + " does not match with any of " + "the public subnets that other vips match"));
            }
        }
        return clusterNetworks.size() > 0;
    }

    private void checkAdditionalIPOnPublicSubnetWithVIP() {
        try {
            Set<Object> clusterNetworks = new HashSet<NetworkInfo>();
            Version crsVersion = VerificationUtil.getCRSActiveVersionObj();
            if (crsVersion != null && Version.isPre112((Version)crsVersion)) {
                clusterNetworks = NetworkUtility.getClusterNetworks(this.m_nodeList, this.m_resultSet);
            } else if (crsVersion != null && !Version.isPre112((Version)crsVersion)) {
                clusterNetworks.addAll(NetworkUtility.getAllPublicNetworks());
            }
            Set<NetworkInfo> vips = this.getVIPList(this.m_nodeList);
            for (NetworkInfo activeVip : vips) {
                for (NetworkInfo networkInfo : clusterNetworks) {
                    if ((!IPAddressUtil.isIPv4AddressString((String)activeVip.getIPAsString()) || !IPAddressUtil.isIPv4AddressString((String)networkInfo.getIPAsString())) && (!IPAddressUtil.isIPv6AddressString((String)activeVip.getIPAsString()) || !IPAddressUtil.isIPv6AddressString((String)networkInfo.getIPAsString())) || networkInfo.getNetworkType() != NetworkConstants.NetworkType.PUBLIC.getValue() || !this.checkSubNetwork(activeVip.getIP(), networkInfo)) continue;
                    Trace.out((String)("The active VIP (" + activeVip.getIPAsString() + ") belongs to public subnet (" + networkInfo.getSubnetAsString() + ") checking if this subnet has an additional IP other than " + "the VIP's"));
                    ResultSet ipAddressRetrievalResSet = new ResultSet();
                    Hashtable<String, List<String>> nodeWiseIPListOnSubnet = NetworkUtility.getAllIPsOnSubnet(this.m_nodeList, networkInfo.getSubnetAsString(), ipAddressRetrievalResSet);
                    if (!ipAddressRetrievalResSet.anySuccess()) {
                        this.m_resultSet.addResultSetData(ipAddressRetrievalResSet);
                        continue;
                    }
                    for (String node : nodeWiseIPListOnSubnet.keySet()) {
                        boolean hasMorethanOneIPOnSubnet = false;
                        List<String> ipListOnNode = nodeWiseIPListOnSubnet.get(node);
                        for (String ip : ipListOnNode) {
                            if (this.isVIPAddress(ip, vips)) {
                                Trace.out((String)("This IP (" + ip + ") is a VIP, skipping"));
                                continue;
                            }
                            if (NetworkUtility.checkSameIPAddresses(activeVip.getIPAsString(), ip)) continue;
                            hasMorethanOneIPOnSubnet = true;
                            Trace.out((String)("Success for node (" + node + "): " + "The active VIP (" + activeVip.getIPAsString() + ") belongs to public subnet (" + networkInfo.getSubnetAsString() + ") and this subnet has an additional IP (" + ip + ") other than the VIP's"));
                            break;
                        }
                        if (hasMorethanOneIPOnSubnet) continue;
                        String errMsg = s_gMsgBundle.getMessage("5831", true, (Object[])new String[]{networkInfo.getSubnetMaskAsString(), activeVip.getIPAsString(), node});
                        ReportUtil.printWarning(errMsg);
                        this.m_resultSet.addResult(node, 4);
                        this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
                    }
                }
            }
        }
        catch (NetworkException ne) {
            Trace.out((String)"Error while getting cluster interfaces");
            Trace.out((String)("exception : " + ne.getMessage()));
            String errMsg = s_msgBundle.getMessage("10208", true);
            errMsg = errMsg + LSEP + ne.getMessage();
            ReportUtil.sureprintln(errMsg);
            ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, this.m_nodeList, false, false);
            return;
        }
    }

    private boolean checkVIPConsistencyWithActualPublicNetworks(String crsHome, Version crsActiveVersion) {
        boolean ret = true;
        Set<NetworkInfo> vips = null;
        Hashtable<String, List<NetworkInfo>> nodeNetworksMap = null;
        try {
            vips = this.getVIPList(this.m_nodeList);
            nodeNetworksMap = NetworkUtility.getNodeIfListUsingOifCfg(crsHome, this.m_nodeList);
        }
        catch (NetworkException ne) {
            Trace.out((String)("Caught NetworkException - failed to get the network information , Error :" + ne.getMessage()));
            this.m_resultSet.addErrorDescription(new ErrorDescription(ne.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        for (String node : nodeNetworksMap.keySet()) {
            List<NetworkInfo> nodeNetworkList = nodeNetworksMap.get(node);
            for (NetworkInfo network : nodeNetworkList) {
                for (NetworkInfo vipInfo : vips) {
                    if (vipInfo.getNodeName() == null || !vipInfo.getNodeName().equalsIgnoreCase(node) || network.getInterfaceName() != vipInfo.getInterfaceName() || network.getSubnet().equals(vipInfo.getSubnet()) && network.getSubnetMask().equals(vipInfo.getSubnetMask())) continue;
                    Trace.out((String)("Public subnet " + network.getSubnetAsString() + "/" + network.getSubnetMaskAsString() + " on the interface " + network.getInterfaceName() + " does not have VIP on it on node " + node));
                    String errMsg = s_gMsgBundle.getMessage("5830", true, (Object[])new String[]{network.getSubnetAsString() + "/" + network.getSubnetMaskAsString(), network.getInterfaceName(), node});
                    ReportUtil.sureprintln(errMsg);
                    ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, new String[]{node}, true, false);
                    ret = false;
                }
            }
        }
        return ret;
    }

    private boolean checkSubNetwork(InetAddress vip, NetworkInfo network) {
        byte[] netmask;
        int i = 0;
        byte[] ip1 = vip.getAddress();
        if (ip1.length != (netmask = network.getSubnetMask().getAddress()).length) {
            Trace.out((String)("vip(name=" + vip.getHostName() + ",ip=" + vip.getHostAddress() + ") and cluIf(subnet=" + network.getSubnetAsString() + ",netmask=" + network.getSubnetMaskAsString() + ") are not same type of address family"));
            String errMsg = MessageBundle.getMessage((MessageKey)PrCiMsgID.IPADDR_SUBNETMASK_LENGTH_MISMATCH, (boolean)true, (Object[])new Object[]{vip.getHostAddress(), network.getSubnetMaskAsString()});
            ReportUtil.sureprintln(errMsg);
            ResultSet.updateResultSetWithErrorDescription(errMsg, this.m_resultSet, this.m_nodeList, true, false);
            return false;
        }
        byte[] vipSubnet = new byte[ip1.length];
        for (i = 0; i < ip1.length; ++i) {
            vipSubnet[i] = (byte)(ip1[i] & netmask[i]);
        }
        byte[] ifSubnet = network.getSubnet().getAddress();
        for (i = 0; i < vipSubnet.length && vipSubnet[i] == ifSubnet[i]; ++i) {
        }
        return i == vipSubnet.length;
    }

    private boolean isVIPAddress(String address, Set<NetworkInfo> vips) {
        if (VerificationUtil.isStringGood(address)) {
            for (NetworkInfo vipIf : vips) {
                if (!NetworkUtility.checkSameIPAddresses(vipIf.getIPAsString(), address)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("10201", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("10200", false);
    }

    @Override
    public String getTaskID() {
        return "NODE_VIP";
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    @Override
    protected boolean setupNewNodesForBigCluster() {
        String[] appNodes = null;
        try {
            appNodes = this.m_nodeMgr.getNewNodes(this.m_newNodes, NodeRoleCapability.HUB_CAPABLE);
        }
        catch (NoSuchNodesException nsnEx) {
            Trace.out((String)"NodeSuchNodesException ccured while getting node of type HUB_CAPABLE");
            this.m_resultSet.addResult(this.m_newNodes, 6);
            this.m_newNodes = new String[0];
            this.m_newVipNames = new String[0];
            return true;
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException occured while getting node of type HUB_CAPABLE. mesg=" + nmEx.getMessage()));
            return false;
        }
        List<String> appNodesLst = Arrays.asList(appNodes);
        String[] tmpNewNodes = new String[appNodes.length];
        String[] tmpNewVipNames = new String[appNodes.length];
        int j = 0;
        for (int i = 0; i < this.m_newNodes.length; ++i) {
            if (appNodesLst.contains(this.m_newNodes[i])) {
                tmpNewNodes[j] = this.m_newNodes[i];
                tmpNewVipNames[j] = this.m_newVipNames[i];
                ++j;
                continue;
            }
            this.m_resultSet.addResult(this.m_newNodes[i], 6);
        }
        this.m_newNodes = tmpNewNodes;
        this.m_newVipNames = tmpNewVipNames;
        return true;
    }
}

