/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Vector;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OFSUtil;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.sTaskUSMDriverChecks;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUSMDriverChecks
extends Task {
    private static final String STR_INSTALLED = "Installed";
    private static final String STR_LOADED = "Loaded";

    public TaskUSMDriverChecks(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskUSMDriverChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskUSMDriverChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskUSMDriverChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (VerificationUtil.isACFSSupported(false)) {
            if (this.m_globalContext.isRollingUpgrade()) {
                if (VerificationUtil.isACFSInstalled(false)) {
                    Trace.out((String)"ACFS is installed. adding the acfs version compatibility check during upgrade");
                    return true;
                }
                Trace.out((String)"ACFS is not found installed in this environment. Skipping the ACFS version compatibility check during upgrade.");
                return false;
            }
            Trace.out((String)"ACFS is supported on this platform. But this is not a rolling upgrade. skipping the check");
            return false;
        }
        Trace.out((String)"ACFS is not supported on this platform. skipping the check");
        return false;
    }

    @Override
    public boolean performTask() {
        Trace.out((int)5, (String)"Performing USM Drivers verification task...");
        if (this.m_globalContext.isUpgrade()) {
            Trace.out((String)"Performing the ACFS version compatibitility check during upgrade");
            return this.performACFSVersionCompatibilityCheck();
        }
        return this.performUSMDriverConsistencyChecks();
    }

    private boolean performACFSVersionCompatibilityCheck() {
        String crsHome = this.m_globalContext.getCRSHome();
        String errorMsg = null;
        if (VerificationUtil.isStringGood(crsHome)) {
            Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
            if (crsActiveVersion != null) {
                ArrayList<DriverConsistencyCheckThread> threadList = new ArrayList<DriverConsistencyCheckThread>();
                for (String node : this.m_nodeList) {
                    DriverConsistencyCheckThread nodeThread = new DriverConsistencyCheckThread(node, crsHome, crsActiveVersion);
                    threadList.add(nodeThread);
                    nodeThread.start();
                }
                for (DriverConsistencyCheckThread nodeThread : threadList) {
                    Result nodeResult = null;
                    try {
                        nodeThread.join();
                        nodeResult = nodeThread.getResult();
                    }
                    catch (InterruptedException ie) {
                        Trace.out((String)("Thread interrupted. Error is : " + ie.getMessage()));
                        nodeResult = new Result(nodeThread.getNode());
                        nodeResult.setStatus(2);
                        nodeResult.addErrorDescription(new ErrorDescription(ie.getMessage()));
                    }
                    this.m_resultSet.addResult(nodeThread.getNode(), nodeResult);
                }
            } else {
                errorMsg = s_gMsgBundle.getMessage("6020", true, (Object[])new String[]{VerificationUtil.getLocalNode()});
                this.m_resultSet.addErrorDescription(new ErrorDescription(errorMsg));
                this.m_resultSet.setStatus(2);
                VerificationUtil.traceAndLogError(errorMsg);
            }
        } else {
            errorMsg = s_msgBundle.getMessage("5301", true);
            this.m_resultSet.addErrorDescription(new ErrorDescription(errorMsg));
            this.m_resultSet.setStatus(2);
            VerificationUtil.traceAndLogError(errorMsg);
        }
        return this.m_resultSet.allSuccess();
    }

    private boolean performUSMDriverConsistencyChecks() {
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5160", false));
        ResultSet resultSet = new ResultSet();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        Vector<String> unknownNodes = new Vector<String>();
        sTaskUSMDriverChecks sTask = new sTaskUSMDriverChecks();
        boolean ret = sTask.checkDriversInstalled(this.m_nodeList, resultSet);
        Trace.out((int)5, (String)("Return value from checkDriversInstalled is " + ret));
        this.m_resultSet.addResultSetData(resultSet);
        if (!ret) {
            Trace.out((int)5, (String)"Complete failure checking driver installed status on all of the nodes");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5156", true));
            return false;
        }
        Trace.out((int)5, (String)"Drivers installed check passed on at least one node");
        resultSet.filterResult(succNodes, failNodes, unknownNodes);
        this.reportDriversInstalledStatus(succNodes, failNodes, unknownNodes);
        Trace.out((int)5, (String)"Proceeding to check if drivers loaded");
        if (succNodes.size() > 0) {
            Trace.out((int)5, (String)"Now check if drivers loaded");
            resultSet.clear();
            ret = sTask.checkDriversLoaded(succNodes, resultSet);
            Trace.out((int)5, (String)("Return value from checkDriversLoaded is " + ret));
            this.m_resultSet.addResultSetData(resultSet);
            if (ret) {
                Trace.out((int)5, (String)"Drivers loaded check passed on at least one node");
                succNodes.clear();
                failNodes.clear();
                unknownNodes.clear();
                resultSet.filterResult(succNodes, failNodes, unknownNodes);
                this.reportDriversLoadedStatus(succNodes, failNodes, unknownNodes);
            } else {
                Trace.out((int)5, (String)"Complete failure checking driver loaded status on all of the nodes");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5168", true));
                return false;
            }
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("5161", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5162", false));
        return false;
    }

    private void reportDriversInstalledStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes) {
        Trace.out((int)5, (String)"Reporting Drivers Installed Status");
        this.reportDriversStatus(succNodes, failNodes, unknownNodes, "5163", "5156", "5165", "5166", STR_INSTALLED);
    }

    private void reportDriversLoadedStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes) {
        Trace.out((int)5, (String)"Reporting Drivers Loaded Status");
        this.reportDriversStatus(succNodes, failNodes, unknownNodes, "5167", "5168", "5169", "5170", STR_LOADED);
    }

    private void reportDriversStatus(Vector<String> succNodes, Vector<String> failNodes, Vector<String> unknownNodes, String passmsg, String allfailmsg, String failmsg, String unknownmsg, String whatmsg) {
        Trace.out((int)5, (String)("Reporting " + whatmsg + " Drivers Status:"));
        if (succNodes.size() > 0) {
            Trace.out((int)5, (String)("USM Drivers " + whatmsg + " on node " + succNodes));
            ReportUtil.println(s_msgBundle.getMessage(passmsg, false) + LSEP + succNodes);
        } else {
            Trace.out((int)5, (String)("USM Drivers not " + whatmsg + " on all of the nodes"));
            ReportUtil.sureprintln(s_msgBundle.getMessage(allfailmsg, true));
        }
        if (failNodes.size() > 0) {
            Trace.out((int)5, (String)("USM Drivers not " + whatmsg + " on following nodes: " + LSEP + failNodes));
            ReportUtil.sureprintln(s_msgBundle.getMessage(failmsg, true) + LSEP + failNodes);
        }
        if (unknownNodes.size() > 0) {
            Trace.out((int)5, (String)("Unable to determine if USM Drivers " + whatmsg + " on following nodes: " + LSEP + unknownNodes));
            ReportUtil.sureprintln(s_msgBundle.getMessage(unknownmsg, true) + LSEP + failNodes);
        }
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4498", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4448", false);
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }

    class DriverConsistencyCheckThread
    extends Thread {
        String m_node = null;
        String m_crsHome = null;
        Version m_crsActiveVersion = null;
        Result m_result = null;

        DriverConsistencyCheckThread(String node, String crsHome, Version crsActiveVersion) {
            this.m_node = node;
            this.m_result = new Result(this.m_node);
            this.m_crsHome = crsHome;
            this.m_crsActiveVersion = crsActiveVersion;
        }

        @Override
        public void run() {
            try {
                String acfsKernelVersionStr;
                OFSUtil ofs = new OFSUtil(this.m_crsHome + VerificationConstants.FSEP + "bin");
                Version acfsCommandsVersion = null;
                Version acfsKernelVersion = null;
                if (Version.isPre12101((Version)this.m_crsActiveVersion)) {
                    acfsCommandsVersion = this.m_crsActiveVersion;
                    acfsKernelVersionStr = ofs.getOFSActiveVersion(this.m_node);
                    acfsKernelVersion = VerificationUtil.getVersionObject(acfsKernelVersionStr);
                } else {
                    acfsKernelVersionStr = ofs.getOFSKernelVersion(this.m_node);
                    acfsKernelVersion = VerificationUtil.getVersionObject(acfsKernelVersionStr);
                    String acfsCommandsVersionStr = ofs.getOFSCommandsVersion(this.m_node);
                    acfsCommandsVersion = VerificationUtil.isStringGood(acfsCommandsVersionStr) ? VerificationUtil.getVersionObject(acfsCommandsVersionStr) : this.m_crsActiveVersion;
                }
                if (acfsKernelVersion.toString4().equals(acfsCommandsVersion.toString4())) {
                    this.m_result.setStatus(1);
                } else {
                    this.m_result.setStatus(3);
                    String errorMsg = Task.s_gMsgBundle.getMessage("11499", true, (Object[])new String[]{acfsKernelVersion.toString(), acfsCommandsVersion.toString(), this.m_node});
                    this.m_result.addErrorDescription(new ErrorDescription(errorMsg));
                    VerificationUtil.traceAndLogError(errorMsg);
                }
            }
            catch (CmdToolUtilException cue) {
                VerificationUtil.traceAndLogError(cue.getMessage());
                this.m_result.addErrorDescription(new ErrorDescription(cue.getMessage()));
                this.m_result.setStatus(2);
            }
            catch (ConfigurationException ce) {
                VerificationUtil.traceAndLogError(ce.getMessage());
                this.m_result.addErrorDescription(new ErrorDescription(ce.getMessage()));
                this.m_result.setStatus(2);
            }
        }

        public String getNode() {
            return this.m_node;
        }

        public Result getResult() {
            return this.m_result;
        }
    }
}

