/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.Step;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.InvalidStepException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskSwapSize
extends TaskPeerCompatibility
implements PeerCompatibleTask {
    private StorageSize m_reqdSwapSize;
    private StorageSize m_reqRimMemSize;
    private StorageSize m_reqdMinSwapSize;
    private StorageSize m_reqdMaxSwapSize;
    private String m_refElemName;
    private List<Step> m_stepList = new ArrayList<Step>();
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1057", false);

    public TaskSwapSize(double size, StorageUnit unit) {
        this.m_reqdSwapSize = new StorageSize(size, unit);
    }

    public TaskSwapSize(StorageSize size) {
        this.m_reqdSwapSize = size;
    }

    public TaskSwapSize(String refElemName) {
        this.m_refElemName = refElemName;
    }

    public void addStep(RangeOfValue range, StorageUnit unit, float multiplier) throws InvalidStepException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Inside addStep: range = " + range + ", unit = " + (Object)((Object)unit) + ", mulitplier = " + multiplier));
        }
        this.m_stepList.add(new Step(range, unit, multiplier));
    }

    @Override
    public boolean performTask() {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        if (this.m_refElemName == null) {
            this.performFixedSizeVerification();
        } else {
            this.performStepVerification();
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0304", false, (Object[])new String[]{ReportUtil.unitizeSize(this.m_reqdSwapSize)}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0305", false, (Object[])new String[]{ReportUtil.unitizeSize(this.m_reqdSwapSize), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    void performFixedSizeVerification() {
        GlobalExecution globalExec = new GlobalExecution();
        NodeManager nm = null;
        boolean bigCluster = false;
        List<Object> rimNodeList = null;
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nm = nmf.getNodeManager();
            bigCluster = nm.isBigCluster();
            if (bigCluster) {
                rimNodeList = Arrays.asList(nm.getNodes(NodeRoleCapability.RIM));
            }
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((String)("NodeManagerFactoryException :" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage());
            return;
        }
        catch (NoSuchNodesException e) {
            rimNodeList = new ArrayList();
        }
        catch (NodeManagerException e) {
            Trace.out((String)("NodeManagerFactoryException :" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage());
            return;
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("m_reqswapSize=" + this.m_reqdSwapSize));
        }
        ResultSet swpRsltSet = new ResultSet();
        globalExec.checkSwapSpace(this.m_nodeList, new StorageSize(0.0, StorageUnit.BYTE), swpRsltSet);
        this.m_resultSet.addResultSetData(swpRsltSet);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        Hashtable t = swpRsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String avl;
            String node = (String)e.nextElement();
            StorageSize requiredStorageSize = this.m_reqdSwapSize;
            if (this.m_reqRimMemSize != null && bigCluster && rimNodeList.contains(node)) {
                requiredStorageSize = this.m_reqRimMemSize;
            }
            CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, requiredStorageSize, null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                StorageSize avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                this.m_resultSet.getResult(node).setHasResultValues(true);
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("reqd=" + requiredStorageSize + ";avl=" + avl));
                }
                this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(requiredStorageSize));
                this.m_resultSet.getResult(node).setActualValue(ReportUtil.unitizeSize(avlSS));
                collectionElement.setValue(ReportUtil.unitizeSize(avlSS, 1));
                if (avlSS.compareTo(requiredStorageSize) >= 0) {
                    comment = ReportUtil.PASSED;
                    collectionElement.setStatus(1);
                } else {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7573", true, (Object[])new String[]{node, ReportUtil.unitizeSize(this.m_reqdSwapSize), ReportUtil.unitizeSize(avlSS)}), s_msgBundle, "7573");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 3);
                    comment = ReportUtil.FAILED;
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                }
            } else {
                avl = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7574", true, (Object[])new String[]{node}), s_msgBundle, "7574");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                comment = ReportUtil.FAILED;
                collectionElement.setStatus(3);
                collectionElement.addErrorDescription(errDesc);
            }
            ReportUtil.writeRecord(node, ReportUtil.unitizeSize(avl, StorageUnit.KBYTE), ReportUtil.unitizeSize(requiredStorageSize), comment);
        }
    }

    void performStepVerification() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet swpRsltSet = new ResultSet();
        ResultSet memRsltSet = new ResultSet();
        globalExec.checkSwapSpace(this.m_nodeList, 0L, swpRsltSet);
        this.m_resultSet.addResultSetData(swpRsltSet);
        globalExec.checkMemory(this.m_nodeList, 0L, memRsltSet, true);
        this.m_resultSet.addResultSetData(memRsltSet);
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        Hashtable htSwap = swpRsltSet.getResultTable();
        Hashtable htMem = memRsltSet.getResultTable();
        String avlSwpStr = ReportUtil.UNKNOWN;
        String reqdSwpStr = ReportUtil.UNKNOWN;
        Enumeration eSwap = htSwap.keys();
        while (eSwap.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String node = (String)eSwap.nextElement();
            Result resultSwap = (Result)htSwap.get(node);
            Result resultMem = (Result)htMem.get(node);
            CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, null, null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            if (resultSwap.getStatus() == 1 && resultMem.getStatus() == 1) {
                StorageSize avlSwpBytes = (StorageSize)resultSwap.getResultInfoSet().firstElement();
                StorageSize avlMemBytes = (StorageSize)resultMem.getResultInfoSet().firstElement();
                avlSwpStr = Double.toString(avlSwpBytes.sizeIn(StorageUnit.KBYTE));
                StorageSize reqdSwapMemorySize = this.getRequiredSwapSize(avlMemBytes);
                collectionElement.setValue(ReportUtil.unitizeSize(avlSwpBytes, 1));
                if (reqdSwapMemorySize == null) {
                    return;
                }
                collectionElement.setExpectedValue(ReportUtil.unitizeSize(reqdSwapMemorySize, 1));
                reqdSwpStr = Double.toString(reqdSwapMemorySize.sizeIn(StorageUnit.KBYTE));
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(reqdSwapMemorySize));
                this.m_resultSet.getResult(node).setActualValue(ReportUtil.unitizeSize(avlSwpBytes));
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("avlMemBytes=" + avlMemBytes));
                    Trace.out((String)("avlSwpBytes=" + avlSwpBytes));
                    Trace.out((String)("reqdSwapMemorySize=" + reqdSwapMemorySize));
                }
                if (avlSwpBytes.compareTo(reqdSwapMemorySize) >= 0) {
                    comment = ReportUtil.PASSED;
                    collectionElement.setStatus(1);
                } else {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7573", true, (Object[])new String[]{node, ReportUtil.unitizeSize(reqdSwapMemorySize), ReportUtil.unitizeSize(avlSwpBytes)}), s_msgBundle, "7573");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    this.m_resultSet.addResult(node, 3);
                    comment = ReportUtil.FAILED;
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                }
            } else {
                if (resultSwap.getStatus() != 1) {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7574", true, (Object[])new String[]{node}), s_msgBundle, "7574");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                }
                if (resultMem.getStatus() != 1) {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7531", true, (Object[])new String[]{node}), s_msgBundle, "7531");
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                }
                avlSwpStr = ReportUtil.UNKNOWN;
                reqdSwpStr = ReportUtil.UNKNOWN;
                comment = ReportUtil.FAILED;
                this.m_resultSet.addResult(node, 3);
            }
            ReportUtil.writeRecord(node, ReportUtil.unitizeSize(avlSwpStr, StorageUnit.KBYTE), ReportUtil.unitizeSize(reqdSwpStr, StorageUnit.KBYTE), comment);
        }
    }

    private StorageSize getRequiredSwapSize(StorageSize avlMemBytes) {
        StorageSize reqdSwapMemorySize = null;
        boolean stepFound = false;
        StorageUnit unit = StorageUnit.BYTE;
        for (Step step : this.m_stepList) {
            unit = step.getUnit();
            try {
                if (!step.getRange().contains(avlMemBytes)) {
                    continue;
                }
            }
            catch (InvalidRangeManipulationException irme) {
                if (!Trace.isTraceEnabled()) break;
                Trace.out((Exception)irme);
                break;
            }
            stepFound = true;
            reqdSwapMemorySize = new StorageSize(avlMemBytes.sizeIn(unit) * (double)step.getMultiplier(), unit);
            if (!Trace.isTraceEnabled()) break;
            Trace.out((String)("multiplier=" + step.getMultiplier()));
            break;
        }
        if (this.m_reqdMinSwapSize != null && (reqdSwapMemorySize == null || this.m_reqdMinSwapSize.compareTo(reqdSwapMemorySize) > 0)) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("The calculated swap memory " + reqdSwapMemorySize + " is less than the minimum " + this.m_reqdMinSwapSize + " . Using specified minimum as the requirement"));
            }
            reqdSwapMemorySize = this.m_reqdMinSwapSize;
        }
        if (this.m_reqdMaxSwapSize != null && (reqdSwapMemorySize == null || this.m_reqdMaxSwapSize.compareTo(reqdSwapMemorySize) < 0)) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("The calculated swap memory " + reqdSwapMemorySize + " is greater than the maximum " + this.m_reqdMaxSwapSize + " . Using specified maximum as the requirement"));
            }
            reqdSwapMemorySize = this.m_reqdMaxSwapSize;
        }
        if (!stepFound && reqdSwapMemorySize == null) {
            this.m_resultSet.setStatus(2);
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("7575", true), s_msgBundle, "7575");
            this.m_resultSet.addErrorDescription(errDesc);
            return null;
        }
        this.m_reqdSwapSize = reqdSwapMemorySize;
        return reqdSwapMemorySize;
    }

    public void setMinSwapSize(StorageSize size) {
        this.m_reqdMinSwapSize = size;
    }

    public void setMaxSwapSize(StorageSize size) {
        this.m_reqdMaxSwapSize = size;
    }

    @Override
    public String getTaskID() {
        return "CHECK_SWAP_SIZE";
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4420", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4471", false);
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet archRsltSet = new ResultSet();
        globalExec.checkSwapSpace(this.m_nodeList, new StorageSize(0.0, StorageUnit.BYTE), archRsltSet);
        return archRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("1057", false);
    }

    @Override
    protected boolean matchesReferenceNode(Object nodeValue, Object referenceNodeValue) {
        StorageSize nodeSize = (StorageSize)nodeValue;
        StorageSize refNodeSize = (StorageSize)referenceNodeValue;
        if (nodeSize == refNodeSize) {
            return true;
        }
        if (nodeSize == null || refNodeSize == null) {
            return false;
        }
        return nodeSize.compareTo(refNodeSize) >= 0;
    }

    public void setRimValue(StorageSize storageSize) {
        this.m_reqRimMemSize = storageSize;
    }
}

