/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.impl.crs.ResourceType;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskPathGroupPermissions
extends Task {
    private String m_path;
    private static final String PERMISSION_X = "1";
    private static final String PERMISSION_W = "2";
    private static final String PERMISSION_WX = "3";
    private static final String PERMISSION_R = "4";
    private static final String PERMISSION_RX = "5";
    private static final String PERMISSION_RW = "6";
    private static final String PERMISSION_RWX = "7";
    private static final String ERROR_FILE_INFO = "1";

    public TaskPathGroupPermissions(String[] nodeList, String path) {
        super(nodeList, null, 1);
        this.m_path = path;
    }

    @Override
    public boolean performTask() {
        List<String> ancestors = null;
        ArrayList<String> groups = null;
        ResultSet fileInfoRset = new ResultSet();
        Hashtable<String, Hashtable<String, FileInfo>> fileInfoCollection = new Hashtable();
        Trace.out((String)"ENTRY");
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("12890", false, (Object[])new String[]{this.m_path}));
        Result resultUser = new Result(m_localNode);
        String user = VerificationUtil.getCRSUser(resultUser, false);
        if (user == null) {
            String msg = resultUser.getErrMessage();
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.printError(msg);
            return false;
        }
        Trace.out((String)("user[" + user + "]"));
        VerificationCommand[] cmdArray = new VerificationCommand[1];
        String nodeCmd = null;
        nodeCmd = m_localNode;
        cmdArray[0] = new VerificationCommand(nodeCmd, new String[]{"-getgroups", user}, null);
        ResultSet groupsRset = new ResultSet();
        String[] strGroups = null;
        VerificationCommand cmdGrp = null;
        new GlobalHandler().submit((Command[])cmdArray, 0, groupsRset);
        if (groupsRset.getStatus() == 1) {
            cmdGrp = cmdArray[0];
            if (cmdGrp.getVfyCode() != 0) {
                String msg = s_gMsgBundle.getMessage("12894", true, (Object[])new String[]{user, nodeCmd});
                this.m_resultSet.addResult(this.m_nodeList, 3);
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.printError(msg);
                return false;
            }
        } else {
            this.m_resultSet.addResultSetData(groupsRset);
            ReportUtil.printErrorNodes(groupsRset);
            return false;
        }
        String[] strResultStr = cmdGrp.getCommandResult().getResultString();
        String reoutput = VerificationUtil.fetchVerificationValue(VerificationUtil.strArr2String(strResultStr));
        String[] tmpTokens = reoutput.split(":");
        strGroups = tmpTokens[1].trim().split(" ");
        groups = new ArrayList<String>(Arrays.asList(strGroups));
        Trace.out((String)("groups[" + groups + "]"));
        ancestors = this.getPathAncestors(this.m_path);
        if (ancestors.size() == 0) {
            ancestors.add(this.m_path);
        }
        fileInfoCollection = VerificationUtil.getFileAttributes(this.m_nodeList, ancestors, null, null, null, fileInfoRset);
        ResultSet executePermRset = new ResultSet();
        this.verifyPermissions(fileInfoCollection, user, groups, executePermRset);
        this.m_resultSet.addResultSetData(executePermRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("12891", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("12892", false));
        return false;
    }

    private void verifyPermissions(Hashtable<String, Hashtable<String, FileInfo>> pathFileInfo, String user, List<String> groups, ResultSet permissionsRSet) {
        Hashtable<String, FileInfo> pathInfo = null;
        Enumeration<String> nodekeys = pathFileInfo.keys();
        ArrayList<String> pathKeys = null;
        String node = null;
        FileInfo info = null;
        String groupName = null;
        String groupPermission = null;
        String otherPermission = null;
        while (nodekeys.hasMoreElements()) {
            node = nodekeys.nextElement();
            pathInfo = pathFileInfo.get(node);
            pathKeys = new ArrayList<String>(pathInfo.keySet());
            Collections.sort(pathKeys);
            for (String path : pathKeys) {
                info = pathInfo.get(path);
                Trace.out((String)("node[" + node + "] path[" + path + "] pathInfo[" + info + "]"));
                groupName = info.getFileGroup();
                if (info.getStatus().equals("1")) {
                    String msg = s_gMsgBundle.getMessage("12893", true, (Object[])new String[]{user, path, node, info.getErrorString()});
                    permissionsRSet.addResult(node, 3);
                    ErrorDescription errDesc = new ErrorDescription(msg);
                    permissionsRSet.addErrorDescription(node, errDesc);
                    ReportUtil.printError(msg);
                    return;
                }
                otherPermission = info.getFilePermissions().substring(3, 4);
                if (otherPermission.equals("1") || otherPermission.equals(PERMISSION_WX) || otherPermission.equals(PERMISSION_RX) || otherPermission.equals(PERMISSION_RWX)) {
                    permissionsRSet.addResult(node, 1);
                    continue;
                }
                if (groups.contains(groupName)) {
                    groupPermission = info.getFilePermissions().substring(2, 3);
                    if (groupPermission.equals("1") || groupPermission.equals(PERMISSION_WX) || groupPermission.equals(PERMISSION_RX) || groupPermission.equals(PERMISSION_RWX)) {
                        permissionsRSet.addResult(node, 1);
                        continue;
                    }
                    String msg = s_gMsgBundle.getMessage("12895", true, (Object[])new String[]{path, groupName, this.getTextualPermissions(otherPermission), this.getTextualPermissions(groupPermission), node});
                    Trace.out((String)msg);
                    permissionsRSet.addResult(node, 3);
                    ErrorDescription errDesc = new ErrorDescription(msg);
                    permissionsRSet.addErrorDescription(errDesc);
                    ReportUtil.printError(msg);
                    return;
                }
                String msg = s_gMsgBundle.getMessage("12896", true, (Object[])new String[]{groupName, path, VerificationUtil.strList2List(groups), node});
                Trace.out((String)msg);
                permissionsRSet.addResult(node, 3);
                ErrorDescription errDesc = new ErrorDescription(msg);
                permissionsRSet.addErrorDescription(errDesc);
                ReportUtil.printError(msg);
                return;
            }
        }
    }

    private String getTextualPermissions(String permission) {
        if (permission.equals("1")) {
            return "--" + ResourceType.ACL_PERM.EXECUTE;
        }
        if (permission.equals(PERMISSION_W)) {
            return "-" + ResourceType.ACL_PERM.WRITE + "-";
        }
        if (permission.equals(PERMISSION_WX)) {
            return "-" + ResourceType.ACL_PERM.WRITE + ResourceType.ACL_PERM.EXECUTE;
        }
        if (permission.equals(PERMISSION_R)) {
            return ResourceType.ACL_PERM.READ + "--";
        }
        if (permission.equals(PERMISSION_RX)) {
            return ResourceType.ACL_PERM.READ + "-" + ResourceType.ACL_PERM.EXECUTE;
        }
        if (permission.equals(PERMISSION_RW)) {
            return ResourceType.ACL_PERM.READ.toString() + ResourceType.ACL_PERM.WRITE.toString() + "-";
        }
        if (permission.equals(PERMISSION_RWX)) {
            return ResourceType.ACL_PERM.READ.toString() + ResourceType.ACL_PERM.WRITE.toString() + ResourceType.ACL_PERM.EXECUTE;
        }
        return null;
    }

    public List<String> getPathAncestors(String path) {
        Vector<String> ancestors = new Vector<String>();
        String basePath = path;
        String parent = null;
        Trace.out((String)(" basePath[" + basePath + "]"));
        if (basePath.lastIndexOf(FSEP) == -1) {
            return ancestors;
        }
        parent = basePath.substring(0, basePath.lastIndexOf(FSEP));
        if (parent.equals("")) {
            return ancestors;
        }
        ancestors.add(parent);
        while (parent.lastIndexOf(FSEP) != -1 && parent.length() != parent.lastIndexOf(FSEP) + 1) {
            if ((parent = parent.substring(0, parent.lastIndexOf(FSEP))).equals("")) continue;
            ancestors.add(parent);
        }
        Collections.reverse(ancestors);
        return ancestors;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("12888", false, (Object[])new String[]{this.m_path});
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("12889", false, (Object[])new String[]{this.m_path});
    }
}

