/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskNetworkInterfaceAttributes
extends Task {
    Set<NetworkInfo> m_clusterNetworks = null;
    String[] m_solarisNonGlobalZoneNodes = null;
    boolean m_isRootCredsAvailable = false;
    String m_command = "/usr/sbin/ipadm";

    public TaskNetworkInterfaceAttributes(VerificationTaskContext ctx) {
        super(ctx);
        this.setSeverity(SeverityType.CRITICAL);
    }

    @Override
    protected void init() {
        this.m_solarisNonGlobalZoneNodes = VerificationUtil.getSolarisNonGlobalZoneNodes(this.m_nodeList, new ResultSet());
        this.m_clusterNetworks = NetworkDataDiscovery.getClusterNetworks(m_localNode, new ResultSet());
        VerificationUtil.traceAndLog("Non-global zone nodes: %s, clusterNetworks: %s", VerificationUtil.strArr2List(this.m_solarisNonGlobalZoneNodes), VerificationUtil.strCollection2String(NetworkDataDiscovery.getClusterNetworkNames(this.m_clusterNetworks)));
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        boolean isApplicable = NetworkUtility.isNetworksSetGood(this.m_clusterNetworks) && RootAutomationUtility.isRootExecutionConfigured();
        return isApplicable;
    }

    @Override
    protected boolean performTask() {
        boolean retVal = true;
        this.m_resultSet.addResult(this.m_nodeList, 1);
        if (NetworkUtility.isNetworksSetGood(this.m_clusterNetworks) && NetworkDataDiscovery.hasNetworkTypeInClusterNetworks(this.m_clusterNetworks, NetworkConstants.NetworkType.PUBLIC.getValue()) && this.m_solarisNonGlobalZoneNodes != null && this.m_solarisNonGlobalZoneNodes.length > 0) {
            retVal &= this.checkIfClassTypeNotInherited(this.m_solarisNonGlobalZoneNodes, this.m_clusterNetworks, this.m_resultSet);
        }
        return retVal;
    }

    private boolean checkIfClassTypeNotInherited(String[] nodeList, Set<NetworkInfo> clusterNetworks, ResultSet networkInterfaceAttributesRS) {
        boolean retValue = true;
        HashSet<String> publicNetworksWithInheritedAttribute = new HashSet<String>();
        HashSet<String> nodesWithPublicInheritedNetworkInterface = new HashSet<String>();
        try {
            if (RootAutomationUtility.isRootExecutionConfigured()) {
                this.m_rootCreds = RootAutomationUtility.getRootExecutionInfo();
                this.m_isRootCredsAvailable = true;
            }
        }
        catch (VerificationException e) {
            VerificationUtil.traceAndLog("error while getting root automation");
            ReportUtil.sureprintln(e.getMessage());
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            networkInterfaceAttributesRS.addErrorDescription(errDesc);
            networkInterfaceAttributesRS.addResult(this.m_nodeList, 2);
        }
        if (!this.m_isRootCredsAvailable) {
            VerificationUtil.traceAndLog("root credentials are not available, skipping the checks for interface attribute CLASS/TYPE");
        } else {
            HashMap<String, Set<String>> inheritedNetworkInterfacesIdsByNode = new HashMap<String, Set<String>>();
            ResultSet ipadmCommandRS = new ResultSet();
            this.getInheritedNetworkInterfaces(nodeList, inheritedNetworkInterfacesIdsByNode, ipadmCommandRS);
            if (ipadmCommandRS.anySuccess()) {
                if (!inheritedNetworkInterfacesIdsByNode.isEmpty()) {
                    for (NetworkInfo networkItem : clusterNetworks) {
                        if (networkItem.getNetworkType() != NetworkConstants.NetworkType.PUBLIC.getValue()) continue;
                        String publicNetworkIfName = networkItem.getInterfaceName();
                        for (String node : nodeList) {
                            Set inheritednetworkInterfaceIds;
                            if (!inheritedNetworkInterfacesIdsByNode.containsKey(node) || !(inheritednetworkInterfaceIds = (Set)inheritedNetworkInterfacesIdsByNode.get(node)).contains(publicNetworkIfName)) continue;
                            retValue = false;
                            nodesWithPublicInheritedNetworkInterface.add(node);
                            publicNetworksWithInheritedAttribute.add(publicNetworkIfName);
                        }
                    }
                } else {
                    VerificationUtil.traceAndLog("No interfaces found with CLASS/TYPE set to 'inherited'");
                }
            } else {
                retValue = false;
                networkInterfaceAttributesRS.addResultSetData(ipadmCommandRS);
            }
        }
        if (publicNetworksWithInheritedAttribute.size() > 0) {
            String errorMessage = s_gMsgBundle.getMessage("10472", true, (Object[])new String[]{VerificationUtil.strCollection2String(publicNetworksWithInheritedAttribute), VerificationUtil.strCollection2String(nodesWithPublicInheritedNetworkInterface)});
            ErrorDescription errorDescription = new ErrorDescription(errorMessage);
            ReportUtil.printError(errorMessage);
            networkInterfaceAttributesRS.addErrorDescription(errorDescription);
            networkInterfaceAttributesRS.addResult(nodesWithPublicInheritedNetworkInterface.toArray(new String[0]), 3);
        }
        return retValue;
    }

    private void getInheritedNetworkInterfaces(String[] nodeList, Map<String, Set<String>> inheritedInterfacesIds, ResultSet inheritedNetworkInterfacesRS) {
        GlobalExecution globalExec = new GlobalExecution();
        String[] env = null;
        String errMsg = null;
        String output = null;
        HashMap<String, String> nodeOutputMap = new HashMap<String, String>();
        ResultSet commandRS = new ResultSet();
        try {
            globalExec.runGenericCmdAsRoot(nodeList, this.m_command, env, null, this.m_rootCreds, this.m_defaultTimeout, commandRS);
        }
        catch (RootAutomationNotConfiguredException e) {
            VerificationUtil.traceAndLog("error while running command as Root");
            ReportUtil.sureprintln(e.getMessage());
            ErrorDescription errDesc = new ErrorDescription(e.getMessage());
            inheritedNetworkInterfacesRS.addErrorDescription(errDesc);
            inheritedNetworkInterfacesRS.addResult(nodeList, 2);
            return;
        }
        inheritedNetworkInterfacesRS.addResultSetData(commandRS);
        if (!commandRS.anySuccess()) {
            VerificationUtil.traceAndLog("root command execution failed");
            StringBuilder errors = new StringBuilder();
            for (String node : nodeList) {
                List<VerificationError> errList = commandRS.getResult(node).getErrors();
                StringBuilder sb = new StringBuilder();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                errors.append(String.format("error on node %s is : %s", node, sb.toString()) + LSEP);
                ReportUtil.sureprintln(sb.toString());
            }
            VerificationUtil.traceAndLog(errors.toString());
            return;
        }
        for (int i = 0; i < nodeList.length; ++i) {
            Result result = commandRS.getResult(nodeList[i]);
            if (result.getStatus() == 1) {
                output = (String)commandRS.getResult(nodeList[i]).getResultInfoSet().get(0);
                nodeOutputMap.put(nodeList[i], output);
                continue;
            }
            List<VerificationError> errList = commandRS.getResult(nodeList[i]).getErrors();
            StringBuilder sb = new StringBuilder();
            for (VerificationError vfyErr : errList) {
                sb.append(vfyErr.getErrorMessage());
            }
            errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{this.m_command, nodeList[i], ""}) + LSEP + sb.toString();
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            VerificationUtil.traceAndLog("error on node " + nodeList[i] + " is " + sb.toString());
            inheritedNetworkInterfacesRS.addErrorDescription(nodeList[i], errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        for (Map.Entry entry : nodeOutputMap.entrySet()) {
            output = (String)entry.getValue();
            String node = (String)entry.getKey();
            VerificationUtil.traceAndLog("Analyzing output =" + output);
            if (VerificationUtil.isStringGood(output)) {
                String[] outputLines;
                String inheritedValue = "inherited";
                for (String line : outputLines = VerificationUtil.string2strArr(output, VerificationUtil.LSEP)) {
                    if (!line.contains(inheritedValue)) continue;
                    String[] outputColumns = VerificationUtil.string2strArr(line, " ");
                    String ifName = outputColumns[0];
                    if (ifName.contains("/")) {
                        ifName = ifName.substring(0, ifName.indexOf("/"));
                    }
                    if (inheritedInterfacesIds.containsKey(ifName)) {
                        inheritedInterfacesIds.get(ifName).add(node);
                        continue;
                    }
                    HashSet<String> nodes = new HashSet<String>();
                    nodes.add(node);
                    inheritedInterfacesIds.put(ifName, nodes);
                }
                continue;
            }
            errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{this.m_command, node});
            inheritedNetworkInterfacesRS.addResult(node, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            inheritedNetworkInterfacesRS.addErrorDescription(errDesc);
            ReportUtil.printError(errMsg);
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("10470", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("10471", false);
    }
}

