/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.gpnp.GPnPASMProfile;
import oracle.cluster.verification.gpnp.GPnPCSSProfile;
import oracle.cluster.verification.gpnp.GPnPHostNetwork;
import oracle.cluster.verification.gpnp.GPnPNetwork;
import oracle.cluster.verification.gpnp.GPnPNetworkProfile;
import oracle.cluster.verification.gpnp.GPnPProfile;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskGPnPProfileCollection
extends Task {
    public TaskGPnPProfileCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return !(!VerificationUtil.isStringGood(this.m_globalContext.getCRSHome()) && !VerificationUtil.isStringGood(this.m_globalContext.getHAHome()) || !VerificationUtil.isBaselineCollectionMode() && !VerificationUtil.isCVUResource());
    }

    public TaskGPnPProfileCollection(String[] nodeList) {
        super(nodeList);
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing GPnP Collection");
        CollectionResultSet<GPnPProfile> gpnpProfileRS = ClusterwareUtil.getGPnPProfile(this.m_nodeList);
        HashMap<String, CollectionResult<GPnPProfile>> t = gpnpProfileRS.getNodeCollectionResults();
        Set<String> e = t.keySet();
        for (String node : e) {
            CollectionResult<GPnPProfile> nodeResult = t.get(node);
            this.m_resultSet.addResult(node, nodeResult.getNodeResultStatus().getResultStatus());
            if (!NodeResultStatus.SUCCESSFUL.equals((Object)nodeResult.getNodeResultStatus())) continue;
            try {
                GPnPASMProfile asmProfile;
                GPnPCSSProfile cssProfile;
                ArrayList<CollectionElement> nodeCollectionElementList = new ArrayList<CollectionElement>();
                GPnPProfile nodeProfile = nodeResult.getCollectedValue();
                GPnPNetworkProfile networkProfile = nodeProfile.getNetworkProfile();
                if (networkProfile != null && networkProfile.getHostNetworks() != null) {
                    for (GPnPHostNetwork hostNetwork : networkProfile.getHostNetworks()) {
                        for (GPnPNetwork network : hostNetwork.getNetworks()) {
                            CollectionElement hostNetworkCE = new CollectionElement("Network:" + network.getId(), null, null, null, "Network:" + hostNetwork.getId(), 1);
                            CollectionElement ipCE = new CollectionElement("IP", String.valueOf(network.getIpAddress()), null, null, "IP", 1);
                            CollectionElement adapterCE = new CollectionElement("Adapter", network.getAdapter(), null, null, "Adapter", 1);
                            CollectionElement useCE = new CollectionElement("Use", network.getUse(), null, null, "Use", 1);
                            hostNetworkCE.addChild(ipCE);
                            hostNetworkCE.addChild(adapterCE);
                            hostNetworkCE.addChild(useCE);
                            nodeCollectionElementList.add(hostNetworkCE);
                        }
                    }
                }
                if ((cssProfile = nodeProfile.getCssProfile()) != null) {
                    CollectionElement cssProfileCE = new CollectionElement("CSS-Profile:" + cssProfile.getId(), null, null, null, "CSS-Profile:" + cssProfile.getId(), 1);
                    CollectionElement cssDSCE = new CollectionElement("DiscoveryString", cssProfile.getDiscoveryString(), null, null, "DiscoveryString", 1);
                    CollectionElement cssLDCE = new CollectionElement("LeaseDuration", cssProfile.getLeaseDuration(), null, null, "LeaseDuration", 1);
                    cssProfileCE.addChild(cssDSCE);
                    cssProfileCE.addChild(cssLDCE);
                    nodeCollectionElementList.add(cssProfileCE);
                }
                if ((asmProfile = nodeProfile.getAsmProfile()) != null) {
                    CollectionElement asmProfileCE = new CollectionElement("ASM-Profile:" + asmProfile.getId(), null, null, null, "ASM-Profile:" + asmProfile.getId(), 1);
                    CollectionElement asmDSCE = new CollectionElement("DiscoveryString", asmProfile.getDiscoveryString(), null, null, "DiscoveryString", 1);
                    CollectionElement asmSPFileCE = new CollectionElement("SPFile", asmProfile.getSpFile(), null, null, "SPFile", 1);
                    CollectionElement asmModeCE = new CollectionElement("Mode", (Object)asmProfile.getMode(), null, null, "Mode", 1);
                    asmProfileCE.addChild(asmDSCE);
                    asmProfileCE.addChild(asmSPFileCE);
                    asmProfileCE.addChild(asmModeCE);
                    nodeCollectionElementList.add(asmProfileCE);
                }
                this.m_resultSet.getResult(node).addCollectionElements(nodeCollectionElementList);
            }
            catch (CollectionValueUnavailableException e1) {
                Trace.out(e);
            }
        }
        return retVal;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.GPNP_COLLECTION;
    }

    @Override
    public String getTaskID() {
        return "GPNPPROFILE_COLLECTION";
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11185", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11186", false);
    }
}

