/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Vector;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ResourceState;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskGPNPIntegrity
extends Task {
    String GPNPD_CHECK_COMMAND = "crsctl stat res ora.gpnpd -init";

    public TaskGPNPIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (this.m_nodeList == null || this.m_nodeList.length == 0) {
            VerificationUtil.traceAndLogWarning("Skipping GPNP integrity check as no nodes with CRS install found.");
            return false;
        }
        return true;
    }

    public TaskGPNPIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskGPNPIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskGPNPIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing GPNP Integrity verification task... ");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5250", false));
        this.performGPNPIntegrityChecks();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5251", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5252", false));
        return false;
    }

    void performGPNPIntegrityChecks() {
        ErrorDescription errorDesc;
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            String msg = s_msgBundle.getMessage("5301", true);
            ReportUtil.printError(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return;
        }
        String resstatCmd = crsHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + this.GPNPD_CHECK_COMMAND;
        VerificationCommand[] gpnpCmdArray = new VerificationCommand[this.m_nodeList.length];
        for (int j = 0; j < this.m_nodeList.length; ++j) {
            String[] arg = new String[]{"-rungencmd", resstatCmd};
            String[] env = null;
            gpnpCmdArray[j] = new VerificationCommand(this.m_nodeList[j], arg, env);
        }
        Trace.out((String)"about to submit gpnp status check command");
        new GlobalHandler().submit((Command[])gpnpCmdArray, 0, this.m_resultSet);
        if (!this.m_resultSet.anySuccess()) {
            Trace.out((String)("Global failure checking GPNP resource status with command " + resstatCmd));
            String message = s_msgBundle.getMessage("5253", true, (Object[])new String[]{resstatCmd});
            ErrorDescription errorDesc2 = new ErrorDescription(message);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(errorDesc2);
            ReportUtil.sureprintln(message);
            return;
        }
        Vector<String> resDownNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8018", false));
        for (int nodeIndex = 0; nodeIndex < this.m_nodeList.length; ++nodeIndex) {
            VerificationCommand gpnpCmd = gpnpCmdArray[nodeIndex];
            Result result = gpnpCmd.getResult();
            String node = gpnpCmd.getNode();
            this.m_resultSet.addResult(node, result);
            if (result.getStatus() == 1) {
                String output = gpnpCmd.getOutput();
                if (output == null) {
                    Trace.out((String)("Error retreiving output of crsctl command on node " + node));
                    ReportUtil.writeRecord(node, ReportUtil.FAILED);
                    this.m_resultSet.addResult(node, 2);
                    String errMsg = s_msgBundle.getMessage("5254", true, (Object[])new String[]{resstatCmd, node});
                    ReportUtil.sureprintln(errMsg);
                    ErrorDescription errorDesc3 = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(node, errorDesc3);
                    continue;
                }
                Trace.out((String)("Parsing command output: " + output));
                ResourceState resst = ResourceState.checkState(output);
                switch (resst) {
                    case ONLINE: 
                    case INTERMEDIATE: {
                        ReportUtil.writeRecord(node, ReportUtil.PASSED);
                        break;
                    }
                    case OFFLINE: 
                    case UNKNOWN: {
                        resDownNodes.add(node);
                        ReportUtil.writeRecord(node, ReportUtil.FAILED);
                        this.m_resultSet.addResult(node, 3);
                        break;
                    }
                }
                continue;
            }
            Trace.out((String)("Error executing gpnp resource check on node " + node));
            failNodes.add(node);
            ReportUtil.writeRecord(node, ReportUtil.FAILED);
        }
        if (resDownNodes.size() != 0) {
            String errMsg = s_msgBundle.getMessage("5255", true, (Object[])new String[]{VerificationUtil.strList2List(resDownNodes)});
            ReportUtil.sureprintln(errMsg);
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(resDownNodes, errorDesc);
        }
        if (failNodes.size() != 0) {
            String errMsg = s_msgBundle.getMessage("5256", true, (Object[])new String[]{resstatCmd, VerificationUtil.strList2List(failNodes)});
            ReportUtil.sureprintln(errMsg);
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(failNodes, errorDesc);
        }
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4446", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5201", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

