/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCRSUserConsistent
extends Task {
    private boolean m_isSIHA = false;

    public TaskCRSUserConsistent(String[] nodeList) {
        super(nodeList);
    }

    public TaskCRSUserConsistent(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("IS_SIHA".equals(argName) && VerificationUtil.isStringGood(argVal)) {
                if (!"true".equalsIgnoreCase(argVal)) continue;
                this.m_isSIHA = true;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    public boolean performTask() {
        String errMsg = null;
        String currentUser = VerificationUtil.getDefaultOracleUser();
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9552", false));
        String localNodeName = null;
        for (int i = 0; i < this.m_nodeList.length; ++i) {
            if (!VerificationUtil.isLocalNode(this.m_nodeList[i])) continue;
            localNodeName = this.m_nodeList[i];
            break;
        }
        if (localNodeName == null) {
            try {
                localNodeName = VerificationUtil.getLocalNodename();
            }
            catch (NodelistNotFoundException e) {
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, new ErrorDescription(e.getMessage()));
                return false;
            }
        }
        Result nodeRslt = new Result(localNodeName);
        String CRSUserNode = VerificationUtil.getCRSUser(localNodeName, nodeRslt, this.m_isSIHA);
        if (nodeRslt.getStatus() == 1 && CRSUserNode != null && CRSUserNode.trim().length() > 0) {
            CRSUserNode = CRSUserNode.trim();
            nodeRslt.setHasResultValues(true);
            nodeRslt.setActualValue(currentUser);
            nodeRslt.setExpectedValue(CRSUserNode);
            if (CRSUserNode.equals(currentUser)) {
                ReportUtil.printResult(s_msgBundle.getMessage("9553", false));
                this.m_resultSet.addResult(localNodeName, nodeRslt);
                return true;
            }
            ReportUtil.printResult(s_msgBundle.getMessage("9554", false));
            errMsg = s_msgBundle.getMessage("9555", true, (Object[])new String[]{currentUser, CRSUserNode});
            ReportUtil.printError(errMsg);
            nodeRslt.addErrorDescription(new ErrorDescription(errMsg));
            nodeRslt.setStatus(3);
            this.m_resultSet.addResult(localNodeName, nodeRslt);
            return false;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("9554", false));
        errMsg = s_msgBundle.getMessage("9556", true);
        ReportUtil.printError(errMsg);
        nodeRslt.addErrorDescription(new ErrorDescription(errMsg));
        this.m_resultSet.addResult(localNodeName, nodeRslt);
        return false;
    }

    public void setSIHA(boolean isSIHA) {
        this.m_isSIHA = isSIHA;
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9551", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9550", false);
    }
}

