/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.CollectionResultSetImpl;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.OSCollectionsCommandHandler;
import oracle.ops.verification.framework.util.OSPackageInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskAllOSPackageCollection
extends Task {
    private String m_commandId;

    public TaskAllOSPackageCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("COMMAND_ID".equals(argName)) {
                this.m_commandId = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean performTask() {
        Trace.out((String)"ENTRY");
        if (!OSCollectionsCommandHandler.osPackagesCollectionAvailable()) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        CollectionResultSetImpl<List<OSPackageInfo>> colRes = OSCollectionsCommandHandler.getAllPackages(this.m_commandId, this.m_nodeList);
        HashMap<String, CollectionResult<List<OSPackageInfo>>> t = colRes.getNodeCollectionResults();
        for (String node : t.keySet()) {
            CollectionResult<List<OSPackageInfo>> result = t.get(node);
            this.m_resultSet.addResult(node, colRes.getStatus());
            if (colRes.getStatus() != 1) {
                for (VerificationError error : colRes.getErrors()) {
                    this.m_resultSet.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            try {
                for (OSPackageInfo pkg : result.getCollectedValue()) {
                    String ceName = pkg.getName();
                    if (VerificationUtil.isStringGood(pkg.getArchitecture())) {
                        ceName = ceName + "[" + pkg.getArchitecture() + "]";
                    }
                    CollectionElement ce = new CollectionElement(ceName, pkg.getVersion(), null, null, ceName, 1);
                    this.m_resultSet.addCollectionElement(node, ce);
                }
            }
            catch (CollectionValueUnavailableException e1) {
                Trace.out((Exception)e1);
            }
        }
        return true;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.OS_PACKAGES;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13102", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13103", false);
    }
}

