/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.EnumSet;
import java.util.Vector;
import oracle.cluster.verification.UserEquivCheckType;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.sAdminPriv;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskAdminPrivileges
extends Task {
    private String m_operation;
    private boolean m_toCheckNodeReach = true;
    private String m_osdba = null;
    private String m_asmAdminGrp = null;
    private String m_asmDbaGrp = null;
    private String m_oraInv = null;
    private String m_oracleHome;
    private EnumSet<UserEquivCheckType> m_userEquivCheckTypeSet;

    public TaskAdminPrivileges(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        switch (this.m_globalContext.getVerificationType()) {
            case COMPONENT_ADMIN_PRIVILEGES: {
                ParamManager paramMgr = this.m_globalContext.getParamManager();
                this.m_operation = paramMgr.getAdminPrivOperation();
                this.setOSDBA(CVUVariables.getValue(CVUVariableConstants.DBA_GROUP));
                this.setOraInv(CVUVariables.getValue(CVUVariableConstants.INSTALL_GROUP));
                this.setOracleHome(CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME));
                this.setASMADMIN(CVUVariables.getValue(CVUVariableConstants.ASM_GROUP));
                this.setASMDBA(CVUVariables.getValue(CVUVariableConstants.ASM_DBA_GROUP));
                Trace.out((String)"=== ParamManager returned operation=%s, OSDBA=%s, ASMDBA=%s, ASMADMIN=%s, ORAINV=%s, OracleHome=%s", (Object[])new Object[]{this.m_operation, this.m_osdba, this.m_asmDbaGrp, this.m_asmAdminGrp, this.m_oraInv, this.m_oracleHome});
                break;
            }
            default: {
                ExecutableInfo execInfo = this.m_ctx.getExecInfo();
                for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
                    String argName = arg.getArgName();
                    String argVal = arg.getArgVal(true);
                    if ("OPERATION".equals(argName)) {
                        this.m_operation = argVal;
                        continue;
                    }
                    Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
                }
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        switch (this.m_globalContext.getVerificationType()) {
            case COMPONENT_ADMIN_PRIVILEGES: {
                ParamManager paramMgr = this.m_globalContext.getParamManager();
                this.m_operation = paramMgr.getAdminPrivOperation();
                if (!this.m_operation.equalsIgnoreCase("user_equiv")) break;
                Trace.out((String)"Only user equivalence check requested on command line,  hence admin priv check not applicable");
                return false;
            }
        }
        return true;
    }

    public TaskAdminPrivileges(String[] nodeList, String operation) {
        this(nodeList, operation, null, 1);
    }

    public TaskAdminPrivileges(String[] nodeList, String operation, MultiTaskHandler multiTaskHandler) {
        this(nodeList, operation, multiTaskHandler, 1);
    }

    public TaskAdminPrivileges(String[] nodeList, String operation, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        this.m_operation = operation;
    }

    public void setOperation(String operation) {
        this.m_operation = operation;
    }

    public void setOSDBA(String osdba) {
        this.m_osdba = osdba;
    }

    public void setASMADMIN(String asmadmingrp) {
        this.m_asmAdminGrp = asmadmingrp;
    }

    public void setASMDBA(String asmdbagrp) {
        this.m_asmDbaGrp = asmdbagrp;
    }

    public void setOraInv(String oraInv) {
        this.m_oraInv = oraInv;
    }

    public void setOracleHome(String oracleHome) {
        this.m_oracleHome = oracleHome;
    }

    public String getOSDBA() {
        return this.m_osdba;
    }

    public String getASMADMINGRP() {
        return this.m_asmAdminGrp;
    }

    public String getASMDBAGRP() {
        return this.m_asmDbaGrp;
    }

    public String getOraInv() {
        return this.m_oraInv;
    }

    public String getOracleHome() {
        return this.m_oracleHome;
    }

    public void setCheckNodeReach(boolean toCheckNodeReach) {
        this.m_toCheckNodeReach = toCheckNodeReach;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing Admin Privileges verification task... ");
        String[] equivNodeArr = this.m_nodeList;
        ResultSet destLocResultSet = new ResultSet();
        Vector<String> succDLNodes = new Vector<String>();
        Vector<String> failDLNodes = new Vector<String>();
        String taskName = VerificationUtil.getDestLoc();
        VerificationUtil.checkDestLoc(equivNodeArr, destLocResultSet, succDLNodes, failDLNodes, true);
        TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy(taskName, equivNodeArr, this, destLocResultSet);
        anonymousTask.performAnonymousTask(destLocResultSet);
        if (succDLNodes.size() == 0) {
            return false;
        }
        String[] okNodeArr = succDLNodes.toArray(new String[succDLNodes.size()]);
        ResultSet admPrvResultSet = new ResultSet();
        boolean admPrvStatus = new sAdminPriv(okNodeArr, this.m_operation, admPrvResultSet, this).checkAdminPriv();
        this.m_resultSet.uploadResultSet(admPrvResultSet);
        Trace.out((String)"ResultSet should hold all data");
        return !this.m_resultSet.anyFailure();
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4428", false);
    }

    @Override
    public String getTaskID() {
        return "ADMIN_PRIV";
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4479", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        sb.append("\n    Operation: " + this.m_operation);
        sb.append("\n    OSDBA: " + this.m_osdba);
        sb.append("\n    ORAINV: " + this.m_oraInv);
        return sb.toString();
    }
}

