/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.ASMPresence;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.helper.CVUHelperConstants;

public class TaskASMRunning
extends Task
implements CVUHelperConstants {
    @Override
    public boolean performTask() {
        ASMPresence asmPresence = CVUHelperUtil.getASMPresence();
        if (ASMPresence.FAR.equals((Object)asmPresence)) {
            Trace.out((String)"No checks for FAR ASM yet");
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6052", false));
        ArrayList<String> runningASMNodes = new ArrayList<String>();
        ArrayList<String> failedASMNodes = new ArrayList<String>();
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
        try {
            Trace.out((int)5, (String)"Checking if ASM is running on nodes");
            asmdg.checkASMRunning(this.m_nodeList, runningASMNodes, failedASMNodes);
        }
        catch (ASMDiskGroupsUtilException e1) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            for (String node : this.m_nodeList) {
                failedASMNodes.add(node);
            }
            Trace.out((int)5, (String)("Error checking if ASM is running on all nodes " + e1.getMessage()));
        }
        if (runningASMNodes.size() == 0) {
            ReportUtil.printError(LSEP + s_msgBundle.getMessage("4194", true) + LSEP);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            return false;
        }
        if (runningASMNodes.size() == this.m_nodeList.length) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5108", false));
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else if (ASMPresence.LOCAL.equals((Object)asmPresence)) {
            ReportUtil.printError(LSEP + s_msgBundle.getMessage("4193", true) + LSEP);
            String[] faileNodeArr = failedASMNodes.toArray(new String[0]);
            ReportUtil.sureprintNodelist(faileNodeArr);
            this.m_nodeList = runningASMNodes.toArray(new String[0]);
            this.m_resultSet.addResult(this.m_nodeList, 1);
            this.m_resultSet.addResult(faileNodeArr, 3);
        } else if (ASMPresence.NEAR.equals((Object)asmPresence)) {
            int asmCount = CVUHelperUtil.getASMCount();
            if (runningASMNodes.size() >= asmCount) {
                ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("6055", false));
                this.m_resultSet.addResult(this.m_nodeList, 1);
            } else {
                String msg = s_gMsgBundle.getMessage("6056", true, (Object[])new String[]{asmCount + "", runningASMNodes.size() + ""});
                ReportUtil.printError(LSEP + msg + LSEP);
                String[] faileNodeArr = failedASMNodes.toArray(new String[0]);
                ReportUtil.sureprintNodelist(faileNodeArr);
                this.m_nodeList = runningASMNodes.toArray(new String[0]);
                this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
                this.m_resultSet.addResult(this.m_nodeList, 3);
            }
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6053", false));
            return true;
        }
        ReportUtil.println(LSEP + s_gMsgBundle.getMessage("6054", false));
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("6050", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("6051", false);
    }
}

