/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.impl.verification.SharedStorageResultSetImpl;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMDeviceSharedness
extends Task {
    private String[] m_devArr = null;
    private SharedStorageResultSetImpl m_ssResSetImpl;
    private TaskSharedStorageAccess.StorageThread[] m_stThreadArr;
    private Vector<TaskSharedStorageAccess.StorageThread> m_sharedSet;
    private Vector<TaskSharedStorageAccess.StorageThread> m_nonSharedSet;
    private Hashtable<Object, Vector<Object>> m_signaturePathMap = new Hashtable();
    HashMap<String, Vector<StorageInfo>> m_storageInfoMap = new HashMap();

    public TaskASMDeviceSharedness(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskASMDeviceSharedness(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskASMDeviceSharedness(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskASMDeviceSharedness(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    protected void init() {
        if (this.m_globalContext.isASMCheck()) {
            this.m_devArr = this.m_globalContext.getASMdevices();
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return this.m_devArr != null;
    }

    @Override
    public boolean performTask() {
        boolean cvuqdiskRequired = VerificationUtil.isPlatformLinux();
        boolean cvuqdiskAvailable = false;
        this.m_ssResSetImpl = new SharedStorageResultSetImpl();
        if (cvuqdiskRequired) {
            ResultSet pkgRsltSet = new ResultSet();
            cvuqdiskAvailable = VerificationUtil.isCVUQDiskAvailable(this.m_nodeList, pkgRsltSet, this);
            this.m_ssResSetImpl.uploadResultSet(pkgRsltSet);
            if (!cvuqdiskAvailable) {
                this.m_resultSet.uploadResultSet(pkgRsltSet);
                this.m_resultSet.setStatus(3);
                return false;
            }
        }
        TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(this.m_nodeList);
        for (int j = 0; j < this.m_devArr.length; ++j) {
            Trace.out((String)("Discovered device : " + this.m_devArr[j]));
        }
        List<String> discoveryASMPaths = Arrays.asList(this.m_devArr);
        taskSSAccess.setStorageIDlist(this.m_devArr);
        taskSSAccess.setCheckOCFS(false);
        taskSSAccess.setCheckNFSOrNoFS(true);
        taskSSAccess.setASMpaths(true);
        taskSSAccess.setOracleFileType(OracleFileType.ASM);
        taskSSAccess.setDiscoveryASMPaths(discoveryASMPaths);
        taskSSAccess.setConsiderASMStorage(true);
        this.addChildTask(taskSSAccess);
        taskSSAccess.setChildTaskLevel(this.getChildTaskLevel() + 1);
        Task previousTaskReference = null;
        previousTaskReference = ReportUtil.setTaskReference(taskSSAccess);
        taskSSAccess.perform();
        ReportUtil.setTaskReference(previousTaskReference);
        this.m_ssResSetImpl.uploadResultSet(taskSSAccess.getResultSet());
        this.m_stThreadArr = taskSSAccess.threadList;
        if (this.m_stThreadArr != null && this.m_stThreadArr.length > 0) {
            Vector<TaskSharedStorageAccess.StorageThread> stThreadList = new Vector<TaskSharedStorageAccess.StorageThread>();
            Hashtable<String, TaskSharedStorageAccess.StorageThread> ht = new Hashtable<String, TaskSharedStorageAccess.StorageThread>();
            for (int i = 0; i < this.m_stThreadArr.length; ++i) {
                String key = this.m_stThreadArr[i].getStoragePath();
                TaskSharedStorageAccess.StorageThread sthrd = (TaskSharedStorageAccess.StorageThread)ht.get(key);
                if (null != sthrd) continue;
                Trace.out((String)("Inserting key >" + key + "< into hash table."));
                ht.put(key, this.m_stThreadArr[i]);
            }
            Enumeration enumht = ht.elements();
            while (enumht.hasMoreElements()) {
                TaskSharedStorageAccess.StorageThread st = (TaskSharedStorageAccess.StorageThread)enumht.nextElement();
                Trace.out((String)("Adding storage >" + st.getStoragePath() + "< into vector"));
                stThreadList.add(st);
            }
            this.m_nonSharedSet = new Vector();
            Vector<TaskSharedStorageAccess.StorageThread> sharedSet = this.verifySharedness(stThreadList, this.m_nonSharedSet);
            this.m_sharedSet = sharedSet;
            for (TaskSharedStorageAccess.StorageThread storageThread : sharedSet) {
                int stType;
                String path = storageThread.getStoragePath();
                Vector<StorageInfo> stInfoSet = storageThread.getStorageInfoVector();
                StorageInfo firstst = null;
                if (stInfoSet.size() <= 0 || (stType = (firstst = stInfoSet.firstElement()).getType()) != 1 && stType != 2) continue;
                Trace.out((String)("Adding shared path '" + path + "' to storageInfoMap"));
                this.m_storageInfoMap.put(path, stInfoSet);
                if (stType != 1 || !VerificationUtil.isStringGood(firstst.getSignature())) continue;
                VerificationUtil.updateResultMap(this.m_signaturePathMap, firstst.getSignature(), path);
            }
        }
        this.m_resultSet.uploadResultSet(this.m_ssResSetImpl);
        if (this.m_ssResSetImpl.allSuccess()) {
            if (this.m_ssResSetImpl.anyWarning()) {
                Trace.out((String)"ResultSet shows some Warnings");
            } else {
                Trace.out((String)"ResultSet shows all Success");
            }
            return true;
        }
        Trace.out((String)"ResultSet shows at least one failure");
        return false;
    }

    private Vector<TaskSharedStorageAccess.StorageThread> verifySharedness(Vector<TaskSharedStorageAccess.StorageThread> sharedSet, Vector<TaskSharedStorageAccess.StorageThread> nonSharedSubSet) {
        Trace.out((int)2, (String)"Entry");
        Vector<TaskSharedStorageAccess.StorageThread> sharedSubset = new Vector<TaskSharedStorageAccess.StorageThread>();
        Trace.out((String)("Size of sharedSet is " + sharedSet.size()));
        if (sharedSet == null || sharedSet.size() <= 0) {
            Trace.out((String)"Shared Storage set is empty.");
            ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5100", true));
            this.m_ssResSetImpl.addResult(this.m_nodeList, 3);
            this.m_ssResSetImpl.addErrorDescription(errorDesc);
            ReportUtil.printResult(s_msgBundle.getMessage("5195", true));
            ReportUtil.sureblankln();
            return sharedSubset;
        }
        Enumeration<TaskSharedStorageAccess.StorageThread> setEnum = sharedSet.elements();
        while (setEnum.hasMoreElements()) {
            TaskSharedStorageAccess.StorageThread stThread = setEnum.nextElement();
            Vector<StorageInfo> stInfoSet = stThread.getStorageInfoVector();
            String path = null;
            if (stThread.isShared()) {
                Trace.out((String)("Size of stInfoSet = " + stInfoSet.size()));
                path = stThread.getStoragePath();
                String typeStr = stInfoSet.firstElement().getTypeStr();
                Trace.out((String)("Shared path = " + path));
                Trace.out((String)("Shared device type = " + typeStr));
                this.m_ssResSetImpl.addResult(this.m_nodeList, 1);
                sharedSubset.add(stThread);
                continue;
            }
            int vStatus = 3;
            path = stThread.getStoragePath();
            String errMsg = null;
            if (stInfoSet != null && stInfoSet.size() > 0) {
                Trace.out((String)("Path " + path + " is not shared, but available on at least one node."));
                String typeStr = stInfoSet.firstElement().getTypeStr();
                if (1 == stInfoSet.firstElement().getType() && this.m_nodeList.length == stInfoSet.size()) {
                    ArrayList<String> diskNodeList = new ArrayList<String>();
                    Trace.out((String)("DISK Path " + path + " does not have a valid signature on all nodes."));
                    for (StorageInfo dskStInfo : stInfoSet) {
                        if (diskNodeList.contains(dskStInfo.getNode())) continue;
                        diskNodeList.add(dskStInfo.getNode());
                    }
                    vStatus = 4;
                    errMsg = s_msgBundle.getMessage("7020", false, (Object[])new String[]{path}) + LSEP + ((Object)diskNodeList).toString();
                } else {
                    errMsg = s_gMsgBundle.getMessage("10487", true, (Object[])new String[]{path});
                }
            } else {
                Trace.out((String)("Path " + path + " is an invalid path."));
                errMsg = s_gMsgBundle.getMessage("5150", true, (Object[])new String[]{path});
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            this.m_ssResSetImpl.addResult(this.m_nodeList, vStatus);
            this.m_ssResSetImpl.addErrorDescription(errorDesc);
            nonSharedSubSet.add(stThread);
        }
        if (sharedSubset.size() + nonSharedSubSet.size() > 0 && ReportUtil.isVerbose()) {
            this.reportVerifySharedness(sharedSubset, nonSharedSubSet);
        }
        Trace.out((int)2, (String)"Exit");
        return sharedSubset;
    }

    public void reportVerifySharedness(Vector<TaskSharedStorageAccess.StorageThread> sharedSubset, Vector<TaskSharedStorageAccess.StorageThread> nonSharedSubset) {
        String typeStr;
        String path;
        Vector<StorageInfo> stInfoSet;
        TaskSharedStorageAccess.StorageThread stThread;
        Trace.out((int)2, (String)"Entry");
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("5101", false));
        ReportUtil.sureblankln();
        if (sharedSubset.size() > 0) {
            ReportUtil.surewriteColHeaders(s_msgBundle.getMessage("8055", false), s_msgBundle.getMessage("8056", false));
            Enumeration<TaskSharedStorageAccess.StorageThread> sharedEnum = sharedSubset.elements();
            while (sharedEnum.hasMoreElements()) {
                stThread = sharedEnum.nextElement();
                stInfoSet = stThread.getStorageInfoVector();
                path = stThread.getStoragePath();
                typeStr = stInfoSet.firstElement().getTypeStr();
                ReportUtil.surewriteRecord(path, typeStr);
            }
        }
        if (nonSharedSubset.size() > 0) {
            Enumeration<TaskSharedStorageAccess.StorageThread> nonSharedEnum = nonSharedSubset.elements();
            while (nonSharedEnum.hasMoreElements()) {
                stThread = nonSharedEnum.nextElement();
                stInfoSet = stThread.getStorageInfoVector();
                path = stThread.getStoragePath();
                if (stInfoSet != null && stInfoSet.size() > 0) {
                    Trace.out((String)("Path " + path + " is not shared, but available " + "on at least one node."));
                    typeStr = stInfoSet.firstElement().getTypeStr();
                    String notSharedMsg = s_gMsgBundle.getMessage("10487", true, (Object[])new String[]{path});
                    ReportUtil.sureprintln(notSharedMsg);
                    ReportUtil.verboseReportPrintln(notSharedMsg);
                    continue;
                }
                Trace.out((String)("Path " + path + " is an invalid path."));
                String invalidPath = s_gMsgBundle.getMessage("5150", true, (Object[])new String[]{path});
                ReportUtil.sureprintln(invalidPath);
                ReportUtil.verboseReportPrintln(invalidPath);
            }
        }
    }

    public SharedStorageResultSetImpl getSharedStorageResultSetImpl() {
        return this.m_ssResSetImpl;
    }

    public void setDeviceArray(String[] deviceArray) {
        this.m_devArr = deviceArray;
    }

    public Vector<TaskSharedStorageAccess.StorageThread> getSharedSetVector() {
        return this.m_sharedSet;
    }

    public Vector<TaskSharedStorageAccess.StorageThread> getNonSharedSetVector() {
        return this.m_nonSharedSet;
    }

    public TaskSharedStorageAccess.StorageThread[] getSharedStorageThreadArray() {
        return this.m_stThreadArr;
    }

    public Hashtable<Object, Vector<Object>> getSignaturePathMap() {
        return this.m_signaturePathMap;
    }

    public HashMap<String, Vector<StorageInfo>> getStorageInfoMap() {
        return this.m_storageInfoMap;
    }

    public String[] getDeviceArray() {
        return this.m_devArr;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13160", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13161", false);
    }
}

