/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import oracle.cluster.impl.crs.ResourceLiterals;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.ASMPresence;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.ClusterwareUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMConfigurationCollection
extends Task {
    public TaskASMConfigurationCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskASMConfigurationCollection(String[] nodeList) {
        super(nodeList);
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return VerificationUtil.isBaselineCollectionMode() || VerificationUtil.isCVUResource();
    }

    @Override
    public boolean performTask() {
        boolean retVal = true;
        Trace.out((String)"Performing ASM Configuration Collection");
        ASMPresence asmPresence = CVUHelperUtil.getASMPresence();
        CollectionElement asmPresenceCE = new CollectionElement("ASM_MODE", null, null, null, "ASM_MODE", 1);
        if (asmPresence.equals((Object)ASMPresence.LOCAL)) {
            asmPresenceCE.setValue("LOCAL");
        } else {
            asmPresenceCE.setValue("FLEX");
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        this.m_resultSet.addResult("ASM", 1);
        this.m_resultSet.addCollectionElement("ASM", asmPresenceCE);
        Trace.out((String)"Collecting ASM related CRS resource Collection");
        String node = this.m_nodeList[0];
        CollectionResultSet<List<CollectionElement>> crsResourceCollectionRS = ClusterwareUtil.collectCRSResourceAttributes(node, false);
        HashMap<String, CollectionResult<List<CollectionElement>>> t = crsResourceCollectionRS.getNodeCollectionResults();
        Set<String> e = t.keySet();
        CollectionResult<List<CollectionElement>> nodeResult = t.get(node);
        this.m_resultSet.addResult(node, nodeResult.getNodeResultStatus().getResultStatus());
        if (NodeResultStatus.SUCCESSFUL.equals((Object)nodeResult.getNodeResultStatus())) {
            try {
                List<CollectionElement> crsResourceCEList = nodeResult.getCollectedValue();
                Iterator<CollectionElement> resourceIterator = crsResourceCEList.iterator();
                while (resourceIterator.hasNext()) {
                    CollectionElement resourceCE = resourceIterator.next();
                    boolean isASMRelatedResource = false;
                    for (CollectionElement resourceAttrCE : resourceCE.getChildrens()) {
                        if (!resourceAttrCE.getName().equalsIgnoreCase(ResourceLiterals.TYPE.name())) continue;
                        Pattern asmTypePattern = Pattern.compile("ora\\.*asm[^.]*\\.type", 2);
                        isASMRelatedResource = asmTypePattern.matcher(String.valueOf(resourceAttrCE.getValue())).matches();
                        break;
                    }
                    if (isASMRelatedResource) continue;
                    resourceIterator.remove();
                }
                for (CollectionElement ce : crsResourceCEList) {
                    this.m_resultSet.addCollectionElement("ASM", ce);
                }
            }
            catch (CollectionValueUnavailableException e1) {
                this.m_resultSet.addErrorDescription(new ErrorDescription(e1.getMessage()));
                this.m_resultSet.setStatus(2);
            }
        }
        return retVal;
    }

    @Override
    public String getTaskID() {
        return "ASM_CONFIGURATION_COLLECTION";
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11210", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11211", false);
    }
}

