/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.impl.verification.FixupResultSetImpl;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.InvalidFixupNodeException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.fixup.FixupTaskListContainer;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.TaskCompletionEvent;
import oracle.ops.verification.framework.engine.task.TaskCompletionEventMulticaster;
import oracle.ops.verification.framework.engine.task.TaskCompletionListener;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUCheckSkipper;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Task
implements VerificationConstants,
TaskCompletionListener,
VerificationTask {
    protected static MessageBundle s_msgBundle;
    protected static MessageBundle s_gMsgBundle;
    protected static MessageBundle s_plgMsgBundle;
    protected static MessageBundle s_eMsgBundle;
    public static final int CONTINUE = 1;
    public static final int STOP_ON_ERROR = 2;
    public static final int ACTION_ON_ERROR = 3;
    public static final int ACTION_ON_COMPLETION = 4;
    protected VerificationTaskContext m_ctx;
    protected GlobalVerificationContext m_globalContext;
    protected String[] m_nodeList;
    protected String m_defaultTaskID = null;
    protected String m_taskName = null;
    private int m_actionOnCompletion;
    protected ResultSet m_resultSet = new ResultSet();
    private static boolean m_fixupReqd;
    private boolean m_isFixupProcessed = false;
    private boolean m_fixupRebootRequired = false;
    private FixupData m_fixupData = null;
    protected FixupResultSetImpl m_fixupResultSet = null;
    private MultiTaskHandler m_multiTaskHandler;
    private boolean m_diagnosticMode = false;
    private Vector m_tasksWaitedFor = new Vector();
    private TaskCompletionListener m_taskCompletionListener;
    private int m_dataPointsVerified = 0;
    protected List<String> m_childTaskListToExclude = new ArrayList<String>();
    private List<Task> m_childTasks = new ArrayList<Task>();
    private Integer m_childTaskLevel = 0;
    private boolean m_hasChildTasks;
    private Task m_parentTask = null;
    private StringBuffer m_taskVerificationDetails = new StringBuffer();
    private StringBuffer m_taskErrorDetails = new StringBuffer();
    private StringBuffer m_taskWarningDetails = new StringBuffer();
    private StringBuffer m_taskInformationalDetails = new StringBuffer();
    private List<String> m_errorMessageIDs = new ArrayList<String>();
    private boolean m_isTaskOver;
    private boolean m_runBefore = false;
    protected String m_elementName;
    protected String m_description;
    protected SeverityType m_taskSeverity = SeverityType.CRITICAL;
    protected boolean m_bestPractice = false;
    protected boolean m_baseline = false;
    protected String m_moreDetails;
    protected List<String> m_referenceList;
    protected NodeManager m_nodeMgr = null;
    protected String[] m_ignoreNodeList = null;
    private static ParamManager pm;
    public static boolean m_isCLImode;
    public static boolean m_isAPImode;
    public static boolean m_isFromRuncluvfy;
    protected static String m_localNode;
    Calendar m_beginTime;
    Calendar m_endTime;
    int m_defaultTimeout = 0;
    RootUserCredentials m_rootCreds = null;
    CollectionGroup m_collectionGroup = null;
    private boolean m_collectionMode = false;
    private boolean m_disabled = false;
    protected boolean m_silent;

    public Task() {
        this(null, 1);
    }

    public Task(MultiTaskHandler multiTaskHandler) {
        this(multiTaskHandler, 1);
    }

    public Task(MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        this.m_multiTaskHandler = multiTaskHandler;
        this.m_actionOnCompletion = actionOnCompletion;
        this.m_nodeMgr = this.getNodeManager();
        this.m_defaultTaskID = this.getClass().getSimpleName().toUpperCase();
        this.m_globalContext = GlobalVerificationContext.getInstance();
    }

    public Task(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public Task(VerificationTaskContext ctx) {
        this(ctx.getNodeList());
        this.m_ctx = ctx;
    }

    public Task(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public Task(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        Trace.out((String)(this.getClass().getName() + "::nodeList='" + VerificationUtil.strArr2List(nodeList) + "'"));
        this.m_ctx = new VerificationTaskContext(null);
        this.m_globalContext = GlobalVerificationContext.getInstance();
        this.m_nodeList = nodeList;
        this.m_multiTaskHandler = multiTaskHandler;
        this.m_actionOnCompletion = actionOnCompletion;
        this.m_nodeMgr = this.getNodeManager();
        this.m_defaultTaskID = this.getClass().getSimpleName().toUpperCase();
    }

    public ExecutableInfo getExecutableInfo() {
        return this.m_ctx.getExecInfo();
    }

    public void setExecutableInfo(ExecutableInfo execInfo) {
        this.m_ctx.setExecutableInfo(execInfo);
    }

    public void setBaseline(boolean baseLine) {
        this.m_baseline = baseLine;
    }

    public String[] getNodeList() {
        return this.m_nodeList;
    }

    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    public void setTaskName(String taskName) {
        this.m_taskName = taskName;
    }

    public void disable() {
        this.m_disabled = true;
    }

    public boolean isPluggable() {
        return false;
    }

    public final boolean isApplicable() throws VerificationException {
        this.init();
        return this.isTaskApplicable();
    }

    protected boolean isTaskApplicable() throws VerificationException {
        return true;
    }

    protected void init() {
    }

    public boolean isDisabled() {
        return this.m_disabled;
    }

    protected boolean performTask() {
        this.m_resultSet.addResult(this.m_nodeList, 1);
        return true;
    }

    public boolean performDiagnostics() {
        return true;
    }

    public void clean() {
        Trace.out((String)"Default 'clean()' method called.");
    }

    public boolean perform() {
        boolean resultVal;
        this.m_beginTime = Calendar.getInstance();
        ArrayList<String> loggerDataBeforeTask = new ArrayList<String>();
        this.m_childTasks = new ArrayList<Task>();
        List<String> loggerData = VerificationLogData.getVerificationLogData();
        loggerDataBeforeTask.addAll(loggerData);
        String taskName = this.getClass().getName();
        if (taskName.contains(".")) {
            taskName = taskName.substring(taskName.lastIndexOf(".") + 1);
        }
        if (taskName.equals("PluggableTask")) {
            taskName = taskName + "(" + this.getTaskID() + ")";
        }
        taskName = taskName + ":" + this.getElementName();
        taskName = taskName + "[" + this.getTaskID() + "]";
        VerificationUtil.traceAndLog(LSEP + taskName + ":TASK_START");
        if (this.skipThisTask()) {
            Trace.out((String)(taskName + " is marked for skipping. not performing this task"));
            resultVal = true;
        } else if (!this.setupNodesForBigCluster()) {
            Trace.out((String)"setupNodesForBigCluster() failed. ");
            resultVal = false;
        } else if (this.m_nodeList != null && this.m_nodeList.length == 0) {
            Trace.out((String)"0 size nodelist. The task does not have to execute on any nodes.");
            resultVal = true;
        } else {
            VerificationUtil.traceAndLog(LSEP + "m_nodeList='" + VerificationUtil.strArr2List(this.m_nodeList) + "'");
            FixupTaskListContainer.addPerformedTask(this);
            ReportUtil.reportTaskVerifying(this);
            resultVal = !this.performTask() ? (this.m_diagnosticMode ? this.performDiagnostics() : false) : true;
        }
        if (this.m_multiTaskHandler != null) {
            if (this.m_taskCompletionListener != null) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"Inside Task:perform() - sending events...");
                }
                TaskCompletionEvent completionEvent = new TaskCompletionEvent(this, 2000);
                this.m_taskCompletionListener.taskCompleted(completionEvent);
            }
            this.m_multiTaskHandler.removeFromCurrentTaskSet(this);
        }
        this.m_isTaskOver = true;
        this.processIgnoreCVUErrors();
        int taskStatus = this.m_resultSet.getStatus();
        if (taskStatus == 1) {
            StringBuilder summary = new StringBuilder(taskName + ":TASK_SUMMARY:SUCCESSFUL");
            this.m_endTime = Calendar.getInstance();
            summary.append(":Total time taken [" + VerificationUtil.getElapsedTime(this.m_beginTime, this.m_endTime) + "]");
            Trace.out((String)("Task Begin time [" + VerificationUtil.getDateAndTimeString(this.m_beginTime) + "]"));
            Trace.out((String)("Task End time [" + VerificationUtil.getDateAndTimeString(this.m_endTime) + "]"));
            VerificationUtil.traceAndLog(LSEP + summary.toString());
        } else {
            StringBuilder summary = taskStatus == 4 ? new StringBuilder(taskName + ":TASK_SUMMARY:WARNING") : new StringBuilder(taskName + ":TASK_SUMMARY:FAILED");
            summary.append(":" + this.getSeverity().name());
            summary.append(":" + ResultSet.resultsetStatusString(taskStatus));
            this.m_endTime = Calendar.getInstance();
            summary.append(":Total time taken [" + VerificationUtil.getElapsedTime(this.m_beginTime, this.m_endTime) + "]");
            Trace.out((String)("Task Begin time [" + VerificationUtil.getDateAndTimeString(this.m_beginTime) + "]"));
            Trace.out((String)("Task End time [" + VerificationUtil.getDateAndTimeString(this.m_endTime) + "]"));
            List<VerificationError> errorList = this.m_resultSet.getErrors();
            for (VerificationError err : errorList) {
                summary.append(LSEP + "          ERRORMSG(GLOBAL): " + err.getErrorMessage());
                this.addErrorMessageID(err.getErrorMessage());
            }
            if (this.m_resultSet.hasNodeResults()) {
                List<VerificationResult> nrList = null;
                try {
                    nrList = this.m_resultSet.getNodeResults();
                }
                catch (NodeResultsUnavailableException nre) {
                    summary.append(LSEP + "          APPLICATION_ERROR: NodeResultsUnavailableException thrown when hasNodeResults() returns true");
                }
                if (nrList != null) {
                    for (VerificationResult nres : nrList) {
                        errorList = nres.getErrors();
                        for (VerificationError err : errorList) {
                            summary.append(LSEP + "          ERRORMSG(" + nres.getNode() + "): " + err.getErrorMessage());
                            this.addErrorMessageID(err.getErrorMessage());
                        }
                    }
                }
            }
            VerificationUtil.traceAndLog(LSEP + summary.toString());
        }
        if (this.m_nodeList != null && this.m_nodeList.length > 0) {
            ReportUtil.reportTaskEndStatus(this);
        }
        this.clean();
        return resultVal;
    }

    public void setActionOnCompletion(int actionOnCompletion) {
        this.m_actionOnCompletion = actionOnCompletion;
    }

    public int getActionOnCompletion() {
        return this.m_actionOnCompletion;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    @Override
    public FixupResultSet getFixupResultSet() {
        return this.m_fixupResultSet;
    }

    public void updateFixupResultSet(FixupResultSetImpl fixupResultSet) {
        if (this.m_fixupResultSet == null) {
            this.m_fixupResultSet = fixupResultSet;
        } else {
            this.m_fixupResultSet.updateResultSet(fixupResultSet);
        }
    }

    public void addFixupResult(String node, FixupResult result) throws InvalidFixupNodeException {
        if (null != this.m_fixupResultSet) {
            this.m_fixupResultSet.addNodeResult(node, result);
        }
    }

    public synchronized Vector getTasksWaitedFor() {
        return this.m_tasksWaitedFor;
    }

    public synchronized boolean isEmptyTasksWaitedFor() {
        return this.m_tasksWaitedFor.isEmpty();
    }

    public synchronized void waitFor(Task task) {
        this.m_tasksWaitedFor.addElement(task);
        task.addTaskCompletionListener(this);
    }

    public synchronized void waitFor(Task[] taskArr) {
        for (int i = 0; i < taskArr.length; ++i) {
            this.m_tasksWaitedFor.addElement(taskArr[i]);
            taskArr[i].addTaskCompletionListener(this);
        }
    }

    public synchronized void removeFromTasksWaitedFor(Task task) {
        this.m_tasksWaitedFor.removeElement(task);
    }

    @Override
    public void taskCompleted(TaskCompletionEvent e) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Inside Task:taskCompleted()...");
        }
        this.removeFromTasksWaitedFor(e.getTask());
        if (this.isEmptyTasksWaitedFor() && this.m_multiTaskHandler != null) {
            this.m_multiTaskHandler.addToCurrentTaskSet(this);
        }
    }

    public synchronized void addTaskCompletionListener(TaskCompletionListener l) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Inside Task:addTaskCompletionListener()...");
        }
        this.m_taskCompletionListener = TaskCompletionEventMulticaster.add(this.m_taskCompletionListener, l);
    }

    protected void setFixup(boolean fixupReqd) {
        m_fixupReqd = fixupReqd;
    }

    protected boolean isFixupReqd() {
        return m_fixupReqd;
    }

    @Override
    public boolean isRebootRequiredForFixup() {
        return this.m_fixupRebootRequired;
    }

    protected void setRebootRequiredForFixup(boolean rebootRequired) {
        this.m_fixupRebootRequired = rebootRequired;
    }

    @Override
    public boolean isFixable() {
        return this.m_fixupData != null && this.m_fixupData.getFixableNodes().size() > 0;
    }

    public FixupData getFixupData() {
        return this.m_fixupData;
    }

    public void setFixupData(FixupData fixupDataObj) {
        if (null != fixupDataObj && fixupDataObj.getParticipatingNodes().size() > 0) {
            boolean addedToContainer = this.isFixupDataSet();
            this.m_fixupData = fixupDataObj;
            if (!addedToContainer) {
                FixupTaskListContainer.addFixupTask(this);
            }
        }
    }

    protected boolean isFixupDataSet() {
        return this.m_fixupData != null;
    }

    public String getTaskID() {
        return this.getDefaultTaskID();
    }

    public String getTaskName() {
        if (VerificationUtil.isStringGood(this.m_taskName)) {
            return this.m_taskName;
        }
        return this.getTaskID();
    }

    public final String getDefaultTaskID() {
        if (!VerificationUtil.isStringGood(this.m_defaultTaskID)) {
            this.m_defaultTaskID = this.getClass().getSimpleName().toUpperCase();
        }
        return this.m_defaultTaskID;
    }

    @Override
    public String getElementName() {
        if (this.m_elementName != null) {
            return this.m_elementName;
        }
        return this.getDefaultElementName();
    }

    public abstract String getDefaultElementName();

    @Override
    public String getDescription() {
        if (this.m_description != null) {
            return this.m_description;
        }
        return this.getDefaultDescription();
    }

    public abstract String getDefaultDescription();

    @Override
    public VerificationResultSet verify() throws SubtasksNotCompleteException, VerificationException {
        return this.verify(FixupUtility.getDefaultFixupRequirement());
    }

    @Override
    public VerificationResultSet verify(boolean fixup) throws SubtasksNotCompleteException, VerificationException {
        if (this.m_runBefore) {
            this.m_resultSet = new ResultSet();
        }
        if (this.hasSubtasks()) {
            List<Object> listOfSubtasks = new ArrayList();
            try {
                listOfSubtasks = this.getSubtasks();
            }
            catch (SubtasksUnavailableException e) {
                Trace.out((Exception)e);
            }
            for (VerificationTask verificationTask : listOfSubtasks) {
                if (((Task)verificationTask).isTaskOver()) continue;
                throw new SubtasksNotCompleteException(s_msgBundle.getMessage("7500", false));
            }
            for (VerificationTask verificationTask : listOfSubtasks) {
                this.m_resultSet.uploadResultSet(((Task)verificationTask).getResultSet(), true);
            }
        } else {
            m_fixupReqd = fixup;
            this.perform();
        }
        this.m_runBefore = true;
        this.m_resultSet.traceResultSet("=== m_resultSet before return from verify() ===");
        return this.m_resultSet;
    }

    @Override
    public boolean hasSubtasks() {
        return false;
    }

    @Override
    public boolean hasCreatedTasks() {
        return this.m_hasChildTasks;
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        return new ArrayList<VerificationTask>();
    }

    public boolean isTaskOver() {
        return this.m_isTaskOver;
    }

    public void addChildTask(Task childTask) {
        if (childTask != null) {
            this.m_childTasks.add(childTask);
            this.m_hasChildTasks = true;
            childTask.setChildTaskLevel(this.m_childTaskLevel + 1);
        }
    }

    @Override
    public List<VerificationTask> getCreatedTasks() {
        ArrayList<VerificationTask> cvTasks = new ArrayList<VerificationTask>();
        for (Task childTask : this.m_childTasks) {
            cvTasks.add(childTask);
        }
        return cvTasks;
    }

    public void setChildTasksToExclude(List<String> childTasksToExclude) {
        this.m_childTaskListToExclude.addAll(childTasksToExclude);
    }

    public List<String> getChildTasksToExclude() {
        return this.m_childTaskListToExclude;
    }

    public void setChildTaskLevel(Integer childTaskLevel) {
        this.m_childTaskLevel = childTaskLevel;
    }

    public Integer getChildTaskLevel() {
        return this.m_childTaskLevel;
    }

    public void setParentTask(Task parentTask) {
        this.m_parentTask = parentTask;
    }

    public Task getParentTask() {
        return this.m_parentTask;
    }

    public void addErrorMessageID(String errorMessage) {
        String[] errorMessageArr = errorMessage.split(LSEP);
        Pattern pattern = Pattern.compile("PR.*-.* : .*");
        Trace.out((int)1, (String)("\nerrorMessageArr: '" + VerificationUtil.strArr2List(errorMessageArr) + "'"));
        if (errorMessageArr == null || errorMessageArr.length == 0) {
            return;
        }
        for (String errMessage : errorMessageArr) {
            String trimmedErrorMessage;
            Trace.out((int)1, (String)("\nerrMessage: '" + errMessage + "'"));
            if (errMessage.length() == 0 || !errMessage.contains("PR") || (trimmedErrorMessage = errMessage.substring(errMessage.indexOf("P"))).indexOf("-") == -1 || trimmedErrorMessage.indexOf(" ") == -1) continue;
            Trace.out((int)1, (String)("Matching error message to pattern: '" + trimmedErrorMessage + "'"));
            String messageID = trimmedErrorMessage.substring(0, trimmedErrorMessage.indexOf(" "));
            messageID = messageID.trim();
            Matcher matcher = pattern.matcher(trimmedErrorMessage);
            if (!matcher.matches()) {
                Trace.out((String)("Matcher failed pattern, checking ID string: '" + messageID + "' to see if it matchs 'PRxx-' and a " + "length less than 20"));
                if (!messageID.substring(4, 5).equals("-") || !messageID.startsWith("PR") || messageID.length() >= 20) continue;
            }
            Trace.out((int)1, (String)("Adding ID string: '" + messageID + "'"));
            if (this.m_errorMessageIDs.contains(messageID)) continue;
            this.m_errorMessageIDs.add(messageID);
        }
    }

    public String getErrorMessageIDs() {
        if (this.m_errorMessageIDs.size() == 0) {
            return "";
        }
        String messageIDs = new String("");
        for (String errorMessageID : this.m_errorMessageIDs) {
            messageIDs = messageIDs.concat((messageIDs.length() > 0 ? ", " : "") + errorMessageID);
        }
        return " (" + messageIDs + ")";
    }

    public void setElementName(String elementName) {
        this.m_elementName = elementName;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setMultiTaskHandler(MultiTaskHandler multiTaskHandler) {
        this.m_multiTaskHandler = multiTaskHandler;
    }

    @Override
    public SeverityType getSeverity() {
        return this.m_taskSeverity;
    }

    public void setSeverity(SeverityType taskSeverity) {
        this.m_taskSeverity = taskSeverity;
    }

    protected boolean hasRunBefore() {
        return this.m_runBefore;
    }

    public boolean isBestPractice() {
        return this.m_bestPractice;
    }

    public boolean isBaseline() {
        return this.m_baseline;
    }

    public void setMoreDetails(String moreDetails) {
        this.m_moreDetails = moreDetails;
    }

    public String getMoreDetails() {
        return this.m_moreDetails;
    }

    public void setReferences(List<String> referenceList) {
        this.m_referenceList = referenceList;
    }

    public List<String> getReferences() {
        return this.m_referenceList;
    }

    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.ALL;
    }

    private NodeManager getNodeManager() {
        NodeManager nm = null;
        try {
            NodeManagerFactory nmFactory = NodeManagerFactory.getInstance();
            nm = nmFactory.getNodeManager();
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException occured. message: " + nmEx.getMessage()));
            Trace.out((Exception)nmEx);
            Trace.out((String)"This should not occur if upper layers have created the NodeManager");
        }
        return nm;
    }

    private boolean setupNodesForBigCluster() {
        Trace.out((String)("START: m_nodeList=" + VerificationUtil.strArr2List(this.m_nodeList)));
        if (this.m_nodeMgr == null) {
            Trace.out((String)"NodeManager is null. THIS SHOULD NOT OCCUR");
            Trace.out((String)"Returning false.");
            return false;
        }
        if (!this.m_nodeMgr.isBigCluster()) {
            return true;
        }
        NodeRoleCapability nodeType = this.getApplicableNodeRoleCapability();
        if (nodeType == NodeRoleCapability.ALL) {
            Trace.out((String)"Task will execute on all types of nodes");
            return true;
        }
        String[] appNodes = null;
        String[] newAppNodes = null;
        try {
            Trace.out((String)("trying to get nodes of type " + (Object)((Object)nodeType)));
            try {
                appNodes = this.m_nodeMgr.getNodes(this.m_nodeList, nodeType);
            }
            catch (NoSuchNodesException nsnEx) {
                Trace.out((String)("NodeSuchNodesException: \noccured while getting node of type " + (Object)((Object)nodeType) + "\nfrom nodelist: " + VerificationUtil.strArr2List(this.m_nodeList)));
            }
            try {
                if (this.m_nodeMgr.isNewNodesAvailable()) {
                    newAppNodes = this.m_nodeMgr.getNewNodes(this.m_nodeList, nodeType);
                }
            }
            catch (NoSuchNodesException nsnEx) {
                Trace.out((String)("NodeSuchNodesException: \noccured while getting node of type " + (Object)((Object)nodeType) + "\nfrom nodelist: " + VerificationUtil.strArr2List(this.m_nodeList)));
            }
        }
        catch (NodeManagerException nmEx) {
            String errMsg = nmEx.getMessage();
            Trace.out((String)("NodeManagerException occured while getting node of type " + (Object)((Object)nodeType)));
            Trace.out((String)("NodeManagerException message" + errMsg));
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        ArrayList<String> appNodeList = new ArrayList<String>();
        if (appNodes != null) {
            appNodeList.addAll(Arrays.asList(appNodes));
        }
        if (newAppNodes != null) {
            appNodeList.addAll(Arrays.asList(newAppNodes));
        }
        ArrayList<String> notAppNodes = new ArrayList<String>();
        for (String node : this.m_nodeList) {
            if (appNodeList.contains(node)) continue;
            Trace.out((String)("adding " + node + "to not applicable nodes list"));
            notAppNodes.add(node);
        }
        Trace.out((int)1, (String)("appNodes: " + VerificationUtil.strArr2List(appNodes) + "  newAppNodes: " + VerificationUtil.strArr2List(newAppNodes)));
        this.m_ignoreNodeList = notAppNodes.toArray(new String[0]);
        this.m_resultSet.addResult(this.m_ignoreNodeList, 6);
        this.m_nodeList = appNodeList.toArray(new String[appNodeList.size()]);
        if (this.m_nodeMgr.isNewNodesAvailable()) {
            return this.setupNewNodesForBigCluster();
        }
        Trace.out((String)("END: m_nodeList=" + VerificationUtil.strArr2List(this.m_nodeList)));
        return true;
    }

    protected boolean setupNewNodesForBigCluster() {
        return true;
    }

    private boolean skipThisTask() {
        CVUCheckSkipper taskSkipper = CVUCheckSkipper.getInstance();
        if (!taskSkipper.isSkipTask(this)) {
            return false;
        }
        Trace.out((String)(this.getTaskID() + " is disabled."));
        String errMsg = s_gMsgBundle.getMessage("11640", true, (Object[])new String[]{this.getElementName()});
        ReportUtil.printWarning(errMsg);
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
        this.m_resultSet.addResult(this.m_nodeList, 4);
        return true;
    }

    private void processIgnoreCVUErrors() {
        String ignoreErrors = CVUVariables.getValue(CVUVariableConstants.ORA_IGNORE_CVU_ERRORS);
        if (!Boolean.parseBoolean(ignoreErrors)) {
            return;
        }
        this.m_resultSet.turnAllErrorsToWarnings();
    }

    public void setFixupProcessed() {
        if (this.isFixable()) {
            this.m_isFixupProcessed = true;
        }
    }

    public boolean isFixupProcessed() {
        return this.m_isFixupProcessed;
    }

    public void setBestPractice(boolean bestPractice) {
        this.m_bestPractice = bestPractice;
    }

    public boolean isSilent() {
        return this.m_silent;
    }

    public void setSilent(boolean silent) {
        this.m_silent = silent;
    }

    public CollectionGroup getCollectionGroup() {
        return this.m_collectionGroup;
    }

    public void setCollectionGroup(CollectionGroup collectionGroup) {
        this.m_collectionGroup = collectionGroup;
    }

    public void setCollectionMode(boolean collectionMode) {
        this.m_collectionMode = collectionMode;
    }

    public boolean isCollectionMode() {
        return this.m_collectionMode;
    }

    public boolean isContainerTask() {
        return false;
    }

    public String getTaskVerificationDetailsContent() {
        return this.m_taskVerificationDetails.toString();
    }

    public void addTaskVerificationDetails(String detailsString) {
        this.m_taskVerificationDetails.append(detailsString);
    }

    public String getTaskInformationalDetailsContent() {
        return this.m_taskInformationalDetails.toString();
    }

    public void addTaskInformationalDetails(String informationalString) {
        this.m_taskInformationalDetails.append(informationalString);
    }

    public String getTaskErrorDetailsContent() {
        return this.m_taskErrorDetails.toString();
    }

    public void addTaskErrorDetails(String detailsString) {
        this.m_taskErrorDetails.append(detailsString);
    }

    public String getTaskWarningDetailsContent() {
        return this.m_taskWarningDetails.toString();
    }

    public void addTaskWarningDetails(String detailsString) {
        this.m_taskWarningDetails.append(detailsString);
    }

    public Task getTaskReference() {
        return this;
    }

    public int getDataPointsVerified() {
        return this.m_dataPointsVerified;
    }

    public boolean isTypeTarget() {
        return false;
    }

    static {
        block2: {
            s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
            s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
            s_plgMsgBundle = VerificationUtil.getMessageBundle("Prve");
            s_eMsgBundle = VerificationUtil.getMessageBundle("Prve");
            m_fixupReqd = FixupUtility.getDefaultFixupRequirement();
            pm = null;
            try {
                pm = ParamManager.getInstance();
            }
            catch (UninitializedParamManagerException e) {
                if (!Trace.isLevelEnabled((int)1)) break block2;
                Trace.out((Exception)e);
            }
        }
        m_isCLImode = VerificationUtil.isCLIMode();
        m_isAPImode = VerificationUtil.isAPIMode();
        m_isFromRuncluvfy = pm.isRuncluvfy();
        m_localNode = VerificationUtil.getLocalNode();
    }
}

