/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentSkipListSet;
import oracle.cluster.remote.NodeProgressListener;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.report.ReportUtil;

class ODNSDOutputMonitor
extends Thread
implements NodeProgressListener {
    private String message = null;
    private ConcurrentSkipListSet<String> listQueryReceive;
    private Process m_proc;
    private MessageBundle s_gMsgBundle;
    private int lineCount;
    private int cntReceivedQuery;

    public ODNSDOutputMonitor(MessageBundle gMsgBundle) {
        this.s_gMsgBundle = gMsgBundle;
        this.listQueryReceive = new ConcurrentSkipListSet();
        this.lineCount = 0;
        this.cntReceivedQuery = 0;
        Trace.out((String)("TraceFile: " + Trace.getTraceFile()));
    }

    public ODNSDOutputMonitor(Process proc, MessageBundle gMsgBundle) {
        this.m_proc = proc;
        this.s_gMsgBundle = gMsgBundle;
        this.listQueryReceive = new ConcurrentSkipListSet();
        this.lineCount = 0;
        this.cntReceivedQuery = 0;
        Trace.out((String)("TraceFile: " + Trace.getTraceFile()));
    }

    public int getTotalReceivedQuery() {
        return this.cntReceivedQuery;
    }

    public ConcurrentSkipListSet<String> getListReceivedQuery() {
        return this.listQueryReceive;
    }

    public void updateStatus(String msg, String node) {
    }

    public String getMessage() {
        return this.message;
    }

    public void write(String node, String line) {
        this.write(line);
    }

    @Override
    public void run() {
        try {
            InputStreamReader opReader = new InputStreamReader(this.m_proc.getInputStream());
            BufferedReader br = new BufferedReader(opReader);
            String line = null;
            Trace.out((String)"read output lines");
            Trace.out((String)("TraceFile: " + Trace.getTraceFile()));
            while ((line = br.readLine()) != null) {
                Trace.out((String)line);
                this.write(line);
            }
        }
        catch (IOException e) {
            Trace.out((String)("IOE while reading odnsd output : " + e.getMessage()));
        }
    }

    public void write(String line) {
        Trace.out((String)line);
        switch (this.lineCount) {
            case 0: {
                if (line.indexOf("HEADER") != -1) {
                    this.lineCount = 1;
                    break;
                }
                Trace.out((String)("ignored - couldn't parse " + line));
                break;
            }
            case 1: {
                if (line.indexOf("QUERY: 1") != -1) {
                    this.lineCount = 2;
                    break;
                }
                this.lineCount = 0;
                Trace.out((String)("Ignored - couldn't parse" + line));
                break;
            }
            case 2: {
                int commaIndex = line.indexOf(",");
                if (commaIndex < 2) {
                    Trace.out((String)("couldn't parse" + line));
                    this.lineCount = 0;
                    ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("5714", true, (Object[])new String[]{"odnsd", line}));
                    break;
                }
                String lookupName = line.substring(2, commaIndex).trim();
                if (lookupName != null || lookupName.length() != 0) {
                    ReportUtil.sureprintln(this.s_gMsgBundle.getMessage("5801", false, (Object[])new String[]{lookupName}));
                    ++this.cntReceivedQuery;
                    this.listQueryReceive.add(lookupName);
                } else {
                    Trace.out((String)"lookup name is empty");
                }
                this.lineCount = 0;
            }
        }
    }
}

