/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqAppCluster;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.component.BaselineComponent;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class AppClusterStage
extends Stage
implements VerificationConstants {
    private static final String APP_CLUSTER_TYPE = "application";

    @Override
    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside AppClusterStage:init()...");
    }

    AppClusterStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    @Override
    protected boolean checkSetup() {
        super.checkSetup();
        String[] validNodesPreCRSchk = this.getValidNodeList();
        if (validNodesPreCRSchk == null || validNodesPreCRSchk.length == 0) {
            return false;
        }
        if (this.m_verificationMode == 1) {
            Trace.out((String)"==== Skipping CRS home check. n/a for pre check");
            return validNodesPreCRSchk.length == this.getNodeList().length;
        }
        String[] nodesWithCRSinstall = VerificationUtil.getNodesWithCRSInstall(validNodesPreCRSchk, this.m_resultSet);
        this.setValidNodeList(nodesWithCRSinstall);
        if (nodesWithCRSinstall == null) {
            return false;
        }
        return nodesWithCRSinstall.length == this.getNodeList().length;
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        List<Task> appClusterStageTaskList = null;
        ParamPreReqAppCluster param = new ParamPreReqAppCluster();
        if (this.m_verificationMode == 1) {
            appClusterStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_APPLICATION_CLUSTER_INST, this.getValidNodeList(), (ParamPreReq)param, this);
        } else {
            String clusterType = VerificationUtil.getClusterType();
            if (!clusterType.equals(APP_CLUSTER_TYPE)) {
                throw new TaskFactoryException(s_gMsgBundle.getMessage("13202", true, (Object[])new String[]{clusterType}));
            }
            appClusterStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_APPLICATION_CLUSTER_INST, this.getValidNodeList(), (ParamPreReq)param, this);
        }
        this.addToCurrentTaskSet(appClusterStageTaskList.toArray(new Task[0]));
    }

    @Override
    public void generateReport() {
    }

    @Override
    protected void postVerify() {
        String collect = CVUVariables.getValue(CVUVariableConstants.BASELINE_COLLECT);
        if (!VerificationUtil.isStringGood(collect)) {
            return;
        }
        BaselineComponent comp = null;
        try {
            comp = new BaselineComponent(VerificationType.COMPONENT_BASELINE, this.getValidNodeList(), true);
            comp.verify();
        }
        catch (ComponentInitException e) {
            Trace.out((int)5, (String)"IGNORED Exception %s : %s", (Object[])new Object[]{((Object)((Object)e)).getClass(), e.getMessage()});
        }
    }
}

