/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.factory.data;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.sql.rowset.CachedRowSet;
import oracle.cluster.verification.pluggable.PluggableTaskUtil;
import oracle.cluster.verification.pluggable.VerificationExecutableException;
import oracle.cluster.verification.pluggable.analyzer.PluggableJavaAnalyzer;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.data.ArgType;
import oracle.ops.verification.framework.engine.factory.data.DataComparator;
import oracle.ops.verification.framework.engine.factory.data.DataType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.factory.data.ExecutableType;
import oracle.ops.verification.framework.engine.factory.data.ResultAnalyzerException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ExternalDataComparator
extends DataComparator {
    private ExecutableInfo m_comparatorExecutable = null;

    public ExternalDataComparator(ExecutableInfo compExec) {
        this.m_comparatorExecutable = compExec;
    }

    @Override
    public ResultSet analyzeResult(ResultSet vfnResult) throws ResultAnalyzerException {
        if (this.m_comparatorExecutable.getExecutableType() == ExecutableType.JAVA) {
            return this.analyzeResultUsingJavaAnalyzer(vfnResult);
        }
        return this.analyzeResultInternal(vfnResult);
    }

    private ResultSet analyzeResultUsingJavaAnalyzer(ResultSet vfnResult) throws ResultAnalyzerException {
        PluggableJavaAnalyzer analyzer = this.getPluggableAnalyzer();
        return analyzer.analyze(vfnResult);
    }

    private PluggableJavaAnalyzer getPluggableAnalyzer() throws ResultAnalyzerException {
        String className = this.m_comparatorExecutable.getExecutableName();
        String classLocation = "oracle.cluster.verification.pluggable.analyzer." + className;
        try {
            Constructor constructor = PluggableTaskUtil.getClassConstructFromPackage(className, "oracle.cluster.verification.pluggable.analyzer", null);
            Object[] params = new Object[]{};
            PluggableJavaAnalyzer analyzer = (PluggableJavaAnalyzer)constructor.newInstance(params);
            analyzer.setExecutableInfo(this.m_comparatorExecutable);
            return analyzer;
        }
        catch (InstantiationException e) {
            Trace.out((String)("error while constructing " + this.m_comparatorExecutable.getExecutableName() + " from class " + classLocation + " Error: " + e.getMessage()));
            VerificationLogData.logError("error while constructing " + this.m_comparatorExecutable.getExecutableName() + " from class " + classLocation + " Error: " + e.getMessage());
            throw new ResultAnalyzerException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            Trace.out((String)("Illegal Access while constructing object of class " + classLocation + " Error is :\n" + e.getMessage()));
            VerificationLogData.logError("Illegal Access while constructing object of class " + classLocation + " Error is :\n" + e.getMessage());
            throw new ResultAnalyzerException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            Trace.out((String)("IllegalArgumentException while constructing object of class " + classLocation + " Error is :\n" + e.getMessage()));
            VerificationLogData.logError("IllegalArgumentException while constructing object of class " + classLocation + " Error is :\n" + e.getMessage());
            throw new ResultAnalyzerException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Trace.out((String)("InvocationTargetException while constructing object of class " + classLocation + " Error is :\n" + e.getMessage()));
            VerificationLogData.logError("InvocationTargetException while constructing object of class " + classLocation + " Error is :\n" + e.getMessage());
            throw new ResultAnalyzerException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            Trace.out((String)("Constructor " + this.m_comparatorExecutable.getExecutableName() + " not found in class " + classLocation + " Error: " + e.getMessage()));
            VerificationLogData.logError("Constructor " + this.m_comparatorExecutable.getExecutableName() + " not found in class " + classLocation + " Error: " + e.getMessage());
            throw new ResultAnalyzerException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            Trace.out((String)("Class " + classLocation + " not found: " + e.getMessage()));
            VerificationLogData.logError("Class " + classLocation + " not found: " + e.getMessage());
            throw new ResultAnalyzerException(e.getMessage());
        }
        catch (ClassCastException e) {
            Trace.out((String)("ClassCastException while casting the object of class " + classLocation + " to PluggableJavaAnalyzer, Error is :\n" + e.getMessage()));
            VerificationLogData.logError("ClassCastException while constructing object of class " + classLocation + " to PluggableJavaAnalyzer, Error is :\n" + e.getMessage());
            throw new ResultAnalyzerException(e.getMessage());
        }
    }

    private ResultSet analyzeResultInternal(ResultSet vfnResult) throws ResultAnalyzerException {
        ResultSet rsltSet;
        block16: {
            Hashtable ht = vfnResult.getResultTable();
            Enumeration e = ht.keys();
            rsltSet = new ResultSet();
            boolean isGlobal = this.m_comparatorExecutable.getLocalNodeCheck();
            Trace.out((String)"Attempting to execute an external analyzer");
            String fileName = new String();
            String executableArg = new String();
            String destLoc = VerificationUtil.getCVUSubDirPath();
            String path = new String();
            if (destLoc != null) {
                ClusterCmd cmd = new ClusterCmd();
                path = destLoc + "tempdir";
                try {
                    String localNode = VerificationUtil.getLocalNode();
                    if (!cmd.createDirWithPermissionsOnNodes(new String[]{localNode}, path, "0700")) {
                        Trace.out((String)("Failed to create directory:" + path));
                        throw new ResultAnalyzerException(s_msgBundle.getMessage("0006", false, (Object[])new String[]{path}));
                    }
                }
                catch (ClusterException ce) {
                    Trace.out((String)"Unable to create directory with the given permissions.");
                    rsltSet = vfnResult;
                    String errMsg = s_msgBundle.getMessage("0006", false, (Object[])new String[]{path});
                    ErrorDescription errDesc = new ErrorDescription(errMsg, "", "");
                    rsltSet.addErrorDescription(errDesc);
                    rsltSet.setStatus(2);
                    return rsltSet;
                }
            }
            Trace.out((String)"Fetching fileList");
            String fileList = ExternalDataComparator.getFileName(path, "filelist");
            Trace.out((String)("fileList=" + fileList));
            this.writeToFile(fileList, "PATH=" + path + VerificationUtil.LSEP, false);
            Trace.out((String)("isGlobal=" + isGlobal));
            if (isGlobal) {
                String node;
                Result result;
                fileName = "DATA_GLOBAL_" + ExternalDataComparator.getProcessId() + "_" + ExternalDataComparator.getTimeStamp();
                executableArg = ExternalDataComparator.getFileName(path, fileName);
                boolean toAppend = false;
                if (e.hasMoreElements() && (result = (Result)ht.get(node = (String)e.nextElement())).getStatus() == 1) {
                    try {
                        Object collectedValue = result.getResultInfoSet().firstElement();
                        String collectedValueStr = this.getValueString(collectedValue);
                        this.writeToFile(executableArg, collectedValueStr + VerificationUtil.LSEP, toAppend);
                        if (!toAppend) {
                            toAppend = true;
                        }
                    }
                    catch (SQLException e1) {
                        throw new ResultAnalyzerException(e1.getMessage(), e1);
                    }
                    String contents = "<GLOBAL>=" + fileName + VerificationUtil.LSEP;
                    this.writeToFile(fileList, contents, true);
                }
            } else {
                while (e.hasMoreElements()) {
                    String node = (String)e.nextElement();
                    Result result = (Result)ht.get(node);
                    if (result.getStatus() != 1) continue;
                    fileName = "DATA_" + node + "_" + ExternalDataComparator.getProcessId() + "_" + ExternalDataComparator.getTimeStamp();
                    executableArg = ExternalDataComparator.getFileName(path, fileName);
                    boolean toAppend = false;
                    try {
                        Object collectedValue = result.getResultInfoSet().firstElement();
                        String collectedValueStr = this.getValueString(collectedValue);
                        this.writeToFile(executableArg, collectedValueStr + VerificationUtil.LSEP, toAppend);
                        if (!toAppend) {
                            toAppend = true;
                        }
                    }
                    catch (SQLException e1) {
                        throw new ResultAnalyzerException(e1.getMessage(), e1);
                    }
                    String contents = node + "=" + fileName + VerificationUtil.LSEP;
                    this.writeToFile(fileList, contents, true);
                }
            }
            ExecutableInfo holder = this.m_comparatorExecutable;
            ExecutableArgument eArg = new ExecutableArgument("arg0", ArgType.DEFINED, DataType.STRING, fileList);
            holder.addExecArgument(0, eArg);
            try {
                rsltSet = this.execVerificationExecutableAnalyzer(holder);
            }
            catch (ResultAnalyzerException rae) {
                rsltSet.setStatus(2);
                if (!Trace.isLevelEnabled((int)5)) break block16;
                Trace.out((String)("ResultAnalyzerException: " + rae.getMessage()));
                Trace.stackTrace((Throwable)rae);
            }
        }
        return rsltSet;
    }

    private String getValueString(Object collectedValue) throws SQLException {
        String collectedValueStr = "";
        if (collectedValue instanceof CachedRowSet) {
            CachedRowSet collectedRowSet = (CachedRowSet)collectedValue;
            int columnCount = collectedRowSet.getMetaData().getColumnCount();
            while (collectedRowSet.next()) {
                for (int i = 0; i < columnCount; ++i) {
                    if (i != 0) {
                        collectedValueStr = collectedValueStr + "\t";
                    }
                    collectedValueStr = collectedValueStr + collectedRowSet.getString(i + 1);
                }
                collectedValueStr = collectedValueStr + VerificationUtil.LSEP;
            }
        } else {
            collectedValueStr = String.valueOf(collectedValue);
        }
        return collectedValueStr;
    }

    private ResultSet execVerificationExecutableAnalyzer(ExecutableInfo info) throws ResultAnalyzerException {
        Trace.out((String)"Starting execVerificationExecutableAnalyzer...");
        ResultSet resultSet = new ResultSet();
        try {
            String localNode = VerificationUtil.getLocalNode();
            resultSet = PluggableTaskUtil.mapResultSet(PluggableTaskUtil.execExecutable(new String[]{localNode}, info));
        }
        catch (VerificationExecutableException vee) {
            throw new ResultAnalyzerException(vee.getMessage());
        }
        return resultSet;
    }

    boolean writeToFile(String fileName, String resStr, boolean append) {
        boolean ret = false;
        try {
            FileWriter fstream = new FileWriter(fileName, append);
            BufferedWriter out = new BufferedWriter(fstream);
            out.append(resStr);
            out.close();
            ret = true;
        }
        catch (IOException e) {
            Trace.out((String)e.getMessage());
        }
        return ret;
    }

    static String getProcessId() {
        long id = Thread.currentThread().getId();
        return Long.toString(id);
    }

    static String getFileName(String path, String prefix) {
        return path + VerificationUtil.FSEP + prefix;
    }

    static String getTimeStamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmmss");
        return dateFormat.format(new Date());
    }
}

