/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.io.File;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class SoftwareComponent
extends Component {
    SoftwareComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        String release = null;
        String oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
        Trace.out((String)("==== ParamManager reports Oracle Home as: " + oracleHome));
        if (oracleHome != null) {
            release = CVUVariables.getValue(CVUVariableConstants.RELEASE);
            if ("10gR1".equalsIgnoreCase(release)) {
                release = "10.1";
            } else if ("10gR2".equalsIgnoreCase(release)) {
                release = "10.2";
            } else if ("11gR1".equalsIgnoreCase(release)) {
                release = "11.1";
            } else if ("11gR2".equalsIgnoreCase(release)) {
                release = "11.2";
            }
        } else {
            String home = null;
            boolean haConfigured = VerificationUtil.isHAConfigured();
            if (haConfigured) {
                home = VerificationUtil.getHAHome();
                if (home == null) {
                    throw new ComponentInitException(s_msgBundle.getMessage("5307", false));
                }
            } else {
                home = VerificationUtil.getCRSHome();
                if (home == null) {
                    throw new ComponentInitException(s_msgBundle.getMessage("5301", false));
                }
            }
            Trace.out((String)"init: Validation for comp software");
            if (haConfigured) {
                File cfgFile;
                MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
                String cfgFilePath = null;
                try {
                    cfgFilePath = VerificationUtil.getCompSoftwareConfigXmlPath();
                }
                catch (XmlFilePathException x) {
                    throw new ComponentInitException(x.getMessage());
                }
                if (cfgFilePath != null && !(cfgFile = new File(cfgFilePath)).exists()) {
                    throw new ComponentInitException(theMB.getMessage("5740", true));
                }
            }
            String activeVersion = null;
            activeVersion = haConfigured ? VerificationUtil.getSIHAReleaseVersion() : VerificationUtil.getCRSActiveVersion();
            if (activeVersion == null) {
                release = "12.2";
            } else if (activeVersion.startsWith("12.1") || activeVersion.startsWith("12.0")) {
                release = "12.1";
            } else if (activeVersion.startsWith("11.2")) {
                release = "11.2";
            } else if (activeVersion.startsWith("11.1") || activeVersion.startsWith("11.0")) {
                release = "11.1";
            } else if (activeVersion.startsWith("10.2")) {
                release = "10.2";
            } else if (activeVersion.startsWith("10.1") || activeVersion.startsWith("10.0")) {
                release = "10.1";
            }
        }
        if (VerificationUtil.isStringGood(release)) {
            CVUVariables.setValue(CVUVariableConstants.RELEASE, release);
        }
    }

    @Override
    public boolean verify() {
        this.checkSetup();
        ErrorDescription errDesc = null;
        if (null == this.getValidNodeList()) {
            return false;
        }
        if (VerificationUtil.isCRSConfigured()) {
            if (null == VerificationUtil.getNodesWithCRSInstall(this.getValidNodeList(), this.m_resultSet)) {
                return false;
            }
        } else if (!VerificationUtil.isHAConfigured()) {
            String node = null;
            try {
                node = VerificationUtil.getLocalNodename();
            }
            catch (NodelistNotFoundException nlnfe) {
                Trace.out((String)nlnfe.getMessage());
                return false;
            }
            String msgNoCRSConfigured = s_prvgMsgBundle.getMessage("11902", true, (Object[])new String[]{node});
            ReportUtil.printError(msgNoCRSConfigured + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            errDesc = new ErrorDescription("11902", s_msgBundle);
            errDesc = new ErrorDescription(s_prvgMsgBundle.getMessage("11902", true, (Object[])new String[]{node}));
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_SOFTWARE: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "SOFTWARE";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9966", false);
    }
}

