/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageBundleList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAnonymousProxy;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.engine.task.TaskUserEquivalence;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.report.ReportUtilConstants;
import oracle.ops.verification.framework.report.xmlreport.XmlReportTool;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Component
implements VerificationConstants {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    protected static MessageBundle s_prveMsgBundle = VerificationUtil.getMessageBundle("Prve");
    protected String[] m_nodeList;
    protected String[] m_validNodeList;
    protected Vector<VerificationTask> m_currentTaskSet = new Vector();
    protected VerificationType m_verificationType;
    protected ParamManager m_paramMgr;
    protected ResultSet m_resultSet = new ResultSet();
    private Set<String> m_alreadyAddedGlobalErrors = new HashSet<String>();
    protected String m_crsctlCmdErrors = null;
    protected List<Task> m_taskReportList = new ArrayList<Task>();
    protected ReportUtilConstants.BasicClusterWareDetails m_clusterwareDetails = new ReportUtilConstants.BasicClusterWareDetails();
    private static XmlReportTool s_xmlReportTool = null;

    public void init() throws ComponentInitException {
        this.init(true);
    }

    public void init(boolean initNodelist) throws ComponentInitException {
        try {
            this.m_paramMgr = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            throw new ComponentInitException(e.getMessage());
        }
        if (initNodelist) {
            String autoNodeListStr = CVUVariables.getValue(CVUVariableConstants.AUTO_LIST);
            String hubNodeListStr = CVUVariables.getValue(CVUVariableConstants.HUB_LIST);
            String rimNodeListStr = CVUVariables.getValue(CVUVariableConstants.RIM_LIST);
            String targetHubSizeStr = CVUVariables.getValue(CVUVariableConstants.TARGET_HUB_SIZE);
            if (autoNodeListStr != null || hubNodeListStr != null || rimNodeListStr != null) {
                boolean targetHubSize = false;
                ArrayList<String> allNodeList = new ArrayList<String>();
                if (autoNodeListStr != null) {
                    allNodeList.addAll(Arrays.asList(autoNodeListStr.split(",")));
                }
                if (hubNodeListStr != null) {
                    allNodeList.addAll(Arrays.asList(hubNodeListStr.split(",")));
                }
                if (rimNodeListStr != null) {
                    allNodeList.addAll(Arrays.asList(rimNodeListStr.split(",")));
                }
                VerificationUtil.setLocalNodeFirst(allNodeList);
                this.m_nodeList = allNodeList.toArray(new String[0]);
            } else {
                try {
                    this.m_nodeList = VerificationUtil.getNodelist();
                }
                catch (NodelistNotFoundException e) {
                    throw new ComponentInitException(e.getMessage());
                }
            }
            this.initRemoteExec();
            this.initNodeManager();
            VerificationUtil.adjustTraceSize(this.m_nodeList.length);
        }
    }

    protected void initRemoteExec() throws ComponentInitException {
        try {
            VerificationUtil.startRemoteExecServer();
        }
        catch (VerificationException e) {
            throw new ComponentInitException(e.getMessage());
        }
    }

    protected NodeManager initNodeManager() throws ComponentInitException {
        if (this.m_nodeList == null) {
            Trace.out((String)"m_nodeList is not initialized");
            throw new ComponentInitException(s_msgBundle.getMessage("7508", true));
        }
        try {
            NodeManagerFactory nmf;
            String autoNodeListStr = CVUVariables.getValue(CVUVariableConstants.AUTO_LIST);
            String hubNodeListStr = CVUVariables.getValue(CVUVariableConstants.HUB_LIST);
            String rimNodeListStr = CVUVariables.getValue(CVUVariableConstants.RIM_LIST);
            String targetHubSizeStr = CVUVariables.getValue(CVUVariableConstants.TARGET_HUB_SIZE);
            if (autoNodeListStr != null || hubNodeListStr != null || rimNodeListStr != null) {
                Trace.out((String)"Creating NodeMamanger with autoNodes=%s, hubNodes=%s, rimNodes=%s, targetHubSize=%s", (Object[])new Object[]{autoNodeListStr, hubNodeListStr, rimNodeListStr, targetHubSizeStr});
                int targetHubSize = 0;
                String[] autoNodeList = null;
                String[] hubNodeList = null;
                String[] rimNodeList = null;
                if (autoNodeListStr != null) {
                    autoNodeList = autoNodeListStr.split(",");
                }
                if (hubNodeListStr != null) {
                    hubNodeList = hubNodeListStr.split(",");
                }
                if (rimNodeListStr != null) {
                    rimNodeList = rimNodeListStr.split(",");
                }
                if (targetHubSizeStr != null) {
                    targetHubSize = Integer.parseInt(targetHubSizeStr);
                } else {
                    if (autoNodeList != null) {
                        targetHubSize = autoNodeList.length;
                    }
                    if (hubNodeList != null) {
                        targetHubSize += hubNodeList.length;
                    }
                }
                NodeManagerFactory nmf2 = NodeManagerFactory.getInstance();
                return nmf2.getNodeManager(hubNodeList, rimNodeList, autoNodeList, targetHubSize);
            }
            String crsHome = null;
            String haHome = null;
            boolean crsRunning = false;
            boolean haRunning = false;
            String localNode = VerificationUtil.getLocalNode();
            ArrayList cmdOpList = new ArrayList();
            ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
            try {
                if (VerificationUtil.isCRSConfigured()) {
                    crsHome = VerificationUtil.getCRSHome();
                    Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj(true);
                    if (crsActiveVersion != null && VerificationUtil.isStringGood(crsHome)) {
                        clusterwareInfo.validateCRSRunning(crsHome, localNode, crsActiveVersion);
                        crsRunning = true;
                    }
                } else if (VerificationUtil.isHAConfigured()) {
                    haHome = VerificationUtil.getHAHome();
                    clusterwareInfo.validateHARunning(haHome, localNode);
                    haRunning = true;
                }
            }
            catch (InstallException e) {
                this.m_crsctlCmdErrors = e.getMessage();
                Trace.out((String)("CRS/HA found to be not running :" + this.m_crsctlCmdErrors));
            }
            if (crsRunning || haRunning) {
                Trace.out((String)"CRS is configured. Creating node manager without any arguments");
                nmf = NodeManagerFactory.getInstance();
                return nmf.getNodeManager();
            }
            Trace.out((String)("both CRS or HA is not running. creating nodeManager with node list " + VerificationUtil.strArr2List(this.m_nodeList)));
            nmf = NodeManagerFactory.getInstance();
            return nmf.getNodeManager(this.m_nodeList);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new ComponentInitException(nmfEx.getMessage());
        }
    }

    protected boolean validateEnvironment() {
        MessageBundle theMB = MessageBundle.getMessageBundle((MessageBundleList.FacilityList)MessageBundleList.FacilityList.Prvg);
        ErrorDescription errDesc = null;
        if (VerificationUtil.isHAConfigured()) {
            String msg = theMB.getMessage("5740", true);
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            Trace.out((String)msg);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        if (!VerificationUtil.isCRSConfigured()) {
            String msg = theMB.getMessage("1016", true, (Object[])new String[]{this.getComponentDisplayName()});
            errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            Trace.out((String)msg);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return true;
    }

    protected boolean checkSetup() {
        boolean setupResult = false;
        Trace.out((String)"Performing checkSetup for component...");
        Trace.out((int)1, (String)("m_nodeList: '" + VerificationUtil.strArr2List(this.m_nodeList, ", ") + "' getNodeList(): '" + VerificationUtil.strArr2List(this.getNodeList(), ", ") + "'"));
        if (VerificationUtil.isLocalNodeOperation()) {
            this.setValidNodeList(this.getNodeList());
            Vector<String> destLocSuccNodes = this.checkDestLoc(this.getValidNodeList());
            if (!destLocSuccNodes.isEmpty()) {
                this.setValidNodeList(destLocSuccNodes.toArray(new String[0]));
                if (destLocSuccNodes.size() == this.getNodeList().length) {
                    setupResult = true;
                } else {
                    Trace.out((String)"Dest loc check failed on some of the nodes.");
                }
            }
        } else {
            Vector<String> reachableNodes = this.checkNodeReachability(this.getNodeList());
            if (!reachableNodes.isEmpty()) {
                boolean isOperationUserEquivalence;
                Trace.out((String)("Nodes reachable are " + reachableNodes));
                this.setValidNodeList(reachableNodes.toArray(new String[0]));
                boolean bl = isOperationUserEquivalence = this.m_verificationType.equals((Object)VerificationType.COMPONENT_ADMIN_PRIVILEGES) && this.m_paramMgr.getAdminPrivOperation().equalsIgnoreCase("user_equiv");
                if (!isOperationUserEquivalence) {
                    Vector<String> nodesWithUserEquivalence = this.checkUserEquivalence(this.getValidNodeList());
                    if (!nodesWithUserEquivalence.isEmpty()) {
                        this.setValidNodeList(nodesWithUserEquivalence.toArray(new String[0]));
                        Vector<String> destLocSuccNodes = this.checkDestLoc(this.getValidNodeList());
                        if (!destLocSuccNodes.isEmpty()) {
                            this.setValidNodeList(destLocSuccNodes.toArray(new String[0]));
                            if (destLocSuccNodes.size() == this.getNodeList().length) {
                                Trace.out((String)"Setup was successfull on all the nodes");
                                setupResult = true;
                            }
                        } else {
                            Trace.out((String)"Dest loc check failed on all the nodes.");
                            setupResult = false;
                        }
                    } else {
                        Trace.out((String)"None of the nodes have user equivalence.");
                        setupResult = false;
                        this.setValidNodeList(null);
                    }
                } else {
                    Trace.out((String)"This is \"-o user_equiv\" operation. The user equivalence check will be performed later. Checking dest loc on local node now.");
                    Vector<String> destLocSuccNodes = this.checkDestLoc(new String[]{VerificationUtil.getLocalNode()});
                    setupResult = !destLocSuccNodes.isEmpty();
                }
            } else {
                Trace.out((String)"None of the nodes are reachable.");
                setupResult = false;
                this.setValidNodeList(null);
            }
        }
        Trace.out((String)("Valid list of nodes for this check is " + VerificationUtil.strArr2List(this.getValidNodeList())));
        return setupResult;
    }

    private Vector<String> checkNodeReachability(String[] nodeList) {
        Vector<String> succNodes = new Vector<String>();
        Vector failNodes = new Vector();
        TaskNodeConnectivity taskNodeReach = new TaskNodeConnectivity(nodeList);
        taskNodeReach.setTaskType(1);
        ReportUtil.setQuietModeLocal(true);
        boolean nodeReachSucc = taskNodeReach.performTask();
        ReportUtil.setQuietModeLocal(false);
        Trace.out((String)"Node Reachability checked.");
        if (!nodeReachSucc) {
            TaskAnonymousProxy taskAnonProxy = new TaskAnonymousProxy(taskNodeReach.getElementName(), nodeList, null, taskNodeReach.getResultSet());
            taskAnonProxy.perform();
            taskNodeReach.getResultSet().getSuccNodes(succNodes, failNodes);
            Trace.out((String)"Node Reachability had some failures, add results to task list so they will be output to user.");
            this.m_taskReportList.add(taskNodeReach);
            this.m_resultSet.uploadResultSet(taskNodeReach.getResultSet());
            if (succNodes.isEmpty()) {
                String stopMessage = s_msgBundle.getMessage("4095", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                ReportUtil.printError(stopMessage);
                ReportUtil.reportPrint(stopMessage);
                return succNodes;
            }
            String limitedVerMsg = s_msgBundle.getMessage("0008", false);
            String notReachableMsg = s_msgBundle.getMessage("4096", true);
            ReportUtil.sureprintln(VerificationConstants.LSEP + ReportUtil.WARNING + VerificationConstants.LSEP);
            ReportUtil.processAlert(notReachableMsg + " " + VerificationUtil.strCollection2String(failNodes, ", "));
            ReportUtil.processAlert(limitedVerMsg + " " + VerificationUtil.strCollection2String(succNodes, ", ") + LSEP);
        } else {
            succNodes.addAll(Arrays.asList(nodeList));
        }
        return succNodes;
    }

    private Vector<String> checkDestLoc(String[] nodeList) {
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        ResultSet destlocRS = new ResultSet();
        VerificationUtil.checkDestLoc(nodeList, destlocRS, succNodes, failNodes, true);
        if (!failNodes.isEmpty()) {
            String taskNameStr = "'" + VerificationUtil.getDestLoc() + "'";
            TaskAnonymousProxy anonymousTask = new TaskAnonymousProxy(taskNameStr, failNodes.toArray(new String[failNodes.size()]), null, destlocRS);
            anonymousTask.perform();
            this.m_taskReportList.add(anonymousTask);
        }
        this.m_resultSet.uploadResultSet(destlocRS);
        return succNodes;
    }

    private Vector<String> checkUserEquivalence(String[] nodeList) {
        Vector<String> succNodes = new Vector<String>();
        Vector failNodes = new Vector();
        TaskUserEquivalence taskUserEquiv = new TaskUserEquivalence(nodeList);
        ReportUtil.setQuietModeLocal(true);
        boolean userEquivSucc = taskUserEquiv.performTask();
        ReportUtil.setQuietModeLocal(false);
        Trace.out((String)"Performed User Equivalence check");
        if (!userEquivSucc) {
            TaskAnonymousProxy taskAnonProxy = new TaskAnonymousProxy(taskUserEquiv.getElementName(), nodeList, null, taskUserEquiv.getResultSet());
            taskAnonProxy.perform();
            taskUserEquiv.getResultSet().getSuccNodes(succNodes, failNodes);
            Trace.out((String)"User Equivalence had some failures, add results to task list so they will be output to user.");
            this.m_taskReportList.add(taskUserEquiv);
            this.m_resultSet.uploadResultSet(taskUserEquiv.getResultSet());
            if (succNodes.isEmpty()) {
                String stopMessage = s_msgBundle.getMessage("4008", false) + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
                ReportUtil.printError(stopMessage);
                ReportUtil.reportPrint(stopMessage);
                return succNodes;
            }
            String noEquivMsg = s_msgBundle.getMessage("4009", true);
            String limitedVerMsg = s_msgBundle.getMessage("0008", false);
            ReportUtil.printWarning(noEquivMsg);
            ReportUtil.sureprintNodelist(failNodes);
            ReportUtil.sureprintln(limitedVerMsg);
            ReportUtil.sureprintNodelist(succNodes);
            ReportUtil.reportFormatPrintln(noEquivMsg + VerificationUtil.strCollection2String(failNodes, ", "));
            ReportUtil.reportFormatPrintln(limitedVerMsg + VerificationUtil.strCollection2String(succNodes, ", ") + LSEP);
        } else {
            succNodes.addAll(Arrays.asList(nodeList));
        }
        return succNodes;
    }

    protected String[] getNodeList() {
        return this.m_nodeList;
    }

    protected void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    protected String[] getValidNodeList() {
        return this.m_validNodeList;
    }

    protected void setValidNodeList(String[] validNodeList) {
        this.m_validNodeList = validNodeList;
    }

    public ResultSet getResultSet() {
        if (VerificationLogData.hasGlobalErrors() && !this.getNewGlobalErrorsToAdd().isEmpty()) {
            Trace.out((String)"There are Global errors to be reported for this Component. Updating resultset.....");
            this.m_resultSet.setStatus(2);
            for (ErrorDescription errorDesc : this.getNewGlobalErrorsToAdd()) {
                this.m_resultSet.addErrorDescription(errorDesc);
            }
        }
        if (!VerificationLogData.getFailureNodes().isEmpty()) {
            Trace.out((String)("Updating resultset with failure nodes " + VerificationLogData.getFailureNodes()));
            for (String failedNodes : VerificationLogData.getFailureNodes()) {
                this.m_resultSet.addResult(failedNodes, 2);
            }
        }
        return this.m_resultSet;
    }

    private List<ErrorDescription> getNewGlobalErrorsToAdd() {
        ArrayList<ErrorDescription> newErrorList = new ArrayList<ErrorDescription>();
        for (ErrorDescription errDesc : VerificationLogData.getGlobalErrors()) {
            if (this.m_alreadyAddedGlobalErrors.contains(errDesc.getErrorMessage())) continue;
            newErrorList.add(errDesc);
            this.m_alreadyAddedGlobalErrors.add(errDesc.getErrorMessage());
        }
        return newErrorList;
    }

    public abstract boolean verify();

    public final VerificationType getVerificationType() {
        return this.m_verificationType;
    }

    protected final boolean verifyComponent() {
        try {
            this.setTaskList();
            for (VerificationTask t : this.m_currentTaskSet) {
                this.m_taskReportList.add((Task)t);
            }
        }
        catch (ComponentInitException e1) {
            Trace.out((String)("Caught ComponentInitException Error is : " + e1.getMessage()));
            Trace.out((Exception)((Object)e1));
            this.m_resultSet.addResult(this.m_validNodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_validNodeList, new ErrorDescription(e1.getMessage()));
            return false;
        }
        Trace.out((String)("m_currentTaskSet.size=" + this.m_currentTaskSet.size()));
        this.performTaskList(this.m_currentTaskSet);
        Trace.out((String)"Component.verify(): setting status and exiting...");
        return this.m_resultSet.getStatus() == 1 || this.m_resultSet.getStatus() == 4;
    }

    private boolean performTaskList(Collection<VerificationTask> taskSet) {
        boolean result = true;
        for (VerificationTask vtask : taskSet) {
            Task task = (Task)vtask;
            if (task.hasSubtasks()) {
                try {
                    result = this.performTaskList(task.getSubtasks());
                }
                catch (SubtasksUnavailableException e) {
                    Trace.out((Exception)e);
                    this.m_resultSet.addResult(this.m_validNodeList, 2);
                    this.m_resultSet.addErrorDescription(this.m_validNodeList, new ErrorDescription(e.getMessage()));
                    ReportUtil.printError(e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                    return false;
                }
            }
            this.m_resultSet.traceResultSet("Before performing task:" + task.getClass().getName());
            try {
                result = task.perform();
            }
            catch (Exception ex) {
                Trace.out((String)("Fatal error occured while executing the task " + task.getClass()));
                Trace.out((String)("Task Element" + task.getDefaultElementName()));
                Trace.out((String)("Exception :" + ex.getMessage()));
                Trace.out((Exception)ex);
                result = false;
            }
            Trace.out((String)("Add result data after performing task:" + task.getClass().getName()));
            this.m_resultSet.uploadResultSet(task.getResultSet());
            switch (task.getActionOnCompletion()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (result) break;
                    return false;
                }
                case 3: {
                    if (result || this.actionOnTaskError(task)) break;
                    return false;
                }
                case 4: {
                    if (this.actionOnTaskCompletion(task)) break;
                    return false;
                }
            }
        }
        return result;
    }

    public void generateResults() {
        Object errorMsg = null;
        String compName = this.m_paramMgr.getCompID();
        Trace.out((String)("Component name in Component is:" + compName));
        String compMsg = ReportUtil.getCompMsg(compName);
        Trace.out((String)("Component ID in ReportUtil is:" + compMsg));
        if (VerificationUtil.isStringGood(compMsg)) {
            this.m_clusterwareDetails.setCVUOperation(compMsg);
        } else {
            this.m_clusterwareDetails.setCVUOperation(this.getComponentDisplayName());
        }
        this.m_clusterwareDetails.setCVUHome(VerificationUtil.getCVHome());
        this.m_clusterwareDetails.setCrsUserName(VerificationUtil.getDefaultOracleUser());
        this.m_clusterwareDetails.setnodeListStr(VerificationUtil.strArr2List(this.m_validNodeList));
        if (!ReportUtil.getOldFormat()) {
            ReportUtil.reportOperationalSummary(this.m_clusterwareDetails, this.m_taskReportList);
        }
    }

    public synchronized Vector<VerificationTask> getCurrentTaskSet() {
        return this.m_currentTaskSet;
    }

    protected synchronized void addToCurrentTaskSet(Task task) {
        this.m_currentTaskSet.addElement(task);
    }

    protected synchronized void addToCurrentTaskSet(Task[] taskArr) {
        if (taskArr != null && taskArr.length > 0) {
            this.addToCurrentTaskSet(Arrays.asList(taskArr));
        }
    }

    protected synchronized void addToCurrentTaskSet(List<Task> taskList) {
        this.m_currentTaskSet.addAll(taskList);
    }

    private synchronized void setTaskList() throws ComponentInitException {
        if (this.m_currentTaskSet.isEmpty()) {
            try {
                List<Task> taskList = TaskFactory.getInstance().getTaskList(this.m_verificationType, this.m_validNodeList);
                this.addToCurrentTaskSet(taskList);
            }
            catch (PreReqNotSupportedException e) {
                throw new ComponentInitException(e.getMessage());
            }
            catch (TaskFactoryException e) {
                throw new ComponentInitException(e.getMessage());
            }
        }
    }

    Component(VerificationType verificationType) throws ComponentInitException {
        this.m_verificationType = verificationType;
    }

    public abstract String getComponentName();

    public abstract String getComponentDisplayName();

    public boolean actionOnTaskError(Task task) {
        Trace.out((String)"Inside component:actionOnTaskError()...");
        return true;
    }

    public boolean actionOnTaskCompletion(Task task) {
        Trace.out((String)"Inside component:actionOnTaskCompletion()...");
        return true;
    }
}

