/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import java.util.ArrayList;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.EntityStatus;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.util.VerificationUtil;

public class Entity<T> {
    private EntityStatus m_status = EntityStatus.NOT_APPLICABLE;
    private T m_value = null;
    private List<ErrorDescription> m_errorList = new ArrayList<ErrorDescription>();

    public Entity() {
    }

    public Entity(EntityStatus status) {
        this.m_status = status;
    }

    public Entity(T value) {
        this.m_value = value;
        this.m_status = EntityStatus.VALID;
        Trace.out((String)("Value=" + this.m_value));
    }

    public void setStatus(EntityStatus status) {
        this.m_status = status;
    }

    public void addErrDesc(ErrorDescription errorDesc) {
        this.m_errorList.add(errorDesc);
    }

    public void addErrDesc(List<ErrorDescription> errorDescList) {
        this.m_errorList.addAll(errorDescList);
    }

    public void setValue(T value) {
        this.m_value = value;
    }

    public T getValue() {
        return this.m_value;
    }

    public List<ErrorDescription> getErrors() {
        return this.m_errorList;
    }

    public EntityStatus getStatus() {
        return this.m_status;
    }

    public String toString() {
        if (this.m_status == EntityStatus.VALID) {
            return this.m_value.toString();
        }
        return this.m_status.name() + ": " + VerificationUtil.errDescCol2errMsgStr(this.m_errorList);
    }
}

