/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.sysman.ois.oisc.oiscx.OiscxFilesListBuilder;

public class ComponentSoftwareDistribution
implements VerificationConstants {
    private String m_name;
    private String m_mapFileName;
    private String m_mapFileDirectory;
    private List<FileInfo> m_files;
    private List<FileInfo> m_acls;

    protected ComponentSoftwareDistribution(String name) {
        this.m_name = name;
        this.m_files = new ArrayList<FileInfo>();
        this.m_acls = new ArrayList<FileInfo>();
        this.m_mapFileDirectory = "";
        String[] ancestors = this.m_name.split("\\.");
        for (int index = 1; index < ancestors.length; ++index) {
            this.m_mapFileDirectory = this.m_mapFileDirectory + ancestors[index] + VerificationUtil.FSEP;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getMapFileName() {
        return this.m_mapFileName;
    }

    public void setMapFileName(String mapFileName) {
        this.m_mapFileName = mapFileName;
    }

    public String getMapFileDirectory() {
        return this.m_mapFileDirectory;
    }

    public void addFile(FileInfo file) {
        this.m_files.add(file);
    }

    public void addAcl(FileInfo acl) {
        this.m_acls.add(acl);
    }

    public List<FileInfo> getFiles() {
        return this.m_files;
    }

    public List<FileInfo> getAclFiles() {
        return this.m_acls;
    }

    private OiscxFilesListBuilder.OiscxInclude findFile(FileInfo fileToSearch, ArrayList files) {
        String tmpFileToSearchName = null;
        String tmpFileName = null;
        String[] tokenFileList = null;
        String[] tokenFileToSearch = null;
        OiscxFilesListBuilder.OiscxInclude oFile = null;
        for (Object obj : files) {
            oFile = (OiscxFilesListBuilder.OiscxInclude)obj;
            tmpFileName = oFile.getSourceFileName();
            tmpFileName = tmpFileName.replace("\\", "/");
            tokenFileList = tmpFileName.split("/");
            tmpFileToSearchName = fileToSearch.getFileName();
            tokenFileToSearch = (tmpFileToSearchName = tmpFileToSearchName.replace("\\", "/")).split("/");
            if (!tokenFileList[tokenFileList.length - 1].equals(tokenFileToSearch[tokenFileToSearch.length - 1])) continue;
            return oFile;
        }
        return null;
    }

    public void processACLFiles(ArrayList files) {
        String permissions = null;
        String pathFile = null;
        FileInfo filePerm = null;
        OiscxFilesListBuilder.OiscxInclude fileToSetPerm = null;
        String line = null;
        for (FileInfo aclFile : this.m_acls) {
            try {
                BufferedReader filesReader = new BufferedReader(new FileReader(aclFile.getFileName()));
                while ((line = filesReader.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    String[] permissionsFile = line.split("\\s+");
                    permissions = permissionsFile[0];
                    pathFile = permissionsFile[1];
                    filePerm = new FileInfo();
                    filePerm.setFileName(pathFile);
                    fileToSetPerm = this.findFile(filePerm, files);
                    if (fileToSetPerm == null) continue;
                    Trace.out((String)("TST File[" + fileToSetPerm.getSourceFileName() + "] perm[" + fileToSetPerm.getPerms() + "] newperm[" + permissions + "]"));
                    fileToSetPerm.setPerms(permissions);
                }
            }
            catch (IOException ioe) {
                Trace.out((String)("The file " + aclFile.getFileName() + " cannot be processed. " + ioe.getMessage()));
            }
        }
    }

    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append("component name[" + this.m_name + "]\n");
        for (FileInfo file : this.m_files) {
            string.append("  file name[" + file.getFileName() + "]\n");
        }
        return string.toString();
    }
}

