/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.RunGenericRootCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class VerificationCommand
extends RemoteExecCommand
implements VerificationConstants {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    protected Result m_result;
    protected Object m_key;
    private String m_output;
    private String m_exectaskOutput = "";
    private String m_cmdExecuted;
    private int m_vfyCode;
    private static String s_subDir = VerificationUtil.getCVUSubDir();
    private String m_error;
    private String m_executionLogDetails;
    private LinkedHashMap<String, List<String>> m_executionErrorsMap;
    private String m_exceptionError = null;
    private RootUserCredentials m_rootCreds = null;
    private int m_timeout = 0;
    private String m_command = null;
    protected String[] m_nodeArr = null;
    protected ResultSet m_rootResultSet = null;
    private static String PRVF_FACILITY = "PRVF";
    private static String PRVG_FACILITY = "PRVG";

    public VerificationCommand(String node) {
        super("", null, null, node, VerificationUtil.isLocalNodeOperation(), null, "", "");
        super.setSubDirAndGroup(s_subDir, null);
        this.checkAndSetLocalExecution(node);
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String node, String[] args, String[] env) {
        super(VerificationUtil.getDestLoc() + s_subDir + File.separator + VerificationUtil.getCmd4RemExec(), args, env, node, VerificationUtil.isLocalNodeOperation(), (String[])null, (String[])null, VerificationUtil.getDestLoc());
        super.setSubDirAndGroup(s_subDir, null);
        this.checkAndSetLocalExecution(node);
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String node, String[] args, String[] env, NativeResult nativeResult) {
        super(VerificationUtil.getDestLoc() + s_subDir + File.separator + VerificationUtil.getCmd4RemExec(), args, env, node, (String[])null, (String[])null, VerificationUtil.getDestLoc(), nativeResult);
        super.setSubDirAndGroup(s_subDir, null);
        this.checkAndSetLocalExecution(node);
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String node, String[] args, String[] env, Result result) {
        super(VerificationUtil.getDestLoc() + s_subDir + File.separator + VerificationUtil.getCmd4RemExec(), args, env, node, VerificationUtil.isLocalNodeOperation(), (String[])null, (String[])null, VerificationUtil.getDestLoc());
        super.setSubDirAndGroup(s_subDir, null);
        this.checkAndSetLocalExecution(node);
        this.m_key = node;
        this.m_result = result != null ? result : new Result(node);
    }

    public VerificationCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc) {
        this(cmd, args, env, node, cmdFiles, null, srcLoc, destLoc);
    }

    public VerificationCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String[] remoteExecFiles, String srcLoc, String destLoc) {
        super(cmd, args, env, node, VerificationUtil.isLocalNodeOperation(), cmdFiles, remoteExecFiles, srcLoc, destLoc);
        super.setSubDirAndGroup(s_subDir, null);
        this.checkAndSetLocalExecution(node);
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String[] nodeArr, String command, RootUserCredentials rootCreds, int timeout, ResultSet resultSet) throws RootAutomationNotConfiguredException {
        super("", null, null, nodeArr[0], false, null, "", "");
        this.m_nodeArr = nodeArr;
        this.m_rootCreds = rootCreds;
        this.m_timeout = timeout;
        this.m_command = command;
        this.m_rootResultSet = resultSet;
    }

    private void checkAndSetLocalExecution(String node) {
        if (node != null) {
            if (node.equals("localnode") || VerificationUtil.isLocalNode(node)) {
                Trace.out((String)("Setting local execution to TRUE for this command on node (" + node + ")"));
                super.setLocalExecution(true);
            } else {
                Trace.out((String)("Setting local execution to FALSE for this command on node (" + node + ")"));
                super.setLocalExecution(false);
            }
        }
    }

    public String getErrorString() {
        return super.getErrorString();
    }

    public boolean execute() {
        String command;
        boolean commandSucc = true;
        boolean execSucc = true;
        String fmtdResult = "";
        String vfyCodeStr = null;
        StringBuffer buf = new StringBuffer();
        Trace.out((String)":: Inside execute() [Thread:");
        this.m_result.addTraceInfo("::Inside execute() ");
        commandSucc = super.execute();
        if (commandSucc) {
            String[] resultStrings = this.commandResult.getResultString();
            if (resultStrings == null || resultStrings.length == 0) {
                commandSucc = false;
            } else {
                this.m_exectaskOutput = fmtdResult = VerificationUtil.strArr2List(resultStrings, System.getProperty("line.separator"));
                this.m_result.setExectaskOutput(this.m_exectaskOutput);
                this.m_executionErrorsMap = this.fetchExecutionErrorDetails();
                this.m_executionLogDetails = this.fetchExecutionLogDetails();
                command = this.getExecCommand();
                if (command != null) {
                    buf.append("Command: '" + command + "'");
                }
                if (fmtdResult != null) {
                    buf.append(VerificationConstants.LSEP + "Output: '" + fmtdResult + "'");
                }
                VerificationLogData.logFine(buf.toString());
                this.m_output = VerificationUtil.fetchVerificationValue(fmtdResult);
                Trace.out((int)1, (String)("Formatted exectask output is:\n " + fmtdResult));
                this.m_error = VerificationUtil.fetchError(fmtdResult);
                vfyCodeStr = VerificationUtil.fetchVerificationResult(fmtdResult);
                if (vfyCodeStr == null) {
                    this.m_vfyCode = 1;
                    Trace.out((String)"VRES value was NULL, VfyCode is set to 1. ");
                } else {
                    this.m_vfyCode = Integer.parseInt(vfyCodeStr);
                    Trace.out((String)("VfyCode is: " + this.m_vfyCode));
                }
                this.m_cmdExecuted = VerificationUtil.fetchCommandValue(fmtdResult);
            }
        }
        if (commandSucc && VerificationUtil.fetchExecResult(fmtdResult)) {
            execSucc = true;
            this.m_result.setStatus(1);
        } else {
            execSucc = false;
            if (VerificationUtil.isStringGood(this.commandResult.getErrorString())) {
                Trace.out((String)("commandResult.getErrorString()=" + this.commandResult.getErrorString()));
                VerificationLogData.logError(this.commandResult.getErrorString());
                this.m_result.addErrorInfo(this.commandResult.getErrorString());
            }
            String commandOut = VerificationUtil.fetchVerificationValue(fmtdResult);
            command = this.getExecCommand();
            if (command != null) {
                buf.append("Command: '" + command + "'");
            }
            if (commandOut != null) {
                buf.append(VerificationConstants.LSEP + "Output: '" + commandOut + "'");
            } else {
                buf.append(VerificationConstants.LSEP + "Output: is EMPTY");
            }
            buf.append(VerificationConstants.LSEP + "Errors: '" + this.getErrorString() + "'");
            VerificationLogData.logError(buf.toString());
            if (commandOut == null) {
                commandOut = this.getErrorString();
            }
            this.m_result.setStatus(2);
            if (command != null && commandOut != null) {
                String errMsg = s_msgBundle.getMessage("7508", false) + VerificationConstants.LSEP + s_msgBundle.getMessage("0050", false, (Object[])new String[]{command, commandOut});
                Trace.out((String)errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_result.addErrorDescription(errDesc);
            }
        }
        return execSucc;
    }

    public boolean runCmdAsRoot() throws RootAutomationNotConfiguredException {
        boolean status = true;
        Trace.out((String)("running " + this.m_command + " as root"));
        RunGenericRootCommand runRootCommand = new RunGenericRootCommand(this.m_nodeArr, this.m_command, this.m_env, this.m_args, this.m_rootCreds, this.m_timeout);
        runRootCommand.execute();
        this.m_rootResultSet.uploadResultSet(runRootCommand.getResultSet());
        if (this.m_rootResultSet.getStatus() != 1) {
            StringBuilder sb = new StringBuilder();
            Trace.out((String)"root command execution failed");
            for (int i = 0; i < this.m_nodeArr.length; ++i) {
                List<VerificationError> errList = this.m_rootResultSet.getResult(this.m_nodeArr[i]).getErrors();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
            }
            ErrorDescription errDesc = new ErrorDescription(sb.toString());
            this.m_rootResultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(sb.toString());
            return false;
        }
        return status;
    }

    public Result getResult() {
        return this.m_result;
    }

    public String getNodeName() {
        return this.m_node;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public Object getKey() {
        return this.m_key;
    }

    public String getOutput() {
        return this.m_output;
    }

    public void setOutput(String newOutput) {
        this.m_output = newOutput;
    }

    public String getError() {
        return this.m_error;
    }

    public void setExceptionError(String exceptionError) {
        this.m_exceptionError = exceptionError;
    }

    public String getExceptionError() {
        return this.m_exceptionError;
    }

    public int getVfyCode() {
        return this.m_vfyCode;
    }

    public void setVfyCode(int new_vfyCode) {
        this.m_vfyCode = new_vfyCode;
    }

    public String getExecCommand() {
        return this.m_cmdExecuted;
    }

    public String getExectaskOutput() {
        return this.m_exectaskOutput;
    }

    public String getCommandExecuted() {
        return this.m_cmd + " " + VerificationUtil.strArr2String(this.m_args);
    }

    public static String fetchTextByTags(String sfmtd, String tag) {
        return VerificationCommand.fetchTextByTags(sfmtd, "<" + tag + ">", "</" + tag + ">");
    }

    public static String[] fetchTextByTagsRepeat(String sfmtd, String tag) {
        return VerificationCommand.fetchTextByTagsRepeat(sfmtd, "<" + tag + ">", "</" + tag + ">");
    }

    public static String fetchTextByTags(String sfmtd, String start_tag, String end_tag) {
        return VerificationCommand.fetchTextByTags(sfmtd, null, start_tag, end_tag);
    }

    public static String[] fetchTextByTagsRepeat(String sfmtd, String start_tag, String end_tag) {
        Vector<String> data = new Vector<String>();
        String tmpStr = null;
        if (VerificationUtil.isStringGood(sfmtd)) {
            sfmtd = sfmtd.trim();
            while (sfmtd.length() > 0) {
                tmpStr = VerificationCommand.fetchTextByTags(sfmtd, start_tag, end_tag);
                Trace.out((int)1, (String)("tmpStr=" + tmpStr));
                if (tmpStr == null) break;
                Trace.out((int)1, (String)("Adding to data:" + tmpStr));
                data.add(tmpStr);
                if (sfmtd.indexOf(end_tag) + end_tag.length() >= sfmtd.length()) break;
                sfmtd = sfmtd.substring(sfmtd.indexOf(end_tag) + end_tag.length());
                Trace.out((int)1, (String)("sfmtd=" + sfmtd));
                sfmtd = sfmtd.trim();
            }
        }
        return data.toArray(new String[0]);
    }

    public static String fetchTextByTags(String sfmtd, String entity, String start_tag, String end_tag) {
        if (null == sfmtd || sfmtd.length() == 0) {
            return null;
        }
        String fmtdstr = null == entity || entity.trim().length() == 0 ? sfmtd : sfmtd;
        int begin = fmtdstr.indexOf(start_tag);
        if (begin == -1) {
            return null;
        }
        begin += start_tag.length();
        int end = fmtdstr.indexOf(end_tag);
        if (end == -1) {
            return null;
        }
        String data = fmtdstr.substring(begin, end);
        Trace.out((int)1, (String)("\nTags " + start_tag + " and " + end_tag + " contains:" + data + "\n"));
        return data;
    }

    public LinkedHashMap<String, List<String>> fetchExecutionErrorDetails() {
        String[] errDescList;
        if (this.m_executionErrorsMap != null) {
            return this.m_executionErrorsMap;
        }
        String node = this.m_node;
        String exectaskOutput = this.m_exectaskOutput;
        Trace.out((int)1, (String)("exectaskOutput =" + exectaskOutput));
        LinkedHashMap<String, List<String>> resMap = new LinkedHashMap<String, List<String>>();
        if (!exectaskOutput.contains("ERR_DESC") && !exectaskOutput.contains("INFO_LOG")) {
            String errStr = VerificationUtil.fetchExecutionDetailsMessage(node, exectaskOutput);
            ArrayList<String> outputList = new ArrayList<String>();
            outputList.add(errStr);
            resMap.put("GLOBAL", outputList);
            return resMap;
        }
        for (String errdesc : errDescList = VerificationCommand.fetchTextByTagsRepeat(exectaskOutput, "ERR_DESC")) {
            String entity = VerificationCommand.fetchTextByTags(errdesc, "ENTITY");
            String entityEnd = "</ENTITY>";
            String errdescSubStr = errdesc.substring(errdesc.indexOf(entityEnd) + entityEnd.length());
            int offsetEndTag = 0;
            ArrayList<String> outputList = new ArrayList<String>();
            while (VerificationUtil.isStringGood(errdescSubStr)) {
                String cmdDetails;
                if (errdescSubStr.startsWith("<ERR_CMD>")) {
                    cmdDetails = VerificationCommand.fetchTextByTags(errdescSubStr, "ERR_CMD");
                    outputList.add(this.fetchCommandMessage(node, cmdDetails));
                    String endCmdTag = "</ERR_CMD>";
                    offsetEndTag = errdescSubStr.indexOf(endCmdTag) + endCmdTag.length();
                } else if (errdescSubStr.startsWith("<ERR_API>")) {
                    String apiDetails = VerificationCommand.fetchTextByTags(errdescSubStr, "ERR_API");
                    outputList.add(this.fetchAPIMessage(node, apiDetails));
                    String endAPITag = "</ERR_API>";
                    offsetEndTag = errdescSubStr.indexOf(endAPITag) + endAPITag.length();
                } else if (errdescSubStr.startsWith("<ERR_FILE>")) {
                    String errFileDetails = VerificationCommand.fetchTextByTags(errdescSubStr, "ERR_FILE");
                    outputList.add(this.fetchErrorFileMessage(node, errFileDetails));
                    String endFileTag = "</ERR_FILE>";
                    offsetEndTag = errdescSubStr.indexOf(endFileTag) + endFileTag.length();
                } else if (errdescSubStr.startsWith("<ERR_SLOS>")) {
                    cmdDetails = VerificationCommand.fetchTextByTags(errdescSubStr, "ERR_SLOS");
                    outputList.add(this.fetchSlosMessage(node, cmdDetails));
                    String endSlosTag = "</ERR_SLOS>";
                    offsetEndTag = errdescSubStr.indexOf(endSlosTag) + endSlosTag.length();
                }
                errdescSubStr = errdescSubStr.substring(offsetEndTag);
            }
            resMap.put(entity, outputList);
        }
        return resMap;
    }

    private String fetchCommandMessage(String node, String exectaskCmdStr) {
        Trace.out((int)1, (String)("exectaskCmdStr =" + exectaskCmdStr + "\n"));
        StringBuilder completeMsg = new StringBuilder();
        String cmdStr = VerificationCommand.fetchTextByTags(exectaskCmdStr, "CMD");
        String outputStr = VerificationCommand.fetchTextByTags(exectaskCmdStr, "OUT");
        String exitValStr = VerificationCommand.fetchTextByTags(exectaskCmdStr, "STAT");
        String errLocation = VerificationCommand.fetchTextByTags(exectaskCmdStr, "ERR_LOC");
        Trace.out((String)(" cmdStr= " + cmdStr + " outputStr= " + outputStr + "exitValStr=" + exitValStr + "errLocation=" + errLocation));
        if (!VerificationUtil.isStringGood(cmdStr)) {
            Trace.out((String)"APPLICATION ERROR (IGNORED):: Empty CMD value has been encountered");
        }
        String msg = VerificationUtil.isStringGood(outputStr) && !outputStr.equals("NULL") ? s_gMsgBundle.getMessage("2043", true, (Object[])new String[]{cmdStr, node}) + LSEP + outputStr : s_gMsgBundle.getMessage("2044", true, (Object[])new String[]{cmdStr, node});
        if (completeMsg.length() != 0) {
            completeMsg.append(LSEP + msg);
        } else {
            completeMsg.append(msg);
        }
        return completeMsg.toString();
    }

    private String fetchAPIMessage(String node, String exetaskApiStr) {
        StringBuilder completeMsg = new StringBuilder();
        String apiName = VerificationCommand.fetchTextByTags(exetaskApiStr, "API");
        String errnoStr = VerificationCommand.fetchTextByTags(exetaskApiStr, "ERRNO");
        String otherStr = VerificationCommand.fetchTextByTags(exetaskApiStr, "OTHER");
        String engTextStr = VerificationCommand.fetchTextByTags(exetaskApiStr, "ENG_TXT");
        String locTextStr = VerificationCommand.fetchTextByTags(exetaskApiStr, "LOC_TXT");
        String errLocation = VerificationCommand.fetchTextByTags(exetaskApiStr, "ERR_LOC");
        Trace.out((String)("api = " + apiName + " errnoStr = " + errnoStr + " otherStr = " + otherStr + " engTextStr = " + engTextStr + " locTextStr = " + locTextStr + "errLocation=" + errLocation));
        if (!VerificationUtil.isStringGood(apiName)) {
            Trace.out((String)"No API name is found.");
        }
        if (!VerificationUtil.isStringGood(errnoStr)) {
            Trace.out((String)"No value of errno is found.");
        }
        String msg = s_gMsgBundle.getMessage("2045", true, (Object[])new String[]{apiName, node, errnoStr});
        if (VerificationUtil.isStringGood(locTextStr) && !locTextStr.equals("NULL")) {
            msg = msg + LSEP + s_gMsgBundle.getMessage("2046", true, (Object[])new String[]{locTextStr});
        }
        if (VerificationUtil.isStringGood(otherStr) && !otherStr.equals("NULL")) {
            msg = msg + LSEP + s_gMsgBundle.getMessage("2047", true, (Object[])new String[]{otherStr});
        }
        if (completeMsg.length() != 0) {
            completeMsg.append(LSEP + msg);
        } else {
            completeMsg.append(msg);
        }
        return completeMsg.toString();
    }

    private String fetchErrorFileMessage(String node, String exectaskFileStr) {
        StringBuilder errorFileMsg = new StringBuilder();
        String facilityStr = VerificationCommand.fetchTextByTags(exectaskFileStr, "FACILITY");
        String idStr = VerificationCommand.fetchTextByTags(exectaskFileStr, "ID");
        String argsStr = VerificationCommand.fetchTextByTags(exectaskFileStr, "ARGS");
        Object[] argsList = VerificationCommand.fetchTextByTagsRepeat(argsStr, "ARG");
        String errLocation = VerificationCommand.fetchTextByTags(exectaskFileStr, "ERR_LOC");
        String traceArgList = "";
        for (String string : argsList) {
            traceArgList = traceArgList + " " + string;
        }
        Trace.out((String)("facilityStr=" + facilityStr + "idStr=" + idStr + "argsList=" + traceArgList + "errLocation=" + errLocation));
        if (!VerificationUtil.isStringGood(facilityStr) || !VerificationUtil.isStringGood(idStr)) {
            Trace.out((String)"APPLICATION ERROR (IGNORED):: Empty facility or id value has been encountered");
        }
        String msg = null;
        if (facilityStr.equalsIgnoreCase(PRVF_FACILITY)) {
            msg = s_msgBundle.getMessage(idStr, true, argsList);
        } else if (facilityStr.equalsIgnoreCase(PRVG_FACILITY)) {
            msg = s_gMsgBundle.getMessage(idStr, true, argsList);
        } else {
            Trace.out((String)"APPLICATION ERROR (IGNORED):: The facility value is set to a improper value");
        }
        if (errorFileMsg.length() != 0) {
            errorFileMsg.append(LSEP + msg);
        } else {
            errorFileMsg.append(msg);
        }
        return errorFileMsg.toString();
    }

    private String fetchSlosMessage(String node, String exectaskSlosStr) {
        StringBuilder completeMsg = new StringBuilder();
        String sloscat = VerificationCommand.fetchTextByTags(exectaskSlosStr, "SLOS_CAT");
        String slosOp = VerificationCommand.fetchTextByTags(exectaskSlosStr, "SLOS_OP");
        String slosDepInfo = VerificationCommand.fetchTextByTags(exectaskSlosStr, "SLOS_DEPINFO");
        String slosDepInfostr = VerificationCommand.fetchTextByTags(exectaskSlosStr, "SLOS_DEPINFOSTR");
        String slosOtherInfo = VerificationCommand.fetchTextByTags(exectaskSlosStr, "SLOS_OTHERINFO");
        String slosLocInfoStr = VerificationCommand.fetchTextByTags(exectaskSlosStr, "SLOS_LOCINFOSTR");
        Trace.out((String)(" sloscat = " + sloscat + " slosop = " + slosOp + " slosdepinfo = " + slosDepInfo + " slosdepinfostr = " + slosDepInfostr + " slosotherinfo =" + slosOtherInfo + " sloslocinfostr = " + slosLocInfoStr));
        String msg = s_gMsgBundle.getMessage("2045", true, (Object[])new String[]{slosOp, node, slosDepInfo});
        if (VerificationUtil.isStringGood(slosLocInfoStr) && !slosLocInfoStr.equals("NULL")) {
            msg = msg + LSEP + s_gMsgBundle.getMessage("2046", true, (Object[])new String[]{slosLocInfoStr});
        }
        if (VerificationUtil.isStringGood(slosOtherInfo) && !slosOtherInfo.equals("NULL")) {
            msg = msg + LSEP + s_gMsgBundle.getMessage("2047", true, (Object[])new String[]{slosOtherInfo});
        }
        if (completeMsg.length() != 0) {
            completeMsg.append(LSEP + msg);
        } else {
            completeMsg.append(msg);
        }
        return completeMsg.toString();
    }

    public String fetchExecutionDetailsMessage() {
        return this.fetchExecutionDetailsMessage(null);
    }

    public String fetchExecutionDetailsMessage(String entity) {
        StringBuilder reusltErrorString = new StringBuilder();
        LinkedHashMap<String, List<String>> resMap = this.fetchExecutionErrorDetails();
        Set<String> keySet = null;
        if (entity != null) {
            keySet = new HashSet<String>();
            keySet.add(entity);
        } else {
            keySet = resMap.keySet();
        }
        for (String key : keySet) {
            List<String> errors = resMap.get(key);
            for (String error : errors) {
                if (reusltErrorString.length() != 0) {
                    reusltErrorString.append(LSEP + error);
                    continue;
                }
                reusltErrorString.append(error);
            }
        }
        return reusltErrorString.toString();
    }

    public String fetchExecutionLogDetails() {
        String node = this.m_node;
        String exectaskOutput = this.m_exectaskOutput;
        if (VerificationUtil.isStringGood(this.m_executionLogDetails)) {
            return this.m_executionLogDetails;
        }
        StringBuilder completeMsg = new StringBuilder();
        Trace.out((int)1, (String)("exectaskOutput=" + exectaskOutput));
        String infoLogStr = VerificationCommand.fetchTextByTags(exectaskOutput, "INFO_LOG");
        String[] cmdArr = VerificationCommand.fetchTextByTagsRepeat(infoLogStr, "EXEC");
        String[] outputArr = VerificationCommand.fetchTextByTagsRepeat(infoLogStr, "OUT");
        String[] exitValArr = VerificationCommand.fetchTextByTagsRepeat(infoLogStr, "STAT");
        Trace.out((String)("cmdArr=" + VerificationUtil.strArr2List(cmdArr) + "outputArr=" + VerificationUtil.strArr2List(outputArr) + "exitValArr=" + VerificationUtil.strArr2List(exitValArr)));
        if (cmdArr.length != outputArr.length || cmdArr.length != exitValArr.length) {
            Trace.out((String)("APPLICATION ERROR (IGNORED):: Found improper sets of EXEC, OUT and STAT tags'cmdArr.length=" + cmdArr.length + "; outputArr.length=" + outputArr.length + "; exitValArr.length=" + exitValArr.length));
        }
        for (int i = 0; i < exitValArr.length; ++i) {
            String exitValStr = exitValArr[i];
            if (!VerificationUtil.isStringGood(cmdArr[i])) {
                Trace.out((String)"APPLICATION ERROR (IGNORED):: Empty EXEC value has been encountered");
                continue;
            }
            String msg = VerificationUtil.isStringGood(outputArr[i]) && !outputArr[i].equals("NULL") ? "Command '" + cmdArr[i] + "' executed on node '" + node + "' had an exit value of '" + exitValArr[i] + "' and produced the following output:" + LSEP + outputArr[i] : "Command '" + cmdArr[i] + "' executed on node '" + node + "' had an exit value of '" + exitValArr[i] + "' and produced no output:";
            if (completeMsg.length() != 0) {
                completeMsg.append(LSEP + msg);
                continue;
            }
            completeMsg.append(msg);
        }
        String debugInfo = this.fetchInfoLogDebugInfo(exectaskOutput);
        if (completeMsg.length() != 0) {
            completeMsg.append(LSEP + debugInfo);
        } else {
            completeMsg.append(debugInfo);
        }
        return completeMsg.toString();
    }

    public void logAllExecutionDetails() {
        String hostName = VerificationCommand.fetchTextByTags(this.m_exectaskOutput, "HOST");
        String initCmd = VerificationCommand.fetchTextByTags(this.m_exectaskOutput, "INITCMD");
        String alllogDetails = this.fetchExecutionLogDetails();
        if (VerificationUtil.isStringGood(alllogDetails)) {
            Trace.out((String)("The details of executed commands and API's are as follows:" + LSEP + "XXXXXXXXXXXXXXXXXX" + LSEP + "Host Name : " + hostName + LSEP + "Init Command : " + initCmd + LSEP + alllogDetails + LSEP + "XXXXXXXXXXXXXXXXXX"));
        } else {
            Trace.out((String)("No command execution details are available for node '" + this.m_node + "'"));
        }
    }

    private String fetchInfoLogDebugInfo(String exectaskOutput) {
        String infoLogStr = VerificationCommand.fetchTextByTags(exectaskOutput, "INFO_LOG");
        String debugInfoMsg = VerificationCommand.fetchTextByTags(infoLogStr, "INFO");
        return debugInfoMsg;
    }
}

