/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RunKillProcCommand
extends VerificationCommand {
    private static String[] kill_cmd = new String[]{"-killproc"};
    String[] newargs = new String[2];

    public RunKillProcCommand(String pid) {
        this("localnode", pid);
    }

    public RunKillProcCommand(String nodeName, String pid) {
        this(nodeName, pid, kill_cmd);
    }

    public RunKillProcCommand(String nodeName, String pid, String[] cmd) {
        this(nodeName, pid, cmd, null);
    }

    public RunKillProcCommand(String nodeName, String pid, String[] kill_cmd, String[] env) {
        super(nodeName, kill_cmd, env);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        this.newargs[0] = kill_cmd[0];
        this.newargs[1] = pid;
        super.setArgs(this.newargs);
        if (nodeName.equals("localnode") || VerificationUtil.isLocalNode(nodeName)) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"Setting Local Execution to be true");
            }
            super.setLocalExecution(true);
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    @Override
    public boolean execute() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("ENTRY thread: " + Thread.currentThread().getName()));
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Node:    " + this.m_node));
            Trace.out((String)("Command: " + this.m_args[1]));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for RunKillProcCommand...";
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("RunKillProcCommand failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("RunKillProcCommand output: " + reoutput));
        }
        result.addResultInfo(reoutput);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return true;
    }
}

