/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.util.ArrayList;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.ServiceConfiguration;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetServiceConfigCommand
extends VerificationCommand {
    private String m_arg1 = "-checkservice";
    private String serviceName;
    private final String errorStart = "<ERROR>";
    private final String errorEnd = "</ERROR>";
    private final String serviceTypeStart = "<SERVICE_TYPE>";
    private final String serviceTypeEnd = "</SERVICE_TYPE>";
    private final String startTypeStart = "<START_TYPE>";
    private final String startTypeEnd = "</START_TYPE>";
    private final String serviceStatusStart = "<SERVICE_STATUS>";
    private final String serviceStatusEnd = "</SERVICE_STATUS>";

    public GetServiceConfigCommand(String node, String service) {
        super(node, null, null);
        String[] args = new String[2];
        this.serviceName = service;
        args[0] = this.m_arg1;
        args[1] = this.serviceName;
        this.setArgs(args);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute() {
        Trace.out((String)("GetServiceConfigCommand:: Inside execute() [Thread:" + Thread.currentThread().getName() + "]"));
        super.execute();
        Result resultCmd = this.getResult();
        String[] resultString = this.getCommandResult().getResultString();
        String fmtdStr = VerificationUtil.strArr2List(resultString, "\n");
        String verificationResult = VerificationUtil.fetchVerificationResult(fmtdStr);
        if (!VerificationUtil.isStringGood(verificationResult)) {
            String trcTxt = "Exectask result shows failure for -checkservice...";
            Trace.out((String)trcTxt);
            resultCmd.addTraceInfo(trcTxt);
            resultCmd.setStatus(2);
            return false;
        }
        if (!verificationResult.equals("0")) {
            String val = VerificationUtil.fetchVerificationValue(fmtdStr);
            String osErr = VerificationUtil.fetchTextByTags(val, "<ERROR>", "</ERROR>");
            Trace.out((String)osErr);
            resultCmd.addErrorInfo(osErr);
            resultCmd.addErrorInfo("getting service configuration failed");
            resultCmd.addErrorDescription(new ErrorDescription(osErr));
            resultCmd.setStatus(2);
            return false;
        }
        Trace.out((String)"getting service configuration succeed");
        String val = VerificationUtil.fetchVerificationValue(fmtdStr);
        String osErr = VerificationUtil.fetchTextByTags(val, "<ERROR>", "</ERROR>");
        if (VerificationUtil.isStringGood(osErr)) {
            resultCmd.setStatus(2);
            resultCmd.addErrorDescription(new ErrorDescription(osErr));
            resultCmd.addErrorInfo(osErr);
            return true;
        }
        ArrayList<ServiceConfiguration> listAttr = new ArrayList<ServiceConfiguration>();
        String strOpt = VerificationUtil.fetchTextByTags(val, "<SERVICE_TYPE>", "</SERVICE_TYPE>");
        int opt = Integer.parseInt(strOpt);
        ServiceConfiguration attr = ServiceConfiguration.serviceTypeFromInt(opt);
        Trace.out((String)("Service type " + (Object)((Object)attr)));
        if (attr != null) {
            listAttr.add(attr);
        }
        strOpt = VerificationUtil.fetchTextByTags(val, "<START_TYPE>", "</START_TYPE>");
        opt = Integer.parseInt(strOpt);
        attr = ServiceConfiguration.startTypeFromInt(opt);
        Trace.out((String)("service start type " + (Object)((Object)attr)));
        if (attr != null) {
            listAttr.add(attr);
        }
        strOpt = VerificationUtil.fetchTextByTags(val, "<SERVICE_STATUS>", "</SERVICE_STATUS>");
        opt = Integer.parseInt(strOpt);
        attr = ServiceConfiguration.serviceStatusFromInt(opt);
        Trace.out((String)("service current status " + (Object)((Object)attr)));
        if (attr != null) {
            listAttr.add(attr);
        }
        resultCmd.setStatus(1);
        resultCmd.addResultInfo(listAttr);
        return true;
    }
}

