/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckHostnameLengthCommand
extends VerificationCommand {
    private static String[] s_args = new String[]{"-gethostname"};
    String m_hostname = null;

    public CheckHostnameLengthCommand(String nodename) {
        super(nodename, s_args, null);
    }

    @Override
    public boolean execute() {
        String resultString = null;
        boolean bResult = super.execute();
        Result result = this.getResult();
        resultString = VerificationUtil.strArr2String(this.getCommandResult().getResultString());
        String trimmed = VerificationUtil.fetchVerificationValue(resultString.trim());
        if (!bResult || resultString == null) {
            String trcTxt = " super.execute() failed for CheckHostnameCommand...";
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckHostnameCommand failed");
            result.setStatus(2);
            return false;
        }
        Trace.out((String)("Retrieved hostname as " + trimmed + " length is " + trimmed.length()));
        if (trimmed.length() > 8) {
            String trcTxt = "Hostname retrieved as " + resultString + " length is more than 8 bytes.";
            result.addTraceInfo(trcTxt);
            result.addTraceInfo("Hostname length check failed.");
            result.addErrorInfo("Hostname was longer than 8 bytes.");
            result.addResultInfo(resultString);
            result.setStatus(3);
            return false;
        }
        if (trimmed.length() < 8) {
            String trcTxt = "Hostname retrieved as " + resultString + "length is less than or equal to 8 bytes.";
            result.addTraceInfo(trcTxt);
            result.addTraceInfo("Hostname length was less than 8 bytes.");
            result.addResultInfo(resultString);
            result.setStatus(1);
        }
        return true;
    }
}

