/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.client;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.InvalidDataFileException;
import oracle.ops.verification.framework.engine.ClusterVerifier;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.InvalidComponentException;
import oracle.ops.verification.framework.engine.factory.data.OperationMode;
import oracle.ops.verification.framework.engine.stage.InvalidStageException;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CluvfyDriver {
    private static String CV = "cv";
    private static String LOG = "log";
    private static String OPT_LOGDIR = "-logdir";
    private static String PROP_CV_TRACELOC = "CV_TRACELOC";
    static final String LSEP = System.getProperty("line.separator");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static String m_localHost = null;

    public CluvfyDriver() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager((SecurityManager)new NullSecurityManager());
            Trace.out((String)"Security manager is set");
        }
    }

    public void parseArguments(String[] args) throws InvalidCommandlineException {
        ParamManager pm = ParamManager.getInstance(OperationMode.cli, args);
        pm.validate(args);
        Trace.out((String)("ParamManager contains:\r\n" + pm));
    }

    public static void main(String[] args) {
        String rshProperty;
        String logdir = null;
        String releaseVer = null;
        ArrayList<String> argsTmp = null;
        if (args.length > 0 && args[args.length - 1].equalsIgnoreCase("_FROM_RUNCLUVFY")) {
            argsTmp = new ArrayList<String>();
            for (int index = 0; index < args.length; ++index) {
                if (args.length > 3 && args[index].equals(OPT_LOGDIR) && index == args.length - 3) {
                    logdir = args[args.length - 2];
                    ++index;
                    continue;
                }
                argsTmp.add(args[index]);
            }
            args = argsTmp.toArray(new String[0]);
            if (VerificationUtil.isStringGood(logdir)) {
                System.setProperty(PROP_CV_TRACELOC, logdir);
            }
        }
        boolean saveTraceState = Trace.isTraceEnabled();
        Trace.traceEnabled((boolean)false);
        try {
            m_localHost = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            System.out.println(s_msgBundle.getMessage("0002", true) + LSEP + uhe.getMessage());
            CluvfyDriver.removePidFileAndExit(1);
        }
        VerificationUtil.setLocalHostName(m_localHost);
        Trace.traceEnabled((boolean)saveTraceState);
        VerificationUtil.setupTracing(true);
        CluvfyDriver cluvfyDriver = new CluvfyDriver();
        if (!VerificationUtil.checkPlatform()) {
            String suppos = VerificationUtil.getSupportedOSPlatform().toString();
            String supparch = VerificationUtil.getSupportedArch();
            System.out.println(s_msgBundle.getMessage("9407", true, (Object[])new String[]{suppos, supparch}));
            Trace.out((String)("Invalid platform. This distribution is valid only for OS " + suppos + " running on hardware architecture " + supparch));
            VerificationLogData.traceLogData();
            CluvfyDriver.removePidFileAndExit(1);
        }
        try {
            cluvfyDriver.parseArguments(args);
        }
        catch (InvalidCommandlineException e) {
            Trace.out((String)e.getMessage());
            Trace.stackTrace((Throwable)e);
            System.out.println(e.getMessage());
            VerificationLogData.traceLogData();
            CluvfyDriver.removePidFileAndExit(1);
        }
        ClusterVerifier clusterVfy = null;
        try {
            clusterVfy = new ClusterVerifier();
        }
        catch (InvalidEnvironmentException iee) {
            Trace.out((String)iee.getMessage());
            VerificationLogData.traceLogData();
            CluvfyDriver.removePidFileAndExit(1);
        }
        if (VerificationUtil.isOTN() && (rshProperty = System.getProperty("SRVM_ALLOW_RSH")) != null && !"TRUE".equalsIgnoreCase(rshProperty) && !"FALSE".equalsIgnoreCase(rshProperty)) {
            Trace.out((String)"Release option(-r) is not provided. Check for source home version");
            releaseVer = CVUVariables.getValue(CVUVariableConstants.GRID_ACTIVE_VERSION);
            if (VerificationUtil.isStringGood(releaseVer) && VerificationUtil.isVersionPre(releaseVer, "12.2")) {
                Trace.out((String)"Found pre 12.2 GI home. Setting RSH fallback to true");
                System.setProperty("SRVM_ALLOW_RSH", "TRUE");
            } else {
                Trace.out((String)"Found post 122 GI home. RSH is not supported starting from 122. Setting it to false");
                System.setProperty("SRVM_ALLOW_RSH", "FALSE");
            }
        }
        ParamManager pm = null;
        int exitStatusVal = 0;
        try {
            pm = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException upme) {
            Trace.out((String)upme.getMessage());
            System.out.println(upme.getMessage());
            VerificationLogData.traceLogData();
            CluvfyDriver.removePidFileAndExit(1);
        }
        if (pm.checkArgFixup() || pm.checkArgFixupNoExecute()) {
            FixupUtility.setDefaultFixupRequirement(true);
        }
        if (pm.checkArgComp()) {
            boolean compChkSuccessful = false;
            try {
                compChkSuccessful = clusterVfy.verifyComponent(pm.getCompID());
            }
            catch (InvalidComponentException ice) {
                Trace.out((String)("INVALIDECOMPONENTEXCEPTION: " + ice.getMessage()));
                Trace.stackTrace((Throwable)((Object)ice));
                System.out.println(ice.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            catch (ComponentInitException e) {
                Trace.out((String)("COMPONENTINITEXCEPTION: " + e.getMessage()));
                Trace.stackTrace((Throwable)((Object)e));
                System.out.println(e.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            catch (InvalidDataFileException idfe) {
                Trace.out((String)("INVALIDDATAFILEEXCEPTION: " + idfe.getMessage()));
                Trace.stackTrace((Throwable)idfe);
                System.out.println(idfe.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            catch (RuntimeException e) {
                Trace.out((String)("RUNTIMEEXCEPTION: " + e.getClass() + ". MESG: " + e.getMessage()));
                Trace.stackTrace((Throwable)e);
                VerificationLogData.logError("RUNTIMEEXCEPTION: " + e.getClass() + "\nMESG : " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            catch (ExceptionInInitializerError ei) {
                Throwable excepCause = ei.getCause();
                VerificationUtil.traceAndLog("EXCEPTIONININITIALIZERERROR: " + ei.getClass() + LSEP + "MESG: " + ei.getMessage() + LSEP + "CAUSE: " + ei.getCause());
                if (excepCause != null) {
                    Trace.stackTrace((Throwable)excepCause);
                    System.out.println(excepCause.getMessage());
                } else {
                    Trace.stackTrace((Throwable)ei);
                    VerificationLogData.logError("EXCEPTIONININITIALIZERERROR: " + ei.getClass() + LSEP + "MESG: " + ei.getMessage() + LSEP + Trace.getStackTrace((Throwable)ei));
                    System.out.println(LSEP + s_msgBundle.getMessage("7508", false) + LSEP);
                }
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            exitStatusVal = compChkSuccessful ? 0 : 1;
        } else if (pm.checkArgStage()) {
            boolean stageChkSuccessful = false;
            try {
                int mode;
                int n = mode = pm.checkArgPre() ? 1 : 2;
                if (pm.checkArgFixup()) {
                    // empty if block
                }
                stageChkSuccessful = clusterVfy.verifyStage(pm.getStageID(), mode);
            }
            catch (InvalidStageException ise) {
                Trace.out((String)("INVALIDSTAGEEXCEPTION: " + ise.getMessage()));
                Trace.stackTrace((Throwable)((Object)ise));
                System.out.println(ise.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            catch (StageInitException e) {
                Trace.out((String)("STAGEINITEXCEPTION: " + e.getMessage()));
                Trace.stackTrace((Throwable)((Object)e));
                System.out.println(e.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            catch (InvalidDataFileException idfe) {
                Trace.out((String)("INVALIDDATAFILEEXCEPTION: " + idfe.getMessage()));
                Trace.stackTrace((Throwable)idfe);
                System.out.println(idfe.getMessage());
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            catch (ExceptionInInitializerError ei) {
                Throwable excepCause = ei.getCause();
                VerificationUtil.traceAndLog("EXCEPTIONININITIALIZERERROR: MESG: " + ei.getMessage() + LSEP + "CAUSE: " + ei.getCause());
                if (excepCause != null) {
                    Trace.stackTrace((Throwable)excepCause);
                    System.out.println(excepCause.getMessage());
                } else {
                    Trace.stackTrace((Throwable)ei);
                    VerificationLogData.logError("EXCEPTIONININITIALIZERERROR: " + ei.getClass() + LSEP + "MESG: " + ei.getMessage() + LSEP + Trace.getStackTrace((Throwable)ei));
                    System.out.println(LSEP + s_msgBundle.getMessage("7508", false) + LSEP);
                }
                System.out.println(LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
                VerificationLogData.traceLogData();
                CluvfyDriver.removePidFileAndExit(1);
            }
            exitStatusVal = stageChkSuccessful ? 0 : 1;
        } else {
            Trace.out((String)"ERROR: Stage or comp was not defined");
            exitStatusVal = 1;
        }
        if (exitStatusVal != 0) {
            VerificationLogData.traceLogData();
        }
        Trace.out((String)"==== cluvfy exiting normally.");
        CluvfyDriver.removePidFileAndExit(exitStatusVal);
    }

    private static void removePidFileAndExit(int exitStatus) {
        String pidFilePath;
        File cvuResourcePidFile;
        if (VerificationUtil.isCVUResource() && (cvuResourcePidFile = new File(pidFilePath = VerificationUtil.getCVUResourcePidFile())).exists()) {
            Trace.out((String)("removing file " + pidFilePath));
            cvuResourcePidFile.delete();
        }
        Trace.close();
        System.exit(exitStatus);
    }
}

