/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.util;

import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DatabaseInfo {
    private String m_dbUniqueName = null;
    private String m_dbDomain = null;
    private String m_dbHome = null;
    private Version m_dbVersion;
    private String m_dbVersionString;

    public DatabaseInfo(String dbUniqueName, String domain, Version v, String dbHome) {
        if (dbUniqueName != null) {
            this.m_dbUniqueName = dbUniqueName.trim();
        }
        if (domain != null) {
            this.m_dbDomain = domain.trim();
        }
        if (dbHome != null) {
            this.m_dbHome = dbHome.trim();
        }
        this.m_dbVersion = v;
        this.m_dbVersionString = String.valueOf(v);
    }

    public DatabaseInfo(String dbUniqueName, String domain, String versionStr, String dbHome) {
        if (dbUniqueName != null) {
            this.m_dbUniqueName = dbUniqueName.trim();
        }
        if (domain != null) {
            this.m_dbDomain = domain.trim();
        }
        if (dbHome != null) {
            this.m_dbHome = dbHome.trim();
        }
        this.m_dbVersionString = versionStr;
        if (VerificationUtil.isStringGood(this.m_dbVersionString)) {
            try {
                this.m_dbVersion = Version.getVersion((String)this.m_dbVersionString);
            }
            catch (ConfigurationException e) {
                Trace.out((Exception)((Object)e));
            }
        }
    }

    public String getUniqueName() {
        return this.m_dbUniqueName;
    }

    public String getDomainName() {
        return this.m_dbDomain;
    }

    public String getDefaultServiceName() {
        if (!VerificationUtil.isStringGood(this.m_dbDomain)) {
            Trace.out((String)("DB domain of '" + this.m_dbUniqueName + "' is null or empty." + " returning database unique name"));
            return this.m_dbUniqueName;
        }
        return this.m_dbUniqueName + "." + this.m_dbDomain;
    }

    public Version getVersion() {
        return this.m_dbVersion;
    }

    public String getVersionString() {
        return this.m_dbVersionString;
    }

    public String getHome() {
        return this.m_dbHome;
    }
}

