/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.util;

import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nls.MessageKey;
import oracle.ops.verification.framework.VerificationConstants;

public class DBUtilsException
extends Exception
implements VerificationConstants {
    private boolean m_isMsg = true;

    public DBUtilsException(String msg) {
        super(msg);
    }

    public DBUtilsException(Throwable cause) {
        super(cause);
        this.m_isMsg = false;
    }

    public DBUtilsException(MessageBundle msgBundle, String key, Object ... args) {
        this((Throwable)null, msgBundle, key, args);
    }

    public DBUtilsException(Throwable cause, MessageBundle msgBundle, String key, Object ... args) {
        super(msgBundle.getMessage(key, true, args), cause);
    }

    public DBUtilsException(String cause, MessageBundle msgBundle, String key, Object ... args) {
        super(cause + LSEP + msgBundle.getMessage(key, true, args));
    }

    public DBUtilsException(MessageKey key, Object ... args) {
        super(MessageBundle.getMessage((MessageKey)key, (boolean)true, (Object[])args), null);
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        Throwable causedBy = super.getCause();
        if (causedBy != null) {
            Throwable nextCause;
            if (this.m_isMsg) {
                sb.append(super.getMessage() + LSEP);
            }
            sb.append(causedBy.getMessage());
            while ((nextCause = causedBy.getCause()) != null) {
                sb.append(LSEP + nextCause.getMessage());
                causedBy = nextCause;
            }
        } else {
            sb.append(super.getMessage());
        }
        return sb.toString();
    }
}

