/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable.analyzer;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.pluggable.analyzer.PluggableJavaAnalyzer;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class PluggableBPFDevicesAnalyzer
implements PluggableJavaAnalyzer {
    private ExecutableInfo m_execInfo;

    @Override
    public ResultSet analyze(ResultSet resultSet) {
        ResultSet analyzerResultSet = new ResultSet();
        HashSet<String> nodesWithAbsentBPFDevices = new HashSet<String>();
        if (resultSet != null) {
            Set nodeList = resultSet.getResultTable().keySet();
            for (String node : nodeList) {
                Result nodeResult = resultSet.getResult(node);
                if (nodeResult.getStatus() == 1 || nodeResult.getStatus() == 4) {
                    try {
                        String output = nodeResult.getActualValue();
                        Trace.out((String)("The output of BPF devices check pluggable script on the node (" + node + " is (" + output + ")"));
                        Trace.out((String)("Processing BPF devices configuration retrieved from node (" + node + ")"));
                        if (nodeResult.getStatus() == 1) {
                            Hashtable<String, Set<String>> duplicateMajMinBPFDev = this.getDuplicatingMajorMinorInBPFDevicesOnNode(output);
                            if (!duplicateMajMinBPFDev.isEmpty()) {
                                nodeResult.setStatus(3);
                                for (String majminKey : duplicateMajMinBPFDev.keySet()) {
                                    String[] arrayMajorMinor = majminKey.trim().split(":");
                                    String majorNumStr = arrayMajorMinor[0];
                                    String minorNumStr = arrayMajorMinor[1];
                                    String warningMsg = s_eMsgBundle.getMessage("0475", true, (Object[])new String[]{VerificationUtil.strCollection2String((Collection)duplicateMajMinBPFDev.get(majminKey)), majorNumStr, minorNumStr, node});
                                    Trace.out((String)warningMsg);
                                    nodeResult.addErrorDescription(new ErrorDescription(warningMsg));
                                }
                            }
                        } else {
                            Hashtable<BPFDeviceInfo, Set<String>> bpfDeviceWithDuplicatingMajorNumberDevList = this.processBPFDeviceScriptOutput(output);
                            if (!bpfDeviceWithDuplicatingMajorNumberDevList.isEmpty()) {
                                for (BPFDeviceInfo bpfDev : bpfDeviceWithDuplicatingMajorNumberDevList.keySet()) {
                                    String errorMsg = s_eMsgBundle.getMessage("0473", true, (Object[])new String[]{bpfDev.getPath(), bpfDev.getMajorNumber(), VerificationUtil.strCollection2String((Collection)bpfDeviceWithDuplicatingMajorNumberDevList.get(bpfDev)), node});
                                    Trace.out((String)errorMsg);
                                    nodeResult.addErrorDescription(new ErrorDescription(errorMsg));
                                }
                                nodeResult.setStatus(3);
                            }
                        }
                        analyzerResultSet.addResult(node, nodeResult);
                    }
                    catch (ResultValuesUnavailableException rvue) {
                        Trace.out((String)("No output from node  " + node));
                        analyzerResultSet.addResult(node, 2);
                    }
                    continue;
                }
                if (nodeResult.getStatus() == 3) {
                    Trace.out((String)("The BPF devices are not created on node " + node));
                    nodesWithAbsentBPFDevices.add(node);
                    analyzerResultSet.addResult(node, nodeResult);
                    continue;
                }
                analyzerResultSet.addResult(node, nodeResult);
            }
            if (!nodesWithAbsentBPFDevices.isEmpty()) {
                String error = s_eMsgBundle.getMessage("0474", true, (Object[])new String[]{VerificationUtil.strCollection2String(nodesWithAbsentBPFDevices)});
                analyzerResultSet.addErrorDescription(new ErrorDescription(error));
            }
        }
        return analyzerResultSet;
    }

    private Hashtable<BPFDeviceInfo, Set<String>> processBPFDeviceScriptOutput(String output) {
        String[] deviceWiseInfo;
        Hashtable<BPFDeviceInfo, Set<String>> bpfDuplicateMajorDeviceTable = new Hashtable<BPFDeviceInfo, Set<String>>();
        for (String str : deviceWiseInfo = output.split(" ")) {
            String[] colonSplit = str.split(":");
            BPFDeviceInfo devInfo = null;
            HashSet<String> duplicatingMajorNumberDeviceList = new HashSet<String>();
            if (colonSplit == null || colonSplit.length <= 0) continue;
            String bpfDevPath = colonSplit[0];
            if (bpfDevPath.contains("[") && bpfDevPath.contains("]")) {
                String majorMinorStr = bpfDevPath.substring(bpfDevPath.indexOf("[") + 1, bpfDevPath.indexOf("]"));
                String[] arrayMajorMinor = majorMinorStr.trim().split("\\|");
                String major = arrayMajorMinor[0];
                String minor = arrayMajorMinor[1];
                bpfDevPath = bpfDevPath.substring(0, bpfDevPath.indexOf("["));
                devInfo = new BPFDeviceInfo(bpfDevPath, major, minor);
            }
            if (colonSplit.length > 1) {
                String[] majorNumberDuplicatingDeviceList = colonSplit[1].split(",");
                duplicatingMajorNumberDeviceList.addAll(Arrays.asList(majorNumberDuplicatingDeviceList));
            }
            bpfDuplicateMajorDeviceTable.put(devInfo, duplicatingMajorNumberDeviceList);
        }
        return bpfDuplicateMajorDeviceTable;
    }

    private Hashtable<String, Set<String>> getDuplicatingMajorMinorInBPFDevicesOnNode(String output) {
        Hashtable<BPFDeviceInfo, Set<String>> bpfDeviceTable = this.processBPFDeviceScriptOutput(output);
        Set<BPFDeviceInfo> bpfDeviceSet = bpfDeviceTable.keySet();
        Hashtable<String, Set<String>> duplicateMajorMinorBPFTable = new Hashtable<String, Set<String>>();
        for (BPFDeviceInfo bpfDev : bpfDeviceSet) {
            for (BPFDeviceInfo currentBpfDev : bpfDeviceSet) {
                if (currentBpfDev.getName().equalsIgnoreCase(bpfDev.getName()) || !currentBpfDev.getMajorNumber().equals(bpfDev.getMajorNumber()) || !currentBpfDev.getMinorNumber().equals(bpfDev.getMinorNumber())) continue;
                String key = currentBpfDev.getMajorNumber() + ":" + currentBpfDev.getMinorNumber();
                if (duplicateMajorMinorBPFTable.containsKey(key)) {
                    duplicateMajorMinorBPFTable.get(key).add(currentBpfDev.getPath());
                    duplicateMajorMinorBPFTable.get(key).add(bpfDev.getPath());
                    continue;
                }
                HashSet<String> bpfDevList = new HashSet<String>();
                bpfDevList.add(currentBpfDev.getPath());
                bpfDevList.add(bpfDev.getPath());
                duplicateMajorMinorBPFTable.put(key, bpfDevList);
            }
        }
        return duplicateMajorMinorBPFTable;
    }

    @Override
    public void setExecutableInfo(ExecutableInfo execInfo) {
        this.m_execInfo = execInfo;
    }

    private class BPFDeviceInfo {
        String m_path;
        String m_name;
        String m_majorNumber;
        String m_minorNumber;

        BPFDeviceInfo(String path, String majorNumber, String minorNumber) {
            this.m_path = path;
            this.m_majorNumber = majorNumber;
            this.m_minorNumber = minorNumber;
            this.m_name = new File(this.m_path).getName();
        }

        String getPath() {
            return this.m_path;
        }

        String getName() {
            return this.m_name;
        }

        String getMajorNumber() {
            return this.m_majorNumber;
        }

        String getMinorNumber() {
            return this.m_minorNumber;
        }
    }
}

