/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.fixup.FixupConstants;
import oracle.cluster.verification.fixup.FixupData;
import oracle.cluster.verification.pluggable.PluggableTasksWithFixupData;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.PluggableTaskContext;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class PluggableFixupDataFactory {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public static FixupData getFixupData(String taskID, PluggableTaskContext pluggableCtx, ResultSet resultSet) {
        FixupData fixupData = null;
        String[] fixableNodes = null;
        fixableNodes = resultSet.anyFailure() ? resultSet.getNodesWithStatus(3) : resultSet.getNodesWithStatus(4);
        if (null != fixableNodes && fixableNodes.length > 0) {
            fixupData = PluggableTasksWithFixupData.contains(taskID) ? PluggableFixupDataFactory.generateFixupForPluggableTask(PluggableTasksWithFixupData.valueOf(taskID), resultSet, pluggableCtx, fixableNodes) : new FixupData(Arrays.asList(fixableNodes));
        }
        return fixupData;
    }

    private static FixupData generateFixupForPluggableTask(PluggableTasksWithFixupData task, ResultSet resultSet, PluggableTaskContext pluggableCtx, String[] fixableNodes) {
        FixupData fixupData = new FixupData(Arrays.asList(fixableNodes));
        String localNode = VerificationUtil.getLocalNode();
        Result result = new Result(localNode);
        ArrayList<String> scriptArgsList = new ArrayList<String>();
        switch (task) {
            case CHECK_BOOT_MOUNTED: {
                break;
            }
            case CHECK_IOCP_STATUS: {
                break;
            }
            case ENABLED_HUGE_PAGE: {
                scriptArgsList.add("-getfixupdata");
                fixupData.addFixupScript(FixupConstants.ScriptType.SHELL, "checkhugepage.sh", scriptArgsList);
                break;
            }
            case CHECK_ZEROCONF: {
                scriptArgsList.add("-getfixupdata");
                fixupData.addFixupScript(FixupConstants.ScriptType.SHELL, "zeroconf.sh", scriptArgsList);
                break;
            }
            case CHECK_GSD_RESOURCE: {
                String crsHome = VerificationUtil.getCRSHome(localNode, result);
                if (result.getStatus() == 1 && VerificationUtil.isStringGood(crsHome)) {
                    fixupData.addFixupInstruction("CRSHOME", crsHome);
                    break;
                }
                ErrorDescription fixupGenFailedErrorDesc = new ErrorDescription(s_msgBundle.getMessage("5301", true));
                fixupData.addFixupGenerationFailedNode(localNode, fixupGenFailedErrorDesc);
                break;
            }
            case CHECK_DAX_ACCESS: {
                scriptArgsList.add("-getfixupdata");
                scriptArgsList.add(CVUVariables.getValue(CVUVariableConstants.RAC_USER));
                fixupData.addFixupScript(FixupConstants.ScriptType.SHELL, "check_dax_access.sh", scriptArgsList);
                break;
            }
            case MAX_LOCKED_MEM: 
            case MEMLOCK_LIMIT: {
                PluggableFixupDataFactory.loadExpectedAndActualValueFromResultSet(fixableNodes, resultSet, fixupData);
                fixupData.addFixupInstruction("USER", System.getProperty("user.name"));
                break;
            }
            case REVERSE_PATH_FILTER: {
                scriptArgsList.add(CVUVariables.getValue(CVUVariableConstants.PVT_NETWORKS_LIST));
                scriptArgsList.add("-getfixupdata");
                fixupData.addFixupScript(FixupConstants.ScriptType.SHELL, "check_rp_filter.sh", scriptArgsList);
            }
        }
        return fixupData;
    }

    private static FixupData loadExpectedAndActualValueFromResultSet(String[] fixableNodes, ResultSet resultSet, FixupData fixupData) {
        for (String node : fixableNodes) {
            Result nodeResult = resultSet.getResult(node);
            String actualValue = "";
            String expectedValue = "";
            if (nodeResult != null) {
                try {
                    actualValue = nodeResult.getActualValue();
                    expectedValue = nodeResult.getExpectedValue();
                }
                catch (ResultValuesUnavailableException e) {
                    Trace.out((String)("Ignoring : Expected or Actual value is not available for node " + node));
                }
            }
            fixupData.setActualValue(node, actualValue == null ? "" : actualValue);
            fixupData.setExpectedValue(node, expectedValue == null ? "" : expectedValue);
        }
        return fixupData;
    }
}

