/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.gpnp;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.gpnp.GPnPHAIP;
import oracle.cluster.verification.gpnp.GPnPHostNetwork;
import oracle.cluster.verification.gpnp.GPnPNetwork;
import oracle.cluster.verification.gpnp.GPnPNetworkProfile;
import oracle.cluster.verification.gpnp.GPnPProfile;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GPnPXmlParser {
    private static final String FILE_SEPARATOR = VerificationConstants.FSEP;
    private static final String GPNPTOOL_GET = "gpnptool get";
    private static final String GPNP_NO_DAEMON = "CLSGPNP_NO_DAEMON";
    private static final String XML_DOC_START = "<?xml";
    private static final String PATH_TO_PROFILE = "/gpnp/profiles/peer/profile.xml";
    public static final String ATTRIBUTE_ID = "id";
    public static final String XML_PROFILE_SEQUENCE = "ProfileSequence";
    public static final String XML_CLUSTER_NAME = "ClusterName";
    public static final String XML_CLUSTER_UID = "ClusterUId";
    public static final String XML_PA_LOCATION = "PALocation";
    public static final String XML_NETWORK_PROFILE = "Network-Profile";
    public static final String XML_HAIP = "HAIP";
    public static final String XML_MULTICAST_ADDRESS = "MulticastAddress";
    public static final String XML_BOOT_MODE = "BootMode";
    public static final String XML_SUBNET = "Subnet";
    public static final String XML_HOST_NETWORK = "HostNetwork";
    public static final String XML_HOST_NAME = "HostName";
    public static final String XML_NETWORK = "Network";
    public static final String XML_IP = "IP";
    public static final String XML_USE = "Use";
    public static final String XML_NAME_TMPL = "NameTmpl";
    public static final String XML_AUTO_IP = "AutoIP";
    public static final String XML_ADAPTER = "Adapter";
    public static final String XML_BIG_CLUSTER = "BC-BigCluster";
    public static final String XML_DISCOVERY_VIP = "DiscoveryVIP";
    public static final String XML_ASM_PROFILE = "ASM-Profile";
    public static final String XML_DISCOVERY_STRING = "DiscoveryString";
    public static final String XML_SP_FILE = "SPFile";
    public static final String XML_MODE = "Mode";
    public static final String XML_CSS_PROFILE = "CSS-Profile";
    public static final String XML_LEASE_DURATION = "LeaseDuration";
    public static final String XML_OCR_PROFILE = "OCR-Profile";
    public static final String XML_OCR_ID = "OCRId";
    public static final String NETWORK_AUTOIP_NONE = "none";
    public static final String NETWORK_AUTOIP_DHCP = "dhcp";
    public static final String NETWORK_AUTOIP_ZEROCONF = "zeroconf";
    private File m_profileGPnPFile = null;
    private DocumentBuilderFactory m_xmlFactory = null;
    private DocumentBuilder m_xmlParser = null;
    private Document m_xmlDocument = null;
    private Element m_rootElement = null;
    private GPnPProfile m_gpnpProfile = null;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public GPnPProfile parse() throws XmlParserException {
        FileReader reader = null;
        String crsHome = VerificationUtil.getCRSHome();
        if (!VerificationUtil.isStringGood(crsHome)) {
            String msg = s_msgBundle.getMessage("5301", true);
            throw new XmlParserException(msg);
        }
        this.m_profileGPnPFile = new File(crsHome + PATH_TO_PROFILE);
        try {
            reader = new FileReader(this.m_profileGPnPFile);
            return this.parse(reader);
        }
        catch (IOException ioe) {
            throw new XmlParserException(ioe.getMessage(), ioe);
        }
    }

    public GPnPProfile parse(FileReader reader) throws XmlParserException {
        InputSource is = null;
        if (reader == null) {
            return null;
        }
        is = new InputSource(reader);
        return this.parse(is);
    }

    public GPnPProfile parseAtNode(String node) throws XmlParserException {
        VerificationCommand gpnpCmd = null;
        Result result = null;
        String nodeResult = null;
        String gpnpToolCommand = null;
        String[] nodeList = new String[]{node};
        ResultSet m_resultSet = new ResultSet();
        String xmlDoc = null;
        InputSource is = null;
        String crsHome = VerificationUtil.getCRSHome();
        if (!VerificationUtil.isStringGood(crsHome)) {
            String msg = s_msgBundle.getMessage("5301", true);
            throw new XmlParserException(msg);
        }
        gpnpToolCommand = crsHome + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + GPNPTOOL_GET + " " + "-o-";
        VerificationCommand[] gpnpCmdArray = new VerificationCommand[1];
        String[] arg = new String[]{"-rungencmd", gpnpToolCommand};
        String[] env = null;
        gpnpCmdArray[0] = new VerificationCommand(node, arg, env);
        Trace.out((String)("gpnp command: " + gpnpToolCommand));
        new GlobalHandler().submit((Command[])gpnpCmdArray, 0, m_resultSet);
        for (int nodeIndex = 0; nodeIndex < nodeList.length; ++nodeIndex) {
            gpnpCmd = gpnpCmdArray[nodeIndex];
            result = gpnpCmd.getResult();
            nodeResult = gpnpCmd.getNode();
            if (result.getStatus() != 1) {
                String errMsg = result.getErrMessage();
                Trace.out((String)errMsg);
                throw new XmlParserException(errMsg);
            }
            String output = gpnpCmd.getOutput();
            output = output.trim();
            xmlDoc = output = output.replaceAll("Success.", "");
        }
        Trace.out((String)("xmlDoc[" + xmlDoc + "]"));
        int startIndex = 0;
        String errorMsg = null;
        startIndex = xmlDoc.indexOf(GPNP_NO_DAEMON);
        if (startIndex > -1) {
            startIndex = xmlDoc.indexOf(XML_DOC_START);
            errorMsg = xmlDoc.substring(0, startIndex - 1);
            throw new XmlParserException(errorMsg);
        }
        StringReader sr = new StringReader(xmlDoc);
        is = new InputSource(sr);
        return this.parse(is);
    }

    public GPnPProfile parse(String xmlDoc) throws XmlParserException {
        InputSource is = null;
        int startIndex = 0;
        String errorMsg = null;
        startIndex = xmlDoc.indexOf(GPNP_NO_DAEMON);
        if (startIndex > -1) {
            startIndex = xmlDoc.indexOf(XML_DOC_START);
            errorMsg = xmlDoc.substring(0, startIndex - 1);
            throw new XmlParserException(errorMsg);
        }
        StringReader sr = new StringReader(xmlDoc);
        is = new InputSource(sr);
        return this.parse(is);
    }

    private GPnPProfile parse(InputSource input) throws XmlParserException {
        try {
            this.m_xmlFactory = DocumentBuilderFactory.newInstance();
            this.m_xmlParser = this.m_xmlFactory.newDocumentBuilder();
            ErrorHandler handler = new ErrorHandler(){

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                    Trace.out((String)("Igonred warning while parsing: " + arg0));
                }
            };
            this.m_xmlParser.setErrorHandler(handler);
            this.m_xmlDocument = null;
            this.m_xmlDocument = this.m_xmlParser.parse(input);
            this.m_rootElement = this.m_xmlDocument.getDocumentElement();
            String profileSequence = this.m_rootElement.getAttribute(XML_PROFILE_SEQUENCE);
            String clusterName = this.m_rootElement.getAttribute(XML_CLUSTER_NAME);
            String clusterUid = this.m_rootElement.getAttribute(XML_CLUSTER_UID);
            String paLocation = this.m_rootElement.getAttribute(XML_PA_LOCATION);
            this.m_gpnpProfile = new GPnPProfile(profileSequence, clusterName, clusterUid, paLocation);
            this.parseNetworkProfile(this.m_gpnpProfile, this.m_rootElement);
            this.parseBigClusterProfile(this.m_gpnpProfile, this.m_rootElement);
            this.parseASMProfile(this.m_gpnpProfile, this.m_rootElement);
            this.parseCSSProfile(this.m_gpnpProfile, this.m_rootElement);
            this.parseOCRProfile(this.m_gpnpProfile, this.m_rootElement);
            return this.m_gpnpProfile;
        }
        catch (ParserConfigurationException pce) {
            throw new XmlParserException(pce.getMessage(), pce);
        }
        catch (IOException ioe) {
            throw new XmlParserException(ioe.getMessage(), ioe);
        }
        catch (SAXException se) {
            throw new XmlParserException(se.getMessage(), se);
        }
    }

    public GPnPProfile getGPnPProfile() {
        return this.m_gpnpProfile;
    }

    private void parseNetworkProfile(GPnPProfile profile, Element gpnpElement) throws XmlParserException {
        NodeList networkProfiles = gpnpElement.getElementsByTagName(XML_NETWORK_PROFILE);
        for (int np = 0; np < networkProfiles.getLength(); ++np) {
            Element networkProfile = (Element)networkProfiles.item(np);
            profile.createNetworkProfile();
            this.parseHAIP(profile.getNetworkProfile(), networkProfile);
            this.parseHostNetwork(profile.getNetworkProfile(), networkProfile);
        }
    }

    private void parseHAIP(GPnPNetworkProfile networkProfile, Element gpnpElement) throws XmlParserException {
        String[] addresses = null;
        String address = null;
        String id = null;
        String multicastAddress = null;
        String bootMode = null;
        String subnet = null;
        GPnPHAIP haipProfile = null;
        Vector multicastAddresses = null;
        InetAddress subnetHAIP = null;
        NodeList haips = gpnpElement.getElementsByTagName(XML_HAIP);
        for (int ha = 0; ha < haips.getLength(); ++ha) {
            Element haip = (Element)haips.item(ha);
            id = haip.getAttribute(ATTRIBUTE_ID);
            multicastAddress = haip.getAttribute(XML_MULTICAST_ADDRESS);
            bootMode = haip.getAttribute(XML_BOOT_MODE);
            subnet = haip.getAttribute(XML_SUBNET);
            if (VerificationUtil.isStringGood(multicastAddress)) {
                addresses = multicastAddress.split(" ");
                for (int i = 0; i < addresses.length; ++i) {
                    address = addresses[i];
                    try {
                        multicastAddresses.add(InetAddress.getByName(address));
                        continue;
                    }
                    catch (UnknownHostException uhe) {
                        Trace.out((String)("HAIP element address:" + address));
                        throw new XmlParserException("HAIP element address:" + address);
                    }
                }
            } else {
                Trace.out((String)("HAIP element multicastAddress:" + multicastAddress));
                throw new XmlParserException("HAIP element multicastAddress:" + multicastAddress);
            }
            try {
                subnetHAIP = InetAddress.getByName(subnet);
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)("HAIP subnet element:" + uhe.getMessage()));
                throw new XmlParserException(uhe.getMessage());
            }
            haipProfile = new GPnPHAIP(id, multicastAddresses, bootMode, subnetHAIP);
            networkProfile.addHAIP(haipProfile);
        }
    }

    private void parseHostNetwork(GPnPNetworkProfile networkProfile, Element gpnpElement) throws XmlParserException {
        GPnPHostNetwork hostNetworkElement = null;
        String id = null;
        String hostName = null;
        NodeList hostNetworks = gpnpElement.getElementsByTagName(XML_HOST_NETWORK);
        for (int hn = 0; hn < hostNetworks.getLength(); ++hn) {
            Element hostNetwork = (Element)hostNetworks.item(hn);
            id = hostNetwork.getAttribute(ATTRIBUTE_ID);
            hostName = hostNetwork.getAttribute(XML_HOST_NAME);
            hostNetworkElement = new GPnPHostNetwork(id, hostName);
            networkProfile.addHostNetwork(hostNetworkElement);
            this.parseNetworks(hostNetworkElement, hostNetwork);
        }
    }

    private void parseNetworks(GPnPHostNetwork hostNetwork, Element gpnpElement) throws XmlParserException {
        InetAddress ipAddress = null;
        String id = null;
        String ip = null;
        String use = null;
        String nameTempl = null;
        String autoIp = null;
        String adapter = null;
        GPnPNetwork gpnpNetwork = null;
        GPnPNetwork.GPnPNetworkAutoIP autoIpNetwork = null;
        NodeList networks = gpnpElement.getElementsByTagName(XML_NETWORK);
        for (int n = 0; n < networks.getLength(); ++n) {
            Element network = (Element)networks.item(n);
            id = network.getAttribute(ATTRIBUTE_ID);
            ip = network.getAttribute(XML_IP);
            use = network.getAttribute(XML_USE);
            nameTempl = network.getAttribute(XML_NAME_TMPL);
            autoIp = network.getAttribute(XML_AUTO_IP);
            adapter = network.getAttribute(XML_ADAPTER);
            try {
                ipAddress = InetAddress.getByName(ip);
            }
            catch (UnknownHostException uhe) {
                Trace.out((String)("Network IP element:" + uhe.getMessage()));
                throw new XmlParserException(uhe.getMessage());
            }
            if (VerificationUtil.isStringGood(autoIp)) {
                if (autoIp.equals(NETWORK_AUTOIP_NONE)) {
                    autoIpNetwork = GPnPNetwork.GPnPNetworkAutoIP.NONE;
                }
                if (autoIp.equals(NETWORK_AUTOIP_DHCP)) {
                    autoIpNetwork = GPnPNetwork.GPnPNetworkAutoIP.DHCP;
                }
                if (autoIp.equals(NETWORK_AUTOIP_ZEROCONF)) {
                    autoIpNetwork = GPnPNetwork.GPnPNetworkAutoIP.ZEROCONF;
                }
            }
            gpnpNetwork = new GPnPNetwork(id, ipAddress, use, nameTempl, autoIpNetwork, adapter);
            hostNetwork.addNetwork(gpnpNetwork);
        }
    }

    private void parseBigClusterProfile(GPnPProfile profile, Element gpnpElement) {
        String id = null;
        String discoveryVIP = null;
        NodeList bigClusterProfiles = gpnpElement.getElementsByTagName(XML_BIG_CLUSTER);
        for (int bc = 0; bc < bigClusterProfiles.getLength(); ++bc) {
            Element bigCluster = (Element)bigClusterProfiles.item(bc);
            id = bigCluster.getAttribute(ATTRIBUTE_ID);
            discoveryVIP = bigCluster.getAttribute(XML_DISCOVERY_VIP);
            profile.createBigClusterProfile(id, discoveryVIP);
        }
    }

    private void parseASMProfile(GPnPProfile profile, Element gpnpElement) {
        String id = null;
        String discoveryString = null;
        String spFile = null;
        String mode = null;
        NodeList asmProfiles = gpnpElement.getElementsByTagName(XML_ASM_PROFILE);
        for (int ap = 0; ap < asmProfiles.getLength(); ++ap) {
            Element asm = (Element)asmProfiles.item(ap);
            id = asm.getAttribute(ATTRIBUTE_ID);
            discoveryString = asm.getAttribute(XML_DISCOVERY_STRING);
            spFile = asm.getAttribute(XML_SP_FILE);
            mode = asm.getAttribute(XML_MODE);
            profile.createASMProfile(id, discoveryString, spFile, mode);
        }
    }

    private void parseCSSProfile(GPnPProfile profile, Element gpnpElement) throws NumberFormatException {
        String id = null;
        String discoveryString = null;
        long leaseDuration = 0L;
        NodeList cssProfiles = gpnpElement.getElementsByTagName(XML_CSS_PROFILE);
        for (int cp = 0; cp < cssProfiles.getLength(); ++cp) {
            Element css = (Element)cssProfiles.item(cp);
            id = css.getAttribute(ATTRIBUTE_ID);
            if (VerificationUtil.isStringGood(css.getAttribute(XML_LEASE_DURATION))) {
                leaseDuration = Integer.parseInt(css.getAttribute(XML_LEASE_DURATION));
            }
            discoveryString = css.getAttribute(XML_DISCOVERY_STRING);
            css.getAttribute(XML_LEASE_DURATION);
            profile.createCSSProfile(id, discoveryString, leaseDuration);
        }
    }

    private void parseOCRProfile(GPnPProfile profile, Element gpnpElement) {
        String id = null;
        String ocrId = null;
        NodeList ocrProfiles = gpnpElement.getElementsByTagName(XML_OCR_PROFILE);
        for (int op = 0; op < ocrProfiles.getLength(); ++op) {
            Element ocr = (Element)ocrProfiles.item(op);
            id = ocr.getAttribute(ATTRIBUTE_ID);
            ocrId = ocr.getAttribute(XML_OCR_ID);
            profile.createOCRProfile(id, ocrId);
        }
    }
}

