/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.FixupStatus;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.fixup.FixupConstants;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.fixup.FixupXMLException;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FixupXmlParser
implements FixupConstants {
    protected Element m_fixupDOMRoot = null;
    protected Document m_fixupDoc = null;

    public FixupXmlParser(String xmlDocumentPath) throws FixupXMLException {
        try {
            this.loadXmlFile(xmlDocumentPath);
        }
        catch (XmlParserException xpe) {
            VerificationLogData.logError("XmlParserException - " + xpe.getMessage());
            Trace.out((String)("Caught XmlParserException with error " + xpe.getMessage()));
            throw new FixupXMLException(xpe.getMessage(), xpe);
        }
        catch (XmlFilePathException xfe) {
            VerificationLogData.logError("XmlFilePathException - " + xfe.getMessage());
            Trace.out((String)("Caught XmlFilePathException with error " + xfe.getMessage()));
            throw new FixupXMLException(xfe.getMessage(), xfe);
        }
    }

    protected FixupXmlParser() {
    }

    private void loadXmlFile(String xmlFilePath) throws XmlParserException, XmlFilePathException {
        String[] pathSplit;
        DocumentBuilderFactory xmlFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder xmlParser = null;
        String xmlFilePathURI = new File(xmlFilePath).toURI().toString();
        String xsdURI = FixupUtility.getCVUFixupXmlSchemaURI();
        String file_xsdURI = null;
        String file_xmlFile = null;
        if (xsdURI.indexOf(":") >= 0) {
            pathSplit = xsdURI.split(":");
            file_xsdURI = pathSplit[1];
        }
        if (xmlFilePathURI.indexOf(":") >= 0) {
            pathSplit = xmlFilePathURI.split(":");
            file_xmlFile = pathSplit[1];
        }
        try {
            Trace.out((String)("==== URIs obtained :xsd URI = " + xsdURI));
            Trace.out((String)("==== URIs obtained :xml URI = " + xmlFilePathURI));
            if (file_xmlFile == null || !new File(file_xmlFile).exists()) {
                throw new FixupXMLException("failed to construct");
            }
            if (file_xsdURI != null && new File(file_xsdURI).exists()) {
                xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                xmlFactory.setNamespaceAware(true);
                xmlFactory.setValidating(true);
                xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xsdURI);
            }
            xmlParser = xmlFactory.newDocumentBuilder();
            ErrorHandler handler = new ErrorHandler(){

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                    Trace.out((String)("Ignored warning while parsing: " + arg0));
                }
            };
            xmlParser.setErrorHandler(handler);
            this.m_fixupDoc = xmlParser.parse(xmlFilePathURI);
            this.m_fixupDOMRoot = this.m_fixupDoc.getDocumentElement();
        }
        catch (SAXException se) {
            throw new XmlParserException(se.getMessage(), se);
        }
        catch (IOException ioe) {
            throw new XmlParserException(ioe.getMessage(), ioe);
        }
        catch (FactoryConfigurationError fce) {
            throw new XmlParserException(fce.getMessage(), fce);
        }
        catch (ParserConfigurationException pce) {
            throw new XmlParserException(pce.getMessage(), pce);
        }
        catch (FixupXMLException fe) {
            throw new XmlParserException(fe.getMessage(), fe);
        }
    }

    public Element getFirstChildNodeByTagName(Element parent, String elementTagName) {
        return this.getChildNodeByTagName(parent, elementTagName, 0);
    }

    public Element getChildNodeByTagName(Element parent, String elementTagName, int childIndex) {
        NodeList childNodes = parent.getElementsByTagName(elementTagName);
        Element child = null;
        if (childNodes != null && childNodes.getLength() > childIndex) {
            child = (Element)childNodes.item(childIndex);
        }
        return child;
    }

    private Element searchChildNodeWithMatchingAttributeValue(Element parent, String childNodeTagName, String attribute, String attributeValue, boolean ignoreCase) {
        NodeList listOfnodes = parent.getElementsByTagName(childNodeTagName);
        int nodeCount = listOfnodes.getLength();
        for (int i = 0; i < nodeCount; ++i) {
            String value = null;
            Element child = (Element)listOfnodes.item(i);
            if (child == null) continue;
            value = child.getAttribute(attribute);
            if (value != null && attributeValue.trim().equals(value.trim())) {
                return child;
            }
            if (!ignoreCase || !attributeValue.trim().equalsIgnoreCase(value.trim())) continue;
            return child;
        }
        return null;
    }

    public List<Element> getAllTaskElements() {
        ArrayList<Element> taskElemList = new ArrayList<Element>();
        NodeList taskList = this.m_fixupDOMRoot.getElementsByTagName("TASK");
        int taskCount = taskList.getLength();
        for (int i = 0; i < taskCount; ++i) {
            taskElemList.add((Element)taskList.item(i));
        }
        return taskElemList;
    }

    public List<Element> getListOfTasksForNode(String node) {
        ArrayList<Element> taskListForNode = new ArrayList<Element>();
        Element taskListElem = this.getFirstChildNodeByTagName(this.m_fixupDOMRoot, "TASK_LIST");
        NodeList taskList = taskListElem.getElementsByTagName("TASK");
        for (int i = 0; i < taskList.getLength(); ++i) {
            Element currentTask = (Element)taskList.item(i);
            if (!this.isNodeParticipatingInTask(node, currentTask)) continue;
            taskListForNode.add(currentTask);
        }
        return taskListForNode;
    }

    public boolean isNodeParticipatingInTask(String node, Element taskElem) {
        List<Element> fixupDataList = this.getFixupDataElementListForTask(taskElem);
        for (Element fixupData : fixupDataList) {
            Element nodeListElem = this.getFirstChildNodeByTagName(fixupData, "NODE_LIST");
            if (null == nodeListElem || null == this.searchChildNodeWithMatchingAttributeValue(nodeListElem, "NODE", "NAME", node, true)) continue;
            return true;
        }
        return false;
    }

    public List<Element> getFixupDataElementListForTask(Element taskElem) {
        Element fixupDataList;
        ArrayList<Element> fixupDataElemList = new ArrayList<Element>();
        if (null != taskElem && (fixupDataList = this.getFirstChildNodeByTagName(taskElem, "FIXUP_DATA_LIST")) != null) {
            int numOfFixDataElem = fixupDataList.getElementsByTagName("FIXUP_DATA").getLength();
            for (int i = 0; i < numOfFixDataElem; ++i) {
                Element fixupData = this.getChildNodeByTagName(fixupDataList, "FIXUP_DATA", i);
                if (null == fixupData) continue;
                fixupDataElemList.add(fixupData);
            }
        }
        return fixupDataElemList;
    }

    public Element getTaskElement(String taskID) {
        Element taskOfInterest = null;
        List<Element> listOfTaskElem = this.getAllTaskElements();
        for (Element task : listOfTaskElem) {
            String currTaskID = task.getAttribute("ID");
            if (!VerificationUtil.isStringGood(currTaskID) || !currTaskID.equals(taskID)) continue;
            taskOfInterest = task;
            break;
        }
        return taskOfInterest;
    }

    public Element getOutputDataElementForNode(Element fixupDataElement, String node) {
        Element nodeElem;
        Element nodeListElem;
        Element outputElementForNode = null;
        if (null != fixupDataElement && null != (nodeListElem = this.getFirstChildNodeByTagName(fixupDataElement, "NODE_LIST")) && null != (nodeElem = this.searchChildNodeWithMatchingAttributeValue(nodeListElem, "NODE", "NAME", node, true))) {
            outputElementForNode = this.getFirstChildNodeByTagName(nodeElem, "FIXUP_OUTPUT_DATA");
        }
        return outputElementForNode;
    }

    public synchronized void addOutputElementforTask(String node, String taskID, Element outputElement, int elementIndex) {
        Element nodeElem;
        Element nodeListElem;
        Element requiredFixupDataElem;
        Trace.out((String)("Adding fixup output for Task " + taskID + " instance number " + elementIndex + " on node " + node));
        Element taskListElem = this.getFirstChildNodeByTagName(this.m_fixupDOMRoot, "TASK_LIST");
        Element taskElem = this.searchChildNodeWithMatchingAttributeValue(taskListElem, "TASK", "ID", taskID, false);
        Element fixupDataListElem = this.getFirstChildNodeByTagName(taskElem, "FIXUP_DATA_LIST");
        if (fixupDataListElem != null && (requiredFixupDataElem = this.getChildNodeByTagName(fixupDataListElem, "FIXUP_DATA", elementIndex)) != null && (nodeListElem = this.getFirstChildNodeByTagName(requiredFixupDataElem, "NODE_LIST")) != null && (nodeElem = this.searchChildNodeWithMatchingAttributeValue(nodeListElem, "NODE", "NAME", node, true)) != null) {
            Element nodeOutputElem = this.getFirstChildNodeByTagName(nodeElem, "FIXUP_OUTPUT_DATA");
            if (nodeOutputElem != null && outputElement != null) {
                nodeElem.removeChild(nodeOutputElem);
            }
            if (outputElement != null) {
                Element outputElemToADD = (Element)this.m_fixupDoc.importNode(outputElement, true);
                nodeElem.appendChild(outputElemToADD);
                this.updateOverAllStatus(requiredFixupDataElem, nodeElem);
                Trace.out((String)("Adding output to node element " + nodeElem.getNodeName()));
                Trace.out((String)("Added output node element " + nodeElem.getFirstChild().getNodeName()));
            }
        }
    }

    public synchronized void updateOverAllStatus(Element fixupDataElem, Element nodeElem) {
        FixupStatus nodeStatus;
        String nodeStatusStr;
        Element nodeStatusElem;
        Element nodeOutputElem = this.getFirstChildNodeByTagName(nodeElem, "FIXUP_OUTPUT_DATA");
        if (null != nodeOutputElem && null != (nodeStatusElem = this.getFirstChildNodeByTagName(nodeOutputElem, "STATUS")) && VerificationUtil.isStringGood(nodeStatusStr = nodeStatusElem.getTextContent()) && null != (nodeStatus = FixupStatus.valueOf(nodeStatusStr))) {
            this.updateOverAllStatus(fixupDataElem, nodeStatus);
        }
    }

    public synchronized void updateOverAllStatus(Element fixupDataElem, FixupStatus status) {
        FixupStatus currentStatus = FixupStatus.UNKNOWN;
        Element overAllStatusElem = this.getFirstChildNodeByTagName(fixupDataElem, "OVERALL_STATUS");
        String currentStatusStr = overAllStatusElem.getTextContent();
        if (VerificationUtil.isStringGood(currentStatusStr) && (currentStatus = FixupStatus.valueOf(currentStatusStr)) != null) {
            if (status == FixupStatus.ERROR || status == FixupStatus.FAILED) {
                if (currentStatus != FixupStatus.ERROR) {
                    currentStatus = status;
                }
            } else if (currentStatus == FixupStatus.UNKNOWN || currentStatus == FixupStatus.SUCCESSFUL) {
                currentStatus = status;
            }
        }
        overAllStatusElem.setTextContent(currentStatus.toString());
    }
}

