/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.ShellLimitType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.TaskShellLimits;

public class CDMShellLimitChecks {
    private Hashtable<ShellLimitType, List<TaskShellLimits.ShellLimitData>> m_fdLimits = new Hashtable();
    private Hashtable<ShellLimitType, List<TaskShellLimits.ShellLimitData>> m_mpLimits = new Hashtable();
    private Hashtable<ShellLimitType, List<TaskShellLimits.ShellLimitData>> m_stackLimits = new Hashtable();
    private Hashtable<ShellLimitType, TaskShellLimits.ShellLimitValue> m_expectedFileDescLimitTable = new Hashtable();
    private Hashtable<ShellLimitType, TaskShellLimits.ShellLimitValue> m_expectedMaxProcLimitTable = new Hashtable();
    private Hashtable<ShellLimitType, TaskShellLimits.ShellLimitValue> m_expectedStackLimitTable = new Hashtable();

    public void addFileDescriptorLimit(String shellSel, ShellLimitType limitType, TaskShellLimits.ShellLimitValue value) {
        this.addLimit(this.m_fdLimits, shellSel, limitType, value);
    }

    private void addLimit(Hashtable<ShellLimitType, List<TaskShellLimits.ShellLimitData>> limitTable, String shellSel, ShellLimitType limitType, TaskShellLimits.ShellLimitValue value) {
        if (value != null) {
            Trace.out((String)("shellSel = " + shellSel + ", limitType = " + (Object)((Object)limitType) + ", value = " + value.toString()));
            TaskShellLimits.ShellLimitData limit = new TaskShellLimits.ShellLimitData(shellSel, value, true);
            if (!limitTable.containsKey((Object)limitType)) {
                ArrayList<TaskShellLimits.ShellLimitData> data = new ArrayList<TaskShellLimits.ShellLimitData>();
                data.add(limit);
                limitTable.put(limitType, data);
            } else {
                limitTable.get((Object)limitType).add(limit);
            }
        } else {
            ArrayList data = new ArrayList();
            limitTable.put(limitType, data);
        }
    }

    public void addStackLimit(String shellSel, ShellLimitType limitType, TaskShellLimits.ShellLimitValue value) {
        this.addLimit(this.m_stackLimits, shellSel, limitType, value);
    }

    public void addMaxProcessExpectedValue(ShellLimitType limitType, TaskShellLimits.ShellLimitValue value) {
        this.m_expectedMaxProcLimitTable.put(limitType, value);
    }

    public void addStackExpectedValue(ShellLimitType limitType, TaskShellLimits.ShellLimitValue value) {
        this.m_expectedStackLimitTable.put(limitType, value);
    }

    public void addFileDescriptorExpectedValue(ShellLimitType limitType, TaskShellLimits.ShellLimitValue value) {
        this.m_expectedFileDescLimitTable.put(limitType, value);
    }

    public void addMaxProcessLimits(String shellSel, ShellLimitType limitType, TaskShellLimits.ShellLimitValue value) {
        this.addLimit(this.m_mpLimits, shellSel, limitType, value);
    }

    public List<TaskShellLimits.ShellLimitData> getSoftFileDescriptorLimits() {
        return this.m_fdLimits.get((Object)ShellLimitType.SOFT);
    }

    public List<TaskShellLimits.ShellLimitData> getHardFileDescriptorLimits() {
        return this.m_fdLimits.get((Object)ShellLimitType.HARD);
    }

    public List<TaskShellLimits.ShellLimitData> getSoftStackLimits() {
        return this.m_stackLimits.get((Object)ShellLimitType.SOFT);
    }

    public List<TaskShellLimits.ShellLimitData> getHardStackLimits() {
        return this.m_stackLimits.get((Object)ShellLimitType.HARD);
    }

    public List<TaskShellLimits.ShellLimitData> getSoftMaxProcessLimits() {
        return this.m_mpLimits.get((Object)ShellLimitType.SOFT);
    }

    public List<TaskShellLimits.ShellLimitData> getHardMaxProcessLimits() {
        return this.m_mpLimits.get((Object)ShellLimitType.HARD);
    }

    public TaskShellLimits.ShellLimitValue getDefaultExpectedMaxProcLimits(ShellLimitType type) {
        return this.m_expectedMaxProcLimitTable.get((Object)type);
    }

    public TaskShellLimits.ShellLimitValue getDefaultExpectedStackLimits(ShellLimitType type) {
        return this.m_expectedStackLimitTable.get((Object)type);
    }

    public TaskShellLimits.ShellLimitValue getDefaultExpectedFileDescLimits(ShellLimitType type) {
        return this.m_expectedFileDescLimitTable.get((Object)type);
    }
}

