/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.RangeOfValue;

public class CDMOperatingSystem {
    public static String DHCP = "DHCP";
    private HashMap<String, Object> m_kernelProperties = new LinkedHashMap<String, Object>();
    private HashMap m_kernelAttributes = new HashMap();
    private List<HashMap<String, Object>> m_packageRanges = new ArrayList<HashMap<String, Object>>();
    private Vector<HashMap> m_systemFiles = new Vector();
    private List<HashMap<String, String>> m_osPatches = new ArrayList<HashMap<String, String>>();
    private List<HashMap<String, String>> m_memorySteps = null;
    private HashMap<String, Object> m_archValues = new HashMap();
    private Vector<HashMap<String, String>> m_envVariables = new Vector();

    public void setAttributes(String osRelease, String osVersion, String osName, String osVendor) {
        Trace.out((String)("osRelease = " + osRelease));
        if (this.m_kernelAttributes == null) {
            this.m_kernelAttributes = new HashMap();
        }
        this.m_kernelAttributes.put(CDMConstraintTypes.RELEASE, osRelease);
        this.m_kernelAttributes.put(CDMConstraintTypes.VERSION, osVersion);
        this.m_kernelAttributes.put(CDMConstraintTypes.NAME, osName);
        this.m_kernelAttributes.put(CDMConstraintTypes.VENDOR, osVendor);
    }

    public void setAttributes(String osKernelVer, String leaf) {
        this.m_kernelAttributes.put(CDMConstraintTypes.KERNEL_VER, osKernelVer);
        this.m_kernelAttributes.put(CDMConstraintTypes.KERNEL_VER_RIM, leaf);
    }

    public void addArchitectureValues(List<String> archs, String severity) {
        this.m_archValues.put(CDMConstraintTypes.VALUE, archs);
        this.m_archValues.put(CDMConstraintTypes.SEVERITY, severity);
    }

    public void addKernelProperty(String name, String name2, String value, String equalTo, String atleast, String atmost, String gthan, String lthan, String severity) {
        Trace.out((String)("name = " + name + ", name2 =" + name2 + ", value = " + value + ", equalTo = " + equalTo + ", minValue = " + atleast + ", maxValue = " + atmost));
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.NAME, name);
        p.put(CDMConstraintTypes.NAME2, name2);
        p.put(CDMConstraintTypes.VALUE, value);
        p.put(CDMConstraintTypes.ATLEAST, atleast);
        p.put(CDMConstraintTypes.ATMOST, atmost);
        p.put(CDMConstraintTypes.GREATER_THAN, gthan);
        p.put(CDMConstraintTypes.LESS_THAN, lthan);
        p.put(CDMConstraintTypes.EQUAL, equalTo);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_kernelProperties.put(name, p);
    }

    public void addKernelPropertySizeStep(String paramName, String name, String value, String gthan, String atLeast, String lthan, String atMost, String units, String multiple, String severity, String minValue, String minUnit, String maxValue, String maxUnit) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("paramName = " + paramName + "name = " + name + ", value = " + value + ", gthan= " + gthan + "atLeast = " + atLeast + ", atMost = " + atMost + "units = " + units + ", multiple = " + multiple));
        }
        Object paramCriteria = this.m_kernelProperties.get(paramName);
        ArrayList paramStepCriteria = null;
        if (paramCriteria instanceof List) {
            paramStepCriteria = (ArrayList)paramCriteria;
        }
        if (paramStepCriteria == null || paramCriteria instanceof String) {
            paramStepCriteria = new ArrayList();
            this.m_kernelProperties.put(paramName, paramStepCriteria);
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.MIN_VALUE, minValue);
        p.put(CDMConstraintTypes.MIN_UNIT, minUnit);
        p.put(CDMConstraintTypes.MAX_VALUE, maxValue);
        p.put(CDMConstraintTypes.MAX_UNIT, maxUnit);
        p.put(CDMConstraintTypes.NAME, name);
        p.put(CDMConstraintTypes.VALUE, value);
        p.put(CDMConstraintTypes.GREATER_THAN, gthan);
        p.put(CDMConstraintTypes.ATLEAST, atLeast);
        p.put(CDMConstraintTypes.LESS_THAN, lthan);
        p.put(CDMConstraintTypes.ATMOST, atMost);
        p.put(CDMConstraintTypes.UNIT, units);
        p.put(CDMConstraintTypes.MULTIPLE, multiple);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        paramStepCriteria.add(p);
    }

    public void addPackageValueCriteria(String name, String value, String severity, String arch) {
        HashMap<String, String> packageCriteria = new HashMap<String, String>();
        packageCriteria.put(CDMConstraintTypes.NAME, name);
        packageCriteria.put(CDMConstraintTypes.VALUE, value);
        packageCriteria.put(CDMConstraintTypes.SEVERITY, severity);
        packageCriteria.put(CDMConstraintTypes.ARCHITECTURE, arch);
        this.m_packageRanges.add(packageCriteria);
    }

    public void addPackageRangeCriteria(String name, RangeOfValue value, String severity, String arch) {
        HashMap<String, Object> packageCriteria = new HashMap<String, Object>();
        packageCriteria.put(CDMConstraintTypes.NAME, name);
        packageCriteria.put(CDMConstraintTypes.VALUE, value);
        packageCriteria.put(CDMConstraintTypes.SEVERITY, severity);
        packageCriteria.put(CDMConstraintTypes.ARCHITECTURE, arch);
        this.m_packageRanges.add(packageCriteria);
    }

    public void addSystemFile(String type, String name) {
        Trace.out((String)("type = " + type + ", name = " + name));
        HashMap<String, String> p = new HashMap<String, String>();
        if (this.m_systemFiles == null) {
            this.m_systemFiles = new Vector();
        }
        p.put(CDMConstraintTypes.TYPE, type);
        p.put(CDMConstraintTypes.NAME, name);
        this.m_systemFiles.add(p);
    }

    public void addEnvVariable(String name, String maxLength, String set) {
        Trace.out((String)("name = " + name + ", maxLength =" + maxLength));
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(CDMConstraintTypes.ENV_VAR_NAME, name);
        env.put(CDMConstraintTypes.MAX_LENGTH, maxLength);
        env.put(CDMConstraintTypes.SET, set);
        this.m_envVariables.add(env);
    }

    public HashMap getKernelAttributes() {
        return this.m_kernelAttributes;
    }

    public HashMap<String, Object> getKernelProperties() {
        return this.m_kernelProperties;
    }

    public List<HashMap<String, Object>> getPackages() {
        return this.m_packageRanges;
    }

    public List<HashMap<String, String>> getOSPatches() {
        return this.m_osPatches;
    }

    public List<HashMap<String, String>> getSwapMemorySteps() {
        return this.m_memorySteps;
    }

    public Vector<HashMap> getSystemFiles() {
        return this.m_systemFiles;
    }

    public HashMap<String, Object> getArchitectureValues() {
        return this.m_archValues;
    }

    public Vector<HashMap<String, String>> getEnvVariables() {
        return this.m_envVariables;
    }

    public void addOSPatch(String val, String severity) {
        Trace.out((String)("value = " + val + ", severity = " + severity));
        HashMap<String, String> p = new HashMap<String, String>();
        if (this.m_systemFiles == null) {
            this.m_systemFiles = new Vector();
        }
        p.put(CDMConstraintTypes.VALUE, val);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_osPatches.add(p);
    }
}

