/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.constraints.CDMCertifiedSystems;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.cluster.verification.constraints.CDMOracleHome;
import oracle.cluster.verification.constraints.CDMReferenceDevices;
import oracle.cluster.verification.constraints.CDMSystem;
import oracle.cluster.verification.constraints.CDMUserInputs;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CDMHost {
    private Vector<String> m_scriptConstraints = null;
    private Vector<String> m_interconnects = null;
    private Hashtable<String, Boolean> m_directories = null;
    private Hashtable<String, HashMap> m_networkNodes = null;
    private Hashtable<String, HashMap<String, HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType>>> m_portTable = null;
    private Vector<CDMSystem> m_cdmSystems = null;
    private Vector<CDMCertifiedSystems> m_cdmCertSystems = null;
    private Vector<CDMReferenceDevices> m_cdmRefDevices = null;
    private Vector<CDMUserInputs> m_cdmUserInputs = null;
    private Vector<CDMOracleHome> m_cdmOracleHomes = null;

    public CDMHost() {
        Trace.out((String)"constructor");
        this.m_cdmOracleHomes = new Vector();
        this.m_cdmUserInputs = new Vector();
        this.m_cdmRefDevices = new Vector();
        this.m_cdmCertSystems = new Vector();
        this.m_cdmSystems = new Vector();
    }

    public void addScriptConstraint(String var) {
        Trace.out((String)("var = " + var));
        if (this.m_scriptConstraints == null) {
            this.m_scriptConstraints = new Vector();
        }
        this.m_scriptConstraints.add(var);
    }

    public void addDirectory(String dirVar, String writeable) {
        Trace.out((String)("dirVar = " + dirVar + "," + "writeable = " + writeable));
        Boolean wr = new Boolean(writeable);
        if (this.m_directories == null) {
            this.m_directories = new Hashtable();
        }
        this.m_directories.put(dirVar, wr);
    }

    public void addNetworkNode(String name, String type, String var, String ipVar) {
        Trace.out((String)("name = " + name + "," + "type = " + type + "," + "var = " + var + ",ipVar = " + ipVar));
        if (this.m_networkNodes == null) {
            this.m_networkNodes = new Hashtable();
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.NAME, name);
        p.put(CDMConstraintTypes.TYPE, type);
        p.put(CDMConstraintTypes.VAR, var);
        p.put(CDMConstraintTypes.IP_VAR, ipVar);
        this.m_networkNodes.put(name, p);
    }

    public void addInterconnect(String var) {
        Trace.out((String)("interconnect = " + var));
        if (this.m_interconnects == null) {
            this.m_interconnects = new Vector();
        }
        this.m_interconnects.add(var);
    }

    public void addIpPort(String name, String portNumber, String protocol, NetworkConstants.NetworkType networkType) {
        Trace.out((String)("Port requirement for " + name + " port number " + portNumber + " on protocol " + protocol + " on network type " + networkType.name()));
        if (this.m_portTable == null) {
            this.m_portTable = new Hashtable();
        }
        NetworkConstants.NetworkProtocol proto = null;
        proto = VerificationUtil.isStringGood(protocol) && (protocol.trim().equalsIgnoreCase("UDP") || protocol.trim().equalsIgnoreCase("TCP")) ? NetworkConstants.NetworkProtocol.valueOf(protocol) : NetworkConstants.NetworkProtocol.TCP;
        if (this.m_portTable.containsKey(name)) {
            if (this.m_portTable.get(name).containsKey(portNumber)) {
                if (!this.m_portTable.get(name).get(portNumber).containsKey((Object)proto)) {
                    this.m_portTable.get(name).get(portNumber).put(proto, networkType);
                } else {
                    NetworkConstants.NetworkType type = this.m_portTable.get(name).get(portNumber).get((Object)proto);
                    if (type != NetworkConstants.NetworkType.ALL && type != networkType) {
                        this.m_portTable.get(name).get(portNumber).remove((Object)proto);
                        this.m_portTable.get(name).get(portNumber).put(proto, NetworkConstants.NetworkType.ALL);
                    }
                }
            } else {
                HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType> protoMap = new HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType>();
                protoMap.put(proto, networkType);
                this.m_portTable.get(name).put(portNumber, protoMap);
            }
        } else {
            HashMap portProtoListMap = new HashMap();
            HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType> protoMap = new HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType>();
            protoMap.put(proto, networkType);
            portProtoListMap.put(portNumber, protoMap);
            this.m_portTable.put(name, portProtoListMap);
        }
    }

    public Hashtable<String, HashMap<String, HashMap<NetworkConstants.NetworkProtocol, NetworkConstants.NetworkType>>> getIpPortConstraint() {
        return this.m_portTable;
    }

    public Vector<String> getScriptConstraints() {
        return this.m_scriptConstraints;
    }

    public Hashtable<String, Boolean> getDirectories() {
        return this.m_directories;
    }

    public Hashtable<String, HashMap> getNetworkNodes() {
        return this.m_networkNodes;
    }

    public void addCDMSystem(CDMSystem cdmSystem) {
        this.m_cdmSystems.add(cdmSystem);
    }

    public Vector<CDMSystem> getCDMSystems() {
        return this.m_cdmSystems;
    }

    public void addCDMCertifiedSystem(CDMCertifiedSystems cdmCertSystem) {
        this.m_cdmCertSystems.add(cdmCertSystem);
    }

    public Vector<CDMCertifiedSystems> getCDMCertifiedSystems() {
        return this.m_cdmCertSystems;
    }

    public void addCDMReferenceDevices(CDMReferenceDevices cdmRefDevice) {
        this.m_cdmRefDevices.add(cdmRefDevice);
    }

    public Vector<CDMReferenceDevices> getCDMReferenceDevices() {
        return this.m_cdmRefDevices;
    }

    public void addCDMUserInput(CDMUserInputs cdmUserInput) {
        this.m_cdmUserInputs.add(cdmUserInput);
    }

    public Vector<CDMUserInputs> getCDMUserInputs() {
        return this.m_cdmUserInputs;
    }

    public void addCDMOracleHome(CDMOracleHome cdmOracleHome) {
        this.m_cdmOracleHomes.add(cdmOracleHome);
    }

    public Vector<CDMOracleHome> getCDMOracleHomes() {
        return this.m_cdmOracleHomes;
    }
}

