/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class StorageSize
implements Comparable<StorageSize> {
    private double m_size;
    private StorageUnit m_units;

    public StorageSize(double size, StorageUnit units) {
        this.m_size = size;
        if (units == null) {
            units = StorageUnit.BYTE;
        }
        this.m_units = units;
    }

    public StorageSize(double size, String units) {
        this.m_size = size;
        if (!VerificationUtil.isStringGood(units)) {
            this.m_units = StorageUnit.BYTE;
        } else {
            for (StorageUnit unit : StorageUnit.values()) {
                if (!unit.toString().equalsIgnoreCase(units.trim())) continue;
                this.m_units = unit;
            }
            if (this.m_units == null) {
                Trace.out((String)"Incorrect units value Strng passed. assuming BYTES as default unit");
                this.m_units = StorageUnit.BYTE;
            }
        }
    }

    @Override
    public int compareTo(StorageSize toCompare) {
        double toCompareUnit;
        double thisUnit;
        if (toCompare == null) {
            return 1;
        }
        int relaxationFactor = 0;
        String defaultRelaxationFactorStr = VDMUtil.getDefaultRelaxationFactor();
        if (VerificationUtil.isStringGood(defaultRelaxationFactorStr)) {
            relaxationFactor = Integer.parseInt(defaultRelaxationFactorStr);
        }
        if ((thisUnit = this.sizeIn(StorageUnit.KBYTE)) > (toCompareUnit = toCompare.sizeIn(StorageUnit.KBYTE))) {
            return 1;
        }
        if (thisUnit == toCompareUnit) {
            return 0;
        }
        Trace.out((String)("The relaxation factor is " + relaxationFactor));
        Trace.out((String)("Comparing this size in KBs (" + thisUnit + ") with size (" + toCompareUnit + ") Kbs"));
        if (relaxationFactor == 0) {
            return -1;
        }
        double difference = toCompareUnit - thisUnit;
        Trace.out((String)("The difference is " + difference));
        double relax = toCompareUnit * (double)relaxationFactor / 100.0;
        Trace.out((String)("Allowed to relax " + relax + " based on the relaxation factor."));
        if (difference > relax) {
            return -1;
        }
        return 2;
    }

    public int compareExactTo(StorageSize o) {
        if (o == null) {
            return 1;
        }
        StorageUnit greaterOfThe2 = this.getGreaterStorageUnits(this.m_units, o.m_units);
        return new Double(this.sizeIn(greaterOfThe2)).compareTo(new Double(o.sizeIn(greaterOfThe2)));
    }

    private StorageUnit getGreaterStorageUnits(StorageUnit unit1, StorageUnit unit2) {
        return unit1.getConversionFactor() >= unit2.getConversionFactor() ? unit1 : unit2;
    }

    public double sizeIn(StorageUnit units) {
        if (units == null) {
            return this.m_size;
        }
        return this.m_size * ((double)this.m_units.getConversionFactor() / (double)units.getConversionFactor());
    }

    public void add(StorageSize size) {
        if (size == null) {
            return;
        }
        StorageUnit units = this.getGreaterStorageUnits(this.m_units, size.m_units);
        this.m_size = this.sizeIn(units) + size.sizeIn(units);
        this.m_units = units;
    }

    public void subtract(StorageSize size) {
        if (size == null) {
            return;
        }
        StorageUnit units = this.getGreaterStorageUnits(this.m_units, size.m_units);
        this.m_size = this.sizeIn(units) - size.sizeIn(units);
        this.m_units = units;
    }

    public void modify(double multiplier) {
        if (this.m_size == 0.0 || multiplier < 0.0) {
            return;
        }
        this.m_size *= multiplier;
    }

    public double getSize() {
        return this.m_size;
    }

    public StorageUnit getUnit() {
        return this.m_units;
    }

    public String toString() {
        return this.m_size + " " + (Object)((Object)this.m_units);
    }

    public static StorageSize parseStorageSize(String str) throws VerificationException {
        Pattern pattern = Pattern.compile("(\\d*)([.]?)(\\d*)(\\s*)([a-zA-Z]*)");
        Matcher m = pattern.matcher(str);
        if (m.matches()) {
            try {
                double d = Double.parseDouble(m.group(1) + m.group(2) + m.group(3));
                StorageUnit unit = StorageUnit.BYTE;
                if (m.group(5) == null || m.group(5).length() == 0 || "B".equalsIgnoreCase(m.group(5))) {
                    unit = StorageUnit.BYTE;
                } else if ("K".equalsIgnoreCase(m.group(5)) || "KB".equalsIgnoreCase(m.group(5))) {
                    unit = StorageUnit.KBYTE;
                } else if ("M".equalsIgnoreCase(m.group(5)) || "MB".equalsIgnoreCase(m.group(5))) {
                    unit = StorageUnit.MBYTE;
                } else if ("G".equalsIgnoreCase(m.group(5)) || "GB".equalsIgnoreCase(m.group(5))) {
                    unit = StorageUnit.GBYTE;
                } else if ("T".equalsIgnoreCase(m.group(5)) || "TB".equalsIgnoreCase(m.group(5))) {
                    unit = StorageUnit.TBYTE;
                } else if ("P".equalsIgnoreCase(m.group(5)) || "PB".equalsIgnoreCase(m.group(5))) {
                    unit = StorageUnit.PBYTE;
                } else {
                    throw new VerificationException(new NumberFormatException(str).getMessage());
                }
                return new StorageSize(d, unit);
            }
            catch (NumberFormatException e) {
                throw new VerificationException(e.getMessage());
            }
        }
        throw new VerificationException(new NumberFormatException(str).getMessage());
    }
}

