﻿using System;
using System.Web;
using System.Text.RegularExpressions;

namespace GenClassLibrary
{
    public class ValidateData
    {
        #region Constants

        private const int length_userid = 6;
        private const int length_appno = 12;
        private const int length_OfcID = 3;
        private const int length_statecode = 2;
        private const int length_distcode = 3;
        private const int length_tempcode = 1;
        private readonly string alpha_series = @"^[a-zA-Z\s]+$";
        private readonly string alphaNumeric_series = @"^[a-zA-Z0-9\s]*$";
        private readonly string no_series = @"^[0-9]+$";
        private readonly string emailformat = @"^([a-zA-Z0-9_\-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$";
        private readonly string weburlformat = @"(?<http>(http:[/][/]|www.)([a-z]|[A-Z]|[0-9]|[/.]|[~])*)";
        private readonly string percentageformat = @"(^(100(?:\.0{1,2})?))|(?!^0*$)(?!^0*\.0*$)^\d{1,2}(\.\d{1,2})?$";
        private readonly string decimalformat = @"^[1-9]\d{1,6}(\.\d{1,2})?$";
        private readonly string ipaddressformat = @"^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)";
        private readonly string imageformat = @"([^\s]+(?=\.(jpeg|jpg|gif|png|JPEG|JPG|GIF|PNG))\.\2)";
        private readonly string dateformat = @"^(3[01]|[12][0-9]|0[1-9])/(1[0-2]|0[1-9])/[0-9]{4}$";
        private readonly string alphaspclchars = @"[a-zA-Z0-9@#$%&*+\-_(),+:;?.,![\]\s\\/]+$";
        private readonly string ImagePath = @"^(?:[\w]\:|\\)(\\[a-z_\-\s0-9\.]+)+\.(?i)(txt|gif|pdf|doc|docx|xls|xlsx)$)";
        private readonly string webip = @"\b\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\b";
        #endregion


        #region Validate functions
        public bool ValidateLength(int obj, int length)
        {
            try
            {
                if (obj != null && length != null)
                {
                    if (obj != length)
                        return false;
                }
                else
                    return false;

            }
            catch (Exception ex)
            {

            }
            return true;
        }
        public bool ValidateLength(int obj, int Minlength, int MaxLength)
        {

            string ObjLength = string.Empty;
            try
            {
                if (Minlength != null && MaxLength != null && obj != null)
                {
                    if (obj < Minlength && obj > MaxLength)
                        return false;
                }
                else
                    return false;


            }
            catch (Exception ex)
            {

            }
            return true;
        }
        public bool ValidateWebIP(string webip)
        {
            try
            {
                if (validateEmptyString(webip))
                    return false;
                else if (!ValidateWebIP(webip))
                    return false;
                else
                    return true;
            }
            catch (Exception ex)
            {

                return false;
            }


        }

        public bool validateAlpha_Only(string alphbetsOnly)
        {
            try
            {
                if (Regex.IsMatch(alphbetsOnly, alpha_series))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validateAphaNumeric(string alphanumericseries)
        {
            try
            {
                if (Regex.IsMatch(alphanumericseries, alphaNumeric_series))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }

        }
        public bool validateNumeric(string numericseries)
        {
            try
            {
                if (Regex.IsMatch(numericseries, no_series))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }

        }
        public bool validateEmail(string emailidformat)
        {
            try
            {
                if (Regex.IsMatch(emailidformat, emailformat))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }

        }
        public bool validateWebUrl(string weburl)
        {
            try
            {
                if (Regex.IsMatch(weburl, weburlformat))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }

        }
        public bool validatePercentage(string percentformat)
        {
            try
            {
                if (Regex.IsMatch(percentformat, percentageformat))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }

        }
        public bool validateDecimalFormat(string deciamlval)
        {
            try
            {
                if (Regex.IsMatch(deciamlval, decimalformat))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }

        }
        public bool validateEmptyString(string emptystring)
        {
            try
            {
                if (string.IsNullOrEmpty(emptystring))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validateIPAddress(string ipaddress)
        {
            try
            {
                if (Regex.IsMatch(ipaddress, ipaddressformat))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validateImage(string imagename)
        {
            try
            {
                if (Regex.IsMatch(imagename, imageformat))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        private bool ValidateImgPath(string path)
        {
            return Regex.IsMatch(path, ImagePath);

        }
        public bool validateDate(string ddmmyyyy)
        {
            try
            {
                if (Regex.IsMatch(ddmmyyyy, dateformat))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validateAlphaSpclChar(string charset)
        {
            try
            {
                if (Regex.IsMatch(charset, alphaspclchars))
                    return true;
                else
                    return false;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validate_decimal_int(string numberformat)
        {
            try
            {
                double xx;
                if (double.TryParse(numberformat, out xx))
                    return true;
                else
                    return false;
            }
            catch (ApplicationException ex)
            {
                return false;
            }
            catch (Exception ex)
            {
                return false;
            }

        }
        public bool validate_userid(string userid)
        {
            try
            {
                if (validateEmptyString(userid))
                    return false;
                else if (userid.Length != length_userid)
                    return false;
                else
                    return true;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validate_applno(string app_no, char apptype)
        {
            try
            {
                //apptype 1 : EM1 and 2 : EM2
                bool check = false;
                switch (apptype)
                {
                    case '1':
                        {
                            if (validateEmptyString(app_no))
                                return false;
                            else if (!validateNumeric(app_no))
                                check = false;
                            else if (app_no.Length != length_appno)
                                check = false;
                            else
                                check = true;
                            break;
                        }

                    default:
                        {
                            check = false;
                            break;
                        }
                }
                return check;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validate_OfcID(string dicid)
        {
            try
            {
                if (validateEmptyString(dicid))
                    return false;
                else if (!validateNumeric(dicid))
                    return false;
                else if (dicid.Length != length_OfcID)
                    return false;
                else
                    return true;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validate_statecode(string stateid)
        {
            try
            {
                if (validateEmptyString(stateid))
                    return false;
                else if (!validateNumeric(stateid))
                    return false;
                else if (stateid.Length != length_statecode)
                    return false;
                else
                    return true;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        public bool validate_distcode(string distid)
        {
            try
            {
                if (validateEmptyString(distid))
                    return false;
                else if (!validateNumeric(distid))
                    return false;
                else if (distid.Length != length_distcode)
                    return false;
                else
                    return true;
            }
            catch (Exception ex)
            {

                return false;
            }
        }
        #endregion

    }
}
