﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace GenClassLibrary
{
    public class Connection
    {
        private string objCon;
        private SqlConnection Conn;
        private string strQuery;
        public Connection()
        {

        }
        public SqlConnection Connect()
        {
            objCon = ConfigurationManager.ConnectionStrings["IMConn"].ConnectionString;
            Conn = new SqlConnection(objCon);
            Conn.Open();
            return Conn;
        }

        public void sessionreset()
        {
            try
            {
                HttpContext.Current.Session.Clear();
                HttpContext.Current.Session.Abandon();
                HttpContext.Current.Response.Cookies.Add(new HttpCookie("InterMark", ""));
                HttpContext.Current.Response.Cookies["InterMark"].HttpOnly = true;
                HttpContext.Current.Response.Cookies.Remove("InterMark");
                HttpContext.Current.Response.Redirect("~/Contents/Login.aspx", false);
            }
            catch (Exception ex)
            {

            }
        }

        public void TempActivityDelete(string Id, string Activity)
        {//log entry when successful logout and browser closed
            Conn = Connect();
            try
            {
                SqlCommand cmd = new SqlCommand("Delete_TempActivity", Conn);
                cmd.CommandType = CommandType.StoredProcedure;
                cmd.Parameters.Add("@SessionID", SqlDbType.VarChar, 50).Value = Id;
                cmd.Parameters.Add("@Activity", SqlDbType.VarChar, 50).Value = Activity;
                cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {

            }
            finally
            {
                Conn.Close();
                Conn.Dispose();
            }
        }
    }
}
