﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DataAccess
{
    class GeneralUtility
    {
        public static int selectIntegerValueByIntegerKey(int argKey, List<KeyValuePair<int, int>> argSearchList)
        {
            int tmpReturnValue = 0;

            foreach (KeyValuePair<int, int> kvp in argSearchList.Where<KeyValuePair<int, int>>(x => x.Key == argKey))
            {
                tmpReturnValue = kvp.Value;
            }

            return tmpReturnValue;
        }

        public static string selectStringValueByIntegerKey(int argKey, List<KeyValuePair<int, string>> argSearchList)
        {
            string tmpReturnValue = string.Empty;

            foreach (KeyValuePair<int, string> kvp in argSearchList.Where<KeyValuePair<int, string>>(x => x.Key == argKey))
            {
                tmpReturnValue = kvp.Value;
            }

            return tmpReturnValue;
        }

        public static string selectStringValueByStringKey(string argKey, List<KeyValuePair<string, string>> argSearchList)
        {
            string tmpReturnValue = string.Empty;

            foreach (KeyValuePair<string, string> kvp in argSearchList.Where<KeyValuePair<string, string>>(x => x.Key.ToUpper() == argKey.ToUpper()))
            {
                tmpReturnValue = kvp.Value;
            }

            return tmpReturnValue;
        }

        public static int selectIntKeyByStringValue(string argValue, List<KeyValuePair<int, string>> argSearchList)
        {
            int tmpReturnValue = 0;

            foreach (KeyValuePair<int, string> kvp in argSearchList.Where<KeyValuePair<int, string>>(x => x.Value.ToUpper() == argValue.ToUpper()))
            {
                tmpReturnValue = kvp.Key;
            }

            return tmpReturnValue;
        }
    }
}
