﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.UI.WebControls;

namespace DataAccess
{
    public class ApplicationConfig
    {
        public int int_app_formid { get; set; }
        public string vchr_app_formtitle { get; set; }
        public string vchr_app_form_desc { get; set; }
        public string vchr_app_form_type { get; set; }
        public int int_req_min_pages { get; set; }
        public int int_req_max_pages { get; set; }
      
        public void BindDropdown(string param, DropDownList ddl, string cond = null)
        {
            DataSet ds = new DataSet();
            try
            {
                List<SqlParameter> sqlParams = new List<SqlParameter>();
                sqlParams.Add(new SqlParameter("@param", param));
                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam("SetupParameter", sqlParams);
                ddl.DataSource = ds;
                ddl.DataTextField = "Name";
                ddl.DataValueField = "Id";
                ddl.DataBind();
                //ddl.Items.Insert(0, new ListItem("-All-", "All"));


            }
            catch (Exception ex)
            {
                ds = null;
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }

        public void BindDropdownAppType(string param, DropDownList ddl, string cond = null)
        {
            DataSet ds = new DataSet();
            try
            {
                List<SqlParameter> sqlParams = new List<SqlParameter>();
                sqlParams.Add(new SqlParameter("@param", param));
                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam("SetupParameter", sqlParams);
                ddl.DataSource = ds;
                ddl.DataTextField = "Name";
                ddl.DataValueField = "Id";
                ddl.DataBind();
                //ddl.Items.Insert(0, new ListItem("-All-", "All"));


            }
            catch (Exception ex)
            {
                ds = null;
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }

        public void BindLocTypeDropdown(DropDownList ddl)
        {
            DataSet ds = new DataSet();
            try
            {
                List<SqlParameter> sqlParams = new List<SqlParameter>();
                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam("SP_SelectLocationType_ForConfig", sqlParams);
                ddl.DataSource = ds;
                ddl.DataTextField = "vchr_loc_type";
                ddl.DataValueField = "int_loc_type_id";
                ddl.DataBind();
                //ddl.Items.Insert(0, new ListItem("-All-", "All"));


            }
            catch (Exception ex)
            {
                ds = null;
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }
        public DataSet SelectApplicationconfig(ApplicationConfig objconfig,int loctypid,string apptyp,string type)
        {
            DataSet ds = new DataSet();
            try
            {
                List<SqlParameter> sqlParams = new List<SqlParameter>();
                sqlParams.Add(new SqlParameter("@loctypeid", loctypid));
                sqlParams.Add(new SqlParameter("@apptyp", apptyp));
                sqlParams.Add(new SqlParameter("@type", type));


                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam("SP_GetAllConfig", sqlParams);
            }
            catch (Exception ex)
            {
                ds = null;
            }
            finally
            {

            }
            return ds;
        }

        public void BindDropdownAppForm(DropDownList ddl, int applicationid, string cond = null)
        {
            DataSet ds = new DataSet();
            try
            {
                List<SqlParameter> sqlParams = new List<SqlParameter>();
                sqlParams.Add(new SqlParameter("@int_application_id", applicationid));

                ds = DataAccessUtility.SelectDataSetViaStoreProcedureParam("SP_SelectForm", sqlParams);
                ddl.DataSource = ds;
                ddl.DataTextField = "Name";
                ddl.DataValueField = "Id";
                ddl.DataBind();
                //ddl.Items.Insert(0, new ListItem("-SELECT-", "0"));
            }
            catch (Exception ex)
            {
                ds = null;
            }
            finally
            {
                ds.Clear();
                ds.Dispose();
            }
        }


    }
}
